/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sharedinventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.occ.ococic.business.helper.UnitConvertHelper;
import kd.occ.ococic.business.sharedinventory.AvailableInventoryServiceImpl;
import kd.occ.ococic.business.sharedinventory.SharedDistributionRulesServiceImpl;
import kd.occ.ococic.business.sharedinventory.SharedInventoryService;
import kd.occ.ococic.pojo.AvailableInventoryParamVO;
import kd.occ.ococic.pojo.DistributionRulesParamVO;
import kd.occ.ococic.pojo.DistributionRulesResultVO;
import kd.occ.ococic.pojo.InventoryDetailInfoVO;
import kd.occ.ococic.pojo.InventoryMatchResultVO;
import kd.occ.ococic.pojo.InventoryParamVO;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.util.StringUtils;

public class SharedInventoryServiceImpl
implements SharedInventoryService {
    @Override
    public List<InventoryMatchResultVO> matchDistributionWarehouse(List<InventoryParamVO> invParamVOList) {
        if (CommonUtils.isNull(invParamVOList)) {
            return new ArrayList<InventoryMatchResultVO>(0);
        }
        List<InventoryParamVO> nonStockOrgInvParamVoList = invParamVOList.stream().filter(obj -> obj.getStockOrgId() == 0L || obj.getWarehouseId() == 0L).collect(Collectors.toList());
        List<InventoryMatchResultVO> matchResultVOList = this.createNonStockOrgMatchResultVO(nonStockOrgInvParamVoList);
        List<InventoryParamVO> stockOrgInvParamVoList = invParamVOList.stream().filter(obj -> obj.getStockOrgId() > 0L && obj.getWarehouseId() > 0L).collect(Collectors.toList());
        matchResultVOList.addAll(this.createStockOrgMatchResultVO(stockOrgInvParamVoList));
        DataSet availableInvDataSet = this.queryScmAvailableInventory(matchResultVOList);
        return this.createMatchResultVOList(matchResultVOList, availableInvDataSet);
    }

    private List<InventoryMatchResultVO> createNonStockOrgMatchResultVO(List<InventoryParamVO> nonStockOrgInvParamVoList) {
        ArrayList<InventoryMatchResultVO> matchResultVOList = new ArrayList<InventoryMatchResultVO>(nonStockOrgInvParamVoList.size());
        if (nonStockOrgInvParamVoList.size() > 0) {
            ArrayList<DistributionRulesParamVO> rulesParamVOList = new ArrayList<DistributionRulesParamVO>(nonStockOrgInvParamVoList.size());
            for (InventoryParamVO invParamVo : nonStockOrgInvParamVoList) {
                DistributionRulesParamVO rulesParamVO = new DistributionRulesParamVO();
                rulesParamVO.setChannelId(invParamVo.getSaleChannelID());
                rulesParamVO.setItemId(invParamVo.getItemId());
                rulesParamVO.setSaleOrgId(invParamVo.getSaleOrgId());
                rulesParamVO.setAdminDivisionId(invParamVo.getAdminDivisionId());
                rulesParamVOList.add(rulesParamVO);
            }
            SharedDistributionRulesServiceImpl rulesService = new SharedDistributionRulesServiceImpl();
            List<DistributionRulesResultVO> rulesResultVOList = rulesService.matchDistributionRules(rulesParamVOList);
            for (InventoryParamVO invParamVO : nonStockOrgInvParamVoList) {
                InventoryDetailInfoVO invyDetailInfoVO;
                InventoryMatchResultVO matchResultVO = new InventoryMatchResultVO();
                matchResultVO.setSaleOrgId(invParamVO.getSaleOrgId());
                matchResultVO.setSaleChannelId(invParamVO.getSaleChannelID());
                matchResultVO.setAdminDivisionId(invParamVO.getAdminDivisionId());
                matchResultVO.setItemId(invParamVO.getItemId());
                matchResultVO.setMaterialId(invParamVO.getMaterialId());
                matchResultVO.setAuxPtyID(invParamVO.getAuxPtyID());
                matchResultVO.setBaseUnitID(invParamVO.getBaseUnitID());
                matchResultVO.setBaseUnitQty(invParamVO.getBaseUnitQty());
                matchResultVO.setUnitId(invParamVO.getUnitId());
                matchResultVO.setUnitQty(invParamVO.getUnitQty());
                matchResultVO.setDistributionModeId(invParamVO.getDistributionModeId());
                matchResultVO.setCustomerKey(invParamVO.getCustomerKey());
                ArrayList<InventoryDetailInfoVO> invDetailInfoList = new ArrayList<InventoryDetailInfoVO>(rulesResultVOList.size());
                if (rulesResultVOList.size() > 0) {
                    int sortSeq = 1;
                    for (DistributionRulesResultVO rulesResultVO : rulesResultVOList) {
                        if (rulesResultVO.getSaleOrgId() != matchResultVO.getSaleOrgId() || rulesResultVO.getSaleChannelId() != matchResultVO.getSaleChannelId() && rulesResultVO.getSaleChannelId() != 0L || rulesResultVO.getAdminDivisionId() != matchResultVO.getAdminDivisionId() || rulesResultVO.getItemId() != matchResultVO.getItemId() || rulesResultVO.getStockOrgId() <= 0L || rulesResultVO.getWarehouseId() <= 0L) continue;
                        invyDetailInfoVO = new InventoryDetailInfoVO();
                        invyDetailInfoVO.setDistributionModeId(rulesResultVO.getDistributionModeId());
                        invyDetailInfoVO.setDeliveryChannelId(rulesResultVO.getDeliveryChannelId());
                        invyDetailInfoVO.setChannelWarehouseId(rulesResultVO.getChannelWarehouseId());
                        invyDetailInfoVO.setStockOrgId(rulesResultVO.getStockOrgId());
                        invyDetailInfoVO.setWarehouseId(rulesResultVO.getWarehouseId());
                        invyDetailInfoVO.setSortSeq(sortSeq);
                        invyDetailInfoVO.setInvtypeId(invParamVO.getInvtypeId());
                        invDetailInfoList.add(invyDetailInfoVO);
                        ++sortSeq;
                    }
                }
                if (invDetailInfoList.size() == 0) {
                    matchResultVO.setInvStatus("3");
                    invyDetailInfoVO = new InventoryDetailInfoVO();
                    invyDetailInfoVO.setDistributionModeId(invParamVO.getDistributionModeId());
                    invyDetailInfoVO.setStockOrgId(invParamVO.getStockOrgId());
                    invyDetailInfoVO.setWarehouseId(invParamVO.getWarehouseId());
                    invyDetailInfoVO.setSortSeq(1);
                    invyDetailInfoVO.setInvtypeId(invParamVO.getInvtypeId());
                    invDetailInfoList.add(invyDetailInfoVO);
                }
                matchResultVO.setInvDetailInfoList(invDetailInfoList);
                matchResultVOList.add(matchResultVO);
            }
        }
        return matchResultVOList;
    }

    private List<InventoryMatchResultVO> createStockOrgMatchResultVO(List<InventoryParamVO> stockOrgInvParamVoList) {
        ArrayList<InventoryMatchResultVO> matchResultVOList = new ArrayList<InventoryMatchResultVO>(stockOrgInvParamVoList.size());
        for (InventoryParamVO invParamVO : stockOrgInvParamVoList) {
            InventoryMatchResultVO matchResultVO = new InventoryMatchResultVO();
            matchResultVO.setSaleOrgId(invParamVO.getSaleOrgId());
            matchResultVO.setSaleChannelId(invParamVO.getSaleChannelID());
            matchResultVO.setAdminDivisionId(invParamVO.getAdminDivisionId());
            matchResultVO.setItemId(invParamVO.getItemId());
            matchResultVO.setMaterialId(invParamVO.getMaterialId());
            matchResultVO.setAuxPtyID(invParamVO.getAuxPtyID());
            matchResultVO.setBaseUnitID(invParamVO.getBaseUnitID());
            matchResultVO.setBaseUnitQty(invParamVO.getBaseUnitQty());
            matchResultVO.setUnitId(invParamVO.getUnitId());
            matchResultVO.setUnitQty(invParamVO.getUnitQty());
            matchResultVO.setCustomerKey(invParamVO.getCustomerKey());
            ArrayList<InventoryDetailInfoVO> invDetailInfoList = new ArrayList<InventoryDetailInfoVO>(1);
            InventoryDetailInfoVO invyDetailInfoVO = new InventoryDetailInfoVO();
            invyDetailInfoVO.setDistributionModeId(invParamVO.getDistributionModeId());
            invyDetailInfoVO.setStockOrgId(invParamVO.getStockOrgId());
            invyDetailInfoVO.setWarehouseId(invParamVO.getWarehouseId());
            invyDetailInfoVO.setSortSeq(1);
            invyDetailInfoVO.setInvtypeId(invParamVO.getInvtypeId());
            invDetailInfoList.add(invyDetailInfoVO);
            matchResultVO.setInvDetailInfoList(invDetailInfoList);
            matchResultVOList.add(matchResultVO);
        }
        return matchResultVOList;
    }

    private DataSet queryScmAvailableInventory(List<InventoryMatchResultVO> matchResultVOList) {
        AvailableInventoryParamVO availableInvParamVO = new AvailableInventoryParamVO();
        for (InventoryMatchResultVO matchResultVO : matchResultVOList) {
            availableInvParamVO.getMaterialIdSet().add(matchResultVO.getMaterialId());
            availableInvParamVO.getAuxPtyIDSet().add(matchResultVO.getAuxPtyID());
            availableInvParamVO.getBaseUnitIDSet().add(matchResultVO.getBaseUnitID());
            availableInvParamVO.getStockOrgIdSet().addAll(matchResultVO.getInvDetailInfoList().stream().map(obj -> obj.getStockOrgId()).collect(Collectors.toSet()));
            availableInvParamVO.getWarehouseIdSet().addAll(matchResultVO.getInvDetailInfoList().stream().map(obj -> obj.getWarehouseId()).collect(Collectors.toSet()));
            availableInvParamVO.getInvTypeIdSet().addAll(matchResultVO.getInvDetailInfoList().stream().filter(obj -> obj.getInvtypeId() > 0L).map(obj -> obj.getInvtypeId()).collect(Collectors.toSet()));
        }
        AvailableInventoryServiceImpl availableInvService = new AvailableInventoryServiceImpl();
        return availableInvService.queryScmAvailableInventory(availableInvParamVO);
    }

    private List<InventoryMatchResultVO> createMatchResultVOList(List<InventoryMatchResultVO> matchResultVOList, DataSet availableInvDataSet) {
        ArrayList<InventoryMatchResultVO> matchInvResultVOList = new ArrayList<InventoryMatchResultVO>(matchResultVOList.size());
        DataSet matchAvailableInvDataSet = this.getMatchAvailableInvDataSet(matchResultVOList, availableInvDataSet);
        matchInvResultVOList.addAll(this.getMatchResultVOMap(matchAvailableInvDataSet).values());
        return matchInvResultVOList;
    }

    private DataSet getMatchAvailableInvDataSet(List<InventoryMatchResultVO> matchResultVOList, DataSet availableInvDataSet) {
        ArrayList<Field> fieldList = new ArrayList<Field>(32);
        fieldList.add(new Field("groupseq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("saleorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("channelid", (DataType)DataType.LongType));
        fieldList.add(new Field("admindivisionid", (DataType)DataType.LongType));
        fieldList.add(new Field("itemid", (DataType)DataType.LongType));
        fieldList.add(new Field("materialid", (DataType)DataType.LongType));
        fieldList.add(new Field("auxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("baseunitqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("unitid", (DataType)DataType.LongType));
        fieldList.add(new Field("unitqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("distributionmodeid", (DataType)DataType.LongType));
        fieldList.add(new Field("deliverychannelid", (DataType)DataType.LongType));
        fieldList.add(new Field("channelwarehouseid", (DataType)DataType.LongType));
        fieldList.add(new Field("stockorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("warehouseid", (DataType)DataType.LongType));
        fieldList.add(new Field("sortseq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("invtypeid_bill", (DataType)DataType.LongType));
        fieldList.add(new Field("customerKey", (DataType)DataType.StringType));
        fieldList.add(new Field("invstatus", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"matchResultData").createDataSetBuilder(rowMeta);
        int seq = 1;
        for (InventoryMatchResultVO invMatchResultVO : matchResultVOList) {
            for (InventoryDetailInfoVO invDetailInfo : invMatchResultVO.getInvDetailInfoList()) {
                dataSetBuilder.append(new Object[]{seq, invMatchResultVO.getSaleOrgId(), invMatchResultVO.getSaleChannelId(), invMatchResultVO.getAdminDivisionId(), invMatchResultVO.getItemId(), invMatchResultVO.getMaterialId(), invMatchResultVO.getAuxPtyID(), invMatchResultVO.getBaseUnitID(), invMatchResultVO.getBaseUnitQty(), invMatchResultVO.getUnitId(), invMatchResultVO.getUnitQty(), invDetailInfo.getDistributionModeId(), invDetailInfo.getDeliveryChannelId(), invDetailInfo.getChannelWarehouseId(), invDetailInfo.getStockOrgId(), invDetailInfo.getWarehouseId(), invDetailInfo.getSortSeq(), invDetailInfo.getInvtypeId(), invMatchResultVO.getCustomerKey(), invMatchResultVO.getInvStatus()});
            }
            ++seq;
        }
        DataSet invMatchResultDataSet = dataSetBuilder.build();
        if (availableInvDataSet != null) {
            DataSet invTypeResultDataSet = invMatchResultDataSet.filter("invtypeid_bill > 0").leftJoin(availableInvDataSet).on("stockorgid", "stockorgid").on("warehouseid", "warehouseid").on("materialid", "materialid").on("auxptyid", "auxptyid").on("baseunitid", "baseunitid").on("invtypeid_bill", "invtypeid").select(invMatchResultDataSet.getRowMeta().getFieldNames(), new String[]{"invtypeid", "avbbaseqty", "keepertype", "keeperid", "ownertype", "ownerid"}).finish();
            DataSet noInvTypeResultDataSet = invMatchResultDataSet.filter("invtypeid_bill = 0").leftJoin(availableInvDataSet).on("stockorgid", "stockorgid").on("warehouseid", "warehouseid").on("materialid", "materialid").on("auxptyid", "auxptyid").on("baseunitid", "baseunitid").select(invMatchResultDataSet.getRowMeta().getFieldNames(), new String[]{"invtypeid", "avbbaseqty", "keepertype", "keeperid", "ownertype", "ownerid"}).finish();
            return invTypeResultDataSet.union(noInvTypeResultDataSet).orderBy(new String[]{"groupseq", "sortseq"});
        }
        return invMatchResultDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, InventoryMatchResultVO> getMatchResultVOMap(DataSet matchAvailableInvDataSet) {
        HashMap<Integer, InventoryMatchResultVO> matchResultVOMap = new HashMap<Integer, InventoryMatchResultVO>(20);
        try {
            InventoryMatchResultVO matchResultVO;
            Row matchAvailableRow = null;
            BigDecimal avbBaseQty = BigDecimal.ZERO;
            BigDecimal billSumAvbBaseQty = BigDecimal.ZERO;
            BigDecimal billBaseQty = BigDecimal.ZERO;
            HashSet<Integer> seqSet = new HashSet<Integer>();
            int seq = 1;
            HashMap<Integer, Row> matchAvailableRowMap = new HashMap<Integer, Row>(20);
            HashMap<String, BigDecimal> sumAvbBaseQtyMap = new HashMap<String, BigDecimal>(20);
            boolean isEnough = false;
            while (matchAvailableInvDataSet.hasNext()) {
                String key;
                matchAvailableRow = matchAvailableInvDataSet.next();
                seq = matchAvailableRow.getInteger("groupseq");
                if (seqSet.contains(seq)) continue;
                if (matchAvailableInvDataSet.getRowMeta().getFields().length == 20 || matchAvailableRow.get("avbbaseqty") == null || matchAvailableRow.getBigDecimal("avbbaseqty").compareTo(BigDecimal.ZERO) <= 0) {
                    if (matchAvailableRowMap.containsKey(seq)) continue;
                    matchAvailableRowMap.put(seq, matchAvailableRow);
                    continue;
                }
                if (matchAvailableRowMap.containsKey(seq)) {
                    matchAvailableRowMap.remove(seq);
                }
                billBaseQty = matchAvailableRow.getBigDecimal("baseunitqty");
                long billInvTypeId = matchAvailableRow.getLong("invtypeid_bill");
                if (billInvTypeId == 0L && matchAvailableRow.get("invtypeid") != null) {
                    billInvTypeId = matchAvailableRow.getLong("invtypeid");
                }
                if (!sumAvbBaseQtyMap.containsKey(key = StringUtils.join((CharSequence)"_", (Object[])new Object[]{matchAvailableRow.getLong("materialid"), matchAvailableRow.getLong("auxptyid"), matchAvailableRow.getLong("baseunitid"), matchAvailableRow.getLong("stockorgid"), matchAvailableRow.getLong("warehouseid"), billInvTypeId}))) {
                    if (matchAvailableRow.get("avbbaseqty") == null) {
                        sumAvbBaseQtyMap.put(key, BigDecimal.ZERO);
                    } else {
                        sumAvbBaseQtyMap.put(key, matchAvailableRow.getBigDecimal("avbbaseqty"));
                    }
                }
                avbBaseQty = (BigDecimal)sumAvbBaseQtyMap.get(key);
                if (!matchResultVOMap.containsKey(seq)) {
                    matchResultVO = new InventoryMatchResultVO();
                    this.setMatchResultVO(matchResultVO, matchAvailableRow);
                    matchResultVOMap.put(seq, matchResultVO);
                } else {
                    matchResultVO = (InventoryMatchResultVO)matchResultVOMap.get(seq);
                    avbBaseQty = (BigDecimal)sumAvbBaseQtyMap.get(key);
                    billSumAvbBaseQty = matchResultVO.containsKey((Object)"sumAvbBaseQty") ? new BigDecimal(matchResultVO.get((Object)"sumAvbBaseQty").toString()) : BigDecimal.ZERO;
                    billBaseQty = billBaseQty.subtract(billSumAvbBaseQty);
                }
                if (BigDecimal.ZERO.compareTo(avbBaseQty) >= 0) continue;
                isEnough = this.setMatchInvDetailInfoList(matchResultVO, matchAvailableRow, billBaseQty, avbBaseQty);
                if (isEnough) {
                    seqSet.add(seq);
                    sumAvbBaseQtyMap.put(key, ((BigDecimal)sumAvbBaseQtyMap.get(key)).subtract(billBaseQty));
                    continue;
                }
                sumAvbBaseQtyMap.put(key, ((BigDecimal)sumAvbBaseQtyMap.get(key)).subtract(avbBaseQty));
            }
            for (Map.Entry entry : matchAvailableRowMap.entrySet()) {
                seq = ((Row)entry.getValue()).getInteger("groupseq");
                if (matchResultVOMap.containsKey(seq)) continue;
                matchResultVO = new InventoryMatchResultVO();
                this.setMatchResultVO(matchResultVO, (Row)entry.getValue());
                this.setMatchInvDetailInfoList(matchResultVO, (Row)entry.getValue(), matchAvailableInvDataSet.getRowMeta().getFields().length == 20);
                matchResultVOMap.put(seq, matchResultVO);
            }
        }
        finally {
            matchAvailableInvDataSet.close();
        }
        return matchResultVOMap;
    }

    private boolean setMatchInvDetailInfoList(InventoryMatchResultVO matchResultVO, Row matchAvailableRow, BigDecimal billBaseQty, BigDecimal avbBaseQty) {
        List invDetailInfoList = matchResultVO.getInvDetailInfoList();
        InventoryDetailInfoVO invyDetailInfoVO = new InventoryDetailInfoVO();
        invyDetailInfoVO.setDistributionModeId(matchAvailableRow.getLong("distributionmodeid").longValue());
        invyDetailInfoVO.setDeliveryChannelId(matchAvailableRow.getLong("deliverychannelid").longValue());
        invyDetailInfoVO.setChannelWarehouseId(matchAvailableRow.getLong("channelwarehouseid").longValue());
        invyDetailInfoVO.setStockOrgId(matchAvailableRow.getLong("stockorgid").longValue());
        invyDetailInfoVO.setWarehouseId(matchAvailableRow.getLong("warehouseid").longValue());
        invyDetailInfoVO.setSortSeq(matchAvailableRow.getInteger("sortseq").intValue());
        invyDetailInfoVO.setInvtypeId(matchAvailableRow.getLong("invtypeid").longValue());
        invyDetailInfoVO.setKeeperType(matchAvailableRow.getString("keepertype"));
        invyDetailInfoVO.setKeeperId(matchAvailableRow.getLong("keeperid").longValue());
        invyDetailInfoVO.setOwnerType(matchAvailableRow.getString("ownertype"));
        invyDetailInfoVO.setOwnerId(matchAvailableRow.getLong("ownerid").longValue());
        String invStatus = "2";
        boolean isEnough = false;
        if (billBaseQty.compareTo(avbBaseQty) <= 0) {
            isEnough = true;
            invStatus = "1";
            invyDetailInfoVO.setAvailableBaseQty(billBaseQty);
            invyDetailInfoVO.setAvailableQty(matchAvailableRow.getBigDecimal("unitqty"));
        } else {
            invStatus = "2";
            invyDetailInfoVO.setAvailableBaseQty(avbBaseQty);
            BigDecimal availableQty = UnitConvertHelper.calculateDestQty(avbBaseQty, matchAvailableRow.getLong("materialid"), matchAvailableRow.getLong("baseunitid"), matchAvailableRow.getLong("unitid"));
            invyDetailInfoVO.setAvailableQty(availableQty);
        }
        BigDecimal billSumAvbBaseQty = BigDecimal.ZERO;
        if (matchResultVO.containsKey((Object)"sumAvbBaseQty")) {
            billSumAvbBaseQty = new BigDecimal(matchResultVO.get((Object)"sumAvbBaseQty").toString());
        }
        matchResultVO.put((Object)"sumAvbBaseQty", (Object)billSumAvbBaseQty.add(invyDetailInfoVO.getAvailableBaseQty()));
        invDetailInfoList.add(invyDetailInfoVO);
        matchResultVO.setInvStatus(invStatus);
        matchResultVO.setInvDetailInfoList(invDetailInfoList);
        return isEnough;
    }

    private void setMatchInvDetailInfoList(InventoryMatchResultVO matchResultVO, Row matchAvailableRow, boolean isJustInit) {
        List invDetailInfoList = matchResultVO.getInvDetailInfoList();
        InventoryDetailInfoVO invyDetailInfoVO = new InventoryDetailInfoVO();
        invyDetailInfoVO.setDistributionModeId(matchAvailableRow.getLong("distributionmodeid").longValue());
        invyDetailInfoVO.setDeliveryChannelId(matchAvailableRow.getLong("deliverychannelid").longValue());
        invyDetailInfoVO.setChannelWarehouseId(matchAvailableRow.getLong("channelwarehouseid").longValue());
        invyDetailInfoVO.setStockOrgId(matchAvailableRow.getLong("stockorgid").longValue());
        invyDetailInfoVO.setWarehouseId(matchAvailableRow.getLong("warehouseid").longValue());
        invyDetailInfoVO.setSortSeq(matchAvailableRow.getInteger("sortseq").intValue());
        invyDetailInfoVO.setInvtypeId(isJustInit || matchAvailableRow.get("invtypeid") == null ? 0L : matchAvailableRow.getLong("invtypeid"));
        invyDetailInfoVO.setKeeperType(isJustInit || matchAvailableRow.get("keepertype") == null ? "" : matchAvailableRow.getString("keepertype"));
        invyDetailInfoVO.setKeeperId(isJustInit || matchAvailableRow.get("keeperid") == null ? 0L : matchAvailableRow.getLong("keeperid"));
        invyDetailInfoVO.setOwnerType(isJustInit || matchAvailableRow.get("ownertype") == null ? "" : matchAvailableRow.getString("ownertype"));
        invyDetailInfoVO.setOwnerId(isJustInit || matchAvailableRow.get("ownerid") == null ? 0L : matchAvailableRow.getLong("ownerid"));
        invyDetailInfoVO.setAvailableBaseQty(BigDecimal.ZERO);
        invyDetailInfoVO.setAvailableQty(BigDecimal.ZERO);
        invDetailInfoList.add(invyDetailInfoVO);
        matchResultVO.setInvDetailInfoList(invDetailInfoList);
    }

    private void setMatchResultVO(InventoryMatchResultVO matchResultVO, Row matchAvailableRow) {
        matchResultVO.setSaleOrgId(matchAvailableRow.getLong("saleorgid").longValue());
        matchResultVO.setSaleChannelId(matchAvailableRow.getLong("channelid").longValue());
        matchResultVO.setAdminDivisionId(matchAvailableRow.getLong("admindivisionid").longValue());
        matchResultVO.setItemId(matchAvailableRow.getLong("itemid").longValue());
        matchResultVO.setAuxPtyID(matchAvailableRow.getLong("auxptyid").longValue());
        matchResultVO.setBaseUnitID(matchAvailableRow.getLong("baseunitid").longValue());
        matchResultVO.setBaseUnitQty(matchAvailableRow.getBigDecimal("baseunitqty"));
        matchResultVO.setUnitId(matchAvailableRow.getLong("unitid").longValue());
        matchResultVO.setUnitQty(matchAvailableRow.getBigDecimal("unitqty"));
        matchResultVO.setCustomerKey(matchAvailableRow.getString("customerKey"));
        matchResultVO.setInvStatus(matchAvailableRow.getString("invstatus"));
    }
}

