/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sn.billdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ococic.business.sn.ValidateInfoLogger;
import kd.occ.ococic.business.sn.billdata.BillFieldMapper;
import kd.occ.ococic.enums.MoveDirectEnum;
import kd.occ.ococic.enums.OperateTypeEnum;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.pojo.SnMainFileVO;
import kd.occ.ococic.pojo.SnMoveTrackVO;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.util.StringUtils;

public abstract class SnMainFileData
implements BillFieldMapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Long, List<String>> checkSnMainFileData(List<DynamicObject> billDynObjList, String billFormId) {
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        if (CommonUtils.isNull(billDynObjList)) {
            return validateInfo.getValidateInfo();
        }
        List<Map<Object, Object>> allEntryDynObjList = this.parseBillEntryBySerailNumber(billDynObjList, billFormId);
        if (allEntryDynObjList.size() == 0) {
            return new HashMap<Long, List<String>>();
        }
        try (DataSet serialNumberDataSet = this.getBillSNMainFilesDataSet(allEntryDynObjList, billFormId);){
            HashSet<String> snnumbers = new HashSet<String>(2000);
            Row snDataSetRow = null;
            String snnumber = "";
            int lineseq = 0;
            long billid = 0L;
            String entrykey = "";
            while (serialNumberDataSet.hasNext()) {
                Long itemId;
                String materialSnNumber;
                snDataSetRow = serialNumberDataSet.next();
                snnumber = snDataSetRow.getString("snnumber");
                lineseq = snDataSetRow.getInteger("seq");
                billid = snDataSetRow.getLong("billid");
                entrykey = snDataSetRow.getString("entrykey");
                String checkSNStatusErrMsg = this.validateSNStatus(snDataSetRow);
                if (!"checksuccess".equals(checkSNStatusErrMsg)) {
                    validateInfo.putBillEntryInfo(billid, entrykey, lineseq, checkSNStatusErrMsg);
                }
                if (snnumbers.contains(materialSnNumber = (itemId = snDataSetRow.getLong("billitemid")) + "." + snnumber)) {
                    validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7:[%s] \u91cd\u590d", (String)"SnMainFileData_0", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber));
                    continue;
                }
                snnumbers.add(materialSnNumber);
            }
        }
        return validateInfo.getValidateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Long, List<String>> apicheckSnMainFileData(List<Map<Object, Object>> allEntryDynObjList, String billFormId) {
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        if (allEntryDynObjList.size() == 0) {
            return new HashMap<Long, List<String>>();
        }
        try (DataSet serialNumberDataSet = this.getBillSNMainFilesDataSet(allEntryDynObjList, billFormId);){
            HashSet<String> snnumbers = new HashSet<String>(2000);
            Row snDataSetRow = null;
            String snnumber = "";
            int lineseq = 0;
            long billid = 0L;
            String entrykey = "";
            while (serialNumberDataSet.hasNext()) {
                Long itemId;
                String materialSnNumber;
                snDataSetRow = serialNumberDataSet.next();
                snnumber = snDataSetRow.getString("snnumber");
                lineseq = snDataSetRow.getInteger("seq");
                billid = snDataSetRow.getLong("billid");
                entrykey = snDataSetRow.getString("entrykey");
                String checkSNStatusErrMsg = this.validateSNStatus(snDataSetRow);
                if (!"checksuccess".equals(checkSNStatusErrMsg)) {
                    validateInfo.putBillEntryInfo(billid, entrykey, lineseq, checkSNStatusErrMsg);
                }
                if (snnumbers.contains(materialSnNumber = (itemId = snDataSetRow.getLong("billitemid")) + "." + snnumber)) {
                    validateInfo.putBillEntryInfo(billid, entrykey, lineseq, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7:[%s] \u91cd\u590d", (String)"SnMainFileData_0", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber));
                    continue;
                }
                snnumbers.add(materialSnNumber);
            }
        }
        return validateInfo.getValidateInfo();
    }

    private String validateSNStatus(Row snDataSetRow) {
        String checkSNStatusMsg = "";
        Long mainfileid = snDataSetRow.getLong("mainfileid");
        if (CommonUtils.isNull((Object)mainfileid)) {
            return this.checkAddNewSnNumberStatus(snDataSetRow);
        }
        String snstatusStr = snDataSetRow.getString("snstatus");
        if (SnStatusEnum.ONWAY.getValue().equals(snstatusStr)) {
            checkSNStatusMsg = this.checkOnWaySNStatus(snDataSetRow, SnStatusEnum.getName((String)snstatusStr));
        }
        return checkSNStatusMsg;
    }

    private String checkAddNewSnNumberStatus(Row snDataSetRow) {
        String snnumber = snDataSetRow.getString("snnumber");
        String moveDirect = snDataSetRow.getString("moveDirect");
        if (MoveDirectEnum.MOVEDIRECT_SRC.getValue().equals(moveDirect)) {
            return "checksuccess";
        }
        return String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u9519\u8bef\u72b6\u6001\u7684\u5e8f\u5217\u53f7,\u9519\u8bef\u7684\u5e8f\u5217\u53f7\u4e3a\uff1a%s-\u65e0\u72b6\u6001\u3002", (String)"SnMainFileData_1", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber);
    }

    private String checkOnWaySNStatus(Row snDataSetRow, String snStatusCN) {
        Long billId = snDataSetRow.getLong("billid");
        Long srcBillId = snDataSetRow.getLong("sourcebillid");
        String snnumber = snDataSetRow.getString("snnumber");
        String moveDirect = snDataSetRow.getString("moveDirect");
        if (CommonUtils.isNull((Object)srcBillId) || srcBillId == 0L) {
            if (MoveDirectEnum.MOVEDIRECT_SRC.getValue().equals(moveDirect)) {
                return "checksuccess";
            }
            return String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u9519\u8bef\u72b6\u6001\u7684\u5e8f\u5217\u53f7,\u9519\u8bef\u7684\u5e8f\u5217\u53f7\u4e3a\uff1a%s\u3002", (String)"SnMainFileData_2", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber);
        }
        if (billId.equals(srcBillId)) {
            return "checksuccess";
        }
        return String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u7684\u5e8f\u5217\u53f7,\u9519\u8bef\u7684\u5e8f\u5217\u53f7\u4e3a\uff1a%1$s-%2$s\u3002", (String)"SnMainFileData_5", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber, snStatusCN);
    }

    private String checkInStockSNStatus(Row snDataSetRow, String snStatusCN) {
        String moveDirect = snDataSetRow.getString("moveDirect");
        if (MoveDirectEnum.MOVEDIRECT_DES.getValue().equals(moveDirect)) {
            return "checksuccess";
        }
        String snnumber = (String)snDataSetRow.get("snnumber");
        return String.format(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u9519\u8bef\u72b6\u6001\u7684\u5e8f\u5217\u53f7,\u9519\u8bef\u7684\u5e8f\u5217\u53f7\u4e3a\uff1a%1$s-%2$s\u3002", (String)"SnMainFileData_6", (String)"occ-ococic-business", (Object[])new Object[0]), snnumber, snStatusCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getBillSNMainFilesDataSet(List<Map<Object, Object>> allEntryDynObjList, String billFormId) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("billtype", (DataType)DataType.StringType));
        fieldList.add(new Field("billid", (DataType)DataType.LongType));
        fieldList.add(new Field("entryid", (DataType)DataType.LongType));
        fieldList.add(new Field("seq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("billitemid", (DataType)DataType.LongType));
        fieldList.add(new Field("billauxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("billlotid", (DataType)DataType.LongType));
        fieldList.add(new Field("billlotnum", (DataType)DataType.StringType));
        fieldList.add(new Field("snnumber", (DataType)DataType.StringType));
        fieldList.add(new Field("moveDirect", (DataType)DataType.StringType));
        fieldList.add(new Field("entrykey", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"entryidToSn").createDataSetBuilder(rowMeta);
        Integer listSize = allEntryDynObjList.size();
        HashSet<Long> itemIdSet = new HashSet<Long>(listSize);
        HashSet<String> snNumberSet = new HashSet<String>(listSize);
        long itemId = 0L;
        String snNumber = "";
        for (Map<Object, Object> entryObjMap : allEntryDynObjList) {
            itemId = (Long)entryObjMap.get("billitemid");
            itemIdSet.add(itemId);
            snNumber = (String)entryObjMap.get("snnumber");
            if (!CommonUtils.isNull((Object)snNumber)) {
                snNumberSet.add(snNumber);
            }
            dataSetBuilder.append(new Object[]{billFormId, entryObjMap.get("billid"), entryObjMap.get("entryid"), entryObjMap.get("seq"), itemId, entryObjMap.get("auxptyid"), entryObjMap.get("lotid"), entryObjMap.get("billlotnum"), snNumber, entryObjMap.get("moveDirect"), entryObjMap.get("entrykey")});
        }
        DataSet billSnRelationDataSet = dataSetBuilder.build();
        String mainFileSelectedFields = StringUtils.join((CharSequence)",", (Object[])new Object[]{"id as mainfileid", "itemid", "number", "snstatus", "hbillid as sourcebillid", "auxptyid", "lotid", "lotnum", "lockstatus"});
        QFilter[] qFilters = new QFilter[]{new QFilter("itemid", "in", itemIdSet), new QFilter("number", "in", snNumberSet)};
        DataSet snMainFileDataSet = QueryServiceHelper.queryDataSet((String)SnMainFileData.class.getName(), (String)"ococic_snmainfile", (String)mainFileSelectedFields, (QFilter[])qFilters, (String)"");
        long snmainFileId = 0L;
        HashSet<Long> snmainFileIdSet = new HashSet<Long>();
        try (DataSet snMainIdDataSet = snMainFileDataSet.copy();){
            while (snMainIdDataSet.hasNext()) {
                Row row = snMainIdDataSet.next();
                snmainFileId = row.getLong("mainfileid");
                snmainFileIdSet.add(snmainFileId);
            }
        }
        DataSet result = billSnRelationDataSet.leftJoin(snMainFileDataSet).on("billitemid", "itemid").on("snnumber", "number").select(billSnRelationDataSet.getRowMeta().getFieldNames(), snMainFileDataSet.getRowMeta().getFieldNames()).finish().filter("snnumber is not null");
        if (snmainFileIdSet.size() > 0) {
            QFilter filter = new QFilter("snmainfileid", "in", snmainFileIdSet);
            DataSet snmovetrack = QueryServiceHelper.queryDataSet((String)SnMainFileData.class.getName(), (String)"ococic_snmovetrack", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"id", "snmainfileid"}), (QFilter[])filter.toArray(), null);
            snmovetrack = snmovetrack.groupBy(new String[]{"snmainfileid"}).count("id").finish();
            DataSet serialNumberDataSet = result.leftJoin(snmovetrack).on("mainfileid", "snmainfileid").select(result.getRowMeta().getFieldNames(), new String[]{"id as trackercounter"}).finish();
            return serialNumberDataSet.orderBy(new String[]{"billtype", "billid", "entryid", "seq"});
        }
        return result.orderBy(new String[]{"billtype", "billid", "entryid", "seq"});
    }

    private List<Map<Object, Object>> parseBillEntryBySerailNumber(List<DynamicObject> billDynObjList, String billFormId) {
        ArrayList<Map<Object, Object>> billentryList = new ArrayList<Map<Object, Object>>(billDynObjList.size() * 2);
        DynamicObjectCollection billentries = null;
        Long billId = null;
        String moveDirect = null;
        for (DynamicObject billDynObj : billDynObjList) {
            billId = billDynObj.getLong("id");
            moveDirect = this.getMoveDirectValue(billDynObj).getValue();
            billentries = billDynObj.getDynamicObjectCollection(this.getBillEntryKey());
            for (DynamicObject billentry : billentries) {
                DynamicObject materialInv = billentry.getDynamicObject(this.getItemIDKey());
                if (!this.isItemEnableSerial(materialInv)) continue;
                if (this.hasSubEntry()) {
                    DynamicObjectCollection subenties = billentry.getDynamicObjectCollection(this.getBillSnEntryKey());
                    for (DynamicObject snEntryDynObj : subenties) {
                        String snNumber = snEntryDynObj.getString(this.getSnNumberKey());
                        if (StringUtils.isEmpty((String)snNumber)) continue;
                        HashMap<String, Object> entryDataMap = new HashMap<String, Object>();
                        entryDataMap.put("billtype", billFormId);
                        entryDataMap.put("billid", billId);
                        entryDataMap.put("entryid", billentry.getLong("id"));
                        entryDataMap.put("seq", billentry.getLong("seq"));
                        entryDataMap.put("billitemid", this.getLongPkId(billentry, this.getItemIDKey()));
                        entryDataMap.put("auxptyid", this.getLongPkId(billentry, this.getAuxPtyIDKey()));
                        entryDataMap.put("lotnum", billentry.getString(this.getLotNumKey()));
                        entryDataMap.put("lotid", this.getLongPkId(billentry, this.getLotIDKey()));
                        entryDataMap.put("snnumber", snNumber);
                        entryDataMap.put("moveDirect", moveDirect);
                        entryDataMap.put("entrykey", this.getBillEntryKey());
                        billentryList.add(entryDataMap);
                    }
                    continue;
                }
                HashMap<String, Object> entryDataMap = new HashMap<String, Object>();
                entryDataMap.put("billtype", billFormId);
                entryDataMap.put("billid", billId);
                entryDataMap.put("entryid", billentry.getLong("id"));
                entryDataMap.put("seq", billentry.getLong("seq"));
                entryDataMap.put("billitemid", this.getLongPkId(billentry, this.getItemIDKey()));
                entryDataMap.put("billauxptyid", this.getLongPkId(billentry, this.getAuxPtyIDKey()));
                entryDataMap.put("billlotnum", billentry.getString(this.getLotNumKey()));
                entryDataMap.put("billlotid", this.getLongPkId(billentry, this.getLotIDKey()));
                entryDataMap.put("snnumber", billentry.getString(this.getSnNumberKey()));
                entryDataMap.put("moveDirect", moveDirect);
                entryDataMap.put("entrykey", this.getBillEntryKey());
                billentryList.add(entryDataMap);
            }
        }
        return billentryList;
    }

    private boolean isItemEnableSerial(DynamicObject itemDynObj) {
        if (itemDynObj == null) {
            return false;
        }
        return itemDynObj.getBoolean("enableserial");
    }

    public final List<SnMainFileVO> getSnMainFileData(List<DynamicObject> billDynObjList, String billFormId, OperateTypeEnum operateType) {
        ArrayList<SnMainFileVO> snMainFileVOList = new ArrayList<SnMainFileVO>();
        if (CommonUtils.isNull(billDynObjList)) {
            return snMainFileVOList;
        }
        for (DynamicObject billDynObj : billDynObjList) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection(this.getBillEntryKey());
            if (CommonUtils.isNull((Object)entryColl)) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection(this.getBillSnEntryKey());
                if (CommonUtils.isNull((Object)snEntryColl)) continue;
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    String snNumber = snEntryDynObj.getString(this.getSnNumberKey());
                    if (StringUtils.isEmpty((String)snNumber)) continue;
                    SnMainFileVO snMainFileVO = new SnMainFileVO();
                    snMainFileVO.setNumber(snNumber);
                    snMainFileVO.setAuxsno(DynamicObjectUtils.getString((DynamicObject)snEntryDynObj, (String)this.getAuxSnoKey()));
                    snMainFileVO.setAuxsnt(DynamicObjectUtils.getString((DynamicObject)snEntryDynObj, (String)this.getAuxSntKey()));
                    snMainFileVO.setOutboxno(DynamicObjectUtils.getString((DynamicObject)snEntryDynObj, (String)this.getOutBoxNoKey()));
                    snMainFileVO.setPackageno(DynamicObjectUtils.getString((DynamicObject)snEntryDynObj, (String)this.getPackageNoKey()));
                    snMainFileVO.setSnStatus(this.getSnStatusValue(billDynObj, operateType));
                    this.setSnMainFileData(billDynObj, entryDynObj, snMainFileVO);
                    ArrayList<SnMoveTrackVO> snMoveTrackVOList = new ArrayList<SnMoveTrackVO>();
                    SnMoveTrackVO snMoveTrackVO = new SnMoveTrackVO();
                    snMoveTrackVO.setBillEntityID(billFormId);
                    snMoveTrackVO.setRemark(snEntryDynObj.getString(this.getSerialCommentKey()));
                    this.setInBillSnMoveTrackData(billDynObj, entryDynObj, snMoveTrackVO);
                    snMoveTrackVO.setDeleteSnMoveTrack(this.isDeleteSnMoveTrack(billDynObj, operateType));
                    snMoveTrackVOList.add(snMoveTrackVO);
                    snMainFileVO.setSnMoveTrackVOList(snMoveTrackVOList);
                    snMainFileVOList.add(snMainFileVO);
                }
            }
        }
        return snMainFileVOList;
    }

    private void setSnMainFileData(DynamicObject billDynObj, DynamicObject entryDynObj, SnMainFileVO snMainFileVO) {
        snMainFileVO.setScmSNID(this.getLongPkId(entryDynObj, this.getScmSNIDKey()));
        snMainFileVO.setItemID(this.getLongPkId(entryDynObj, this.getItemIDKey()));
        snMainFileVO.setMaterialID(this.getLongPkId(entryDynObj, this.getMaterialIDKey()));
        snMainFileVO.setAuxPtyID(this.getLongPkId(entryDynObj, this.getAuxPtyIDKey()));
        snMainFileVO.setLotID(this.getLongPkId(entryDynObj, this.getLotIDKey()));
        snMainFileVO.setLotNum(entryDynObj.getString(this.getLotNumKey()));
        snMainFileVO.setProjectID(this.getLongPkId(entryDynObj, this.getProjectIDKey()));
        snMainFileVO.setProductDate(entryDynObj.getDate(this.getProductDateKey()));
        snMainFileVO.setEffectiveDate(entryDynObj.getDate(this.getEffectiveDateKey()));
        snMainFileVO.setChannelID(this.getLongPkId(billDynObj, this.getChannelIDKey()));
        snMainFileVO.setSaleOrgID(this.getLongPkId(billDynObj, this.getSaleOrgIDKey()));
        snMainFileVO.setSaleChannelID(this.getLongPkId(billDynObj, this.getSaleChannelIDKey()));
        snMainFileVO.setChannelStockId(this.getLongPkId(entryDynObj, this.getChannelStockIdKey()));
        snMainFileVO.setChannelLocationID(this.getLongPkId(entryDynObj, this.getChannelLocationIDKey()));
        snMainFileVO.setChannelStockStatusID(this.getLongPkId(entryDynObj, this.getChannelStockStatusIDKey()));
        snMainFileVO.setChannelStockTypeID(this.getLongPkId(entryDynObj, this.getChannelStockTypeIDKey()));
        snMainFileVO.setOwnerID(this.getLongPkId(entryDynObj, this.getOwnerIDKey()));
        snMainFileVO.setOwnerType(entryDynObj.getString(this.getOwnerTypeKey()));
        snMainFileVO.setKeeperID(this.getLongPkId(entryDynObj, this.getKeeperIDKey()));
        snMainFileVO.setKeeperType(entryDynObj.getString(this.getKeeperTypeKey()));
        snMainFileVO.setBillId(billDynObj.getLong("id"));
    }

    private void setInBillSnMoveTrackData(DynamicObject billDynObj, DynamicObject entryDynObj, SnMoveTrackVO snMoveTrackVO) {
        MoveDirectEnum moveDirect = this.getMoveDirectValue(billDynObj);
        if (MoveDirectEnum.MOVEDIRECT_SRC == moveDirect) {
            snMoveTrackVO.setMoveDirect(moveDirect);
            snMoveTrackVO.setSrcChannelID(this.getLongPkId(billDynObj, this.getChannelIDKey()));
            snMoveTrackVO.setSrcChannelStockId(this.getLongPkId(entryDynObj, this.getChannelStockIdKey()));
            snMoveTrackVO.setSrcChannelLocationID(this.getLongPkId(entryDynObj, this.getChannelLocationIDKey()));
            snMoveTrackVO.setSrcSaleOrgID(this.getLongPkId(billDynObj, this.getSaleOrgIDKey()));
            snMoveTrackVO.setSrcSaleChannelID(this.getLongPkId(billDynObj, this.getSaleChannelIDKey()));
            snMoveTrackVO.setSrcChannelStockStatusID(this.getLongPkId(entryDynObj, this.getChannelStockStatusIDKey()));
            snMoveTrackVO.setSrcChannelStockTypeID(this.getLongPkId(entryDynObj, this.getChannelStockTypeIDKey()));
            snMoveTrackVO.setSrcOwnerID(this.getLongPkId(entryDynObj, this.getOwnerIDKey()));
            snMoveTrackVO.setSrcOwnerType(entryDynObj.getString(this.getOwnerTypeKey()));
            snMoveTrackVO.setSrcKeeperID(this.getLongPkId(entryDynObj, this.getKeeperIDKey()));
            snMoveTrackVO.setSrcKeeperType(entryDynObj.getString(this.getKeeperTypeKey()));
        } else {
            snMoveTrackVO.setMoveDirect(moveDirect);
            snMoveTrackVO.setDestChannelID(this.getLongPkId(billDynObj, this.getOrderChannelIDKey()));
            snMoveTrackVO.setDestSaleOrgID(this.getLongPkId(billDynObj, this.getSaleOrgIDKey()));
            snMoveTrackVO.setDestSaleChannelID(this.getLongPkId(billDynObj, this.getSaleChannelIDKey()));
        }
        snMoveTrackVO.setMoveDate(TimeServiceHelper.now());
        snMoveTrackVO.setBillID(billDynObj.getLong("id"));
        snMoveTrackVO.setBillNo(billDynObj.getString(this.getBillNoKey()));
        snMoveTrackVO.setBillDate(billDynObj.getDate(this.getBillDateKey()));
        snMoveTrackVO.setBillEntryID(entryDynObj.getLong("id"));
        snMoveTrackVO.setItemID(this.getLongPkId(entryDynObj, this.getItemIDKey()));
        snMoveTrackVO.setMaterialID(this.getLongPkId(entryDynObj, this.getMaterialIDKey()));
        snMoveTrackVO.setAuxPtyID(this.getLongPkId(entryDynObj, this.getAuxPtyIDKey()));
    }

    private long getLongPkId(DynamicObject billDynObj, String fieldKey) {
        if (StringUtils.isEmpty((String)fieldKey)) {
            return 0L;
        }
        return billDynObj.getLong(fieldKey + "_id");
    }

    protected boolean isDeleteSnMoveTrack(DynamicObject billDynObj, OperateTypeEnum operateType) {
        return false;
    }
}

