/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.business.sn.mainfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ococic.business.sn.billdata.SnMainFileData;
import kd.occ.ococic.business.sn.billdata.SnMainFileDataCreateFactory;
import kd.occ.ococic.enums.MoveDirectEnum;
import kd.occ.ococic.enums.OperateTypeEnum;
import kd.occ.ococic.enums.SnStatusEnum;
import kd.occ.ococic.pojo.SnMainFileVO;
import kd.occ.ococic.pojo.SnMoveTrackVO;
import kd.occ.ococic.util.CommonUtils;

public class SnMainFileProcessor {
    public List<SnMainFileVO> saveSnMainFile(List<DynamicObject> billDynObjList, String billFormId) {
        List<SnMainFileVO> saveSnMainFileVOList = new ArrayList<SnMainFileVO>();
        if (CommonUtils.isNull(billDynObjList)) {
            return saveSnMainFileVOList;
        }
        List<Long> billIdList = billDynObjList.stream().filter(billDynObj -> billDynObj.getLong("id") > 0L).map(billDynObj -> billDynObj.getLong("id")).collect(Collectors.toList());
        this.deleteSnMainFile(billIdList, billFormId);
        SnMainFileData snMainFileData = SnMainFileDataCreateFactory.getSnMainFileData(billFormId);
        List<SnMainFileVO> snMainFileVOList = snMainFileData.getSnMainFileData(billDynObjList, billFormId, OperateTypeEnum.SAVE);
        saveSnMainFileVOList = this.saveSnMainFile(snMainFileVOList);
        return saveSnMainFileVOList;
    }

    public List<SnMainFileVO> updateSnMainFileByFormId(List<Long> billIdList, String billFormId, OperateTypeEnum operateType) {
        List<SnMainFileVO> saveSnMainFileVOList = new ArrayList<SnMainFileVO>();
        if (CommonUtils.isNull(billIdList)) {
            return saveSnMainFileVOList;
        }
        DynamicObject[] billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFormId));
        SnMainFileData snMainFileData = SnMainFileDataCreateFactory.getSnMainFileData(billFormId);
        List<SnMainFileVO> snMainFileVOList = snMainFileData.getSnMainFileData(CommonUtils.convertToList((DynamicObject[])billDynObjs), billFormId, operateType);
        saveSnMainFileVOList = this.saveSnMainFile(snMainFileVOList);
        return saveSnMainFileVOList;
    }

    private long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }

    private String getBaseDataStringPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getString(fieldKey + "_id");
    }

    public List<SnMainFileVO> saveSnMainFile(List<SnMainFileVO> snMainFileVOList) {
        if (CommonUtils.isNull(snMainFileVOList)) {
            return snMainFileVOList;
        }
        this.querySnMainFileId(snMainFileVOList);
        snMainFileVOList = this.batchSaveSnMainFileData(snMainFileVOList);
        ArrayList<SnMoveTrackVO> snMoveTractVOList = new ArrayList<SnMoveTrackVO>();
        for (SnMainFileVO snMainFileVO : snMainFileVOList) {
            if (snMainFileVO.getSnMoveTrackVOList() == null || snMainFileVO.getSnMoveTrackVOList().size() <= 0) continue;
            for (SnMoveTrackVO moveTractVO : snMainFileVO.getSnMoveTrackVOList()) {
                moveTractVO.setSnMainFileID(snMainFileVO.getSnMainFileID());
            }
            snMoveTractVOList.addAll(snMainFileVO.getSnMoveTrackVOList());
        }
        this.batchSaveSnMoveTrackVO(snMoveTractVOList);
        return snMainFileVOList;
    }

    public Map<Long, List<String>> checkSnByBill(List<DynamicObject> billDynObjList, String billFormId) {
        SnMainFileData snMainFileData = SnMainFileDataCreateFactory.getSnMainFileData(billFormId);
        Map<Long, List<String>> result = snMainFileData.checkSnMainFileData(billDynObjList, billFormId);
        return result;
    }

    public Map<Long, List<String>> apicheckSnMainFileData(List<Map<Object, Object>> allEntryDynObjList, String billFormId) {
        SnMainFileData snMainFileData = SnMainFileDataCreateFactory.getSnMainFileData(billFormId);
        Map<Long, List<String>> result = snMainFileData.apicheckSnMainFileData(allEntryDynObjList, billFormId);
        return result;
    }

    private void querySnMainFileId(List<SnMainFileVO> snMainFileVOList) {
        if (snMainFileVOList.size() == 0) {
            return;
        }
        List snNumberList = snMainFileVOList.stream().filter(snMainFileVO -> StringUtils.isNotEmpty((CharSequence)snMainFileVO.getNumber())).map(SnMainFileVO::getNumber).collect(Collectors.toList());
        QFilter filter = new QFilter("number", "in", (Object)snNumberList.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])new QFilter[]{filter});
        if (snDynObjs != null && snDynObjs.length > 0) {
            block0: for (SnMainFileVO snMainFileVO2 : snMainFileVOList) {
                for (DynamicObject barcodeDynObj : snDynObjs) {
                    if (!snMainFileVO2.getNumber().equals(barcodeDynObj.getString("number"))) continue;
                    snMainFileVO2.setSnMainFileID(barcodeDynObj.getLong("id"));
                    continue block0;
                }
            }
        }
    }

    private List<SnMainFileVO> batchSaveSnMainFileData(List<SnMainFileVO> snMainFileVOList) {
        if (CommonUtils.isNull(snMainFileVOList)) {
            return snMainFileVOList;
        }
        ArrayList<DynamicObject> svnMainFileList = new ArrayList<DynamicObject>(snMainFileVOList.size());
        List snMainFileIdList = snMainFileVOList.stream().filter(snMainFileVO -> snMainFileVO.getSnMainFileID() > 0L).map(SnMainFileVO::getSnMainFileID).collect(Collectors.toList());
        DynamicObject[] snMainFileDynObjs = BusinessDataServiceHelper.load((Object[])snMainFileIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococic_snmainfile"));
        DynamicObject newSnDynObj = null;
        for (SnMainFileVO snMainFileVO2 : snMainFileVOList) {
            if (snMainFileVO2.getSnMainFileID() > 0L) {
                DynamicObject[] dynamicObjectArray = snMainFileDynObjs;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject dynObj = dynamicObjectArray[i];
                    if (snMainFileVO2.getSnMainFileID() != dynObj.getLong("id")) continue;
                    newSnDynObj = dynObj;
                }
            } else {
                newSnDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ococic_snmainfile");
            }
            if (newSnDynObj == null) continue;
            if (snMainFileVO2.getSnMainFileID() <= 0L) {
                newSnDynObj.set("number", (Object)snMainFileVO2.getNumber());
                newSnDynObj.set("auxsno", (Object)snMainFileVO2.getAuxsno());
                newSnDynObj.set("auxsnt", (Object)snMainFileVO2.getAuxsnt());
                newSnDynObj.set("outboxno", (Object)snMainFileVO2.getOutboxno());
                newSnDynObj.set("packageno", (Object)snMainFileVO2.getPackageno());
                newSnDynObj.set("materialid", (Object)snMainFileVO2.getMaterialID());
                newSnDynObj.set("itemid", (Object)snMainFileVO2.getItemID());
                newSnDynObj.set("auxptyid", (Object)snMainFileVO2.getAuxPtyID());
                newSnDynObj.set("scmsnid", (Object)snMainFileVO2.getScmSNID());
                newSnDynObj.set("lotid", (Object)snMainFileVO2.getLotID());
                newSnDynObj.set("lotnum", (Object)snMainFileVO2.getLotNum());
                newSnDynObj.set("projectid", (Object)snMainFileVO2.getProjectID());
                newSnDynObj.set("productdate", (Object)snMainFileVO2.getProductDate());
                newSnDynObj.set("effectivedate", (Object)snMainFileVO2.getEffectiveDate());
                newSnDynObj.set("lockstatus", (Object)"0");
                newSnDynObj.set("createtype", (Object)"D");
                newSnDynObj.set("creator", (Object)RequestContext.get().getUserId());
                newSnDynObj.set("createtime", (Object)TimeServiceHelper.now());
            } else if (newSnDynObj.getLong("lotid_id") == 0L && StringUtils.isNotEmpty((CharSequence)newSnDynObj.getString("lotnum"))) {
                newSnDynObj.set("lotid", (Object)snMainFileVO2.getLotID());
            }
            if ("ocbsoc_delivery_record".equalsIgnoreCase(((SnMoveTrackVO)snMainFileVO2.getSnMoveTrackVOList().get(0)).getBillEntityID())) {
                newSnDynObj.set("hbillid", (Object)0L);
            }
            newSnDynObj.set("snstatus", (Object)snMainFileVO2.getSnStatus().getValue());
            newSnDynObj.set("channelid", (Object)snMainFileVO2.getChannelID());
            newSnDynObj.set("salechannelid", (Object)snMainFileVO2.getSaleChannelID());
            newSnDynObj.set("saleorgid", (Object)snMainFileVO2.getSaleOrgID());
            newSnDynObj.set("channelstockid", (Object)snMainFileVO2.getChannelStockId());
            newSnDynObj.set("channellocationid", (Object)snMainFileVO2.getChannelLocationID());
            newSnDynObj.set("channelstockstatusid", (Object)snMainFileVO2.getChannelStockStatusID());
            newSnDynObj.set("channelstocktypeid", (Object)snMainFileVO2.getChannelStockTypeID());
            newSnDynObj.set("ownertype", (Object)snMainFileVO2.getOwnerType());
            newSnDynObj.set("ownerid", (Object)snMainFileVO2.getOwnerID());
            newSnDynObj.set("keepertype", (Object)snMainFileVO2.getKeeperType());
            newSnDynObj.set("keeperid", (Object)snMainFileVO2.getKeeperID());
            newSnDynObj.set("modifier", (Object)RequestContext.get().getUserId());
            newSnDynObj.set("modifytime", (Object)TimeServiceHelper.now());
            svnMainFileList.add(newSnDynObj);
        }
        Object[] resutlObjs = SaveServiceHelper.save((DynamicObject[])svnMainFileList.toArray(new DynamicObject[svnMainFileList.size()]));
        if (resutlObjs != null && resutlObjs.length > 0) {
            for (Object object : resutlObjs) {
                DynamicObject resutlDynObj = (DynamicObject)object;
                for (SnMainFileVO snMainFileVO3 : snMainFileVOList) {
                    if (!resutlDynObj.getString("number").equals(snMainFileVO3.getNumber())) continue;
                    snMainFileVO3.setSnMainFileID(resutlDynObj.getLong("id"));
                }
            }
        }
        return snMainFileVOList;
    }

    private void batchSaveSnMoveTrackVO(List<SnMoveTrackVO> snMoveTractVOList) {
        if (snMoveTractVOList.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> snMoveTrackList = new ArrayList<DynamicObject>(snMoveTractVOList.size());
        DynamicObject newSnMoveTrackDynObj = null;
        List snMainFileIdList = snMoveTractVOList.stream().filter(snMoveTrackVO -> snMoveTrackVO.getSnMainFileID() > 0L).map(SnMoveTrackVO::getSnMainFileID).collect(Collectors.toList());
        QFilter snFileIdFilter = new QFilter("snmainfileid", "in", (Object)snMainFileIdList.toArray());
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ococic_snmovetrack");
        DynamicObject[] moveTrackDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmovetrack", (String)String.join((CharSequence)",", type.getFields().keySet()), (QFilter[])new QFilter[]{snFileIdFilter});
        HashMap<Long, DynamicObject> srcMoveTrackMap = new HashMap<Long, DynamicObject>();
        HashMap<String, DynamicObject> billMoveTrackMap = new HashMap<String, DynamicObject>();
        String keyStr = "";
        if (moveTrackDynObjs != null && moveTrackDynObjs.length > 0) {
            long snMainFileId = 0L;
            for (DynamicObject moveTrackDynObj : moveTrackDynObjs) {
                if (MoveDirectEnum.MOVEDIRECT_SRC.getValue().equals(moveTrackDynObj.getString("movedirect"))) {
                    snMainFileId = this.getBaseDataLongPkId(moveTrackDynObj, "snmainfileid");
                    srcMoveTrackMap.put(snMainFileId, moveTrackDynObj);
                }
                keyStr = moveTrackDynObj.getLong("billid") + "_" + moveTrackDynObj.getLong("billentryid") + "_" + this.getBaseDataStringPkId(moveTrackDynObj, "billentityid");
                billMoveTrackMap.put(keyStr, moveTrackDynObj);
            }
        }
        HashSet<Long> deleteBillIdSet = new HashSet<Long>();
        HashSet<Long> deleteBillEntryIdSet = new HashSet<Long>();
        HashSet<String> deleteBillEntityIdSet = new HashSet<String>();
        for (SnMoveTrackVO snMoveTrackVO2 : snMoveTractVOList) {
            if (snMoveTrackVO2.isDeleteSnMoveTrack()) {
                deleteBillIdSet.add(snMoveTrackVO2.getBillID());
                deleteBillEntryIdSet.add(snMoveTrackVO2.getBillEntryID());
                deleteBillEntityIdSet.add(snMoveTrackVO2.getBillEntityID());
                continue;
            }
            keyStr = snMoveTrackVO2.getBillID() + "_" + snMoveTrackVO2.getBillEntryID() + "_" + snMoveTrackVO2.getBillEntityID();
            newSnMoveTrackDynObj = billMoveTrackMap.get(keyStr) != null ? (DynamicObject)billMoveTrackMap.get(keyStr) : BusinessDataServiceHelper.newDynamicObject((String)"ococic_snmovetrack");
            newSnMoveTrackDynObj.set("movedirect", (Object)snMoveTrackVO2.getMoveDirect().getValue());
            newSnMoveTrackDynObj.set("billentityid", (Object)snMoveTrackVO2.getBillEntityID());
            newSnMoveTrackDynObj.set("billno", (Object)snMoveTrackVO2.getBillNo());
            newSnMoveTrackDynObj.set("itemid", (Object)snMoveTrackVO2.getItemID());
            newSnMoveTrackDynObj.set("billid", (Object)snMoveTrackVO2.getBillID());
            newSnMoveTrackDynObj.set("snmainfileid", (Object)snMoveTrackVO2.getSnMainFileID());
            newSnMoveTrackDynObj.set("materialid", (Object)snMoveTrackVO2.getMaterialID());
            newSnMoveTrackDynObj.set("movedate", (Object)snMoveTrackVO2.getMoveDate());
            newSnMoveTrackDynObj.set("billdate", (Object)snMoveTrackVO2.getBillDate());
            long srcChannelID = 0L;
            long srcChannelStockId = 0L;
            long srcChannelLocationID = 0L;
            long srcSaleOrgID = 0L;
            long srcSaleChannelID = 0L;
            long srcChannelStockStatusID = 0L;
            long srcChannelStockTypeID = 0L;
            long srcOwnerID = 0L;
            String srcOwnerType = "";
            long srcKeeperID = 0L;
            String srcKeeperType = "";
            if (srcMoveTrackMap.containsKey(snMoveTrackVO2.getSnMainFileID()) && MoveDirectEnum.MOVEDIRECT_DES == snMoveTrackVO2.getMoveDirect()) {
                DynamicObject trackDynObj = (DynamicObject)srcMoveTrackMap.get(snMoveTrackVO2.getSnMainFileID());
                srcChannelID = this.getBaseDataLongPkId(trackDynObj, "srcchannelid");
                srcChannelStockId = this.getBaseDataLongPkId(trackDynObj, "srcchannelstockid");
                srcChannelLocationID = this.getBaseDataLongPkId(trackDynObj, "srcchannellocationid");
                srcSaleOrgID = this.getBaseDataLongPkId(trackDynObj, "srcsaleorgid");
                srcSaleChannelID = this.getBaseDataLongPkId(trackDynObj, "srcsalechannelid");
                srcChannelStockStatusID = this.getBaseDataLongPkId(trackDynObj, "srcstockstatusid");
                srcChannelStockTypeID = this.getBaseDataLongPkId(trackDynObj, "srcstocktypeid");
                srcOwnerID = this.getBaseDataLongPkId(trackDynObj, "srcownerid");
                srcOwnerType = trackDynObj.getString("srcownertype");
                srcKeeperID = this.getBaseDataLongPkId(trackDynObj, "srckeeperid");
                srcKeeperType = trackDynObj.getString("srckeepertype");
            } else {
                srcChannelID = snMoveTrackVO2.getSrcChannelID();
                srcChannelStockId = snMoveTrackVO2.getSrcChannelStockId();
                srcChannelLocationID = snMoveTrackVO2.getSrcChannelLocationID();
                srcSaleOrgID = snMoveTrackVO2.getSrcSaleOrgID();
                srcSaleChannelID = snMoveTrackVO2.getSrcSaleChannelID();
                srcChannelStockStatusID = snMoveTrackVO2.getSrcChannelStockStatusID();
                srcChannelStockTypeID = snMoveTrackVO2.getSrcChannelStockTypeID();
                srcOwnerID = snMoveTrackVO2.getSrcOwnerID();
                srcOwnerType = snMoveTrackVO2.getSrcOwnerType();
                srcKeeperID = snMoveTrackVO2.getSrcKeeperID();
                srcKeeperType = snMoveTrackVO2.getSrcKeeperType();
            }
            newSnMoveTrackDynObj.set("srcchannelid", (Object)srcChannelID);
            newSnMoveTrackDynObj.set("srcchannelstockid", (Object)srcChannelStockId);
            newSnMoveTrackDynObj.set("srcchannellocationid", (Object)srcChannelLocationID);
            newSnMoveTrackDynObj.set("srcsaleorgid", (Object)srcSaleOrgID);
            newSnMoveTrackDynObj.set("srcsalechannelid", (Object)srcSaleChannelID);
            newSnMoveTrackDynObj.set("srcstockstatusid", (Object)srcChannelStockStatusID);
            newSnMoveTrackDynObj.set("srcstocktypeid", (Object)srcChannelStockTypeID);
            newSnMoveTrackDynObj.set("srcownerid", (Object)srcOwnerID);
            newSnMoveTrackDynObj.set("srcownertype", (Object)srcOwnerType);
            newSnMoveTrackDynObj.set("srckeeperid", (Object)srcKeeperID);
            newSnMoveTrackDynObj.set("srckeepertype", (Object)srcKeeperType);
            newSnMoveTrackDynObj.set("destchannelid", (Object)snMoveTrackVO2.getDestChannelID());
            newSnMoveTrackDynObj.set("destchannelstockid", (Object)snMoveTrackVO2.getDestChannelStockId());
            newSnMoveTrackDynObj.set("destchannellocationid", (Object)snMoveTrackVO2.getDestChannelLocationID());
            newSnMoveTrackDynObj.set("destsaleorgid", (Object)snMoveTrackVO2.getDestSaleOrgID());
            newSnMoveTrackDynObj.set("destsalechannelid", (Object)snMoveTrackVO2.getDestSaleChannelID());
            newSnMoveTrackDynObj.set("remark", (Object)snMoveTrackVO2.getRemark());
            newSnMoveTrackDynObj.set("billentryid", (Object)snMoveTrackVO2.getBillEntryID());
            newSnMoveTrackDynObj.set("auxptyid", (Object)snMoveTrackVO2.getAuxPtyID());
            snMoveTrackList.add(newSnMoveTrackDynObj);
        }
        if (snMoveTrackList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])snMoveTrackList.toArray(new DynamicObject[snMoveTrackList.size()]));
        }
        if (deleteBillIdSet.size() > 0) {
            QFilter billIdFilter = new QFilter("billid", "in", (Object)deleteBillIdSet.toArray());
            QFilter billEntryIdFilter = new QFilter("billentryid", "in", (Object)deleteBillEntryIdSet.toArray());
            QFilter billEntityIdFilter = new QFilter("billentityid", "in", (Object)deleteBillEntityIdSet.toArray());
            DeleteServiceHelper.delete((String)"ococic_snmovetrack", (QFilter[])new QFilter[]{billIdFilter, billEntryIdFilter, billEntityIdFilter});
        }
    }

    public void deleteSnMainFile(List<Long> billIdList, String billFormId) {
        if (billIdList == null || billIdList.isEmpty()) {
            return;
        }
        QFilter billIdFilter = new QFilter("billid", "in", (Object)billIdList.toArray());
        QFilter billEntityIdFilter = new QFilter("billentityid", "=", (Object)billFormId);
        DynamicObject[] snMoveTrackDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmovetrack", (String)String.join((CharSequence)",", "id", "snmainfileid"), (QFilter[])new QFilter[]{billIdFilter, billEntityIdFilter});
        if (snMoveTrackDynObjs == null || snMoveTrackDynObjs.length == 0) {
            return;
        }
        HashSet<Long> trackIdSet = new HashSet<Long>(snMoveTrackDynObjs.length);
        HashSet<Long> snMainFileIdSet = new HashSet<Long>(snMoveTrackDynObjs.length);
        for (DynamicObject trackDynObj : snMoveTrackDynObjs) {
            trackIdSet.add(trackDynObj.getLong("id"));
            snMainFileIdSet.add(this.getBaseDataLongPkId(trackDynObj, "snmainfileid"));
        }
        QFilter snFileIdFilter = new QFilter("snmainfileid", "in", (Object)snMainFileIdSet.toArray());
        DynamicObject[] trackDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmovetrack", (String)String.join((CharSequence)",", "id", "snmainfileid"), (QFilter[])new QFilter[]{snFileIdFilter});
        HashMap snMainFileIdMap = new HashMap();
        long snMainFileId = 0L;
        long trackId = 0L;
        for (DynamicObject trackDynObj : trackDynObjs) {
            snMainFileId = this.getBaseDataLongPkId(trackDynObj, "snmainfileid");
            trackId = trackDynObj.getLong("id");
            if (!snMainFileIdMap.containsKey(snMainFileId)) {
                HashSet<Long> snTrackIdSet = new HashSet<Long>();
                snTrackIdSet.add(trackId);
                snMainFileIdMap.put(snMainFileId, snTrackIdSet);
            } else {
                ((Set)snMainFileIdMap.get(snMainFileId)).add(trackId);
            }
            if (((Set)snMainFileIdMap.get(snMainFileId)).size() <= 1) continue;
            snMainFileIdSet.remove(snMainFileId);
        }
        if (trackIdSet.size() > 0) {
            QFilter trackIdFilter = new QFilter("id", "in", (Object)trackIdSet.toArray());
            DeleteServiceHelper.delete((String)"ococic_snmovetrack", (QFilter[])new QFilter[]{trackIdFilter});
        }
        if (snMainFileIdSet.size() > 0) {
            QFilter snMainFileIdFilter = new QFilter("id", "in", (Object)snMainFileIdSet.toArray());
            DeleteServiceHelper.delete((String)"ococic_snmainfile", (QFilter[])new QFilter[]{snMainFileIdFilter});
        }
    }

    public void deleteSnMainFileCover(List<JSONObject> billInfoList, String billFormId) {
        if (billInfoList == null || billInfoList.isEmpty()) {
            return;
        }
        HashSet deleteSnIdSet = new HashSet(billInfoList.size());
        for (JSONObject billInfo : billInfoList) {
            QFilter SNStatusFilter;
            QFilter effectivedateFilter;
            QFilter productdateFilter;
            QFilter saleOrgFilter = new QFilter("saleorgid", "=", (Object)billInfo.getLong("saleorgid"));
            QFilter channelIdFilter = new QFilter("channelid", "=", (Object)billInfo.getLong("channelid"));
            QFilter ItemIdFilter = new QFilter("itemid", "=", (Object)billInfo.getLong("itemid"));
            QFilter auxptyIdFilter = new QFilter("auxptyid", "=", (Object)billInfo.getLong("auxptyid"));
            QFilter LotIdFilter = new QFilter("lotnum", "=", (Object)billInfo.getString("lotnum"));
            DynamicObject[] SnDynObjs = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)"id", (QFilter[])new QFilter[]{ItemIdFilter, LotIdFilter, channelIdFilter, saleOrgFilter, auxptyIdFilter, productdateFilter = new QFilter("productdate", "=", (Object)billInfo.getDate("productdate")), effectivedateFilter = new QFilter("effectivedate", "=", (Object)billInfo.getDate("effectivedate")), SNStatusFilter = new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue())});
            if (SnDynObjs == null || SnDynObjs.length <= 0) continue;
            Set snIdSet = Arrays.stream(SnDynObjs).map(r -> r.getLong("id")).collect(Collectors.toSet());
            deleteSnIdSet.addAll(snIdSet);
        }
        QFilter trackIdFilter = new QFilter("snmainfileid", "in", (Object)deleteSnIdSet.toArray());
        DeleteServiceHelper.delete((String)"ococic_snmovetrack", (QFilter[])new QFilter[]{trackIdFilter});
        QFilter snIdFilter = new QFilter("id", "in", (Object)deleteSnIdSet.toArray());
        DeleteServiceHelper.delete((String)"ococic_snmainfile", (QFilter[])new QFilter[]{snIdFilter});
    }
}

