/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocococ.common.enums.DiscountTypeEnum;

public class AmountUtil {
    public static final BigDecimal ONE = new BigDecimal("1.0");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal HUNDRED = new BigDecimal("100.0");
    protected static int PRICEPRECISION = 4;
    protected static int CURPRICEPRECISION = 4;
    protected static int CURAMOUNTPRECISION = 4;
    protected static int AMOUNTPRECISION = 4;

    public static BigDecimal calDiscountAmount(String discountType, BigDecimal taxPrice, BigDecimal qty, BigDecimal discountRate) {
        BigDecimal discountAmount = ZERO;
        if (StringUtils.isNotBlank((CharSequence)discountType) && taxPrice != null && qty != null) {
            DiscountTypeEnum discoutTypeEnum = DiscountTypeEnum.toDiscountType(discountType);
            switch (discoutTypeEnum) {
                case PERCENT: {
                    discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(HUNDRED, discountRate.scale() + 2, 4));
                    break;
                }
                case PERUNIT: {
                    discountAmount = qty.multiply(discountRate);
                    break;
                }
            }
        }
        return discountAmount;
    }

    public static BigDecimal calPriceByTaxPrice(BigDecimal taxPrice, BigDecimal taxRate) {
        return AmountUtil.calPriceByTaxPrice(taxPrice, taxRate, PRICEPRECISION);
    }

    public static BigDecimal calPriceByTaxPrice(BigDecimal taxPrice, BigDecimal taxRate, int precision) {
        BigDecimal price = ZERO;
        if (taxPrice != null) {
            taxRate = taxRate == null ? ZERO : taxRate.divide(HUNDRED, taxRate.scale() + 2, RoundingMode.HALF_UP);
            price = taxPrice.divide(ONE.add(taxRate), precision, RoundingMode.HALF_UP);
        }
        return price;
    }

    public static BigDecimal calTaxAmount(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountAmount) {
        BigDecimal taxamount = ZERO;
        if (qty != null && taxPrice != null) {
            discountAmount = discountAmount == null ? ZERO : discountAmount;
            taxamount = qty.multiply(taxPrice).subtract(discountAmount);
        }
        return taxamount;
    }

    public static BigDecimal calTax(BigDecimal taxAmount, BigDecimal taxRate) {
        return AmountUtil.calTax(taxAmount, taxRate, AMOUNTPRECISION);
    }

    public static BigDecimal calTax(BigDecimal taxAmount, BigDecimal taxRate, int precision) {
        BigDecimal tax = ZERO;
        if (taxAmount != null && taxRate != null) {
            taxRate = taxRate.divide(HUNDRED, taxRate.scale() + 2, 4);
            tax = taxAmount.multiply(taxRate).divide(taxRate.add(ONE), precision, 4);
        }
        return tax;
    }

    public static BigDecimal calAmount(BigDecimal taxAmount, BigDecimal tax) {
        BigDecimal amount = ZERO;
        if (taxAmount != null) {
            tax = tax == null ? ZERO : tax;
            amount = taxAmount.subtract(tax);
        }
        return amount;
    }

    public static BigDecimal calCurAllAmount(BigDecimal taxAmount, BigDecimal exchangeRate) {
        return AmountUtil.calCurAllAmount(taxAmount, exchangeRate, CURAMOUNTPRECISION);
    }

    public static BigDecimal calCurAllAmount(BigDecimal taxAmount, BigDecimal exchangeRate, int precision) {
        BigDecimal curAllAmount = ZERO;
        if (taxAmount != null && exchangeRate != null && ZERO.compareTo(exchangeRate) != 0) {
            curAllAmount = taxAmount.multiply(exchangeRate).setScale(precision, 4);
        }
        return curAllAmount;
    }

    public static BigDecimal calCurTaxAmount(BigDecimal tax, BigDecimal exchangeRate) {
        return AmountUtil.calCurTaxAmount(tax, exchangeRate, CURAMOUNTPRECISION);
    }

    public static BigDecimal calCurTaxAmount(BigDecimal tax, BigDecimal exchangeRate, int precision) {
        BigDecimal curTaxAmount = ZERO;
        if (tax != null && exchangeRate != null && ZERO.compareTo(exchangeRate) != 0) {
            curTaxAmount = tax.multiply(exchangeRate).setScale(precision, 4);
        }
        return curTaxAmount;
    }

    public static BigDecimal calCurAmount(BigDecimal curAllAmount, BigDecimal curTaxAmount) {
        BigDecimal curAmount = ZERO;
        if (curAllAmount != null && curTaxAmount != null) {
            curAmount = curAllAmount.subtract(curTaxAmount);
        }
        return curAmount;
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxAmount, BigDecimal qty) {
        return AmountUtil.calActualTaxPrice(taxAmount, qty, PRICEPRECISION);
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxAmount, BigDecimal qty, int precision) {
        BigDecimal actualtaxprice = ZERO;
        if (taxAmount != null && qty != null && ZERO.compareTo(qty) < 0) {
            actualtaxprice = taxAmount.divide(qty).setScale(precision, 4);
        }
        return actualtaxprice;
    }

    public static BigDecimal calActualPrice(BigDecimal amount, BigDecimal qty) {
        return AmountUtil.calActualPrice(amount, qty, PRICEPRECISION);
    }

    public static BigDecimal calActualPrice(BigDecimal amount, BigDecimal qty, int precision) {
        BigDecimal actualPrice = ZERO;
        if (amount != null && qty != null && ZERO.compareTo(qty) < 0) {
            actualPrice = amount.divide(qty, precision, 4);
        }
        return actualPrice;
    }
}

