/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.mservice;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocococ.business.rewrite.WriteDeliveryStatusBackToRetailAndRetailKD;
import kd.occ.ocococ.mservice.api.DeliveryOrderService;

public class DeliveryOrderServiceImpl
implements DeliveryOrderService {
    private Log logger = LogFactory.getLog(DeliveryOrderServiceImpl.class);
    private static final String UNSIGN = "0";

    public List<Map<String, Object>> deliveryOrderWriteBack(Map<String, Object> map) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        boolean isChanged = false;
        String signStatus = null;
        if (!CollectionUtils.isEmpty(map)) {
            List details;
            Object billId = map.get("billId");
            DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocococ_deliveryorder");
            if (null != order) {
                DynamicObjectCollection logisticsInfo = order.getDynamicObjectCollection("logisticsinfo");
                DynamicObject newLogisticsRow = logisticsInfo.addNew();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date deliveryDate = null;
                try {
                    deliveryDate = sdf.parse((String)map.get("deliverydate"));
                }
                catch (ParseException e) {
                    HashMap<String, Object> result = new HashMap<String, Object>(8);
                    result.put("status", Boolean.FALSE);
                    result.put("reason", "\u53d1\u8d27\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u4f7f\u7528yyyy-MM-dd");
                    this.logger.error(e.fillInStackTrace());
                    results.add(result);
                    return results;
                }
                signStatus = map.get("signstatus").equals(UNSIGN) ? "A" : "B";
                newLogisticsRow.set("id", (Object)DB.genGlobalLongId());
                newLogisticsRow.set("seq", (Object)logisticsInfo.getRowCount());
                newLogisticsRow.set("arrivaldate", (Object)deliveryDate);
                newLogisticsRow.set("logisticscompany", map.get("logisticsName"));
                newLogisticsRow.set("logisticsbill", map.get("logisticsbill"));
                newLogisticsRow.set("driver", map.get("driverName"));
                newLogisticsRow.set("drivertel", map.get("drivertel"));
                newLogisticsRow.set("carno", map.get("carno"));
                newLogisticsRow.set("lsc_signstatus", (Object)signStatus);
            }
            if (!CollectionUtils.isEmpty((Collection)(details = (List)map.get("detail"))) && order != null) {
                DynamicObjectCollection itemEntries = order.getDynamicObjectCollection("entryentity");
                for (Map detail : details) {
                    HashMap<String, Object> result = new HashMap<String, Object>(8);
                    int index = (Integer)detail.get("seq");
                    DynamicObject entry = (DynamicObject)itemEntries.get(index - 1);
                    BigDecimal deliveryBaseQty = (BigDecimal)detail.get("qty");
                    BigDecimal deliveredBaseQty = entry.getBigDecimal("deliveredbaseqty");
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    result.put("billId", map.get("billId"));
                    result.put("seq", index);
                    if (baseQty.compareTo(deliveryBaseQty.add(deliveredBaseQty)) < 0 || BigDecimal.ZERO.compareTo(deliveryBaseQty) >= 0) {
                        result.put("status", Boolean.FALSE);
                        result.put("reason", "\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u6216\u53d1\u8d27\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u3002");
                    } else {
                        BigDecimal qty = entry.getBigDecimal("qty");
                        BigDecimal deliveryQty = deliveryBaseQty.multiply(qty).divide(baseQty, 4, 4);
                        BigDecimal assistQty = entry.getBigDecimal("assistqty");
                        BigDecimal deliveryAssistQty = deliveryBaseQty.multiply(assistQty).divide(baseQty, 4, 4);
                        BigDecimal deliveredQty = entry.getBigDecimal("deliveredqty");
                        BigDecimal deliveredAssistQty = entry.getBigDecimal("deliveredassistqty");
                        entry.set("deliveredbaseqty", (Object)deliveredBaseQty.add(deliveryBaseQty));
                        entry.set("deliveredqty", (Object)deliveredQty.add(deliveryQty));
                        entry.set("deliveredassistqty", (Object)deliveredAssistQty.add(deliveryAssistQty));
                        result.put("status", Boolean.TRUE);
                        result.put("reason", "");
                        isChanged = true;
                        if (DeliveryStatus.SALE_WAIT_DELIVERY.longValue() == entry.getLong("deliverystatus_id")) {
                            entry.set("signstatus", (Object)"B");
                        }
                        if (baseQty.compareTo(deliveredBaseQty.add(deliveryBaseQty)) == 0) {
                            entry.set("deliverystatus", (Object)DeliveryStatus.SALE_OUTBOUND);
                        } else {
                            entry.set("deliverystatus", (Object)DeliveryStatus.SALE_TRUCK_LOADING);
                        }
                    }
                    results.add(result);
                }
            }
            if (isChanged) {
                if (DeliveryStatus.SALE_WAIT_DELIVERY.longValue() == order.getLong("deliveryallstatus_id")) {
                    order.set("signallstatus", (Object)"B");
                }
                order.set("deliveryallstatus", (Object)DeliveryStatus.SALE_OUTBOUND);
                DynamicObjectCollection items = order.getDynamicObjectCollection("entryentity");
                boolean isAllDelivered = true;
                for (DynamicObject item : items) {
                    if (DeliveryStatus.SALE_OUTBOUND.longValue() == item.getLong("deliverystatus_id")) continue;
                    isAllDelivered = false;
                    break;
                }
                if (isAllDelivered) {
                    order.set("deliveryallstatus", (Object)DeliveryStatus.SALE_OUTBOUND);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
            }
            this.wirteBackDeliveryStatusToRetailAndRetailKD(order);
        }
        return results;
    }

    public void wirteBackDeliveryStatusToRetailAndRetailKD(DynamicObject order) {
        try {
            DynamicObjectCollection itemEntries;
            if (order != null && (itemEntries = order.getDynamicObjectCollection("entryentity")) != null && itemEntries.size() > 0) {
                for (int i = 0; i < itemEntries.size(); ++i) {
                    WriteDeliveryStatusBackToRetailAndRetailKD.writeBackEachRowData((DynamicObject)((DynamicObject)itemEntries.get(i)));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

