/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.opplugin.deliveryorder;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocococ.business.push.AutoPushHelper;
import kd.occ.ocococ.opplugin.deliveryorder.DeliveryOrderValidator;

public class DeliveryOrderAudit
extends AbstractOperationServicePlugIn {
    private static final String SOURCE_ENTITY = "ocococ_deliveryorder";
    private static final String TARGET_ENTITY = "im_saloutbill";
    private static Log logger = LogFactory.getLog(DeliveryOrderAudit.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("distributionmode");
        e.getFieldKeys().add("reccustomer");
        e.getFieldKeys().add("deliveryallstatus");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.deliveryserialnumber");
        e.getFieldKeys().add("entryentity.corebillid");
        e.getFieldKeys().add("entryentity.corebillentity");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        block7: for (DynamicObject dataEntity : dataEntities) {
            String billtypenumber;
            DynamicObject billtype = dataEntity.getDynamicObject("billtype");
            switch (billtypenumber = billtype.getString("number")) {
                case "ocococ_deliveryorder_RD_S": 
                case "ocococ_deliveryorder_RR_N": {
                    this.deliveryOrderAutoPush(dataEntity, billtypenumber);
                    continue block7;
                }
            }
        }
    }

    private void deliveryOrderAutoPush(DynamicObject dataEntity, String billtypenumber) {
        boolean checkResult = this.checkIsNeedPush(dataEntity);
        if (!checkResult) {
            return;
        }
        OperationResult opResult = AutoPushHelper.autoPushBill((Object)dataEntity.getPkValue(), (String)SOURCE_ENTITY, (String)TARGET_ENTITY, (String)"audit");
        if (opResult == null || !opResult.isSuccess()) {
            StringBuilder errorMessage = new StringBuilder();
            if (opResult == null) {
                errorMessage.append(String.format("\u53d1\u8d27\u5355%s\u4e0b\u63a8\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
            } else {
                errorMessage.append(ObjectUtils.nullSafeToString((Object)opResult.getAllErrorOrValidateInfo()));
                if (opResult.getInteractionContext() != null) {
                    errorMessage.append(opResult.getInteractionContext().getSimpleMessage());
                }
                if (errorMessage.length() == 0) {
                    errorMessage.append(opResult.getMessage());
                }
            }
            logger.info(errorMessage.toString());
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)DynamicObjectUtils.getPkValue((DynamicObject)dataEntity), 0, 0, "errorCode_0", "", errorMessage.toString(), ErrorLevel.Warning);
            this.getOperationResult().addErrorInfo((OperateErrorInfo)info);
        }
    }

    private boolean checkIsNeedPush(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            QFilter qFilter;
            DynamicObject saleOrder;
            boolean isInitBill;
            long coreBillId = DynamicObjectUtils.getLong((DynamicObject)((DynamicObject)entryEntity.get(0)), (String)"corebillid");
            String coreBillEntity = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)entryEntity.get(0)), (String)"corebillentity");
            if (coreBillId > 0L && StringUtils.isNotEmpty((CharSequence)coreBillEntity) && (isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)(saleOrder = QueryServiceHelper.queryOne((String)coreBillEntity, (String)"isinitbill", (QFilter[])(qFilter = new QFilter("id", "=", (Object)coreBillId)).toArray())), (String)"isinitbill"))) {
                return false;
            }
        }
        return true;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DeliveryOrderValidator());
    }
}

