/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.opplugin.deliveryorder;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocococ.business.push.AutoPushHelper;
import kd.occ.ocococ.business.rewrite.DeliveryOrderWriteBackHelper;
import kd.occ.ocococ.opplugin.deliveryorder.RetailDeliveryOrderValidator;

public class RetailDeliveryOrderOp
extends AbstractOperationServicePlugIn {
    private static final String OP_CONFIRMDELIVERY = "confirmdelivery";
    private static final String OP_SIGN = "sign";
    private static final String OP_CONFIRMRECEIVE = "confirmreceive";
    private static final String SOURCE_ENTITY = "ocococ_deliveryorder";
    private static final String TARGET_ENTITY = "im_saloutbill";
    private static final Log logger = LogFactory.getLog(RetailDeliveryOrderOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("deliveryallstatus");
        e.getFieldKeys().add("signallstatus");
        e.getFieldKeys().add("entryentity.deliverystatus");
        e.getFieldKeys().add("entryentity.srcbillentity");
        e.getFieldKeys().add("entryentity.srcbillentryid");
        e.getFieldKeys().add("entryentity.srcbilleid");
        e.getFieldKeys().add("entryentity.deliverystatus");
        e.getFieldKeys().add("entryentity.signstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RetailDeliveryOrderValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        block10: for (DynamicObject bill : bills = e.getDataEntities()) {
            if (key == null) continue;
            switch (key) {
                case "confirmdelivery": {
                    DynamicObject toDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)1026079259451832320L, (String)"ococic_deliverstatus");
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherDeliveryStatus((DynamicObject)bill, null, (DynamicObject)toDeliveryStatus);
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherOrderStatus((DynamicObject)bill, null, (String)"B");
                    continue block10;
                }
                case "sign": {
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherSignStatus((DynamicObject)bill, null, (String)"D");
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherOrderStatus((DynamicObject)bill, null, (String)"D");
                    continue block10;
                }
                case "confirmreceive": {
                    DynamicObject toDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)1026080809389766656L, (String)"ococic_deliverstatus");
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherDeliveryStatus((DynamicObject)bill, null, (DynamicObject)toDeliveryStatus);
                    DeliveryOrderWriteBackHelper.updateDeliveryOrderAndOtherOrderStatus((DynamicObject)bill, null, (String)"G");
                    this.autoPush(bill);
                    continue block10;
                }
            }
        }
    }

    private void autoPush(DynamicObject deliveryOrder) {
        OperationResult opResult;
        DynamicObject billType = deliveryOrder.getDynamicObject("billtype");
        String billTypeNumber = billType.getString("number");
        if ("ocococ_deliveryorder_RR_N".equals(billTypeNumber) && ((opResult = AutoPushHelper.autoPushBill((Object)deliveryOrder.getPkValue(), (String)SOURCE_ENTITY, (String)TARGET_ENTITY, (String)"audit")) == null || !opResult.isSuccess())) {
            StringBuilder pushMsgBuilder = new StringBuilder();
            if (opResult == null) {
                pushMsgBuilder.append(String.format("\u53d1\u8d27\u5355:%s \u4e0b\u63a8\u5931\u8d25\uff0c\u672a\u77e5\u539f\u56e0\uff1anull", DynamicObjectUtils.getString((DynamicObject)deliveryOrder, (String)"billno")));
            } else {
                String errorMessage = opResult.getMessage();
                if (StringUtils.isEmpty((CharSequence)errorMessage)) {
                    opResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                    pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                } else {
                    pushMsgBuilder.append(errorMessage);
                }
            }
            logger.info(pushMsgBuilder.toString());
            ValidationErrorInfo info2 = new ValidationErrorInfo("", (Object)DynamicObjectUtils.getPkValue((DynamicObject)deliveryOrder), 0, 0, "errorCode_0", "", pushMsgBuilder.toString(), ErrorLevel.Warning);
            this.getOperationResult().addErrorInfo((OperateErrorInfo)info2);
        }
    }
}

