/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.opplugin.retail;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocococ.business.push.AutoPushHelper;

public class Audit
extends AbstractOperationServicePlugIn {
    private static final String SOURCE_ENTITY = "ocococ_retailbill";
    private static final String TARGET_ENTITY = "ocococ_deliveryorder";
    private static Log logger = LogFactory.getLog(Audit.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("saleoption");
        e.getFieldKeys().add("entryentity.goodsid");
        e.getFieldKeys().add("entryentity.sourcebillid");
        e.getFieldKeys().add("ribilldelivery.isdelivery");
        e.getFieldKeys().add("ribilldelivery.deliveryserialnumber");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            try {
                OperationResult opResult;
                boolean isNeedPush = this.checkIsNeedPush(dataEntity);
                if (!isNeedPush || (opResult = AutoPushHelper.autoPushBill((Object)dataEntity.getPkValue(), (String)SOURCE_ENTITY, (String)TARGET_ENTITY, (String)"audit")) != null && opResult.isSuccess()) continue;
                StringBuilder pushMsgBuilder = new StringBuilder();
                if (opResult == null) {
                    pushMsgBuilder.append(String.format("\u96f6\u552e\u5355:%s \u4e0b\u63a8\u5931\u8d25\uff0c\u672a\u77e5\u539f\u56e0\uff1anull", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                } else {
                    String errorMessage = opResult.getMessage();
                    if (StringUtils.isEmpty((CharSequence)errorMessage)) {
                        opResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                        pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                    } else {
                        pushMsgBuilder.append(errorMessage);
                    }
                }
                ValidationErrorInfo info2 = new ValidationErrorInfo("", (Object)DynamicObjectUtils.getPkValue((DynamicObject)dataEntity), 0, 0, "errorCode_0", "", pushMsgBuilder.toString(), ErrorLevel.Warning);
                this.getOperationResult().addErrorInfo((OperateErrorInfo)info2);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private boolean checkIsNeedPush(DynamicObject dataEntity) {
        long sourcebillid;
        boolean isNeedPush = true;
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity) && (sourcebillid = ((DynamicObject)entryentity.get(0)).getLong("sourcebillid")) > 0L) {
            String srcchangeitemtype;
            DynamicObject sourceBill;
            String selectFields;
            String srcBillType = "";
            String saleoption = dataEntity.getString("saleoption");
            if (saleoption.equals("1")) {
                selectFields = "sourcebillid,srcbiztype,srcchangeitemtype";
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ocpos_saleorder", (String)selectFields);
                srcBillType = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcbiztype");
            } else {
                selectFields = "sourcebillid,srcbillbiztype,srcchangeitemtype";
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ocpos_saleorder_return", (String)selectFields);
                srcBillType = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcbillbiztype");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)srcBillType, (CharSequence)"H") && StringUtils.equals((CharSequence)(srcchangeitemtype = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcchangeitemtype")), (CharSequence)"3")) {
                isNeedPush = false;
            }
        }
        return isNeedPush;
    }
}

