/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.business.deliveryorder;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocococ.common.util.AmountUtil;

public class DeliveryOrderBotpHelper {
    protected static final int RECISION = 4;

    public static DynamicObject afterConvert(DynamicObject bill) {
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        if (entryentity != null && entryentity.size() > 0) {
            int pricePrecision = 4;
            int amtPrecision = 4;
            int curAmtPrecision = 4;
            boolean hasTax = bill.getBoolean("istax");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            DynamicObject currency = bill.getDynamicObject("settlecurrency");
            DynamicObject localCur = bill.getDynamicObject("currency");
            if (currency != null) {
                pricePrecision = currency.getInt("priceprecision");
                amtPrecision = currency.getInt("amtprecision");
            }
            if (localCur != null) {
                curAmtPrecision = localCur.getInt("amtprecision");
            }
            for (DynamicObject billentry : entryentity) {
                DeliveryOrderBotpHelper.setPrice(billentry, hasTax, pricePrecision);
                DeliveryOrderBotpHelper.setDiscountAmount(billentry);
                DeliveryOrderBotpHelper.setAmount(billentry, amtPrecision);
                DeliveryOrderBotpHelper.setCurAmount(billentry, exchangeRate, curAmtPrecision);
                DeliveryOrderBotpHelper.setActualPrice(billentry, pricePrecision);
            }
            DeliveryOrderBotpHelper.setTotalAmount(entryentity, bill);
        }
        return bill;
    }

    public static void setTotalAmount(DynamicObjectCollection entryentity, DynamicObject bill) {
        BigDecimal taxallamount = bill.getBigDecimal("taxallamount");
        BigDecimal totalamount = bill.getBigDecimal("totalamount");
        BigDecimal totaltaxamount = bill.getBigDecimal("totaltaxamount");
        BigDecimal curtotalallamount = bill.getBigDecimal("curtotalallamount");
        BigDecimal curtotalamount = bill.getBigDecimal("curtotalamount");
        BigDecimal curtotaltaxamount = bill.getBigDecimal("curtotaltaxamount");
        for (DynamicObject billentry : entryentity) {
            BigDecimal curallamount;
            BigDecimal curtaxamount;
            BigDecimal curamount;
            BigDecimal tax;
            BigDecimal amount;
            BigDecimal taxAmount = billentry.getBigDecimal("taxamount");
            if (taxAmount != null) {
                taxallamount = taxallamount.add(taxAmount);
            }
            if ((amount = billentry.getBigDecimal("amount")) != null) {
                totalamount = totalamount.add(amount);
            }
            if ((tax = billentry.getBigDecimal("tax")) != null) {
                totaltaxamount = totaltaxamount.add(tax);
            }
            if ((curamount = billentry.getBigDecimal("curamount")) != null) {
                curtotalamount = curtotalamount.add(curamount);
            }
            if ((curtaxamount = billentry.getBigDecimal("curtaxamount")) != null) {
                curtotaltaxamount = curtotaltaxamount.add(curtaxamount);
            }
            if ((curallamount = billentry.getBigDecimal("curallamount")) == null) continue;
            curtotalallamount = curtotalallamount.add(curallamount);
        }
        bill.set("taxallamount", (Object)taxallamount);
        bill.set("totalamount", (Object)totalamount);
        bill.set("totaltaxamount", (Object)totaltaxamount);
        bill.set("curtotalallamount", (Object)curtotalallamount);
        bill.set("curtotalamount", (Object)curtotalamount);
        bill.set("curtotaltaxamount", (Object)curtotaltaxamount);
    }

    public static void setPrice(DynamicObject billentry, boolean hasTax, int precision) {
        BigDecimal taxPrice = billentry.getBigDecimal("taxprice");
        if (hasTax) {
            BigDecimal taxRate = billentry.getBigDecimal("taxrate");
            BigDecimal price = AmountUtil.calPriceByTaxPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)precision);
            billentry.set("price", (Object)price);
        } else {
            billentry.set("price", (Object)taxPrice);
        }
    }

    public static void setDiscountAmount(DynamicObject billentry) {
        String discountType = billentry.getString("discounttype");
        BigDecimal taxPrice = billentry.getBigDecimal("taxprice");
        BigDecimal qty = billentry.getBigDecimal("qty");
        BigDecimal discountRate = billentry.getBigDecimal("discount");
        BigDecimal discountAmount = AmountUtil.calDiscountAmount((String)discountType, (BigDecimal)taxPrice, (BigDecimal)qty, (BigDecimal)discountRate);
        billentry.set("discountamount", (Object)discountAmount);
    }

    public static void setAmount(DynamicObject billentry, int amtPrecision) {
        BigDecimal qty = billentry.getBigDecimal("qty");
        BigDecimal taxPrice = billentry.getBigDecimal("taxprice");
        BigDecimal discountAmount = billentry.getBigDecimal("discountamount");
        BigDecimal taxAmount = AmountUtil.calTaxAmount((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discountAmount);
        BigDecimal taxRate = billentry.getBigDecimal("taxrate");
        BigDecimal tax = AmountUtil.calTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)amtPrecision);
        BigDecimal amount = AmountUtil.calAmount((BigDecimal)taxAmount, (BigDecimal)tax);
        billentry.set("taxamount", (Object)taxAmount);
        billentry.set("tax", (Object)tax);
        billentry.set("amount", (Object)amount);
    }

    public static void setCurAmount(DynamicObject billentry, BigDecimal exchangeRate, int curAmtPrecision) {
        BigDecimal taxAmount = billentry.getBigDecimal("taxamount");
        BigDecimal curAllAmount = AmountUtil.calCurAllAmount((BigDecimal)taxAmount, (BigDecimal)exchangeRate, (int)curAmtPrecision);
        BigDecimal tax = billentry.getBigDecimal("tax");
        BigDecimal curTaxAmount = AmountUtil.calCurTaxAmount((BigDecimal)tax, (BigDecimal)exchangeRate, (int)curAmtPrecision);
        BigDecimal curAmount = AmountUtil.calCurAmount((BigDecimal)curAllAmount, (BigDecimal)curTaxAmount);
        billentry.set("curallamount", (Object)curAllAmount);
        billentry.set("curtaxamount", (Object)curTaxAmount);
        billentry.set("curamount", (Object)curAmount);
    }

    public static void setActualPrice(DynamicObject billentry, int pricePrecision) {
        BigDecimal discountRate = billentry.getBigDecimal("discount");
        if (discountRate == null || AmountUtil.ZERO.compareTo(discountRate) == 0) {
            BigDecimal price = billentry.getBigDecimal("price");
            BigDecimal taxPrice = billentry.getBigDecimal("taxprice");
            billentry.set("actualprice", (Object)price);
            billentry.set("actualtaxprice", (Object)taxPrice);
        } else {
            BigDecimal qty = billentry.getBigDecimal("qty");
            BigDecimal amount = billentry.getBigDecimal("amount");
            BigDecimal actualPrice = AmountUtil.calActualPrice((BigDecimal)amount, (BigDecimal)qty, (int)pricePrecision);
            BigDecimal taxAmount = billentry.getBigDecimal("taxamount");
            BigDecimal actualTaxPrice = AmountUtil.calActualTaxPrice((BigDecimal)taxAmount, (BigDecimal)qty, (int)pricePrecision);
            billentry.set("actualprice", (Object)actualPrice);
            billentry.set("actualtaxprice", (Object)actualTaxPrice);
        }
    }
}

