/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.business.deliveryorder;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;

public class PosDeliveryOrderStatusHelper {
    public static void updataSaleOrderValue(String entityName, List<Object> subEntryIds, String key, Object value) {
        DynamicObject[] saleOrders;
        QFilter qFilter = new QFilter("goodsentryentity.salesorderdelivery", "in", subEntryIds);
        for (DynamicObject saleOrder : saleOrders = BusinessDataServiceHelper.load((String)entityName, (String)("orderstatus,salesorderdelivery," + key + "," + "goodsentryentity"), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    if (!subEntryIds.contains(delivery.getPkValue())) continue;
                    delivery.set(key, value);
                }
            }
        }
        if ("deliverystatus".equals(key)) {
            PosDeliveryOrderStatusHelper.checkSaleOrderDelivery(saleOrders, value);
        }
        SaveServiceHelper.update((DynamicObject[])saleOrders);
    }

    private static void checkSaleOrderDelivery(DynamicObject[] saleOrders, Object value) {
        for (DynamicObject saleOrder : saleOrders) {
            boolean isEqual = true;
            DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    Object pkValue = delivery.getDynamicObject("deliverystatus").getPkValue();
                    if (((DynamicObject)value).getPkValue().equals(pkValue)) continue;
                    isEqual = false;
                }
            }
            if (isEqual && DeliveryStatus.SALE_OUTBOUND.equals(((DynamicObject)value).getPkValue())) {
                saleOrder.set("orderstatus", (Object)"D");
                continue;
            }
            if (!isEqual || !DeliveryStatus.RETURN_HAVE_PICK.equals(((DynamicObject)value).getPkValue())) continue;
            saleOrder.set("orderstatus", (Object)"G");
        }
    }

    public static void updataRetailOrderStatus(List<Object> subEntryIds, String key, Object value) {
        DynamicObject[] retailOrders;
        QFilter qFilter = new QFilter("entryentity.ribilldelivery", "in", subEntryIds);
        for (DynamicObject retailOrder : retailOrders = BusinessDataServiceHelper.load((String)"ocococ_retailbill", (String)PosDeliveryOrderStatusHelper.getRetailOrderFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection goodsEntryEntity = retailOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("ribilldelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    if (!subEntryIds.contains(delivery.getPkValue())) continue;
                    delivery.set(key, value);
                }
            }
        }
        if ("deliverystatus".equals(key)) {
            PosDeliveryOrderStatusHelper.checkRetailOrderDelivery(retailOrders, value);
        }
        SaveServiceHelper.update((DynamicObject[])retailOrders);
    }

    private static void checkRetailOrderDelivery(DynamicObject[] retailOrders, Object value) {
        for (DynamicObject retailOrder : retailOrders) {
            boolean isEqual = true;
            DynamicObjectCollection goodsEntryEntity = retailOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("ribilldelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    Object pkValue = delivery.getDynamicObject("deliverystatus").getPkValue();
                    if (((DynamicObject)value).getPkValue().equals(pkValue)) continue;
                    isEqual = false;
                }
            }
            if (!isEqual || !DeliveryStatus.SALE_OUTBOUND.equals(((DynamicObject)value).getPkValue())) continue;
            retailOrder.set("orderstatus", (Object)"D");
        }
    }

    public static void updataDeliveryOrderStatus(List<Object> subEntryIds, DynamicObject deliveryStatus) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)PosDeliveryOrderStatusHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryEntity = deliveryOrder.getDynamicObjectCollection("entryentity");
            deliveryOrder.set("deliveryallstatus", (Object)deliveryStatus);
            for (DynamicObject entry : entryEntity) {
                entry.set("deliverystatus", (Object)deliveryStatus);
            }
        }
        SaveServiceHelper.update((DynamicObject[])deliveryOrders);
    }

    public static void updataSignStatus(List<Object> subEntryIds, String signStatus) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)PosDeliveryOrderStatusHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryEntity = deliveryOrder.getDynamicObjectCollection("entryentity");
            deliveryOrder.set("signallstatus", (Object)signStatus);
            for (DynamicObject entry : entryEntity) {
                entry.set("signstatus", (Object)signStatus);
            }
        }
        SaveServiceHelper.update((DynamicObject[])deliveryOrders);
    }

    public static void updataReturnDataToDeliveryOrder(List<Object> subEntryIds, DynamicObject returnData) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)PosDeliveryOrderStatusHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection logiSticsInfoEntity = deliveryOrder.getDynamicObjectCollection("logisticsinfo");
            logiSticsInfoEntity.clear();
            DynamicObject logiSticsInfo = new DynamicObject(logiSticsInfoEntity.getDynamicObjectType());
            logiSticsInfo.set("arrivaldate", (Object)returnData.getDate("arrivaldate"));
            if (returnData.get("logisticscompany") != null) {
                logiSticsInfo.set("logisticscompany", returnData.getDynamicObject("logisticscompany").get("name"));
            }
            logiSticsInfo.set("logisticsbill", returnData.get("logisticsbill"));
            if (returnData.get("driver") != null) {
                logiSticsInfo.set("driver", returnData.getDynamicObject("driver").get("name"));
            }
            logiSticsInfo.set("drivertel", returnData.get("drivertel"));
            logiSticsInfo.set("carno", returnData.get("carno"));
            logiSticsInfo.set("lsc_signstatus", (Object)"B");
            logiSticsInfo.set("infodescription", returnData.get("infodescription"));
            logiSticsInfoEntity.add((Object)logiSticsInfo);
        }
        SaveServiceHelper.save((DynamicObject[])deliveryOrders);
    }

    public static boolean checkOrderDelivery(ListSelectedRowCollection selectedRowCollection, String entityName, String deliveryStatusId) {
        DynamicObject[] saleOrders;
        boolean isAllow = false;
        List saleOrderSubEntryIds = selectedRowCollection.stream().map(ListSelectedRow::getSubEntryPrimaryKeyValue).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("goodsentryentity.salesorderdelivery", "in", saleOrderSubEntryIds);
        for (DynamicObject saleOrder : saleOrders = BusinessDataServiceHelper.load((String)entityName, (String)"salesorderdelivery,deliverystatus,goodsentryentity", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    DynamicObject deliveryStatus;
                    if (!saleOrderSubEntryIds.contains(delivery.getPkValue()) || !(deliveryStatus = delivery.getDynamicObject("deliverystatus")).getPkValue().toString().equals(deliveryStatusId)) continue;
                    isAllow = true;
                }
            }
        }
        return isAllow;
    }

    private static String getFileds() {
        return String.join((CharSequence)",", "logisticsinfo", "arrivaldate", "logisticscompany", "logisticsbill", "driver", "drivertel", "carno", "lsc_signstatus", "infodescription", "deliveryallstatus", "signallstatus", "entryentity", "deliverystatus", "signstatus");
    }

    private static String getRetailOrderFileds() {
        return String.join((CharSequence)",", "entryentity", "ribilldelivery", "deliverystatus", "signstatus");
    }
}

