/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.business.push;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.helper.BotpFlowingHelper;

public class AutoPushHelper {
    public static OperationResult autoPushBill(Object pkValue, String sourceEntityNumber, String targetEntityNumber, String opNumber) {
        ConvertOperationResult convertResult;
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        ListSelectedRow listSelectedRow = new ListSelectedRow(pkValue);
        list.add(listSelectedRow);
        PushArgs pushArgs = new PushArgs(sourceEntityNumber, targetEntityNumber, list);
        pushArgs.setHasRight(true);
        Set<Object> targetBillIds = new HashSet();
        if (targetEntityNumber.equals("im_saloutbill")) {
            convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (convertResult.isSuccess()) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                List targetDos = convertResult.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainEntityType);
                for (DynamicObject targetDo : targetDos) {
                    OperateOption saveOption = OperateOption.create();
                    saveOption.setVariableValue("ishasright", String.valueOf(true));
                    saveOption.setVariableValue("ignorewarn", String.valueOf(true));
                    saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                    OperationResult saveOpResult = SaveServiceHelper.saveOperate((String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{targetDo}, (OperateOption)saveOption);
                    if (!saveOpResult.isSuccess()) continue;
                    targetBillIds.add(targetDo.getPkValue());
                }
            }
        } else {
            convertResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            targetBillIds = convertResult.getTargetBillIds();
        }
        BotpFlowingHelper.insertBotpFlowing((ConvertOperationResult)convertResult, (Object)pkValue, targetBillIds);
        if (!convertResult.isSuccess()) {
            OperationResult opResult = new OperationResult();
            opResult.setBillCount(1);
            opResult.setShowMessage(false);
            StringBuilder sbMsg = new StringBuilder();
            ArrayList<OperateErrorInfo> lstErrorInfo = new ArrayList<OperateErrorInfo>(0);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            sbMsg.append(convertResult.getMessage());
            List billReports = convertResult.getBillReports();
            if (!CollectionUtils.isEmpty((Collection)billReports)) {
                for (SourceBillReport report : billReports) {
                    List sourceRowReport = report.getLinkEntityRowReports();
                    if (CollectionUtils.isEmpty((Collection)sourceRowReport)) continue;
                    for (SourceRowReport rowReport : sourceRowReport) {
                        rowReport.getFailMessages().forEach(sbMsg::append);
                    }
                }
            }
            if (sbMsg.length() > 0) {
                errorInfo.setMessage(sbMsg.toString());
            } else {
                errorInfo.setMessage("\u65e0\u9519\u8bef\u63d0\u793a");
            }
            lstErrorInfo.add(errorInfo);
            opResult.setSuccess(false);
            opResult.setAllErrorInfo(lstErrorInfo);
            return opResult;
        }
        OperationResult operationResult = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        StringBuilder errorMessage = new StringBuilder();
        if (targetBillIds != null && targetBillIds.size() != 0) {
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((Object[])targetBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)targetEntityNumber));
            switch (opNumber) {
                case "submit": {
                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option);
                    if (operationResult.isSuccess()) break;
                    errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                    if (operationResult.getInteractionContext() != null) {
                        errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                    }
                    if (errorMessage.length() == 0) {
                        errorMessage.append(operationResult.getMessage());
                    }
                    BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                    return operationResult;
                }
                case "audit": {
                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option);
                    if (!operationResult.isSuccess()) {
                        errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                        }
                        if (errorMessage.length() == 0) {
                            errorMessage.append(operationResult.getMessage());
                        }
                        BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                        List successPkIds = operationResult.getSuccessPkIds();
                        if (successPkIds == null || successPkIds.size() == 0) {
                            return operationResult;
                        }
                    }
                    if ((operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option)).isSuccess()) break;
                    errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                    if (operationResult.getInteractionContext() != null) {
                        errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                    }
                    if (errorMessage.length() == 0) {
                        errorMessage.append(operationResult.getMessage());
                    }
                    BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                    return operationResult;
                }
            }
        }
        BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)"");
        return operationResult;
    }
}

