/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.business.push;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocococ.business.push.AutoPushHelper;

public class DeliveryOrderPushHelper {
    private static final Log log = LogFactory.getLog(DeliveryOrderPushHelper.class);

    public static JSONObject billAutoPushOcocBillAudit(DynamicObject dataEntity, String sourceEntityNumber) {
        JSONObject jsonObject = new JSONObject();
        switch (sourceEntityNumber) {
            case "ocococ_retailbill": {
                jsonObject = DeliveryOrderPushHelper.billAutoPushDeliveryOrderAudit(dataEntity);
                break;
            }
            default: {
                jsonObject.put("status", (Object)"false");
                jsonObject.put("msg", (Object)String.format("\u5355\u636e\u6807\u8bc6\uff1a%s \u81ea\u52a8\u4e0b\u63a8\u5e76\u5ba1\u6838\u529f\u80fd\u672a\u5b9e\u73b0\u3002", sourceEntityNumber));
            }
        }
        return jsonObject;
    }

    public static JSONObject billAutoPushDeliveryOrderAudit(DynamicObject dataEntity) {
        JSONObject jsonResult = new JSONObject();
        boolean isSuccessPush = false;
        StringBuilder errorMessage = new StringBuilder();
        try {
            long retailId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
            OperationResult pushResult = AutoPushHelper.autoPushBill(retailId, "ocococ_retailbill", "ocococ_deliveryorder", "audit");
            if (pushResult == null) {
                errorMessage.append(String.format("\u96f6\u552e\u5355%s\u4e0b\u63a8\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
            } else if (!pushResult.isSuccess()) {
                errorMessage.append(ObjectUtils.nullSafeToString((Object)pushResult.getAllErrorOrValidateInfo()));
                if (pushResult.getInteractionContext() != null) {
                    errorMessage.append(pushResult.getInteractionContext().getSimpleMessage());
                }
                if (errorMessage.length() == 0) {
                    errorMessage.append(pushResult.getMessage());
                }
            } else {
                isSuccessPush = true;
            }
        }
        catch (Exception e) {
            errorMessage.append(String.format("\u96f6\u552e\u5355%s\u4e0b\u63a8\u5f02\u5e38:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage()));
        }
        log.info(errorMessage.toString());
        if (isSuccessPush) {
            jsonResult.put("status", (Object)"true");
        } else {
            jsonResult.put("status", (Object)"false");
        }
        jsonResult.put("msg", (Object)errorMessage.toString());
        return jsonResult;
    }

    public static String checkRetailOrderAllowPush(DynamicObject dataEntity) {
        String msg = "";
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return msg;
        }
        block0: for (DynamicObject entry : entryentity) {
            DynamicObjectCollection ribilldelivery;
            boolean enableSerial;
            DynamicObject goodsId = DynamicObjectUtils.getDynamicObject((DynamicObject)entry, (String)"goodsid");
            DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)(goodsId = BusinessDataServiceHelper.loadSingle((Object)goodsId.getPkValue(), (String)"ocdbd_iteminfo")), (String)"material");
            Object materialId = material.getPkValue();
            QFilter qFilter = new QFilter("masterid", "=", materialId);
            DynamicObject[] materialIds = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"enableserial", (QFilter[])qFilter.toArray());
            if (materialIds.length == 0 || !(enableSerial = materialIds[0].getBoolean("enableserial")) || CollectionUtils.isEmpty((Collection)(ribilldelivery = entry.getDynamicObjectCollection("ribilldelivery")))) continue;
            for (DynamicObject delivery : ribilldelivery) {
                boolean isFromOls;
                boolean isdelivery = delivery.getBoolean("isdelivery");
                String deliveryserialnumber = delivery.getString("deliveryserialnumber");
                String srcBillType = dataEntity.getString("srcbilltype");
                boolean bl = isFromOls = StringUtils.equals((CharSequence)srcBillType, (CharSequence)"L") || StringUtils.equals((CharSequence)srcBillType, (CharSequence)"S");
                if (isdelivery || !StringUtils.isEmpty((CharSequence)deliveryserialnumber) || !isFromOls) continue;
                msg = "\u5e8f\u5217\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210\u53d1\u8d27\u5355\u3002";
                continue block0;
            }
        }
        long sourcebillid = ((DynamicObject)entryentity.get(0)).getLong("sourcebillid");
        if (sourcebillid > 0L) {
            String srcchangeitemtype;
            DynamicObject sourceBill;
            String selectFields;
            String srcBizType = "";
            String saleoption = dataEntity.getString("saleoption");
            if (saleoption.equals("1")) {
                selectFields = "sourcebillid,srcbiztype,srcchangeitemtype";
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ocpos_saleorder", (String)selectFields);
                srcBizType = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcbiztype");
            } else {
                selectFields = "sourcebillid,srcbillbiztype,srcchangeitemtype";
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"ocpos_saleorder_return", (String)selectFields);
                srcBizType = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcbillbiztype");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)"H") && StringUtils.equals((CharSequence)(srcchangeitemtype = DynamicObjectUtils.getString((DynamicObject)sourceBill, (String)"srcchangeitemtype")), (CharSequence)"3")) {
                msg = "\u96f6\u552e\u6362\u8d27\uff1a\u6362\u8d27\u7c7b\u578b=\u8865\u5dee\uff0c\u4e0d\u751f\u6210\u53d1\u8d27\u5355\u3002";
            }
        }
        return msg;
    }

    public static String checkDeliveryOrderAllowPush(DynamicObject dataEntity, String billtypenumber) {
        String distributionmodeNumber;
        StringBuilder sbMsg = new StringBuilder();
        DynamicObject deliveryallstatus = dataEntity.getDynamicObject("deliveryallstatus");
        if (deliveryallstatus != null) {
            String deliverystatusnumber = deliveryallstatus.getString("number");
            if (StringUtils.equals((CharSequence)billtypenumber, (CharSequence)"ocococ_deliveryorder_RD_S") && StringUtils.equals((CharSequence)deliverystatusnumber, (CharSequence)"F011")) {
                sbMsg.append("\u6807\u51c6\u96f6\u552e\u53d1\u8d27\u5355\uff1a \u53d1\u8d27\u72b6\u6001 = \u6682\u505c\u53d1\u8d27\uff0c\u4e0d\u751f\u6210\u9500\u552e\u51fa\u5e93\u5355\u3002");
            }
        }
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject distributionmode = dataEntity.getDynamicObject("distributionmode");
        if (!(distributionmode == null || StringUtils.equals((CharSequence)(distributionmodeNumber = distributionmode.getString("number")), (CharSequence)"E") || StringUtils.equals((CharSequence)distributionmodeNumber, (CharSequence)"F") || CollectionUtils.isEmpty((Collection)entryentity))) {
            for (DynamicObject entry : entryentity) {
                String deliveryserialnumber;
                DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entry, (String)"material");
                QFilter qFilter = new QFilter("masterid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)material));
                DynamicObject[] materialIds = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"enableserial", (QFilter[])qFilter.toArray());
                if (materialIds.length == 0 || !materialIds[0].getBoolean("enableserial") || !StringUtils.isEmpty((CharSequence)(deliveryserialnumber = entry.getString("deliveryserialnumber")))) continue;
                sbMsg.append("\u5e8f\u5217\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210\u9500\u552e\u51fa\u5e93\u5355");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            QFilter qFilter;
            DynamicObject saleOrder;
            boolean isInitBill;
            long coreBillId = DynamicObjectUtils.getLong((DynamicObject)((DynamicObject)entryentity.get(0)), (String)"corebillid");
            String coreBillEntity = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)entryentity.get(0)), (String)"corebillentity");
            if (coreBillId > 0L && StringUtils.isNotEmpty((CharSequence)coreBillEntity) && (isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)(saleOrder = QueryServiceHelper.queryOne((String)coreBillEntity, (String)"isinitbill", (QFilter[])(qFilter = new QFilter("id", "=", (Object)coreBillId)).toArray())), (String)"isinitbill"))) {
                sbMsg.append("\u521d\u59cb\u5316\u5355\u636e\uff0c\u4e0d\u751f\u6210\u9500\u552e\u51fa\u5e93\u5355");
            }
        }
        return sbMsg.toString();
    }
}

