/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.business.rewrite;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class WriteDeliveryStatusBackToRetailAndRetailKD {
    private static final String ORDER_DETAIL_ENTRY = "entryentity";
    private static final String CORE_BILL_ID = "corebillid";
    private static final String CORE_BILL_ENTRYID = "corebillentryid";
    private static final String DELIVERY_STATUS = "deliverystatus";
    private static final String LSD_SIGN = "ocococ_retailbill";
    private static final String LSKD_SIGN = "ocpos_saleorder";
    private static final String DELIVERY_STATUS_SIGN = "ococic_deliverstatus";

    public static void writeBackEachRowData(DynamicObject eachEntity) {
        if (eachEntity != null) {
            DynamicObject deliveryStatus = WriteDeliveryStatusBackToRetailAndRetailKD.getDeliverySentStatus();
            Long corebillentryid = eachEntity.getLong(CORE_BILL_ENTRYID);
            Long corebillid = eachEntity.getLong(CORE_BILL_ID);
            if (deliveryStatus != null && corebillentryid != null && corebillid != null) {
                WriteDeliveryStatusBackToRetailAndRetailKD.commonBillEntityDataSetting(deliveryStatus, corebillentryid, corebillid, LSD_SIGN);
                WriteDeliveryStatusBackToRetailAndRetailKD.retailOrgDataSetting(deliveryStatus, corebillentryid, corebillid, LSD_SIGN);
            }
        }
    }

    public static void commonBillEntityDataSetting(DynamicObject deliveryStatus, Long corebillentryid, Long corebillid, String corebillentity) {
        Long id = corebillid;
        Long entryid = corebillentryid;
        String selectfields = "id,orderstatus,entryentity,ribilldelivery,ribilldelivery.id,ribilldelivery.deliverystatus";
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)corebillentity, (String)selectfields, (QFilter[])idFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject eachBill : dynamicObjects) {
                eachBill.set("orderstatus", (Object)"B");
                DynamicObjectCollection entryentity = eachBill.getDynamicObjectCollection(ORDER_DETAIL_ENTRY);
                for (int j = 0; j < entryentity.size(); ++j) {
                    DynamicObjectCollection deliveryEntity = ((DynamicObject)entryentity.get(j)).getDynamicObjectCollection("ribilldelivery");
                    if (deliveryEntity == null || deliveryEntity.size() <= 0) continue;
                    for (int i = 0; i < deliveryEntity.size(); ++i) {
                        if (!((DynamicObject)deliveryEntity.get(i)).get("id").equals(entryid)) continue;
                        ((DynamicObject)deliveryEntity.get(i)).set(DELIVERY_STATUS, (Object)deliveryStatus);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public static void retailOrgDataSetting(DynamicObject deliveryStatus, Long corebillentryid, Long corebillid, String corebillentity) {
        String selectfields = "id,orderstatus,entryentity,entryentity.sourcebillno, entryentity.ribilldelivery,entryentity.ribilldelivery.deliverystatus";
        Long id = corebillid;
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)corebillentity, (String)selectfields, (QFilter[])idFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject eachBill : dynamicObjects) {
                eachBill.set("orderstatus", (Object)"B");
                DynamicObjectCollection entryentity = eachBill.getDynamicObjectCollection(ORDER_DETAIL_ENTRY);
                for (int j = 0; j < entryentity.size(); ++j) {
                    String billno = ((DynamicObject)entryentity.get(j)).getString("sourcebillno");
                    DynamicObjectCollection deliveryEntity = ((DynamicObject)entryentity.get(j)).getDynamicObjectCollection("ribilldelivery");
                    if (deliveryEntity == null || deliveryEntity.size() <= 0) continue;
                    for (int i = 0; i < deliveryEntity.size(); ++i) {
                        if (!((DynamicObject)deliveryEntity.get(i)).get("id").equals(corebillentryid) || billno == null) continue;
                        WriteDeliveryStatusBackToRetailAndRetailKD.setretailOrgDelivery(deliveryStatus, billno, LSKD_SIGN, corebillentryid);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public static void setretailOrgDelivery(DynamicObject deliveryStatus, String billno, String corebillentity, Long corebillentryid) {
        String selectfields = "id, goodsentryentity.id, goodsentryentity.salesorderdelivery.id,goodsentryentity.salesorderdelivery.deliverystatus";
        QFilter billnoFilter = new QFilter("billno", "=", (Object)billno);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)corebillentity);
        Object[] fieldKeys = entityType.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)corebillentity, (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])billnoFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject eachBill : dynamicObjects) {
                DynamicObjectCollection goodsentryentity = eachBill.getDynamicObjectCollection("goodsentryentity");
                for (int j = 0; j < goodsentryentity.size(); ++j) {
                    DynamicObjectCollection deliveryEntity = ((DynamicObject)goodsentryentity.get(j)).getDynamicObjectCollection("salesorderdelivery");
                    if (deliveryEntity == null || deliveryEntity.size() <= 0) continue;
                    for (int i = 0; i < deliveryEntity.size(); ++i) {
                        ((DynamicObject)deliveryEntity.get(i)).set(DELIVERY_STATUS, (Object)deliveryStatus);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private static DynamicObject getDeliverySentStatus() {
        String filternumber = "F003";
        QFilter numberFilter = new QFilter("number", "=", (Object)filternumber);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DELIVERY_STATUS_SIGN, (String)"id", (QFilter[])numberFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }
}

