/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.botp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.occ.ocbase.business.handle.ScmSNHandle;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.business.helper.changemodel.CurrencyHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.MdrBillConvertPlugin;

public class DeliveryOrderPushSaloutPlugin
extends MdrBillConvertPlugin {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("deliverystatus");
        e.addSrcField("billtype");
        e.addSrcField("material");
        e.addSrcField(String.join((CharSequence)".", "material", "id"));
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendedDataEntities = entitySet.FindByEntityKey(tgtMainType);
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            ArrayList<DynamicObject> newEntryDynObjList = new ArrayList<DynamicObject>(20);
            DynamicObject bill = extendedDataEntity.getDataEntity();
            billList.add(bill);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            DynamicObject invSchemeDynObj = bill.getDynamicObject("invscheme");
            newEntryDynObjList.addAll(this.setReserveRecordEntryInfo(entrys, invSchemeDynObj));
            if (newEntryDynObjList.size() > 0) {
                entrys.clear();
                entrys.addAll(newEntryDynObjList);
            }
            this.calculateEntryQty(entrys);
            this.setDefalutOwnerAndKeeeper(bill);
            this.processAmount(bill);
        }
        List imBills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillBotpService", (String)"imBillsAfterConvert", (Object[])new Object[]{tgtMainType, billList});
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            ExtendedDataEntity entity = extendedDataEntities[i];
            DynamicObject bill = entity.getDataEntity();
            DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
            for (IDataEntityProperty dp : properties) {
                bill.set(dp, ((DynamicObject)imBills.get(i)).get(dp));
            }
            entity.setDataEntity((DynamicObject)imBills.get(i));
        }
        this.handlerSn(extendedDataEntities);
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        if (this.isAfterDeliveredSettle(e)) {
            e.setCustFilterDesc("\u5355\u636e\u6838\u7b97\u65f6\u70b9\u4e3a\u3010\u53d1\u8d27\u540e\u6838\u7b97\u3011\u4e0d\u5141\u8bb8\u4e0b\u63a8\u3010\u5f85\u53d1\u8d27\u548c\u5df2\u88c5\u8f66\u72b6\u6001\u3011\u7684\u5206\u5f55");
            e.setCustFilterExpression(" deliverystatus  != " + DeliveryStatus.SALE_WAIT_DELIVERY + "and deliverystatus  != " + DeliveryStatus.SALE_TRUCK_LOADING);
            QFilter qFilter1 = new QFilter("deliverystatus", "!=", (Object)DeliveryStatus.SALE_WAIT_DELIVERY).and("deliverystatus", "!=", (Object)DeliveryStatus.SALE_TRUCK_LOADING);
            e.getCustQFilters().add(qFilter1);
        }
    }

    private List<DynamicObject> setReserveRecordEntryInfo(DynamicObjectCollection entrys, DynamicObject invSchemeDynObj) {
        Set<String> ignoreKeys = this.setIgnoreCopyKeys();
        ArrayList<DynamicObject> newEntryDynObjList = new ArrayList<DynamicObject>(entrys.size());
        Map<Long, List<DynamicObject>> orderDynObjMap = this.getOrderDynObjMap(entrys);
        Map<Long, JSONArray> reserveRecordMap = this.getReserveRecordMap(orderDynObjMap);
        BigDecimal baseqty = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            boolean initByScheme = true;
            if (!CommonUtils.isNull(reserveRecordMap)) {
                long reserveEntryId;
                JSONArray jsonArray;
                newEntryDynObjList.add(entry);
                long subEntryId = entry.getLong("mainbillentryid");
                List<DynamicObject> reserveEntryDynObjList = orderDynObjMap.get(subEntryId);
                if (reserveEntryDynObjList != null && reserveEntryDynObjList.size() > 0 && (jsonArray = reserveRecordMap.get(reserveEntryId = reserveEntryDynObjList.get(0).getLong("id"))) != null && jsonArray.size() > 0) {
                    initByScheme = false;
                    JSONObject firstJsonObj = jsonArray.getJSONObject(0);
                    baseqty = entry.getBigDecimal("baseqty");
                    this.setOutEntryInfo(entry, firstJsonObj);
                    baseqty = baseqty.subtract(entry.getBigDecimal("baseqty"));
                    if (jsonArray.size() > 1) {
                        int size = jsonArray.size();
                        for (int i = 1; i < size; ++i) {
                            DynamicObject addEntryDynObj = new DynamicObject(entry.getDynamicObjectType());
                            DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)addEntryDynObj, (DynamicObject)entry, ignoreKeys);
                            this.setOutEntryInfo(addEntryDynObj, jsonArray.getJSONObject(i));
                            newEntryDynObjList.add(addEntryDynObj);
                            baseqty = baseqty.subtract(addEntryDynObj.getBigDecimal("baseqty"));
                            this.setNewRowValue(entry, addEntryDynObj, i + 1);
                        }
                    }
                    if (BigDecimal.ZERO.compareTo(baseqty) < 0) {
                        DynamicObject addEntryDynObj = new DynamicObject(entry.getDynamicObjectType());
                        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)addEntryDynObj, (DynamicObject)entry, ignoreKeys);
                        JSONObject jsonObj = new JSONObject();
                        jsonObj.put("baseqty", (Object)baseqty);
                        this.setOutEntryInfo(addEntryDynObj, jsonObj);
                        this.initEntryByScheme(addEntryDynObj, invSchemeDynObj);
                        newEntryDynObjList.add(addEntryDynObj);
                        this.setNewRowValue(entry, addEntryDynObj, jsonArray.size() + 1);
                    }
                }
            }
            if (!initByScheme) continue;
            this.initEntryByScheme(entry, invSchemeDynObj);
        }
        return newEntryDynObjList;
    }

    private void calculateEntryQty(DynamicObjectCollection entrys) {
        for (DynamicObject entry : entrys) {
            DynamicObject materialDynObj = DynamicObjectUtils.getDynamicObject((DynamicObject)entry.getDynamicObject("material"), (String)"masterid");
            if (materialDynObj == null) continue;
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            BigDecimal remainReturnBaseQty = entry.getBigDecimal("remainreturnbaseqty");
            BigDecimal remainJoinPriceBaseQty = entry.getBigDecimal("remainjoinpricebaseqty");
            BigDecimal unverifyBaseQty = entry.getBigDecimal("unverifybaseqty");
            long auxUnitId = entry.getLong(String.join((CharSequence)"_", "unit2nd", "id"));
            long baseUnitId = entry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
            long unitId = entry.getLong(String.join((CharSequence)"_", "unit", "id"));
            if (auxUnitId > 0L) {
                entry.set("qtyunit2nd", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialDynObj.getLong("id"), (Long)baseUnitId, (Long)auxUnitId));
            }
            entry.set("qty", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialDynObj.getLong("id"), (Long)baseUnitId, (Long)unitId));
            entry.set("remainreturnqty", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)remainReturnBaseQty, (Long)materialDynObj.getLong("id"), (Long)baseUnitId, (Long)unitId));
            entry.set("remainjoinpriceqty", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)remainJoinPriceBaseQty, (Long)materialDynObj.getLong("id"), (Long)baseUnitId, (Long)unitId));
            entry.set("unverifyqty", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)unverifyBaseQty, (Long)materialDynObj.getLong("id"), (Long)baseUnitId, (Long)unitId));
        }
    }

    private Map<Long, List<DynamicObject>> getOrderDynObjMap(DynamicObjectCollection outEntryColl) {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(outEntryColl.size());
        for (DynamicObject saleOutDetail : outEntryColl) {
            if (!"ocbsoc_saleorder".equalsIgnoreCase(saleOutDetail.getString("mainbillentity")) || saleOutDetail.getLong("mainbillid") <= 0L) continue;
            mainBillIdSet.add(saleOutDetail.getLong("mainbillid"));
        }
        ArrayList reserveEntryList = new ArrayList(outEntryColl.size());
        if (mainBillIdSet.size() > 0) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"ocbsoc_saleorder");
            DynamicObject[] orderDynObjs = BusinessDataServiceHelper.load((Object[])mainBillIdSet.toArray(), (DynamicObjectType)entityType);
            if (orderDynObjs != null && orderDynObjs.length > 0) {
                for (DynamicObject orderDynObj : orderDynObjs) {
                    DynamicObjectCollection reserveEntryColl = orderDynObj.getDynamicObjectCollection("reserveitementry");
                    if (reserveEntryColl == null || reserveEntryColl.size() <= 0) continue;
                    reserveEntryList.addAll(reserveEntryColl);
                }
            }
        }
        return reserveEntryList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("reservedetailid")));
    }

    private Map<Long, JSONArray> getReserveRecordMap(Map<Long, List<DynamicObject>> orderDynObjMap) {
        if (orderDynObjMap == null || orderDynObjMap.size() == 0) {
            return null;
        }
        HashSet<Long> billEntryIdSet = new HashSet<Long>(20);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : orderDynObjMap.entrySet()) {
            for (DynamicObject reserveDynObj : mapEntry.getValue()) {
                billEntryIdSet.add(reserveDynObj.getLong("id"));
            }
        }
        Map reserveRecordMap = null;
        if (billEntryIdSet.size() > 0) {
            reserveRecordMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ReserveRecordQueryService", (String)"reserveRecordQuery", (Object[])new Object[]{billEntryIdSet});
        }
        return reserveRecordMap;
    }

    private void setOutEntryInfo(DynamicObject entry, JSONObject jsonObj) {
        entry.set("outinvtype", jsonObj.get((Object)"invtype"));
        entry.set("outinvstatus", jsonObj.get((Object)"invstatus"));
        entry.set("outownertype", jsonObj.get((Object)"ownertype"));
        entry.set("outowner", jsonObj.get((Object)"owner"));
        entry.set("outkeepertype", jsonObj.get((Object)"keepertype"));
        entry.set("outkeeper", jsonObj.get((Object)"keeper"));
        entry.set("warehouse", jsonObj.get((Object)"warehouse"));
        entry.set("location", jsonObj.get((Object)"location"));
        entry.set("lotnumber", jsonObj.get((Object)"lotnum"));
        entry.set("project", jsonObj.get((Object)"project"));
        entry.set("producedate", jsonObj.get((Object)"producedate"));
        entry.set("expirydate", jsonObj.get((Object)"expirydate"));
        entry.set("baseqty", jsonObj.get((Object)"baseqty"));
    }

    private void processAmount(DynamicObject bill) {
        BigDecimal exChangeRate = null;
        exChangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        DynamicObject org = bill.getDynamicObject("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = CurrencyHelper.getCurrency((Long)orgId);
                bill.set("currency", (Object)currency);
            }
            if (exRateTable == null) {
                exRateTable = CurrencyHelper.getExRateTable((Long)orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            Date bizTime = bill.getDate("exratedate");
            if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
                Long curId = (Long)currency.getPkValue();
                Long settleCurId = (Long)settleCurrency.getPkValue();
                Long exRateTableId = (Long)exRateTable.getPkValue();
                exChangeRate = CurrencyHelper.getExChangeRate((Long)settleCurId, (Long)curId, (Long)exRateTableId, (Date)bizTime);
                bill.set("exchangerate", (Object)exChangeRate);
            }
        }
    }

    private boolean isAfterDeliveredSettle(BeforeBuildRowConditionEventArgs e) {
        String settletimepoint;
        ListSelectedRow listSelectedRow = (ListSelectedRow)e.getSelectedRows().get(0);
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"ocococ_deliveryorder", (String)"billtype");
        DynamicObject billTypeParameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"ocococ_deliveryorder", (String)"ocococ_delorder_btparam", (long)entity.getLong("billtype_id"));
        return null != billTypeParameter && billTypeParameter.get("settletimepoint") != null && "1".equals(settletimepoint = billTypeParameter.get("settletimepoint").toString());
    }

    private void initEntryByScheme(DynamicObject entry, DynamicObject invScheme) {
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject invType = null;
        if (isInUpdate) {
            ownerType = invScheme.getString("ownertype");
            keeperType = invScheme.getString("keepertype");
            invStatus = invScheme.getDynamicObject("invstatus");
            invType = this.getDefaltInvtype(invScheme);
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvTtatus = null;
        DynamicObject outInvType = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString("outownertype");
            outKeeperType = invScheme.getString("outkeepertype");
            DynamicObjectCollection outinvstatusentrys = invScheme.getDynamicObjectCollection("outinvstatusentry");
            DynamicObject outinvstatusDyObj = null;
            if (outinvstatusentrys != null && outinvstatusentrys.size() > 0) {
                outinvstatusDyObj = ((DynamicObject)outinvstatusentrys.get(0)).getDynamicObject("outinvstatus");
                if (!((DynamicObject)outinvstatusentrys.get(0)).getBoolean("outinvstatusisdefault")) {
                    for (int i = 1; i < outinvstatusentrys.size(); ++i) {
                        if (!((DynamicObject)outinvstatusentrys.get(i)).getBoolean("outinvstatusisdefault")) continue;
                        outinvstatusDyObj = ((DynamicObject)outinvstatusentrys.get(i)).getDynamicObject("outinvstatus");
                        break;
                    }
                }
            }
            outInvTtatus = outinvstatusDyObj;
            outInvType = this.getDefaltOutInvtype(invScheme);
        }
        if (CommonUtils.isNull((Object)entry.get("ownertype"))) {
            entry.set("ownertype", (Object)ownerType);
        }
        if (CommonUtils.isNull((Object)entry.get("keepertype"))) {
            entry.set("keepertype", (Object)keeperType);
        }
        if (CommonUtils.isNull((Object)entry.get("outownertype"))) {
            entry.set("outownertype", (Object)outOwnerType);
        }
        if (CommonUtils.isNull((Object)entry.get("outkeepertype"))) {
            entry.set("outkeepertype", (Object)outKeeperType);
        }
        if (CommonUtils.isNull((Object)entry.get("invstatus"))) {
            entry.set("invstatus", (Object)invStatus);
        }
        if (CommonUtils.isNull((Object)entry.get("invtype"))) {
            entry.set("invtype", (Object)invType);
        }
        if (DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("outinvstatus")) == 0L) {
            entry.set("outinvstatus", (Object)outInvTtatus);
        }
        if (DynamicObjectUtils.getPkValue((DynamicObject)entry.getDynamicObject("outinvtype")) == 0L) {
            entry.set("outinvtype", (Object)outInvType);
        }
    }

    private DynamicObject getDefaltInvtype(DynamicObject invScheme) {
        return this.getDefaultInvType(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    private DynamicObject getDefaultInvType(DynamicObject invScheme, String invTypeEntry, String invTypeIsDefault, String invType) {
        DynamicObjectCollection invtypeEntrys = invScheme.getDynamicObjectCollection(invTypeEntry);
        DynamicObject defaltInvtype = null;
        if (invtypeEntrys != null && invtypeEntrys.size() > 0) {
            for (DynamicObject invtypeEntry : invtypeEntrys) {
                if (!invtypeEntry.getBoolean(invTypeIsDefault)) continue;
                defaltInvtype = invtypeEntry.getDynamicObject(invType);
                break;
            }
            if (defaltInvtype == null) {
                defaltInvtype = ((DynamicObject)invtypeEntrys.get(0)).getDynamicObject(invType);
            }
        }
        return defaltInvtype;
    }

    private DynamicObject getDefaltOutInvtype(DynamicObject invScheme) {
        return this.getDefaultInvType(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    private void setDefalutOwnerAndKeeeper(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            if (CommonUtils.isNull((Object)entry.get("outkeeper"))) {
                String outKeeperType = (String)entry.get("outkeepertype");
                Object defalutOutKeeperId = null;
                if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                    defalutOutKeeperId = this.getDefalutOutKeeper(bill, outKeeperType);
                }
                entry.set("outkeeper", defalutOutKeeperId);
            }
            if (CommonUtils.isNull((Object)entry.get("outowner"))) {
                String outOwnerType = (String)entry.get("outownertype");
                Object defalutOutOwnerId = null;
                if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
                    DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
                    defalutOutOwnerId = this.getDefalutOutOwner(bill, outOwnerType, settleOrg);
                }
                entry.set("outowner", defalutOutOwnerId);
            }
            if (CommonUtils.isNull((Object)entry.get("keeper"))) {
                String keeperType = entry.getString("keepertype");
                Object defalutKeeperId = null;
                if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                    defalutKeeperId = this.getDefalutKeeper(bill, keeperType);
                }
                entry.set("keeper", defalutKeeperId);
            }
            if (!CommonUtils.isNull((Object)entry.get("owner"))) continue;
            String ownerType = (String)entry.get("ownertype");
            Object defalutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defalutOwnerId = this.getDefalutOwner(bill, ownerType, entry.get("outowner"));
            }
            entry.set("owner", defalutOwnerId);
        }
    }

    private Object getDefalutOutKeeper(DynamicObject bill, String type) {
        Object keeper = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "bos_org": {
                keeper = bill.get("org");
                break;
            }
            case "bd_customer": {
                keeper = bill.get("customer");
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return keeper;
    }

    private Object getDefalutOutOwner(DynamicObject bill, String type, Object settleOrg) {
        Object owner = null;
        String outOwnerType = type;
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            return owner;
        }
        switch (outOwnerType) {
            case "bos_org": {
                if (settleOrg == null) break;
                owner = settleOrg;
                break;
            }
            case "bd_customer": {
                Object customer = bill.get("customer");
                if (customer == null) break;
                owner = customer;
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return owner;
    }

    private Object getDefalutKeeper(DynamicObject bill, String type) {
        Object keeper = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeper;
        }
        switch (type) {
            case "bos_org": {
                keeper = bill.get("org");
                break;
            }
            case "bd_customer": {
                keeper = bill.get("customer");
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return keeper;
    }

    private Object getDefalutOwner(DynamicObject bill, String type, Object outowner) {
        Object ownerId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ownerId;
        }
        switch (type) {
            case "bos_org": {
                ownerId = outowner;
                break;
            }
            case "bd_customer": {
                ownerId = bill.get("customer");
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return ownerId;
    }

    private void handlerSn(ExtendedDataEntity[] entitys) {
        List saleOutBills = ScmSNHandle.autoSetPrimaryKey((ExtendedDataEntity[])entitys);
        HashSet srcBillBntryIds = new HashSet();
        saleOutBills.forEach(r -> r.getDynamicObjectCollection("billentry").forEach(c -> srcBillBntryIds.add(c.getLong("srcbillentryid"))));
        Map snDataMap = ScmSNHandle.queryDeliveryOrderSnData(srcBillBntryIds);
        ArrayList billSNRelations = new ArrayList();
        saleOutBills.forEach(saleOutBill -> saleOutBill.getDynamicObjectCollection("billentry").forEach(saleOutEntry -> {
            List snDatas = (List)snDataMap.get(saleOutEntry.getLong("srcbillentryid"));
            if (!CollectionUtils.isEmpty((Collection)snDatas)) {
                List<Object[]> tsnData = this.getTrueSnData(snDatas, (DynamicObject)saleOutEntry);
                billSNRelations.add(ScmSNHandle.buildSaleOutBillSn((long)saleOutBill.getLong("id"), (long)saleOutEntry.getLong("id"), tsnData));
            }
        }));
        if (billSNRelations.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saleOutBills.toArray(new DynamicObject[saleOutBills.size()]));
            SaveServiceHelper.save((DynamicObject[])billSNRelations.toArray(new DynamicObject[billSNRelations.size()]));
        }
    }

    private List<Object[]> getTrueSnData(List<Object[]> snDatas, DynamicObject saleOutEntry) {
        int baseQty = saleOutEntry.getBigDecimal("baseqty").intValue();
        int snNum = snDatas.size();
        if (snNum > baseQty) {
            ArrayList<Object[]> tSnDatas = new ArrayList<Object[]>(snNum);
            for (int i = 0; i < baseQty; ++i) {
                Object[] objs = snDatas.get(i);
                tSnDatas.add(objs);
            }
            snDatas.removeAll(tSnDatas);
            return tSnDatas;
        }
        return snDatas;
    }

    private Set<String> setIgnoreCopyKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("seq");
        ignoreKeys.add("receiveaddress");
        ignoreKeys.add("multilanguagetext");
        ignoreKeys.add("billentry_lk");
        return ignoreKeys;
    }

    private void setNewRowValue(DynamicObject fromObj, DynamicObject toObj, int seq) {
        toObj.set("receiveaddress", fromObj.get("receiveaddress"));
        DynamicObjectCollection fromEnlkCollect = fromObj.getDynamicObjectCollection("billentry_lk");
        if (fromEnlkCollect != null && fromEnlkCollect.size() > 0) {
            DynamicObjectCollection entrylk = toObj.getDynamicObjectCollection("billentry_lk");
            for (DynamicObject entryelk : fromEnlkCollect) {
                DynamicObject addEntrylkObj = new DynamicObject(entryelk.getDynamicObjectType());
                addEntrylkObj.set("seq", (Object)seq);
                addEntrylkObj.set("billentry_lk_stableid", entryelk.get("billentry_lk_stableid"));
                addEntrylkObj.set("billentry_lk_sbillid", entryelk.get("billentry_lk_sbillid"));
                addEntrylkObj.set("billentry_lk_sid", entryelk.get("billentry_lk_sid"));
                entrylk.add((Object)addEntrylkObj);
            }
        }
    }
}

