/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.botp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocococ.business.push.DeliveryOrderPushHelper;

public class RetailDeliveryOrderPushSaloutPlugin
extends AbstractConvertPlugIn {
    private static final String KEY_IM_SALOUTBILL = "im_saloutbill";
    private static final String KEY_TABLE_SALOUTBILL = "t_im_saloutbill";
    private static final String KEY_BILLENTRY = "billentry";
    private static final String KEY_TABLE_BILLENTRY = "t_im_saloutbillentry";
    private static final String KEY_SBS_BILLSNRELATION = "sbs_billsnrelation";
    private static final String KEY_SRCBILLENTRYID = "srcbillentryid";
    private static final String KEY_SELECT_FEILD = "entryentity.id,entryentity.deliveryserialnumber,entryentity.qty,entryentity.unit.id";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        DynamicObject[] deliveryOrders;
        List listSelectedRows = e.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            return;
        }
        ArrayList<Object> primaryIds = new ArrayList<Object>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Object primaryId = listSelectedRow.getPrimaryKeyValue();
            primaryIds.add(primaryId);
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((Object[])primaryIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocococ_deliveryorder"))) {
            DynamicObject billtype;
            String billtypenumber;
            String custFilterDesc;
            DynamicObject deliveryallstatus = deliveryOrder.getDynamicObject("deliveryallstatus");
            if (deliveryallstatus == null || StringUtils.isEmpty((CharSequence)(custFilterDesc = DeliveryOrderPushHelper.checkDeliveryOrderAllowPush((DynamicObject)deliveryOrder, (String)(billtypenumber = (billtype = deliveryOrder.getDynamicObject("billtype")).getString("number")))))) continue;
            sb.append(custFilterDesc);
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity billDataEntity : billDataEntities = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject dataEntity = billDataEntity.getDataEntity();
            DynamicObject billType = dataEntity.getDynamicObject("billtype");
            String billTypeNumber = billType.getString("number");
            if (!StringUtils.equals((CharSequence)billTypeNumber, (CharSequence)"ocococ_deliveryorder_RD_S")) continue;
            this.initNewEntityScheme(dataEntity);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntity billData = Arrays.stream(e.getTargetExtDataEntitySet().FindByEntityKey(KEY_IM_SALOUTBILL)).findFirst().orElse(null);
        if (billData == null) {
            return;
        }
        long id = DB.genLongId((String)KEY_TABLE_SALOUTBILL);
        billData.setValue("id", (Object)id);
        ExtendedDataEntity[] billDataEntry = e.getTargetExtDataEntitySet().FindByEntityKey(KEY_BILLENTRY);
        if (billDataEntry == null || billDataEntry.length == 0) {
            return;
        }
        ArrayList<Long> lstSrcEntryId = new ArrayList<Long>(0);
        for (ExtendedDataEntity dataEntity : billDataEntry) {
            long srcEntryId = (Long)dataEntity.getValue(KEY_SRCBILLENTRYID);
            if (lstSrcEntryId.contains(srcEntryId)) continue;
            lstSrcEntryId.add(srcEntryId);
        }
        QFilter filter = new QFilter("entryentity.id", "in", (Object)lstSrcEntryId.toArray());
        DynamicObjectCollection docSrcEntry = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)KEY_SELECT_FEILD, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)docSrcEntry)) {
            return;
        }
        this.saveBillSNRelation(docSrcEntry, billDataEntry, id);
    }

    private void saveBillSNRelation(DynamicObjectCollection docSrcEntry, ExtendedDataEntity[] billDataEntry, long id) {
        long[] entryIds = DB.genLongIds((String)KEY_TABLE_BILLENTRY, (int)billDataEntry.length);
        ArrayList<DynamicObject> lstBillSNRelation = new ArrayList<DynamicObject>(0);
        for (int i = 0; i < billDataEntry.length; ++i) {
            String serialNo;
            DynamicObject srcEntry;
            DynamicObject doUnit;
            billDataEntry[i].setValue("id", (Object)entryIds[i]);
            long srcEntryId = (Long)billDataEntry[i].getValue(KEY_SRCBILLENTRYID);
            DynamicObject doMaterial = (DynamicObject)billDataEntry[i].getValue("material");
            if (doMaterial == null || (doUnit = (DynamicObject)billDataEntry[i].getValue("unit")) == null || (srcEntry = (DynamicObject)docSrcEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"entryentity.id") == srcEntryId).findFirst().orElse(null)) == null || kd.bos.orm.util.StringUtils.isEmpty((Object)(serialNo = DynamicObjectUtils.getString((DynamicObject)srcEntry, (String)"entryentity.deliveryserialnumber")))) continue;
            DynamicObject billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)KEY_SBS_BILLSNRELATION);
            billSNRelation.set("billtype", (Object)KEY_IM_SALOUTBILL);
            billSNRelation.set("entrykey", (Object)KEY_BILLENTRY);
            billSNRelation.set("billid", (Object)id);
            billSNRelation.set("entryid", (Object)entryIds[i]);
            billSNRelation.set("material", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doMaterial));
            billSNRelation.set("unit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doUnit));
            Integer qty = (Integer)billSNRelation.get("qty");
            DynamicObjectCollection docSNEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billSNRelation, (String)"entryentity");
            if (docSNEntry == null) continue;
            DynamicObject doSNEntry = (DynamicObject)docSNEntry.getDynamicObjectType().createInstance();
            billSNRelation.set("qty", (Object)(qty + 1));
            doSNEntry.set("seq", (Object)(docSNEntry.size() + 1));
            doSNEntry.set("snnumber", (Object)serialNo);
            docSNEntry.add((Object)doSNEntry);
            lstBillSNRelation.add(billSNRelation);
        }
        if (lstBillSNRelation.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])lstBillSNRelation.toArray(new DynamicObject[0]));
        }
    }

    private void initNewEntityScheme(DynamicObject dataEntity) {
        DynamicObject invScheme = dataEntity.getDynamicObject("invscheme");
        RetailDeliveryOrderPushSaloutPlugin.initEntityValue(dataEntity, invScheme);
        this.setDefaultOwnerAndKeeper(dataEntity);
    }

    public static void initEntityValue(DynamicObject dataEntity, DynamicObject invScheme) {
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject invType = null;
        if (isInUpdate) {
            ownerType = invScheme.getString("ownertype");
            keeperType = invScheme.getString("keepertype");
            invStatus = RetailDeliveryOrderPushSaloutPlugin.getDefaultInvStatus(invScheme);
            invType = RetailDeliveryOrderPushSaloutPlugin.getDefaultInvType(invScheme);
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvTtatus = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString("outownertype");
            outKeeperType = invScheme.getString("outkeepertype");
            outInvTtatus = RetailDeliveryOrderPushSaloutPlugin.getDefaultOutInvStatus(invScheme);
        }
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(KEY_BILLENTRY);
        for (DynamicObject entry : entrys) {
            entry.set("owner", null);
            entry.set("keeper", null);
            entry.set("ownertype", (Object)ownerType);
            entry.set("keepertype", (Object)keeperType);
            entry.set("outowner", null);
            entry.set("outkeeper", null);
            entry.set("outownertype", (Object)outOwnerType);
            entry.set("outkeepertype", (Object)outKeeperType);
            entry.set("invstatus", (Object)invStatus);
            entry.set("invtype", (Object)invType);
            entry.set("outinvstatus", (Object)outInvTtatus);
        }
    }

    public static DynamicObject getDefaultInvType(DynamicObject invScheme) {
        return RetailDeliveryOrderPushSaloutPlugin.getDefaultObject(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    private static DynamicObject getDefaultObject(DynamicObject invScheme, String invTypeEntry, String invTypeIsDefault, String invType) {
        DynamicObjectCollection invtypeEntrys = invScheme.getDynamicObjectCollection(invTypeEntry);
        DynamicObject defaltInvtype = null;
        if (invtypeEntrys != null && invtypeEntrys.size() > 0) {
            for (DynamicObject invtypeEntry : invtypeEntrys) {
                if (invtypeEntry.get(invTypeIsDefault) == null || !invtypeEntry.getBoolean(invTypeIsDefault)) continue;
                defaltInvtype = invtypeEntry.getDynamicObject(invType);
                break;
            }
            if (defaltInvtype == null) {
                defaltInvtype = ((DynamicObject)invtypeEntrys.get(0)).getDynamicObject(invType);
            }
        }
        return defaltInvtype;
    }

    public static DynamicObject getDefaultOutInvType(DynamicObject invScheme) {
        return RetailDeliveryOrderPushSaloutPlugin.getDefaultObject(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return RetailDeliveryOrderPushSaloutPlugin.getDefaultObject(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return RetailDeliveryOrderPushSaloutPlugin.getDefaultObject(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    public void setDefaultOwnerAndKeeper(DynamicObject dataEntity) {
        boolean initialized = dataEntity.isInitialized();
        if (!initialized) {
            dataEntity.beginInit();
        }
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection(KEY_BILLENTRY);
        for (DynamicObject entry : entrys) {
            String outKeeperType = (String)entry.get("outkeepertype");
            Object defalutOutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                defalutOutKeeperId = this.getDefaultOutKeeper(dataEntity, outKeeperType);
            }
            entry.set("outkeeper", defalutOutKeeperId);
            entry.set("outowner", dataEntity.get("org"));
            String keeperType = entry.getString("keepertype");
            Object defalutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                defalutKeeperId = this.getDefaultKeeper(dataEntity, keeperType);
            }
            entry.set("keeper", defalutKeeperId);
            String ownerType = (String)entry.get("ownertype");
            Object defalutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defalutOwnerId = this.getDefaultOwner(dataEntity, ownerType, entry.get("outowner"));
            }
            entry.set("owner", defalutOwnerId);
        }
    }

    public Object getDefaultOutKeeper(DynamicObject dataEntity, String type) {
        Object keeper = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "bos_org": {
                keeper = dataEntity.get("org");
                break;
            }
            case "bd_customer": {
                keeper = dataEntity.get("customer");
                break;
            }
        }
        return keeper;
    }

    public Object getDefaultOutOwner(DynamicObject dataEntity, String type, Object settleOrg) {
        Object owner = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "bos_org": {
                if (settleOrg == null) break;
                owner = settleOrg;
                break;
            }
            case "bd_customer": {
                Object customer = dataEntity.get("customer");
                if (customer == null) break;
                owner = customer;
                break;
            }
        }
        return owner;
    }

    public Object getDefaultKeeper(DynamicObject dataEntity, String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        Object keeper = null;
        switch (type) {
            case "bos_org": {
                keeper = dataEntity.get("org");
                break;
            }
            case "bd_customer": {
                keeper = dataEntity.get("customer");
                break;
            }
        }
        return keeper;
    }

    public Object getDefaultOwner(DynamicObject dataEntity, String type, Object outOwner) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        Object ownerId = null;
        switch (type) {
            case "bos_org": {
                ownerId = outOwner;
                break;
            }
            case "bd_customer": {
                ownerId = dataEntity.get("customer");
                break;
            }
        }
        return ownerId;
    }
}

