/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.botp.deliveryorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.handle.ScmSNHandle;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OrgUtil;
import kd.occ.ocbase.formplugin.MdrBillConvertPlugin;

public class DeliveryOrderPushPurinbillPlugin
extends MdrBillConvertPlugin {
    private static final String PURIN_srcbillid = "srcbillid";
    private static final String PURIN_BILLENTRY = "billentry";
    private static final String PURIN_PROPERTIES_ORG = "org";
    private static final String PURIN_PROPERTIES_BIZORG = "bizorg";
    private static final String PURIN_PROPERTIES_SUPPLIER = "supplier";
    private static final String PURIN_ENTRY_OWNER = "owner";
    private static final String PURIN_ENTRY_ENTRYSETTLEORG = "entrysettleorg";
    private static final String PURIN_ENTRY_ENTRYREQORG = "entryreqorg";
    private static final String PURIN_ENTRY_KEEPER = "keeper";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        int defaultBatchSize = entitys.length;
        ArrayList<Long> deliveryOrderIds = new ArrayList<Long>(defaultBatchSize);
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(defaultBatchSize);
        for (int i = 0; i < defaultBatchSize; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject bill = entity.getDataEntity();
            bills.add(entity.getDataEntity());
            for (DynamicObject entry : bill.getDynamicObjectCollection(PURIN_BILLENTRY)) {
                deliveryOrderIds.add(entry.getLong(PURIN_srcbillid));
            }
        }
        List imBills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillBotpService", (String)"imBillsAfterConvert", (Object[])new Object[]{tgtMainType, bills});
        for (int i = 0; i < defaultBatchSize; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject bill = entity.getDataEntity();
            DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
            for (IDataEntityProperty dp : properties) {
                bill.set(dp, ((DynamicObject)imBills.get(i)).get(dp));
            }
            entity.setDataEntity((DynamicObject)imBills.get(i));
        }
        DynamicObject[] deliveryOrders = this.reloadDeliveryOrder(deliveryOrderIds);
        HashMap<Long, Long> p2pCache = new HashMap<Long, Long>(defaultBatchSize);
        HashMap<Long, Long> p2iCache = new HashMap<Long, Long>(defaultBatchSize);
        HashMap<Long, Long> s2aCache = new HashMap<Long, Long>(defaultBatchSize);
        HashMap<Long, Long> s2sCache = new HashMap<Long, Long>(defaultBatchSize);
        HashMap<Long, Long> s2iCache = new HashMap<Long, Long>(defaultBatchSize);
        HashMap<Long, Long> s2pCache = new HashMap<Long, Long>(defaultBatchSize);
        for (int i = 0; i < defaultBatchSize; ++i) {
            DynamicObject purInBill = entitys[i].getDataEntity();
            DynamicObject deliveryOrder = deliveryOrders[i];
            this.setStockOrgOfPurInBill(purInBill, deliveryOrder, s2iCache);
            this.setPurOrgOfPurInBill(purInBill, deliveryOrder, s2pCache);
            this.setSupplierOfPurInBill(purInBill, deliveryOrder, s2sCache);
            this.setEntryOrgsOfPurInBill(purInBill, deliveryOrder, p2pCache, p2iCache, s2aCache);
        }
        this.handlerSn(entitys);
    }

    private void handlerSn(ExtendedDataEntity[] entitys) {
        List purInBills = ScmSNHandle.autoSetPrimaryKey((ExtendedDataEntity[])entitys);
        HashSet srcBillBntryIds = new HashSet();
        purInBills.forEach(r -> r.getDynamicObjectCollection(PURIN_BILLENTRY).forEach(c -> srcBillBntryIds.add(c.getLong("srcbillentryid"))));
        Map snDataMap = ScmSNHandle.queryDeliveryOrderSnData(srcBillBntryIds);
        ArrayList billSNRelations = new ArrayList();
        purInBills.forEach(purInBill -> purInBill.getDynamicObjectCollection(PURIN_BILLENTRY).forEach(purInEntry -> {
            List snDatas = (List)snDataMap.get(purInEntry.getLong("srcbillentryid"));
            if (!CollectionUtils.isEmpty((Collection)snDatas)) {
                billSNRelations.add(ScmSNHandle.buildPurInBillSn((long)purInBill.getLong("id"), (long)purInEntry.getLong("id"), (List)snDatas));
            }
        }));
        if (billSNRelations.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])purInBills.toArray(new DynamicObject[purInBills.size()]));
            SaveServiceHelper.save((DynamicObject[])billSNRelations.toArray(new DynamicObject[billSNRelations.size()]));
        }
    }

    private long getConsigneeChannelSaleOrg(DynamicObject deliveryOrder) {
        DynamicObject consigneeChannel = deliveryOrder.getDynamicObject("consigneechannel");
        if (consigneeChannel != null) {
            DynamicObject saleOrg = consigneeChannel.getDynamicObject("saleorg");
            if (saleOrg == null) {
                saleOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)consigneeChannel.getPkValue(), (String)"ocdbd_channel").getDynamicObject("saleorg");
            }
            if (saleOrg != null) {
                return saleOrg.getLong("id");
            }
        }
        return 0L;
    }

    private void setPurOrgOfPurInBill(DynamicObject purInBill, DynamicObject deliveryOrder, Map<Long, Long> s2pCache) {
        Long purOrgId;
        long saleOrgId = this.getConsigneeChannelSaleOrg(deliveryOrder);
        if (saleOrgId > 0L && (purOrgId = this.getTargetOrgIdFromCache(saleOrgId, s2pCache, "getPurchaseOrg2Org")) != null && purOrgId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInBill, (String)PURIN_PROPERTIES_BIZORG, (long)purOrgId);
        }
    }

    private void setStockOrgOfPurInBill(DynamicObject purInBill, DynamicObject deliveryOrder, Map<Long, Long> s2iCache) {
        Long stockOrgId;
        long saleOrgId = this.getConsigneeChannelSaleOrg(deliveryOrder);
        if (saleOrgId > 0L && (stockOrgId = this.getTargetOrgIdFromCache(saleOrgId, s2iCache, "getInventoryOrg2Org")) != null && stockOrgId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInBill, (String)PURIN_PROPERTIES_ORG, (long)stockOrgId);
        }
    }

    private void setSupplierOfPurInBill(DynamicObject purInBill, DynamicObject deliveryOrder, Map<Long, Long> s2sCache) {
        Long supplierId;
        long saleOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)deliveryOrder, (String)PURIN_PROPERTIES_ORG);
        if (saleOrgId > 0L && (supplierId = this.getTargetOrgIdFromCache(saleOrgId, s2sCache, "getSupplier2SaleOrg")) != null && supplierId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInBill, (String)PURIN_PROPERTIES_SUPPLIER, (long)supplierId);
        }
    }

    private void setEntryOrgsOfPurInBill(DynamicObject purInBill, DynamicObject deliveryOrder, Map<Long, Long> p2pCache, Map<Long, Long> p2iCache, Map<Long, Long> s2aCache) {
        DynamicObjectCollection purInEntries = purInBill.getDynamicObjectCollection(PURIN_BILLENTRY);
        for (DynamicObject purInEntry : purInEntries) {
            this.setPurInEntryOwnerSettleOrg(deliveryOrder, purInEntry, s2aCache);
            this.setPurInEntryReqOrg(purInBill, purInEntry, p2pCache);
            this.setPurInEntryKeeper(purInBill, purInEntry, p2iCache);
        }
    }

    private void setPurInEntryKeeper(DynamicObject purInBill, DynamicObject purInEntry, Map<Long, Long> p2iCache) {
        Long inventoryOrgId;
        long purchaseOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)purInBill, (String)PURIN_PROPERTIES_BIZORG);
        if (purchaseOrgId > 0L && (inventoryOrgId = this.getTargetOrgIdFromCache(purchaseOrgId, p2iCache, "getPurchaseOrgToInventoryOrg")) != null && inventoryOrgId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInEntry, (String)PURIN_ENTRY_KEEPER, (long)inventoryOrgId);
        }
    }

    private void setPurInEntryReqOrg(DynamicObject purInBill, DynamicObject purInEntry, Map<Long, Long> p2pCache) {
        Long orgId;
        long purchaseOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)purInBill, (String)PURIN_PROPERTIES_BIZORG);
        if (purchaseOrgId > 0L && (orgId = this.getTargetOrgIdFromCache(purchaseOrgId, p2pCache, "getPurchaseOrgFromOrg")) != null && orgId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInEntry, (String)PURIN_ENTRY_ENTRYREQORG, (long)orgId);
        }
    }

    private void setPurInEntryOwnerSettleOrg(DynamicObject deliveryOrder, DynamicObject purInEntry, Map<Long, Long> s2aCache) {
        Long accountOrgId;
        long saleOrgId = this.getConsigneeChannelSaleOrg(deliveryOrder);
        if (saleOrgId > 0L && (accountOrgId = this.getTargetOrgIdFromCache(saleOrgId, s2aCache, "getAccountOrg2Org")) != null && accountOrgId > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInEntry, (String)PURIN_ENTRY_OWNER, (long)accountOrgId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)purInEntry, (String)PURIN_ENTRY_ENTRYSETTLEORG, (long)accountOrgId);
        }
    }

    private DynamicObject[] reloadDeliveryOrder(ArrayList<Long> deliveryOrderIds) {
        DynamicObject[] deliveryOrders = new DynamicObject[deliveryOrderIds.size()];
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])deliveryOrderIds.stream().collect(Collectors.toSet()).toArray(), (String)"ocococ_deliveryorder");
        for (int i = 0; i < deliveryOrderIds.size(); ++i) {
            deliveryOrders[i] = (DynamicObject)map.get(deliveryOrderIds.get(i));
        }
        return deliveryOrders;
    }

    private Long getTargetOrgIdFromCache(Long sourceOrgId, Map<Long, Long> cache, String orgFuction) {
        Long targetOrgId = null;
        if (sourceOrgId != null && sourceOrgId > 0L && (targetOrgId = cache.get(sourceOrgId)) == null) {
            switch (orgFuction) {
                case "getInventoryOrg2Org": {
                    targetOrgId = OrgUtil.getInventoryOrg2Org((long)sourceOrgId);
                    break;
                }
                case "getPurchaseOrg2Org": {
                    targetOrgId = OrgUtil.getPurchaseOrg2Org((long)sourceOrgId);
                    break;
                }
                case "getAccountOrg2Org": {
                    targetOrgId = OrgUtil.getAccountOrg2Org((long)sourceOrgId);
                    break;
                }
                case "getPurchaseOrgFromOrg": {
                    targetOrgId = OrgUtil.getPurchaseOrgFromOrg((long)sourceOrgId);
                    break;
                }
                case "getPurchaseOrgToInventoryOrg": {
                    targetOrgId = OrgUtil.getPurchaseOrgToInventoryOrg((long)sourceOrgId);
                    break;
                }
                case "getSupplier2SaleOrg": {
                    targetOrgId = this.getSupplier2SaleOrg(sourceOrgId);
                    break;
                }
            }
            if (targetOrgId != null && targetOrgId > 0L) {
                cache.put(sourceOrgId, targetOrgId);
                return targetOrgId;
            }
        }
        return targetOrgId;
    }

    private Long getSupplier2SaleOrg(Long saleOrgId) {
        QFilter qFilter = F7Utils.getEnableFilter();
        qFilter.and("internal_company", "=", (Object)saleOrgId);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])qFilter.toArray());
        if (supplier != null) {
            return supplier.getLong("id");
        }
        return null;
    }
}

