/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.botp.deliveryorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class PosDeliveryOrderCvtSaloutBillPlugin
extends AbstractConvertPlugIn {
    private static final String KEY_IM_SALOUTBILL = "im_saloutbill";
    private static final String KEY_TABLE_SALOUTBILL = "t_im_saloutbill";
    private static final String KEY_BILLENTRY = "billentry";
    private static final String KEY_TABLE_BILLENTRY = "t_im_saloutbillentry";
    private static final String KEY_SBS_BILLSNRELATION = "sbs_billsnrelation";
    private static final String KEY_SRCBILLENTRYID = "srcbillentryid";
    private static final String KEY_SELECT_FEILD = "entryentity.id,entryentity.deliveryserialnumber,entryentity.qty,entryentity.unit.id";

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntity billData = Arrays.stream(e.getTargetExtDataEntitySet().FindByEntityKey(KEY_IM_SALOUTBILL)).findFirst().orElse(null);
        if (billData == null) {
            return;
        }
        long id = DB.genLongId((String)KEY_TABLE_SALOUTBILL);
        billData.setValue("id", (Object)id);
        ExtendedDataEntity[] billDataEntry = e.getTargetExtDataEntitySet().FindByEntityKey(KEY_BILLENTRY);
        if (billDataEntry == null || billDataEntry.length == 0) {
            return;
        }
        ArrayList<Long> lstSrcEntryId = new ArrayList<Long>(0);
        for (ExtendedDataEntity dataEntity : billDataEntry) {
            long srcEntryId = (Long)dataEntity.getValue(KEY_SRCBILLENTRYID);
            if (lstSrcEntryId.contains(srcEntryId)) continue;
            lstSrcEntryId.add(srcEntryId);
        }
        QFilter filter = new QFilter("entryentity.id", "in", (Object)lstSrcEntryId.toArray());
        DynamicObjectCollection docSrcEntry = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)KEY_SELECT_FEILD, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)docSrcEntry)) {
            return;
        }
        this.saveBillSNRelation(docSrcEntry, billDataEntry, id);
    }

    private void saveBillSNRelation(DynamicObjectCollection docSrcEntry, ExtendedDataEntity[] billDataEntry, long id) {
        long[] entryIds = DB.genLongIds((String)KEY_TABLE_BILLENTRY, (int)billDataEntry.length);
        ArrayList<DynamicObject> lstBillSNRelation = new ArrayList<DynamicObject>(0);
        for (int i = 0; i < billDataEntry.length; ++i) {
            String serialNo;
            DynamicObject srcEntry;
            DynamicObject doUnit;
            billDataEntry[i].setValue("id", (Object)entryIds[i]);
            long srcEntryId = (Long)billDataEntry[i].getValue(KEY_SRCBILLENTRYID);
            DynamicObject doMaterial = (DynamicObject)billDataEntry[i].getValue("material");
            if (doMaterial == null || (doUnit = (DynamicObject)billDataEntry[i].getValue("unit")) == null || (srcEntry = (DynamicObject)docSrcEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"entryentity.id") == srcEntryId).findFirst().orElse(null)) == null || StringUtils.isEmpty((Object)(serialNo = DynamicObjectUtils.getString((DynamicObject)srcEntry, (String)"entryentity.deliveryserialnumber")))) continue;
            DynamicObject billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)KEY_SBS_BILLSNRELATION);
            billSNRelation.set("billtype", (Object)KEY_IM_SALOUTBILL);
            billSNRelation.set("entrykey", (Object)KEY_BILLENTRY);
            billSNRelation.set("billid", (Object)id);
            billSNRelation.set("entryid", (Object)entryIds[i]);
            billSNRelation.set("material", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doMaterial));
            billSNRelation.set("unit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doUnit));
            Integer qty = (Integer)billSNRelation.get("qty");
            DynamicObjectCollection docSNEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)billSNRelation, (String)"entryentity");
            if (docSNEntry == null) continue;
            DynamicObject doSNEntry = (DynamicObject)docSNEntry.getDynamicObjectType().createInstance();
            billSNRelation.set("qty", (Object)(qty + 1));
            doSNEntry.set("seq", (Object)(docSNEntry.size() + 1));
            doSNEntry.set("snnumber", (Object)serialNo);
            docSNEntry.add((Object)doSNEntry);
            lstBillSNRelation.add(billSNRelation);
        }
        if (lstBillSNRelation.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])lstBillSNRelation.toArray(new DynamicObject[0]));
        }
    }
}

