/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.botp.deliveryorder;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocococ.business.deliveryorder.DeliveryOrderBotpHelper;

public class SaleOrderPushDeliveryOrderConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObjectCollection entrys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = entitySet.FindByEntityKey(tgtMainType);
        HashSet<Long> orderChannelIdSet = new HashSet<Long>(10);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long orderChannelId = extendedDataEntity.getDataEntity().getLong(String.join((CharSequence)"_", "purchannel", "id"));
            if (orderChannelId <= 0L) continue;
            orderChannelIdSet.add(orderChannelId);
        }
        DynamicObject[] orderChannelDynObjs = null;
        if (orderChannelIdSet.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", orderChannelIdSet);
            String selectors = String.join((CharSequence)",", "id", "balancechannel", "paychannel");
            orderChannelDynObjs = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)selectors, (QFilter[])qFilter.toArray());
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            if (bill == null) continue;
            DeliveryOrderBotpHelper.afterConvert((DynamicObject)bill);
            entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                DynamicObject materialDynObj = entry.getDynamicObject("material");
                long auxUnitId = entry.getLong(String.join((CharSequence)"_", "assistunit", "id"));
                if (materialDynObj != null && auxUnitId > 0L) {
                    long baseUnitId = entry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
                    entry.set("assistqty", (Object)UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialDynObj.getLong("masterid"), (Long)baseUnitId, (Long)auxUnitId));
                }
                if (CommonUtils.isNull((Object)orderChannelDynObjs)) continue;
                for (DynamicObject orderChannelDynObj : orderChannelDynObjs) {
                    DynamicObject balanceChannelDynObj;
                    if (orderChannelDynObj.getLong("id") != bill.getLong(String.join((CharSequence)"_", "purchannel", "id"))) continue;
                    DynamicObject payChannelDynObj = orderChannelDynObj.getDynamicObject("paychannel");
                    if (payChannelDynObj != null) {
                        entry.set("payingcustomer", (Object)payChannelDynObj.getDynamicObject("customer"));
                    }
                    if ((balanceChannelDynObj = orderChannelDynObj.getDynamicObject("balancechannel")) == null) continue;
                    entry.set("settlecustomer", (Object)balanceChannelDynObj.getDynamicObject("customer"));
                }
            }
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys.size() <= 0) continue;
            DynamicObject entry = (DynamicObject)entrys.get(0);
            long srcBilleId = entry.getLong("srcbilleid");
            String srcBillEntity = entry.getString("srcbillentity");
            if (!StringUtils.equals((CharSequence)srcBillEntity, (CharSequence)"ocbsoc_saleorder")) continue;
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)srcBilleId, (String)srcBillEntity);
            DynamicObject billTypeParameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"ocbsoc_saleorder", (String)"ocbsoc_saleorder_btparam", (long)saleOrder.getLong("billtypeid_id"));
            String tradetype = billTypeParameter.getString("tradetype");
            bill.set("tradetype", (Object)tradetype);
        }
    }
}

