/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.BillTypeParameterHelper;
import kd.occ.ocbase.common.util.StringUtils;

public class DeliveryOrderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String SETTLE_TIME_POINT = "settletimepoint";
    private static final String SETTLE_TIME_POINT_IMMEDIATELY = "2";
    private static final String SHIPPING_MODE_IMMEDIATELY = "1";
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (null == billType) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002");
            return;
        }
        DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"ocococ_deliveryorder", (long)billType.getLong("id"));
        if (billTypeParam != null) {
            this.getModel().setValue("businesstype", billTypeParam.get("businesstype"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.mergeAddress();
                this.autoShippingWhenShipModeIsImmediately();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        DynamicObject distributionMode = this.getView().getModel().getDataEntity(true).getDynamicObject("distributionmode");
        if (distributionMode != null) {
            boolean isCheckDistributionMode;
            Object pkValue = distributionMode.getPkValue();
            boolean bl = isCheckDistributionMode = ObjectUtils.nullSafeEquals((Object)pkValue, (Object)926601071999218688L) || ObjectUtils.nullSafeEquals((Object)pkValue, (Object)1188335265681326080L) || ObjectUtils.nullSafeEquals((Object)pkValue, (Object)926601157210585088L);
            if (!isCheckDistributionMode) {
                BasedataEdit distributionModeBaseEdit = (BasedataEdit)this.getControl("distributionmode");
                distributionModeBaseEdit.setMustInput(true);
            }
        }
    }

    private void autoShippingWhenShipModeIsImmediately() {
        if (this.isImmediatelyShipping()) {
            this.getModel().setValue("deliveryallstatus", (Object)DeliveryStatus.SALE_OUTBOUND);
            this.getModel().setValue("signallstatus", (Object)"A");
            DynamicObjectCollection itemEntries = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject itemEntry : itemEntries) {
                itemEntry.set("deliverystatus", (Object)DeliveryStatus.SALE_OUTBOUND);
                itemEntry.set("signstatus", (Object)"A");
                itemEntry.set("deliveredbaseqty", (Object)itemEntry.getBigDecimal("baseqty"));
                itemEntry.set("deliveredqty", (Object)itemEntry.getBigDecimal("qty"));
                itemEntry.set("deliveredassistqty", (Object)itemEntry.getBigDecimal("assistqty"));
            }
        }
    }

    private boolean isImmediatelyShipping() {
        Object shippingMode = this.getModel().getValue("distributionmode");
        if (StringUtils.isEmpty((Object)shippingMode)) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u3010\u914d\u9001\u6a21\u5f0f\u3011\u3002");
            return false;
        }
        return SHIPPING_MODE_IMMEDIATELY.equals(shippingMode.toString());
    }

    private void autoGenerateSaleOutOrder() {
        if (this.isImmediatelySettle()) {
            Object pkValue = this.getModel().getValue("id");
            ArrayList<ListSelectedRow> sourceBill = new ArrayList<ListSelectedRow>(1);
            sourceBill.add(new ListSelectedRow(pkValue, Boolean.TRUE));
            PushArgs pushArgs = new PushArgs("ocococ_deliveryorder", "im_saloutbill", sourceBill);
            ConvertOperationResult convertResults = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            if (convertResults.isSuccess()) {
                Set targetBillIds = convertResults.getTargetBillIds();
                Object billid = targetBillIds.iterator().next();
                BillShowParameter bsp = new BillShowParameter();
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setFormId("im_saloutbill");
                bsp.setPkId(billid);
                this.getView().showForm((FormShowParameter)bsp);
            } else {
                StringBuilder errorMsg = new StringBuilder();
                for (SourceBillReport billReport : convertResults.getBillReports()) {
                    errorMsg.append(billReport.getFailMessage());
                }
                this.getView().showMessage(errorMsg.toString());
            }
        }
    }

    private boolean isImmediatelySettle() {
        DynamicObject billTypeParam;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (null != billType && null != (billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)"ocococ_deliveryorder", (long)billType.getLong("id")))) {
            return SETTLE_TIME_POINT_IMMEDIATELY.equals(billTypeParam.get(SETTLE_TIME_POINT).toString());
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    private void mergeAddress() {
        Object address = this.getModel().getValue("address");
        String addressFullName = DeliveryOrderEdit.getAdminDivisionName(address);
        Object address2 = this.getModel().getValue("detailaddress");
        this.getModel().setValue("alladdress", (Object)(addressFullName + address2));
    }

    private static String getAdminDivisionName(Object adminId) {
        if (StringUtils.isEmpty((Object)adminId)) {
            return "";
        }
        DynamicObject adminDivision = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(adminId.toString())).toArray());
        if (adminDivision == null) {
            return "";
        }
        String fullName = adminDivision.getString("fullname");
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        return fullName.replaceAll("_", "");
    }
}

