/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.pagemodel.OcococDeliveryorder;
import kd.occ.ocococ.business.deliveryorder.DeliverySerialHelper;
import kd.occ.ocococ.business.deliveryorder.PosDeliveryOrderStatusHelper;

public class DeliveryOrderList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long billTypeId = Long.parseLong(((Object)customParams.getOrDefault("billTypeId", 0L)).toString());
        List fs = e.getCustomQFilters();
        if (OcococDeliveryorder.KEY_salesDelivery.equals(billTypeId)) {
            QFilter qFilter = new QFilter("billtype.id", "=", (Object)Long.parseLong("1038197845456356352"));
            qFilter.or("billtype.id", "=", (Object)Long.parseLong("1047118809342782464"));
            qFilter.or("businesstype.id", "=", (Object)Long.parseLong("422876630176775168"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"t_confirmreceive"});
            fs.add(qFilter);
        } else if (OcococDeliveryorder.KEY_returnRecovery.equals(billTypeId)) {
            QFilter qFilter = new QFilter("billtype.id", "=", (Object)Long.parseLong("1047119905381539840"));
            qFilter.or("billtype.id", "=", (Object)Long.parseLong("1041299740748200960"));
            qFilter.or("businesstype.id", "=", (Object)Long.parseLong("688855385217756160"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"t_confirmdelivery"});
            fs.add(qFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List listFilterColumns = args.getCommonFilterColumns();
        if (listShowParameter.isLookUp()) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long billTypeId = Long.parseLong(((Object)customParams.getOrDefault("billTypeId", 0L)).toString());
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String fieldName = commFilter.getFieldName();
            if (!fieldName.equals("billtype.name") || !billTypeId.equals(OcococDeliveryorder.KEY_salesDelivery) && !billTypeId.equals(OcococDeliveryorder.KEY_returnRecovery)) continue;
            List<ComboItem> comboItems = this.getComboItem(billTypeId);
            commFilter.setComboItems(comboItems);
        }
    }

    public List<ComboItem> getComboItem(Long billTypeId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (billTypeId == null) {
            return comboItems;
        }
        ComboItem item = new ComboItem();
        ComboItem item1 = new ComboItem();
        if (billTypeId.equals(OcococDeliveryorder.KEY_salesDelivery)) {
            item.setId("1038197845456356352");
            item.setValue("1038197845456356352");
            item.setCaption(new LocaleString("\u6807\u51c6\u5206\u9500\u53d1\u8d27\u5355"));
            item1.setId("1047118809342782464");
            item1.setValue("1047118809342782464");
            item1.setCaption(new LocaleString("\u6807\u51c6\u96f6\u552e\u53d1\u8d27\u5355"));
        } else if (billTypeId.equals(OcococDeliveryorder.KEY_returnRecovery)) {
            item.setId("1047119905381539840");
            item.setValue("1047119905381539840");
            item.setCaption(new LocaleString("\u6807\u51c6\u96f6\u552e\u9000\u8d27\u5355"));
            item1.setId("1041299740748200960");
            item1.setValue("1041299740748200960");
            item1.setCaption(new LocaleString("\u6807\u51c6\u9000\u8d27\u901a\u77e5\u5355"));
        }
        comboItems.add(item);
        comboItems.add(item1);
        return comboItems;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "manualdelivery": {
                ListSelectedRowCollection selectedRowCollection = this.getSelectedRows();
                if (selectedRowCollection.isEmpty()) {
                    this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
                    return;
                }
                List<Object> idS = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList());
                List noSerialList = DeliverySerialHelper.getItemNoSerialList(idS);
                if (!CollectionUtils.isEmpty((Collection)noSerialList)) {
                    this.toSerialInputList(noSerialList);
                    break;
                }
                if (this.checkSelectedRow(idS)) {
                    this.toHandMarkPage();
                    break;
                }
                this.getView().showTipNotification("\u53ea\u6709\u5df2\u5ba1\u6838\u4e14\u5f85\u53d1\u8d27\u7684\u5355\u636e\u624d\u80fd\u624b\u5de5\u53d1\u8d27\u3002");
                break;
            }
        }
    }

    private boolean checkSelectedRow(List<Object> idS) {
        QFilter qFilter = new QFilter("deliveryallstatus", "=", (Object)DeliveryStatus.SALE_WAIT_DELIVERY);
        qFilter.and("id", "in", idS);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection dyo = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray());
        return !CollectionUtils.isEmpty((Collection)dyo);
    }

    protected void toHandMarkPage() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ocococ_manualmark");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "manualdelivery"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    protected void toSerialInputList(List<Map<String, Object>> noSerialList) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ocococ_seriallistinput");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("list", noSerialList);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getActionId().equals("manualdelivery")) {
            String selectFields = "billtype,entryentity.corebillentryid";
            ListSelectedRowCollection selectedRowCollection = this.getSelectedRows();
            List idS = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", idS);
            DynamicObjectCollection entryEntity = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)selectFields, (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            long billTypeId = ((DynamicObject)entryEntity.get(0)).getLong("billtype");
            List saleOrderSubEntryIds = entryEntity.stream().map(s -> s.get("entryentity.corebillentryid")).distinct().collect(Collectors.toList());
            DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
            DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_OUTBOUND, (String)"ococic_deliverstatus");
            PosDeliveryOrderStatusHelper.updataDeliveryOrderStatus(saleOrderSubEntryIds, (DynamicObject)deliveryStatus);
            PosDeliveryOrderStatusHelper.updataReturnDataToDeliveryOrder(saleOrderSubEntryIds, (DynamicObject)returnData);
            if (billTypeId == 1047118809342782464L) {
                PosDeliveryOrderStatusHelper.updataSaleOrderValue((String)"ocpos_saleorder", saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
                PosDeliveryOrderStatusHelper.updataRetailOrderStatus(saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            } else if (billTypeId == 1047119905381539840L) {
                PosDeliveryOrderStatusHelper.updataSaleOrderValue((String)"ocpos_saleorder_return", saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
                PosDeliveryOrderStatusHelper.updataRetailOrderStatus(saleOrderSubEntryIds, (String)"deliverystatus", (Object)deliveryStatus);
            }
        }
    }
}

