/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DeliveryOrderManualMarkEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TOOL_BAR = "tbmain";
    private static final String MANUAL_DELIVERY = "manualsend";
    private static final String KEY_MANUALREMARK_BILL = "ocococ_manualmark";
    private static final String ORDER_DETAIL_ENTRY = "entryentity";
    private static final String DELIVERY_STATUS_SIGN = "ococic_deliverstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TOOL_BAR});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            default: 
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (key != null) {
            switch (key) {
                case "manualsend": {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ORDER_DETAIL_ENTRY);
                    int[] rowIndexs = entryGrid.getSelectRows();
                    Integer size = rowIndexs.length;
                    if (size < 1) {
                        this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8ba2\u5355\u660e\u7ec6\u3002");
                        break;
                    }
                    this.toHandMarkPage(e);
                }
            }
        }
    }

    protected void toHandMarkPage(AfterDoOperationEventArgs e) {
        BigDecimal deliveredqty;
        BigDecimal qty;
        String hide;
        int currentRowIndex = 0;
        int[] rowIndexs = null;
        String rowIndexString = null;
        Integer size = this.getModel().getEntryRowCount(ORDER_DETAIL_ENTRY);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ORDER_DETAIL_ENTRY);
        if (size > 1) {
            hide = "a";
            rowIndexs = entryGrid.getSelectRows();
            rowIndexString = this.toString(rowIndexs);
        } else {
            hide = "b";
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ORDER_DETAIL_ENTRY);
        }
        if (hide.equals("b") && (qty = (BigDecimal)this.getView().getModel().getValue("qty", currentRowIndex)).compareTo(deliveredqty = (BigDecimal)this.getView().getModel().getValue("deliveredqty", currentRowIndex)) <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5df2\u5168\u90e8\u53d1\u8d27\uff0c\u8bf7\u68c0\u67e5", (String)"DeliveryOrderManualMarkEdit", (String)"drp-ocococ-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("hide", (Object)hide);
        parameter.setCustomParam("type", (Object)"form");
        parameter.setCustomParam("rowindex", (Object)currentRowIndex);
        parameter.setCustomParam("rowIndexString", (Object)rowIndexString);
        parameter.setFormId(KEY_MANUALREMARK_BILL);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_MANUALREMARK_BILL));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public String toString(int[] arr) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            str.append(arr[i]);
            if (i >= arr.length - 1) continue;
            str.append(',');
        }
        return str.substring(0, str.length() - 1).trim();
    }

    public int[] toIntegerArr(String str) {
        String[] a = str.split(",");
        int[] i = new int[a.length];
        for (int k = 0; k < a.length; ++k) {
            if (a[k].trim().isEmpty()) continue;
            i[k] = Integer.parseInt(a[k].trim());
        }
        return i;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        HashMap returnData;
        super.closedCallBack(e);
        boolean whetherOneLine = true;
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal deliveredqty = BigDecimal.ZERO;
        BigDecimal baseqty = BigDecimal.ZERO;
        String rowIndexString = null;
        if (null != e.getReturnData() && StringUtils.equals((CharSequence)KEY_MANUALREMARK_BILL, (CharSequence)e.getActionId()) && (returnData = (HashMap)e.getReturnData()) != null) {
            String hide = (String)returnData.get("hide");
            if (hide.equals("a")) {
                whetherOneLine = false;
            }
            if (whetherOneLine) {
                if (returnData.get("quantity") != null) {
                    quantity = (BigDecimal)returnData.get("quantity");
                }
                int rowindex = (Integer)returnData.get("rowindex");
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ORDER_DETAIL_ENTRY);
                if (dynamicObjectCollection.get(rowindex) != null) {
                    deliveredqty = ((DynamicObject)dynamicObjectCollection.get(rowindex)).getBigDecimal("deliveredqty");
                    baseqty = ((DynamicObject)dynamicObjectCollection.get(rowindex)).getBigDecimal("baseqty");
                }
                Object qty = this.getView().getModel().getValue("qty", rowindex);
                if (deliveredqty.add(quantity).compareTo((BigDecimal)qty) > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u8981\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5", (String)"DeliveryOrderManualMarkEdit", (String)"drp-ocococ-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getModel().setValue("deliveredqty", (Object)deliveredqty.add(quantity), rowindex);
                if (quantity.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal changedbaseQty = deliveredqty.add(quantity).multiply(baseqty).divide((BigDecimal)qty, 4, 4);
                    this.getView().getModel().setValue("deliveredbaseqty", (Object)changedbaseQty, rowindex);
                    this.getView().getModel().setValue("deliverystatus", (Object)this.getDeliverySentStatus("F008"), rowindex);
                }
                if (deliveredqty.add(quantity).compareTo((BigDecimal)qty) == 0) {
                    this.getView().getModel().setValue("deliveredbaseqty", (Object)baseqty, rowindex);
                    this.getView().getModel().setValue("deliverystatus", (Object)this.getDeliverySentStatus(null), rowindex);
                }
            } else {
                int[] arr;
                rowIndexString = (String)returnData.get("rowIndexString");
                for (int eachrownum : arr = this.toIntegerArr(rowIndexString)) {
                    Object qty = this.getView().getModel().getValue("qty", eachrownum);
                    this.getView().getModel().setValue("deliveredqty", qty, eachrownum);
                    Object oribaseqty = this.getView().getModel().getValue("baseqty", eachrownum);
                    this.getView().getModel().setValue("deliveredbaseqty", oribaseqty, eachrownum);
                    this.getView().getModel().setValue("deliverystatus", (Object)this.getDeliverySentStatus(null), eachrownum);
                    this.getView().setEnable(Boolean.FALSE, eachrownum, new String[]{"deliveredqty"});
                    this.getView().setEnable(Boolean.FALSE, eachrownum, new String[]{"deliveredbaseqty"});
                }
            }
            String trackingno = (String)returnData.get("trackingno");
            String logisticcompany = (String)returnData.get("logisticcompany");
            this.getView().getModel().createNewEntryRow("logisticsinfo");
            int n = this.getView().getModel().getEntryRowCount("logisticsinfo") - 1;
            this.getView().getModel().setValue("logisticscompany", (Object)logisticcompany, n);
            this.getView().getModel().setValue("logisticsbill", (Object)trackingno, n);
            this.getView().getModel().setValue("arrivaldate", (Object)new Date(), n);
        }
    }

    private Long getDeliverySentStatus(String number) {
        String filternumber = null;
        filternumber = number == null ? "F003" : number;
        Long id = 0L;
        QFilter numberFilter = new QFilter("number", "=", (Object)filternumber);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DELIVERY_STATUS_SIGN, (String)"id", (QFilter[])numberFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            id = dynamicObjects[0].getLong("id");
        }
        return id;
    }
}

