/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocococ.common.enums.DeliveryOrderTypeEnum;

public class DeliveryOrderSerialEdit
extends AbstractBillPlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"selectserialid")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] index = entryGrid.getSelectRows();
            if (index == null || index.length != 1) {
                NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u884c\u8ba2\u5355\u660e\u7ec6\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (IFormView)this.getView());
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index[0]);
                long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"material");
                if (materialId <= 0L) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u884c\u65e0\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (IFormView)this.getView());
                    return;
                }
                QFilter filter = new QFilter("masterid", "=", (Object)materialId);
                DynamicObject materialInv = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"enableserial", (QFilter[])filter.toArray());
                boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
                if (!isEnableSerial) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u6ca1\u6709\u542f\u7528\u5e8f\u5217\u53f7\u3001\u65e0\u9700\u5f55\u5165\u3002", (IFormView)this.getView());
                    return;
                }
                Map<String, Object> customParams = this.createCustomParams(dataEntity, entryEntities, entryEntity);
                FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocococ_serialentry", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectserialid"));
                this.getView().showForm(parameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"selectserialid") && returnData instanceof JSONArray) {
            JSONArray results = (JSONArray)returnData;
            this.getModel().beginInit();
            this.getModel().deleteEntryData("subentryentity");
            this.getModel().batchCreateNewEntryRow("subentryentity", results.size());
            int index = 0;
            for (Object item : results) {
                JSONObject result = (JSONObject)item;
                long snMainFileId = result.getLongValue("snmainfile");
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"scmserialid", (Object)snMainFileId, (int)index);
                String sn = result.getString("sn");
                this.getModel().setValue("supplyserialnumber", (Object)sn, index);
                ++index;
            }
            this.getModel().endInit();
            this.getView().updateView("subentryentity");
        }
    }

    private Map<String, Object> createCustomParams(DynamicObject dataEntity, DynamicObjectCollection entryEntities, DynamicObject entryEntity) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(5);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"billtype");
        if (billTypeId == DeliveryOrderTypeEnum.DISTRIBUTIONDELIVERY.getId() || billTypeId == DeliveryOrderTypeEnum.RETAILDELIVERY.getId()) {
            customParams.put("key", "delivery");
        } else if (billTypeId == DeliveryOrderTypeEnum.DISTRIBUTIONRETURN.getId()) {
            customParams.put("key", "return");
        } else {
            customParams.put("key", "posreturn");
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"item");
        customParams.put("goodsid", goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"material");
        customParams.put("materialid", materialId);
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materialass");
        customParams.put("auxpty", auxPtyId);
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"stockorg");
        customParams.put("stockorg", stockOrgId);
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"qty");
        customParams.put("selectnumber", qty);
        JSONArray sns = new JSONArray();
        DynamicObjectCollection serialEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"subentryentity");
        if (!CollectionUtils.isEmpty((Collection)serialEntities)) {
            for (DynamicObject serialEntity : serialEntities) {
                JSONObject item = new JSONObject();
                String sn = DynamicObjectUtils.getString((DynamicObject)serialEntity, (String)"supplyserialnumber");
                item.put("sn", (Object)sn);
                long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)serialEntity, (String)"scmserialid");
                item.put("supplyserialid", (Object)snMainFileId);
                String comment = DynamicObjectUtils.getString((DynamicObject)serialEntity, (String)"comment");
                item.put("comment", (Object)comment);
                sns.add((Object)item);
            }
        }
        customParams.put("entryentity", sns);
        customParams.put("serialnumber", sns.size());
        HashSet<Long> existIds = new HashSet<Long>(0);
        for (DynamicObject entity : entryEntities) {
            DynamicObjectCollection subEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entity, (String)"subentryentity");
            if (CollectionUtils.isEmpty((Collection)subEntities)) continue;
            for (DynamicObject subEntity : subEntities) {
                long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)subEntity, (String)"scmserialid");
                if (snMainFileId <= 0L) continue;
                existIds.add(snMainFileId);
            }
        }
        customParams.put("locksnmainfiles", existIds);
        return customParams;
    }
}

