/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocococ.business.push.AutoPushHelper;
import kd.occ.ocococ.common.util.CommonUtil;

public class DeliverySerialInputList
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List data = (List)this.getView().getFormShowParameter().getCustomParam("list");
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("itementry", data.size());
        int i = 0;
        for (Map datum : data) {
            Long itemId = datum.getOrDefault("goodsid", 0L);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsid", (Object)itemId, (int)i);
            Long materialId = datum.getOrDefault("materialid", 0L);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"materialid", (Object)materialId, (int)i);
            Long auxPtyId = datum.getOrDefault("auxpty", 0L);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"auxpty", (Object)auxPtyId, (int)i);
            Long stockOrgId = datum.getOrDefault("stockorg", 0L);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"stockorg", (Object)stockOrgId, (int)i);
            Long selectNumber = datum.getOrDefault("selectnumber", 0L);
            this.getModel().setValue("selectnumber", (Object)selectNumber, i);
            Long saleOrderId = datum.getOrDefault("saleorderid", 0L);
            this.getModel().setValue("saleorderid", (Object)saleOrderId, i);
            ++i;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit snEdit = (TextEdit)this.getView().getControl("sn");
        snEdit.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryKey, (CharSequence)"entryentity")) {
            this.updateSerialNumber();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List data;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocococ_snmainfile_query") && returnData instanceof List && !CollectionUtils.isEmpty((Collection)(data = (List)returnData))) {
            int currIndex = CommonUtil.formatStringToInt((String)this.getPageCache().get("index_" + this.getView().getPageId()));
            this.getModel().beginInit();
            int size = data.size();
            for (int i = 0; i < size; ++i) {
                JSONObject datum = (JSONObject)data.get(i);
                long snMainFileId = datum.getLongValue("snmainfile");
                this.getModel().setItemValueByID("supplyserialid", (Object)snMainFileId, currIndex);
                String sn = datum.getString("sn");
                this.getModel().setValue("sn", (Object)sn, currIndex);
                if (i >= size - 1) continue;
                currIndex = this.getModel().insertEntryRow("entryentity", currIndex + 1);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            this.getPageCache().remove("index_" + this.getView().getPageId());
            this.updateSerialNumber();
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (key = ctrl.getKey()) {
            case "btnok": {
                this.confirm();
                break;
            }
            case "sn": {
                int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getPageCache().put("index_" + this.getView().getPageId(), String.valueOf(currIndex));
                this.querySerialNumber(currIndex);
                break;
            }
        }
    }

    private void confirm() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itementry");
        int index = 1;
        for (DynamicObject entryEntity : entryEntities) {
            int serialNumber;
            int selectNumber = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"selectnumber");
            if (selectNumber != (serialNumber = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"serialnumber"))) {
                this.getView().showMessage(String.format("\u7b2c%d\u884c,\u5546\u54c1\u6570\u91cf\u4e0e\u5df2\u9009\u62e9\u5e8f\u5217\u53f7\u6570\u91cf\u4e0d\u540c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", index));
                continue;
            }
            this.updateParentView();
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    private void updateParentView() {
        DynamicObjectCollection itemEntities = this.getModel().getEntryEntity("itementry");
        int size = itemEntities.size();
        HashSet<Long> orderIds = new HashSet<Long>(size);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(size);
        for (int i = 0; i < itemEntities.size(); ++i) {
            DynamicObject itemEntity = (DynamicObject)itemEntities.get(i);
            long orderId = DynamicObjectUtils.getLong((DynamicObject)itemEntity, (String)"saleorderid");
            if (orderId == 0L) continue;
            orderIds.add(orderId);
            map.put(orderId, i);
        }
        if (CollectionUtils.isEmpty(orderIds)) {
            return;
        }
        QFilter filter = new QFilter("entryentity", "in", orderIds);
        String selectFields = this.getLogisticsInfo();
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)selectFields, (QFilter[])filter.toArray());
        if (orders == null || orders.length <= 0) {
            return;
        }
        for (DynamicObject order : orders) {
            DynamicObjectCollection entries = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)order, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)entries)) continue;
            for (DynamicObject entry : entries) {
                long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entry);
                int index = (Integer)map.get(entryId);
                DynamicObjectCollection serialEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)((DynamicObject)itemEntities.get(index)), (String)"entryentity");
                if (CollectionUtils.isEmpty((Collection)serialEntities)) continue;
                entry.set("deliveryserialnumber", (Object)DynamicObjectUtils.getString((DynamicObject)((DynamicObject)serialEntities.get(0)), (String)"sn"));
                DynamicObjectCollection subEntries = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)"subentryentity");
                if (subEntries == null) continue;
                subEntries.clear();
                for (DynamicObject serialEntity : serialEntities) {
                    DynamicObject subEntry = subEntries.addNew();
                    DynamicObject snMainFile = DynamicObjectUtils.getDynamicObject((DynamicObject)serialEntity, (String)"supplyserialid");
                    subEntry.set("scmserialid", (Object)snMainFile);
                    String sn = DynamicObjectUtils.getString((DynamicObject)serialEntity, (String)"sn");
                    subEntry.set("supplyserialnumber", (Object)sn);
                    String comment = DynamicObjectUtils.getString((DynamicObject)serialEntity, (String)"comment");
                    subEntry.set("comment", (Object)comment);
                    subEntry.set("iscorrect", (Object)Boolean.TRUE);
                    subEntry.set("seq", (Object)subEntries.getRowCount());
                    Object coreBillEntryId = DynamicObjectUtils.get((DynamicObject)entry, (String)"corebillentryid");
                    this.updateSaleOrder(coreBillEntryId, snMainFile, sn, order);
                }
            }
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    private void querySerialNumber(int currIndex) {
        DynamicObject subEntryEntity = this.getModel().getEntryRowEntity("entryentity", currIndex);
        DynamicObject entryEntity = (DynamicObject)subEntryEntity.getParent();
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materialid");
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"auxpty");
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"stockorg");
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("materialid", materialId);
        customParams.put("auxpty", auxPtyId);
        customParams.put("stockorg", stockOrgId);
        customParams.put("ismul", Boolean.TRUE);
        customParams.put("locksnmainfiles", this.getExistId());
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("key");
        customParams.put("key", sign);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocococ_snmainfile_query", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocococ_snmainfile_query"));
        this.getView().showForm(parameter);
    }

    private void updateSerialNumber() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        for (DynamicObject itemEntity : itemEntry) {
            DynamicObjectCollection subEntry = itemEntity.getDynamicObjectCollection("entryentity");
            int index = Math.toIntExact(subEntry.stream().filter(s -> s.get("supplyserialid") != null).count());
            itemEntity.set("serialnumber", (Object)index);
        }
        this.getView().updateView("itementry");
    }

    private void updateSaleOrder(Object coreBillEntryId, DynamicObject supplySerial, String sn, DynamicObject deliveryOrder) {
        DynamicObjectCollection entryEntity;
        if (coreBillEntryId == null) {
            return;
        }
        QFilter qFilter = new QFilter("goodsentryentity.salesorderdelivery", "=", (Object)Long.parseLong(coreBillEntryId.toString()));
        DynamicObject saleOrderId = BusinessDataServiceHelper.loadSingle((String)"ocpos_saleorder", (String)"id", (QFilter[])qFilter.toArray());
        if (saleOrderId == null) {
            return;
        }
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId.get("id"), (String)"ocpos_saleorder");
        DynamicObjectCollection parentItemEntry = saleOrder.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject parentItemEntryRow : parentItemEntry) {
            DynamicObjectCollection deliveryEntry = parentItemEntryRow.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject deliveryEntryRow : deliveryEntry) {
                if (!coreBillEntryId.equals(deliveryEntryRow.getPkValue())) continue;
                deliveryEntryRow.set("snmainfile", (Object)supplySerial);
                deliveryEntryRow.set("deliveryserialnumber", (Object)sn);
            }
        }
        SaveServiceHelper.update((DynamicObject)saleOrder);
        QFilter fFilter = new QFilter("entryentity.ribilldelivery.srcdeliveryentryid", "=", coreBillEntryId);
        DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((String)"ocococ_retailbill", (String)"entryentity,srcdeliveryentryid,ribilldelivery,deliveryserialnumber", (QFilter[])fFilter.toArray());
        if (retailBill != null && !CollectionUtils.isEmpty((Collection)(entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)retailBill, (String)"entryentity")))) {
            for (DynamicObject entryEntityRow : entryEntity) {
                DynamicObjectCollection riBillDelivery = entryEntityRow.getDynamicObjectCollection("ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)riBillDelivery)) continue;
                for (DynamicObject riBillDeliveryRow : riBillDelivery) {
                    if (!coreBillEntryId.equals(riBillDeliveryRow.getLong("srcdeliveryentryid"))) continue;
                    riBillDeliveryRow.set("deliveryserialnumber", (Object)supplySerial.getString("number"));
                }
            }
        }
        SaveServiceHelper.update((DynamicObject)retailBill);
        if (deliveryOrder != null) {
            AutoPushHelper.autoPushBill((Object)deliveryOrder.getPkValue(), (String)"ocococ_deliveryorder", (String)"im_saloutbill", (String)"audit");
        }
    }

    public String getExistId() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("itementry");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return "";
        }
        HashSet result = new HashSet(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection subEntryEntities = entryEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)subEntryEntities)) continue;
            Set subResult = subEntryEntities.stream().filter(x -> x.get("supplyserialid") != null).map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"supplyserialid")).collect(Collectors.toSet());
            result.addAll(subResult);
        }
        if (CollectionUtils.isEmpty(result)) {
            return "";
        }
        return StringUtils.join((Object[])result.toArray(), (String)",");
    }

    public String getLogisticsInfo() {
        return String.join((CharSequence)",", "entryentity", "deliveryserialnumber", "subentryentity", "supplyserialnumber", "comment", "iscorrect", "corebillentryid");
    }
}

