/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.deliveryorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class SerialEdit
extends AbstractBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String sign = (String)e.getFormShowParameter().getCustomParam("key");
        if (!(StringUtils.equals((CharSequence)sign, (CharSequence)"delivery") || StringUtils.equals((CharSequence)sign, (CharSequence)"return") || StringUtils.equals((CharSequence)sign, (CharSequence)"posreturn"))) {
            e.setCancelMessage("\u9875\u9762\u6253\u5f00\u53c2\u6570\u6709\u8bef\uff0c \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit snEdit = (TextEdit)this.getView().getControl("sn");
        snEdit.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Integer selectNumber = customParams.getOrDefault("selectnumber", 0);
        this.getModel().setValue("selectnumber", (Object)selectNumber);
        Integer serialNum = customParams.getOrDefault("serialnumber", 0);
        this.getModel().setValue("serialnumber", (Object)serialNum);
        Long goodIds = customParams.getOrDefault("goodsid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsid", (Object)goodIds);
        Long materialId = customParams.getOrDefault("materialid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"materialid", (Object)materialId);
        Long auxPtyId = customParams.getOrDefault("auxpty", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"auxpty", (Object)auxPtyId);
        Long stockOrgId = customParams.getOrDefault("stockorg", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"stockorg", (Object)stockOrgId);
        JSONArray sns = customParams.getOrDefault("entryentity", null);
        if (!CollectionUtils.isEmpty((Collection)sns)) {
            this.getModel().deleteEntryData("entryentity");
            int[] indexes = this.getModel().batchCreateNewEntryRow("entryentity", sns.size());
            int i = 0;
            for (int index : indexes) {
                JSONObject sn = (JSONObject)sns.get(i);
                String strSn = sn.getString("sn");
                this.getModel().setValue("sn", (Object)strSn, index);
                long snMainFileId = sn.getLongValue("supplyserialid");
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"supplyserialid", (Object)snMainFileId, (int)index);
                String comment = sn.getString("comment");
                this.getModel().setValue("comment", (Object)comment, index);
                ++i;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"sn")) {
            this.updateSerialNumber();
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "sn": {
                int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getPageCache().put("index_" + this.getView().getPageId(), String.valueOf(currIndex));
                this.beforeSnSelect();
                break;
            }
            case "btnok": {
                this.click();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String key = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"entryentity")) {
            this.updateSerialNumber();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List data;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocococ_snmainfile_query") && returnData instanceof List && !CollectionUtils.isEmpty((Collection)(data = (List)returnData))) {
            int currIndex = Integer.parseInt(this.getPageCache().get("index_" + this.getView().getPageId()));
            this.getModel().beginInit();
            int size = data.size();
            for (int i = 0; i < size; ++i) {
                JSONObject datum = (JSONObject)data.get(i);
                long snMainFileId = datum.getLongValue("snmainfile");
                this.getModel().setItemValueByID("supplyserialid", (Object)snMainFileId, currIndex);
                String sn = datum.getString("sn");
                this.getModel().setValue("sn", (Object)sn, currIndex);
                if (i >= size - 1) continue;
                currIndex = this.getModel().insertEntryRow("entryentity", currIndex + 1);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            this.getPageCache().remove("index_" + this.getView().getPageId());
            this.updateSerialNumber();
        }
    }

    private void beforeSnSelect() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materialid");
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"auxpty");
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"stockorg");
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        customParams.put("materialid", materialId);
        customParams.put("auxpty", auxPtyId);
        customParams.put("stockorg", stockOrgId);
        customParams.put("ismul", Boolean.TRUE);
        customParams.put("locksnmainfiles", this.getExistId());
        customParams.put("snmainfile", this.getExpect());
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("key");
        customParams.put("key", sign);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocococ_snmainfile_query", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocococ_snmainfile_query"));
        this.getView().showForm(parameter);
    }

    private void click() {
        int serialNumber;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int selectNumber = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"selectnumber");
        if (selectNumber != (serialNumber = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"serialnumber"))) {
            NotificationUtil.showDefaultTipNotify((String)"\u5546\u54c1\u6570\u91cf\u4e0e\u5df2\u9009\u62e9\u5e8f\u5217\u53f7\u6570\u91cf\u4e0d\u540c\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (IFormView)this.getView());
            return;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u7ef4\u62a4\u5e8f\u5217\u53f7\u660e\u7ec6\u3002", (IFormView)this.getView());
            return;
        }
        JSONArray data = new JSONArray();
        for (DynamicObject entryEntity : entryEntities) {
            long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"supplyserialid");
            if (snMainFileId <= 0L) continue;
            JSONObject datum = new JSONObject();
            datum.put("supplyserialid", (Object)snMainFileId);
            String sn = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"sn");
            datum.put("sn", (Object)sn);
            data.add((Object)datum);
        }
        this.getView().returnDataToParent((Object)data);
        this.getView().close();
    }

    private void updateSerialNumber() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int size = Math.toIntExact(entryEntity.stream().filter(x -> StringUtils.isNotBlank((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"sn"))).count());
        this.getModel().setValue("serialnumber", (Object)size);
    }

    public String getExistId() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set existIds = entryEntity.stream().filter(x -> DynamicObjectUtils.get((DynamicObject)x, (String)"supplyserialid") != null).map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"supplyserialid")).collect(Collectors.toSet());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray parentExitIds = customParams.getOrDefault("locksnmainfiles", null);
        if (!CollectionUtils.isEmpty((Collection)parentExitIds)) {
            existIds.addAll(parentExitIds.stream().map(x -> ((JSONObject)x).getLongValue("supplyserialid")).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(existIds)) {
            return "";
        }
        return StringUtils.join((Object[])existIds.toArray(), (String)",");
    }

    private String getExpect() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray curExitIds = customParams.getOrDefault("entryentity", null);
        if (!CollectionUtils.isEmpty((Collection)curExitIds)) {
            return curExitIds.stream().map(x -> String.valueOf(((JSONObject)x).getLongValue("supplyserialid"))).collect(Collectors.joining(","));
        }
        return "";
    }
}

