/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocococ.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ReturnOrder2DeliveryOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String OP_draft = "draft";
    private static final String OcBsocReturnorder_status_NULL = "";
    private static final String OcBsocReturnorder_pushstatus_DELIVERYORDER = "A";

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] srcDataEntities;
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("ocbsoc_returnorder".equals(srcSubMainType.getName()) && (srcDataEntities = e.getSrcDataEntities()) != null && srcDataEntities.length > 0) {
            ArrayList<Object> pkArray = new ArrayList<Object>(srcDataEntities.length);
            for (DynamicObject srcDataEntity : srcDataEntities) {
                pkArray.add(srcDataEntity.getPkValue());
            }
            srcDataEntities = BusinessDataServiceHelper.load((Object[])pkArray.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocbsoc_returnorder"));
            if (OP_draft.equalsIgnoreCase(opType) || "save".equalsIgnoreCase(opType)) {
                this.onDeliveryOrderSaveWriteBack(srcDataEntities);
            } else if ("delete".equalsIgnoreCase(opType)) {
                this.onDeliveryOrderDeleteWriteBack(srcDataEntities);
            }
        }
    }

    private void onDeliveryOrderSaveWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            if (!StringUtils.isEmpty((String)returnOrder.getString("pushstatus"))) continue;
            returnOrder.set("pushstatus", (Object)OcBsocReturnorder_pushstatus_DELIVERYORDER);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.save((DynamicObject[])updateOrders.toArray(new DynamicObject[updateOrders.size()]));
        }
    }

    private void onDeliveryOrderDeleteWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            DynamicObjectCollection itemEntrys = returnOrder.getDynamicObjectCollection("itementry");
            boolean isNoReturn = true;
            for (DynamicObject itemEntry : itemEntrys) {
                if (BigDecimal.ZERO.compareTo(itemEntry.getBigDecimal("joindelireturnbaseqty")) == 0) continue;
                isNoReturn = false;
                break;
            }
            if (!isNoReturn || !OcBsocReturnorder_pushstatus_DELIVERYORDER.equals(returnOrder.getString("pushstatus"))) continue;
            returnOrder.set("pushstatus", (Object)OcBsocReturnorder_status_NULL);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.update((DynamicObject[])updateOrders.toArray(new DynamicObject[updateOrders.size()]));
        }
    }
}

