/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.occ.ocolmm.business.wechat.WeChatTool;
import org.apache.commons.lang3.StringUtils;

public class LiveList
extends AbstractFormPlugin {
    private static final String TBCREATEURL = "tbcreateurl";
    private static final String GETLIVELIST = "getlivelist";
    private static final String ENTRYENTITY = "entryentity";
    private static final String APPID = "wx5008f0da90098f1c";
    private static final String SECRET = "419f4233549dee5754b464c41c374149";
    private static final int START = 0;
    private static final int LIMIT = 20;
    private static final String ROOMID = "roomid";
    private static final String ROOMNAME = "roomname";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String STATUS = "status";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)TBCREATEURL)) {
            this.createLiveUrl();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)GETLIVELIST, (CharSequence)args.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getLiveList();
        }
    }

    public void getLiveList() {
        JSONObject returnJson = new JSONObject();
        try {
            returnJson = WeChatTool.getMiniProgramLiveList((String)APPID, (String)SECRET, (int)0, (int)20);
            JSONArray room_info = returnJson.getJSONArray("room_info");
            if (room_info.isEmpty() || room_info.size() < 1) {
                this.getView().showErrMessage("\u6682\u65e0\u76f4\u64ad\u6570\u636e", null);
            } else {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, room_info.size());
                for (int i = 0; i < room_info.size(); ++i) {
                    JSONObject roomItem = room_info.getJSONObject(i);
                    roomItem.getString("name");
                    roomItem.getString("cover_img");
                    roomItem.getDate("start_time");
                    roomItem.getDate("end_time");
                    int live_status = roomItem.getIntValue("live_status");
                    String livestate = "";
                    switch (live_status) {
                        case 101: {
                            livestate = "\u76f4\u64ad\u4e2d";
                            break;
                        }
                        case 102: {
                            livestate = "\u672a\u5f00\u59cb";
                            break;
                        }
                        case 103: {
                            livestate = "\u5df2\u7ed3\u675f";
                            break;
                        }
                        case 104: {
                            livestate = "\u7981\u64ad";
                            break;
                        }
                        case 105: {
                            livestate = "\u6682\u505c";
                            break;
                        }
                        case 106: {
                            livestate = "\u5f02\u5e38";
                            break;
                        }
                        case 107: {
                            livestate = "\u5df2\u8fc7\u671f";
                            break;
                        }
                    }
                    this.getModel().setValue(ROOMID, (Object)roomItem.getLong(ROOMID), i);
                    this.getModel().setValue(ROOMNAME, (Object)roomItem.getString("name"), i);
                    this.getModel().setValue(STARTTIME, (Object)roomItem.getDate("start_time"), i);
                    this.getModel().setValue(ENDTIME, (Object)roomItem.getDate("end_time"), i);
                    this.getModel().setValue(STATUS, (Object)livestate, i);
                }
                this.getView().updateView(ENTRYENTITY);
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), null);
        }
    }

    public void createLiveUrl() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] rowIndexs = entryGrid.getSelectRows();
        if (rowIndexs.length > 1) {
            this.getView().showErrMessage("\u53ea\u80fd\u9009\u5219\u4e00\u884c\u6570\u636e\u751f\u6210\u94fe\u63a5", null);
        } else if (rowIndexs.length == 0) {
            this.getView().showErrMessage("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u751f\u6210\u94fe\u63a5", null);
        } else {
            int LiveDY = (Integer)this.getModel().getValue(ROOMID, rowIndexs[0]);
            if (LiveDY > 0) {
                String url = String.format("\u76f4\u64ad\u95f4id\u662f%s", LiveDY);
                this.getView().showMessage(url);
            }
        }
    }
}

