/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class Orders2DeliveryordWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String JOINDELIBASEQTY = "joindelibaseqty";
    private static final String BASEUNITQTY = "baseunitqty";
    private static final String OCOLMM_ORDERSENTRY = "ocolmm_ordersentry";
    private static final String ORDERSTATUS = "orderstatus";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String opType = this.getOpType();
        if ("ocolmm_orders".equals(e.getSrcMainType().getName()) && "audit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add(JOINDELIBASEQTY);
            e.getFieldKeys().add(BASEUNITQTY);
        } else if ("ocolmm_orders".equals(e.getSrcMainType().getName()) && "unaudit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add(JOINDELIBASEQTY);
            e.getFieldKeys().add(BASEUNITQTY);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("ocolmm_orders".equals(srcSubMainType.getName())) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
            if ("audit".equalsIgnoreCase(opType)) {
                for (DynamicObject srcDataEntity : srcDataEntities) {
                    BigDecimal joindelibaseqtysum;
                    DynamicObjectCollection dynamicObjectCollection = srcDataEntity.getDynamicObjectCollection(OCOLMM_ORDERSENTRY);
                    BigDecimal baseunitqtysum = dynamicObjectCollection.stream().map(p -> p.getBigDecimal(BASEUNITQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (baseunitqtysum.compareTo(joindelibaseqtysum = dynamicObjectCollection.stream().map(p -> p.getBigDecimal(JOINDELIBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
                        srcDataEntity.set(ORDERSTATUS, (Object)"4");
                    } else {
                        srcDataEntity.set(ORDERSTATUS, (Object)"5");
                    }
                    bills.add(srcDataEntity);
                }
            } else if ("unaudit".equalsIgnoreCase(opType)) {
                for (DynamicObject srcDataEntity : srcDataEntities) {
                    DynamicObjectCollection dynamicObjectCollection = srcDataEntity.getDynamicObjectCollection(OCOLMM_ORDERSENTRY);
                    BigDecimal joindelibaseqtysum = dynamicObjectCollection.stream().map(p -> p.getBigDecimal(JOINDELIBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (joindelibaseqtysum.compareTo(BigDecimal.ZERO) > 0) {
                        srcDataEntity.set(ORDERSTATUS, (Object)"4");
                    } else {
                        srcDataEntity.set(ORDERSTATUS, (Object)"3");
                    }
                    bills.add(srcDataEntity);
                }
            }
            if (bills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
            }
        }
    }
}

