/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocolmm.common.util.DateUtil;
import org.apache.commons.lang.StringUtils;

public class BranchSalesEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.queryData("C", "A");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        this.queryData(this.getModel().getValue("datarange").toString(), this.getModel().getValue("paystatus").toString());
    }

    private void queryData(String datarange, String paystatus) {
        DynamicObjectCollection mallDYObject = this.getModel().getDataEntity().getDynamicObjectCollection("mall");
        ArrayList<Long> mallList = new ArrayList<Long>();
        for (Object mall : mallDYObject) {
            mallList.add(Long.parseLong(mall.getDynamicObject("fbasedataid").getPkValue().toString()));
        }
        QFilter qFilter = new QFilter("createtime", "<=", (Object)TimeServiceHelper.now());
        switch (datarange) {
            case "A": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getTodayWee());
                break;
            }
            case "B": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "C": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "E": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
        }
        DynamicObjectCollection dyNewMemberCount = QueryServiceHelper.query((String)"ocdbd_user", (String)"id", (QFilter[])qFilter.toArray());
        int newmembercount = dyNewMemberCount.size();
        if (!mallList.isEmpty()) {
            qFilter.and("mallid", "in", mallList);
        }
        qFilter.and("orderstatus", "!=", (Object)"8");
        qFilter.and("cancelstatus", "=", (Object)"A");
        if (StringUtils.equals((String)paystatus, (String)"B")) {
            qFilter.and("orderstatus", "!=", (Object)"1");
        }
        DynamicObjectCollection dyorderscount = QueryServiceHelper.query((String)"ocolmm_orders", (String)"id", (QFilter[])qFilter.toArray());
        int ordersnumber = dyorderscount.size();
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"ocolmm_orders", (String)this.getSelectFild(), (QFilter[])qFilter.toArray());
        BigDecimal saleamount = dyc.stream().map(p -> p.getBigDecimal("productamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        int perticketsales = 0;
        if (ordersnumber > 0) {
            perticketsales = saleamount.divide(new BigDecimal(ordersnumber), 2, 4).intValue();
        }
        Label saleamountlabel = (Label)this.getView().getControl("saleamount");
        Label salenumberlabel = (Label)this.getView().getControl("salenumber");
        Label perticketsaleslabel = (Label)this.getView().getControl("perticketsales");
        Label newmembercountlabel = (Label)this.getView().getControl("newmembercount");
        if (ObjectUtils.isEmpty((Object)dyc)) {
            String text = Integer.toString(0);
            saleamountlabel.setText(text);
            salenumberlabel.setText(text);
            perticketsaleslabel.setText(text);
            newmembercountlabel.setText(text);
        } else {
            saleamountlabel.setText(Integer.toString(saleamount.intValue()));
            salenumberlabel.setText(Integer.toString(ordersnumber));
            perticketsaleslabel.setText(Integer.toString(perticketsales));
            newmembercountlabel.setText(Integer.toString(newmembercount));
        }
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "id", "ocolmm_ordersentry.productamount as productamount");
    }
}

