/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.formplugin.home;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocolmm.common.util.CommonUtil;
import kd.occ.ocolmm.common.util.DateUtil;

public class SalesRankingList
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        String datarange = param.get("datarange").toString();
        String orderby = param.get("orderby").toString();
        List mallList = CommonUtil.castList(param.get("mall"), Long.class);
        QFilter qFilter = new QFilter("ocolmm_ordersentry.isshipping", "=", (Object)Boolean.FALSE);
        switch (datarange) {
            case "A": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getTodayWee());
                break;
            }
            case "B": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfWeek((Date)TimeServiceHelper.today()));
                break;
            }
            case "C": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfMonth((Date)TimeServiceHelper.today()));
                break;
            }
            case "D": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getBeforeMonth((int)3));
                break;
            }
            case "E": {
                qFilter.and("createtime", ">=", (Object)DateUtil.getFirstDayOfYear((Date)TimeServiceHelper.today()));
                break;
            }
        }
        if (!mallList.isEmpty()) {
            qFilter.and("mallid", "in", (Object)mallList);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ocolmm_orders", (String)this.getSelectFild(), (QFilter[])qFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"itemid"});
        groupbyDataSet.sum("productamount");
        groupbyDataSet.sum("qty");
        DataSet dataSet1 = groupbyDataSet.finish();
        DataSet top = null;
        switch (orderby) {
            case "A": {
                top = dataSet1.orderBy(new String[]{"productamount desc"}).top(10);
                break;
            }
            case "B": {
                top = dataSet1.orderBy(new String[]{"qty desc"}).top(10);
                break;
            }
        }
        DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(top);
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("item", (Object)dynamicObject.getLong("itemid"), index);
            Long classId = PosItemUtil.queryItemClass((Object)dynamicObject.getLong("itemid"));
            if (classId.equals(0L)) {
                this.getModel().setValue("itemclass", null, index);
            } else {
                this.getModel().setValue("itemclass", (Object)BusinessDataServiceHelper.loadSingle((Object)classId, (String)"mdr_item_class"), index);
            }
            this.getModel().setValue("salesvolumes", (Object)dynamicObject.getLong("qty"), index);
            this.getModel().setValue("salesamount", (Object)dynamicObject.getLong("productamount"), index);
            this.getModel().setValue("ranking", (Object)(index + 1), index);
        }
        this.getView().updateView();
    }

    private String getSelectFild() {
        return String.join((CharSequence)",", "ocolmm_ordersentry.itemid as itemid", "ocolmm_ordersentry.qty as qty", "ocolmm_ordersentry.productamount as productamount");
    }
}

