/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.opplugin.order;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocolmm.business.pay.PayHelper;
import kd.occ.ocolmm.common.util.DateUtil;

public class OrderRefundTask
extends AbstractTask {
    private static final String P_ocolmm_receipts = "ocolmm_receipts";
    private static final String F_isreceipt = "isreceipt";
    private static final String F_outtradeno = "outtradeno";
    private static final String F_payconfigid = "payconfigid";
    private static final String F_paytypeid = "paytypeid";
    private static final Log logger = LogFactory.getLog(OrderRefundTask.class);

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        if (logger.isErrorEnabled()) {
            logger.error("\u7535\u5546\u9000\u6b3e\u5355\u81ea\u52a8\u9000\u6b3e\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u6267\u884c\uff01");
        }
        QFilter qf = new QFilter("refundstatus", "=", (Object)"1");
        QFilter qf1 = new QFilter("billstatus", "=", (Object)"C");
        QFilter[] qfarr = new QFilter[]{qf, qf1};
        if (logger.isErrorEnabled()) {
            logger.error("\u83b7\u53d6\u5f85\u9000\u6b3e\u7684\u7535\u5546\u9000\u6b3e\u5355\uff01");
        }
        DynamicObject[] dycoll = BusinessDataServiceHelper.load((String)"ocolmm_refundbill", (String)this.RefundQFilter(), (QFilter[])qfarr);
        if (logger.isErrorEnabled()) {
            logger.error("\u5f85\u9000\u6b3e\u5355\u636e\u6570\u91cf\uff1a\uff01" + dycoll.length);
        }
        if (dycoll.length > 0) {
            for (int i = 0; i < dycoll.length; ++i) {
                DynamicObject dyOrders;
                DynamicObject dyReceipts;
                long orderId = ((DynamicObject)dycoll[i].get("orderid")).getLong("id");
                long refundId = dycoll[i].getLong("id");
                long aftersalesId = ((DynamicObject)dycoll[i].get("aftersalesid")).getLong("id");
                QFilter qfAftersales = new QFilter("id", "=", (Object)aftersalesId);
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u5f85\u9000\u6b3e\u7684\u552e\u540e\u5355\uff01");
                }
                DynamicObject dyaftersales = BusinessDataServiceHelper.loadSingle((Object)aftersalesId, (String)"ocolmm_aftersales");
                QFilter qfReceipts = new QFilter("orderid", "=", (Object)orderId);
                qfReceipts.and(F_isreceipt, "=", (Object)Boolean.TRUE);
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u5f85\u9000\u6b3e\u7684\u8d22\u52a1\u6d41\u6c34\uff01");
                }
                if (ObjectUtils.isEmpty((Object)(dyReceipts = BusinessDataServiceHelper.loadSingle((String)P_ocolmm_receipts, (String)this.ReceiptsQFilter(), (QFilter[])qfReceipts.toArray())))) continue;
                Long payTypeId = ((DynamicObject)dyReceipts.get(F_paytypeid)).getLong("id");
                Long payConfigId = ((DynamicObject)dyReceipts.get(F_payconfigid)).getLong("id");
                String outtradeno = dyReceipts.getString(F_outtradeno);
                Long realrefundamount = 0L;
                DynamicObjectCollection asrefundentryDYCOLL = dyaftersales.getDynamicObjectCollection("ocolmm_asrefundentry");
                for (DynamicObject entry : asrefundentryDYCOLL) {
                    Long collectiontypeID = ((DynamicObject)entry.get("collectiontype")).getLong("id");
                    if (Long.compare(payTypeId, collectiontypeID) != 0) continue;
                    realrefundamount = entry.getBigDecimal("realrefundamount").multiply(new BigDecimal(100)).longValue();
                }
                HashMap<String, String> refundData = new HashMap<String, String>();
                long operatorId = Long.parseLong(RequestContext.get().getUserId());
                QFilter orderQF = new QFilter("id", "=", (Object)orderId);
                if (logger.isErrorEnabled()) {
                    logger.error("\u83b7\u53d6\u5f85\u9000\u6b3e\u7684\u8ba2\u5355\uff01");
                }
                if (!ObjectUtils.isEmpty((Object)(dyOrders = BusinessDataServiceHelper.loadSingle((String)"ocolmm_orders", (String)"billsettlecurrid,billno,orderstatus,memberid,apamount", (QFilter[])orderQF.toArray())))) {
                    OperationResult result;
                    Long fid = dyOrders.getLong("id");
                    String billno = dyOrders.getString("billno");
                    Long memberId = ((DynamicObject)dyOrders.get("memberid")).getLong("id");
                    Long billsettlecurrId = ((DynamicObject)dyOrders.get("billsettlecurrid")).getLong("id");
                    long payAmount = dyOrders.getBigDecimal("apamount").multiply(new BigDecimal(100)).longValue();
                    String operaTime = DateUtil.getFormatterNewDate((String)"yyyyMMddHHmmss");
                    refundData.put("billNo", String.valueOf(orderId));
                    refundData.put("operatorId", String.valueOf(operatorId));
                    refundData.put("operaTime", operaTime);
                    refundData.put("total_fee", String.valueOf(realrefundamount));
                    refundData.put("refund_fee", String.valueOf(realrefundamount));
                    refundData.put("transaction_id", outtradeno);
                    refundData.put("out_refund_no", operaTime);
                    if (logger.isErrorEnabled()) {
                        logger.error("\u5f00\u59cb\u9000\u6b3e\uff01");
                    }
                    logger.error(String.format("\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570:payConfigId:%s,payModeId:%s,refundData:%s", payConfigId, payTypeId, refundData.toString()));
                    JSONObject retRefundDate = new JSONObject();
                    Map payConfig = PayHelper.getPayConfig((long)payConfigId, (long)payTypeId);
                    logger.error("payConfig:" + payConfig);
                    if (payConfig.size() > 0) {
                        try {
                            retRefundDate = PayHelper.tradeRefund((long)payTypeId, (Map)payConfig, refundData);
                            logger.error("\u9000\u6b3e\u7ed3\u679c:" + JSONUtils.toString((Object)retRefundDate));
                            logger.info("\u9000\u6b3e\u7ed3\u679c:" + JSONUtils.toString((Object)retRefundDate));
                        }
                        catch (IOException e) {
                            logger.error("\u9000\u6b3e\u62a5\u9519" + e.getMessage());
                        }
                    } else {
                        logger.error("payConfig\u6570\u636e\u4e0d\u5b58\u5728");
                        retRefundDate.put("pay_status", (Object)"");
                    }
                    logger.info("\u5f00\u59cb\u53cd\u5199\u6570\u636e");
                    logger.error("\u5f00\u59cb\u53cd\u5199\u6570\u636e");
                    if (!retRefundDate.getString("pay_status").equals(TradeStatus.SUCCESS.toString())) continue;
                    Date newdate = new Date();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)P_ocolmm_receipts);
                    DynamicObject receipts = new DynamicObject((DynamicObjectType)entityType);
                    receipts.set("billNo", (Object)operaTime);
                    receipts.set("billStatus", (Object)"C");
                    receipts.set("memberid", (Object)memberId);
                    receipts.set("currency", (Object)billsettlecurrId);
                    receipts.set("payamount", (Object)retRefundDate.getBigDecimal("refund_fee").divide(new BigDecimal(100), 2, 4));
                    receipts.set("paydatetime", (Object)newdate);
                    receipts.set(F_paytypeid, (Object)payTypeId);
                    receipts.set(F_isreceipt, (Object)0);
                    receipts.set(F_outtradeno, (Object)retRefundDate.getString("refund_id"));
                    receipts.set("orderno", (Object)billno);
                    receipts.set("orderid", (Object)fid);
                    receipts.set(F_payconfigid, (Object)payConfigId);
                    if (logger.isErrorEnabled()) {
                        logger.error("\u521b\u5efa\u8d22\u52a1\u6d41\u6c34\uff01");
                    }
                    if (!(result = SaveServiceHelper.saveOperate((String)P_ocolmm_receipts, (DynamicObject[])new DynamicObject[]{receipts}, (OperateOption)OperateOption.create())).isSuccess() && logger.isErrorEnabled()) {
                        logger.error("\u8d22\u52a1\u6d41\u6c34\u521b\u5efa\u5931\u8d25\uff01");
                    }
                    DynamicObject dyrefund = BusinessDataServiceHelper.loadSingle((Object)refundId, (String)"ocolmm_refundbill");
                    dyrefund.set("refundstatus", (Object)3);
                    dyrefund.set(F_outtradeno, (Object)retRefundDate.getString("refund_id"));
                    dyrefund.set(F_paytypeid, (Object)payTypeId);
                    OperationResult refundResult = SaveServiceHelper.saveOperate((String)"ocolmm_refundbill", (DynamicObject[])new DynamicObject[]{dyrefund});
                    if (!refundResult.isSuccess() && logger.isErrorEnabled()) {
                        logger.error("\u7535\u5546\u9000\u6b3e\u5355\u53cd\u5199\u5931\u8d25\uff01\u9000\u6b3e\u5355id\uff1a" + refundId);
                    }
                    dyOrders.set("orderstatus", (Object)8);
                    OperationResult ordersResult = SaveServiceHelper.saveOperate((String)"ocolmm_orders", (DynamicObject[])new DynamicObject[]{dyOrders});
                    if (!ordersResult.isSuccess() && logger.isErrorEnabled()) {
                        logger.error("\u8ba2\u5355\u53cd\u5199\u5931\u8d25\uff01\u8ba2\u5355id\uff1a" + orderId);
                    }
                    dyaftersales.set("billstatus", (Object)"G");
                    OperationResult aftersalesResult = SaveServiceHelper.saveOperate((String)"ocolmm_aftersales", (DynamicObject[])new DynamicObject[]{dyaftersales});
                    if (aftersalesResult.isSuccess() || !logger.isErrorEnabled()) continue;
                    logger.error("\u552e\u540e\u5355\u53cd\u5199\u5931\u8d25\uff01\u552e\u540e\u5355id\uff1a" + aftersalesId);
                    continue;
                }
                DynamicObject dyrefund = BusinessDataServiceHelper.loadSingle((Object)refundId, (String)"ocolmm_refundbill");
                dyrefund.set("refundstatus", (Object)2);
                OperationResult refundResult = SaveServiceHelper.saveOperate((String)"ocolmm_refundbill", (DynamicObject[])new DynamicObject[]{dyrefund});
                if (refundResult.isSuccess() || !logger.isErrorEnabled()) continue;
                logger.error("\u7535\u5546\u9000\u6b3e\u5355\u53cd\u5199\u5931\u8d25\uff01\u9000\u6b3e\u5355id\uff1a" + refundId);
            }
        }
    }

    private String ReceiptsQFilter() {
        return String.join((CharSequence)",", F_paytypeid, F_payconfigid, F_outtradeno);
    }

    private String RefundQFilter() {
        return String.join((CharSequence)",", "orderid", "refundstatus", F_outtradeno, "paydatetime", F_paytypeid, "aftersalesid");
    }

    private String AftersalesQFilter() {
        return String.join((CharSequence)",", "billstatus");
    }
}

