/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.common.chart;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocolmm.common.util.DateUtil;

public class OrdersGrowthChartHelper {
    private static Log Logger = LogFactory.getLog(OrdersGrowthChartHelper.class);

    private List<BigDecimal> contructValue2Data(int reduceDay, String queryType) {
        ArrayList<BigDecimal> valueData = new ArrayList<BigDecimal>();
        String begindate = DateUtil.getSpecifyDay(reduceDay);
        String enddate = DateUtil.getNowDay();
        QFilter[] filterList = this.getQFilterList(begindate, enddate);
        ORM orm = ORM.create();
        DataSet set = orm.queryDataSet(this.getClass().getName(), this.getForm(), this.getSelectFild(queryType), filterList);
        switch (queryType) {
            case "A": {
                set = set.orderBy(new String[]{"x_index"}).groupBy(new String[]{"x_index"}).count("ordercount").finish().select("x_index,ordercount,TO_DATE(x_index,'yyyy-MM-dd') as x_date").orderBy(new String[]{"x_date"});
                break;
            }
            case "B": {
                set = set.orderBy(new String[]{"x_index"}).groupBy(new String[]{"x_index"}).sum("productamount").finish().select("x_index,productamount,TO_DATE(x_index,'yyyy-MM-dd') as x_date").orderBy(new String[]{"x_date"});
                break;
            }
        }
        for (Row row : set) {
            Date startTime;
            String date = row.getString("x_index");
            try {
                startTime = new SimpleDateFormat("yyyy-MM-dd").parse(date);
            }
            catch (Exception e) {
                Logger.error("contructValue2Data\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"OrdersGrowthChartHelper_1", (String)"occ-ocolmm-common", (Object[])new Object[]{e.getMessage()}));
            }
            LocalDate startdate = startTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int day = startdate.getDayOfMonth();
            LocalDate nowDate = LocalDate.now();
            LocalDate dt2 = nowDate.minusDays(reduceDay);
            long daysDiff = ChronoUnit.DAYS.between(dt2, startdate);
            int listcount = valueData.size();
            long SpecifyDay = 0L;
            SpecifyDay = reduceDay > 0 ? daysDiff - (long)listcount : (long)(day - listcount);
            if ((long)listcount < daysDiff) {
                int i = 0;
                while ((long)i < SpecifyDay) {
                    long daycount = SpecifyDay - 1L;
                    BigDecimal ordercount = BigDecimal.ZERO;
                    switch (queryType) {
                        case "A": {
                            ordercount = (long)i == daycount ? row.getBigDecimal("ordercount") : new BigDecimal(0);
                            break;
                        }
                        case "B": {
                            ordercount = (long)i == daycount ? (row.getBigDecimal("productamount") == null ? new BigDecimal(0) : row.getBigDecimal("productamount")) : new BigDecimal(0);
                            break;
                        }
                    }
                    valueData.add(ordercount);
                    ++i;
                }
                continue;
            }
            valueData.add(new BigDecimal(0));
        }
        if (reduceDay > valueData.size()) {
            int day = reduceDay - valueData.size();
            for (int i = 0; i < day; ++i) {
                valueData.add(new BigDecimal(0));
            }
        }
        return valueData;
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.category) : pointLineChart.createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.TRUE);
        axisTick.put("grid", Position.left);
        axis.setPropValue("axisTick", (Object)axisTick);
        return axis;
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        Label label = new Label();
        label.setShow(true);
        label.setColor("#000000");
        expireSeries.setLabel(label);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.value) : pointLineChart.createYAxis(name, AxisType.value);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    public void drawChart(PointLineChart pointLineChart, String queryType) {
        boolean isX = true;
        Axis categoryAxis = this.createCategoryAxis(pointLineChart, "\u65e5", isX);
        HashMap nametextstyle = Maps.newHashMap();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", "18");
        categoryAxis.setPropValue("nameTextStyle", (Object)nametextstyle);
        categoryAxis.setPropValue("nameLocation", (Object)"end");
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap axislabel = Maps.newHashMap();
        HashMap textstyle = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle);
        categoryAxis.setPropValue("axisLabel", (Object)axislabel);
        Axis ValueAxis = this.createValueAxis(pointLineChart, "\u5355", !isX);
        switch (queryType) {
            case "A": {
                ValueAxis = this.createValueAxis(pointLineChart, "\u5355", !isX);
                this.createLineSeries(pointLineChart, "", this.contructValue2Data(30, queryType), "red");
                break;
            }
            case "B": {
                ValueAxis = this.createValueAxis(pointLineChart, "\u9500\u552e\u989d\uff08\u5143\uff09", !isX);
                this.createLineSeries(pointLineChart, "", this.contructValue2Data(30, queryType), "red");
                break;
            }
        }
        HashMap yAxisnametextstyle = Maps.newHashMap();
        yAxisnametextstyle.put("color", "#000000");
        yAxisnametextstyle.put("fontSize", "18");
        ValueAxis.setPropValue("nameTextStyle", (Object)yAxisnametextstyle);
        categoryAxis.setCategorys(DateUtil.contructCatetoryData(30));
        pointLineChart.setMargin(Position.right, "80px");
        pointLineChart.setMargin(Position.top, "40px");
        pointLineChart.setMargin(Position.left, "80px");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        HashMap legendtextstyle = Maps.newHashMap();
        legendtextstyle.put("fontSize", "18");
        legendtextstyle.put("color", "#000000");
        pointLineChart.setLegendPropValue("textStyle", (Object)legendtextstyle);
        pointLineChart.refresh();
    }

    protected String getForm() {
        return "ocolmm_orders";
    }

    protected QFilter[] getQFilterList(String begindate, String enddate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = simpleDateFormat.parse(begindate);
            endTime = simpleDateFormat.parse(enddate);
        }
        catch (Exception e) {
            Logger.error("getQFilterList\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"OrdersGrowthChartHelper", (String)"occ-ocolmm-common", (Object[])new Object[0]));
        }
        QFilter qcreatetime = new QFilter("createtime", ">", (Object)startTime);
        QFilter qendtime = new QFilter("createtime", "<", (Object)endTime);
        return new QFilter[]{qcreatetime, qendtime};
    }

    private String getSelectFild(String queryType) {
        String ret = "";
        switch (queryType) {
            case "A": {
                ret = ret + String.join((CharSequence)",", "id", "CONCAT(CONCAT(YEAR(createtime),'-'),CONCAT(CONCAT(MONTH(createtime),'-'),DAYOFMONTH(createtime))) as x_index");
                break;
            }
            case "B": {
                ret = ret + String.join((CharSequence)",", "ocolmm_ordersentry.productamount as productamount", "CONCAT(CONCAT(YEAR(createtime),'-'),CONCAT(CONCAT(MONTH(createtime),'-'),DAYOFMONTH(createtime))) as x_index");
                break;
            }
        }
        return ret;
    }
}

