/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.common.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtil {
    public static String getFormatterNewDate(String formatterstr) {
        LocalDateTime date = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatterstr);
        return date.format(formatter);
    }

    public static Date getTodayWee() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        return date;
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek());
        return gregorianCalendar.getTime();
    }

    public static Date getFirstDayOfYear(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(6, 1);
        return gregorianCalendar.getTime();
    }

    public static Date getBeforeMonth(int monty) {
        Calendar c = Calendar.getInstance();
        c.add(2, -monty);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        return gregorianCalendar.getTime();
    }

    public static String getFirstay() {
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime firstday = date.with(TemporalAdjusters.firstDayOfMonth());
        firstday = firstday.with(LocalTime.MIN);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return firstday.format(formatter);
    }

    public static String getLastDay() {
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        lastDay = lastDay.with(LocalTime.MAX);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return lastDay.format(formatter);
    }

    public static String getNowDay() {
        LocalDateTime date = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return date.format(formatter);
    }

    public static String getSpecifyDay(int reduceDay) {
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime dt2 = date.minusDays(reduceDay);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dt2.format(formatter);
    }

    public static List<String> contructCatetoryData() {
        Calendar cal = Calendar.getInstance();
        int maxDay = cal.getActualMaximum(5);
        ArrayList<String> categoryData = new ArrayList<String>(maxDay);
        for (int i = 1; i <= maxDay; ++i) {
            categoryData.add(String.valueOf(i));
        }
        return categoryData;
    }

    public static List<String> contructCatetoryData(int reduceDay) {
        ArrayList<String> categoryData = new ArrayList<String>(reduceDay);
        LocalDateTime date = LocalDateTime.now();
        for (int i = 29; i >= 0; --i) {
            LocalDateTime dt2 = date.minusDays(i);
            categoryData.add(String.valueOf(dt2.getDayOfMonth()));
        }
        return categoryData;
    }
}

