/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolmm.business.pay;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.util.WechatPayUtil;
import kd.occ.ocbase.common.pay.wechat.vo.RefundRequestParam;
import kd.occ.ocolmm.common.enums.PayModeEnum;

public class PayProcessor {
    private static Log logger = LogFactory.getLog(PayProcessor.class);

    public Map<String, String> getPayConfig(long payConfigId, long payModeId) {
        QFilter filter = new QFilter("id", "=", (Object)payConfigId);
        filter.and(new QFilter("entryentity.channel.id", "=", (Object)payModeId));
        DynamicObjectCollection payChannelDatas = QueryServiceHelper.query((String)"ocdbd_payconfigs", (String)"id,entryentity.id,entryentity.subentryentity.id,entryentity.subentryentity.paramkey,entryentity.subentryentity.paramvalue,entryentity.channel.id", (QFilter[])new QFilter[]{filter});
        HashMap<String, String> payConfig = new HashMap<String, String>(8);
        if (!CollectionUtils.isEmpty((Collection)payChannelDatas)) {
            for (DynamicObject payChannelData : payChannelDatas) {
                payConfig.put(payChannelData.getString("entryentity.subentryentity.paramkey"), payChannelData.getString("entryentity.subentryentity.paramvalue"));
            }
        } else {
            logger.info(String.format("getPayConfig\u65b9\u6cd5\uff0c\u6ca1\u6709\u83b7\u5f97\u5230\u6570\u636e\uff0cpayConfigId:%s,payModeId:%s", payConfigId, payModeId));
        }
        return payConfig;
    }

    public JSONObject tradeRefund(long payModeId, Map<String, String> payConfig, HashMap<String, String> refundData) {
        JSONObject refundResult = new JSONObject();
        String ayWayType = new PayProcessor().getPayWayType(payModeId);
        if (ayWayType.equals(PayModeEnum.WeChatPayType.toString())) {
            JSONObject refundResponse = this.WeChatPayRefund(payConfig, refundData);
            logger.info("refundResponse:" + refundResponse.toJSONString());
            if (refundResponse.getString("pay_status").equals(TradeStatus.SUCCESS.toString())) {
                refundResult.put("pay_status", (Object)TradeStatus.SUCCESS);
                refundResult.put("refund_fee", (Object)refundResponse.getString("refund_fee"));
                refundResult.put("transaction_id", (Object)refundResponse.getString("transaction_id"));
                refundResult.put("out_refund_no", (Object)refundResponse.getString("out_refund_no"));
                refundResult.put("refund_id", (Object)refundResponse.getString("refund_id"));
                refundResult.put("opera_time", (Object)refundData.get("operaTime"));
            } else {
                refundResult.put("pay_status", (Object)TradeStatus.FAILED);
            }
        }
        return refundResult;
    }

    public String getPayWayType(long payModeId) {
        String payWayType = "";
        QFilter filter = new QFilter("id", "=", (Object)payModeId);
        DynamicObject payModePayWayType = BusinessDataServiceHelper.loadSingle((String)"ocdbd_paymode", (String)"paywaytype.number", (QFilter[])new QFilter[]{filter});
        if (payModePayWayType != null) {
            DynamicObject paywayType = (DynamicObject)payModePayWayType.getDynamicObjectCollection("paywaytype").get(0);
            if (paywayType != null) {
                payWayType = paywayType.getDynamicObject("fbasedataid").getString("number");
            }
        } else {
            logger.info("getPayWayType\u65b9\u6cd5\uff0c\u6ca1\u6709\u83b7\u5f97\u5230\u6570\u636e\uff0c\u53c2\u65701{0}", (Object)payModeId);
        }
        return payWayType;
    }

    private JSONObject WeChatPayRefund(Map<String, String> payConfig, HashMap<String, String> refundData) {
        String billNo = refundData.get("billNo");
        long operatorId = Long.parseLong(refundData.get("operatorId"));
        Date operaTime = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            operaTime = sdf.parse(refundData.get("operaTime"));
        }
        catch (ParseException e) {
            logger.error("\u8f6c\u6362\u65f6\u95f4\u683c\u53d1\u751f\u5f02\u5e38\uff0c\u8981\u8f6c\u6362\u7684\u65f6\u95f4:" + refundData.get("operaTime"));
        }
        RefundRequestParam refundRequestParam = new RefundRequestParam(payConfig, billNo, operatorId, operaTime);
        refundRequestParam.setTransactionId(refundData.get("transaction_id"));
        refundRequestParam.setOutRefundNo(refundData.get("out_refund_no"));
        refundRequestParam.setRefundFee(Integer.parseInt(refundData.get("refund_fee")));
        refundRequestParam.setTotalFee(Integer.parseInt(refundData.get("total_fee")));
        logger.info("refundRequestParam:" + refundRequestParam.toString());
        JSONObject refundResponse = WechatPayUtil.refund((RefundRequestParam)refundRequestParam);
        if (refundResponse == null) {
            refundResponse = new JSONObject();
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
            return refundResponse;
        }
        try {
            logger.info("refundResponse:" + JSONUtils.toString((Object)refundResponse));
        }
        catch (IOException e) {
            logger.error("refundResponse\u65b9\u6cd5\u5e8f\u5217\u5316\u62a5\u9519" + e.getMessage());
        }
        refundResponse.put("trade_no", (Object)refundResponse.getString("refund_id"));
        if ("FAIL".equals(refundResponse.getString("return_code"))) {
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
        } else if ("FAIL".equals(refundResponse.getString("result_code"))) {
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
        } else {
            refundResponse.put("pay_status", (Object)TradeStatus.SUCCESS);
        }
        return refundResponse;
    }
}

