/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.business.cart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.util.ItemUtil;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.core.service.auxpty.AuxptyHelper;
import kd.occ.ocolsm.common.util.StringUtil;

public class CartProcessor {
    private static Log Logger = LogFactory.getLog(CartProcessor.class);

    public void addCartItems(long channelId, long memberId, List<DynamicObject> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        List<Long> lstItemId = datas.stream().map(r -> r.getLong("itemId")).collect(Collectors.toList());
        List<Long> lstAuxpropId = datas.stream().map(r -> r.getLong("auxpropId")).collect(Collectors.toList());
        DynamicObject[] cartAssistattrIdQty = this.getCartAuxpropIdQty(lstItemId, lstAuxpropId, channelId, memberId);
        Map cardMap = Arrays.asList(cartAssistattrIdQty).stream().collect(Collectors.toMap(k -> k.getLong("itemId") + "_" + k.getLong("auxpropId"), Function.identity(), (m1, m2) -> m1));
        DynamicObject[] saveData = new DynamicObject[datas.size()];
        int i = 0;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolsm_cartxml");
        for (DynamicObject data : datas) {
            DynamicObject cart = null;
            if (cardMap.containsKey(data.getLong("itemId") + "_" + data.getLong("auxpropId"))) {
                cart = (DynamicObject)cardMap.get(data.getLong("itemId") + "_" + data.getLong("auxpropId"));
                cart.set("qty", (Object)data.getBigDecimal("qty").add(cart.getBigDecimal("qty")));
                cart.set("modifytime", (Object)new Date());
            } else {
                cart = new DynamicObject((DynamicObjectType)entityType);
                cart.set("channelId", (Object)channelId);
                cart.set("memberId", (Object)memberId);
                cart.set("itemId", (Object)data.getLong("itemId"));
                cart.set("auxpropId", (Object)data.getLong("auxpropId"));
                cart.set("spuid", (Object)data.getLong("spuId"));
                cart.set("qty", (Object)data.getBigDecimal("qty"));
                cart.set("orgId", (Object)0);
                cart.set("ischecked", (Object)1);
                cart.set("materialId", (Object)0);
                cart.set("terminalType", (Object)2);
                cart.set("createtime", (Object)new Date());
                cart.set("modifytime", (Object)new Date());
            }
            saveData[i] = cart;
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])saveData);
    }

    public void deleteCartByIds(long memberId, List<Long> lstCartId) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "in", lstCartId));
        if (lstCartId != null && lstCartId.size() > 0) {
            DeleteServiceHelper.delete((String)"ocolsm_cartxml", (QFilter[])filter.toArray());
        }
    }

    public void updateCartCheckedByIds(long memberId, List<Long> lstCartId, boolean isChecked) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        DynamicObject[] arrayCartChecked = BusinessDataServiceHelper.load((String)"ocolsm_cartxml", (String)"id,ischecked", (QFilter[])filter.toArray());
        if (lstCartId == null) {
            if (isChecked) {
                for (DynamicObject cartChecked : arrayCartChecked) {
                    cartChecked.set("ischecked", (Object)"1");
                }
            } else {
                for (DynamicObject cartChecked : arrayCartChecked) {
                    cartChecked.set("ischecked", (Object)"0");
                }
            }
        } else if (isChecked) {
            for (DynamicObject cartChecked : arrayCartChecked) {
                if (lstCartId.contains(cartChecked.getLong("id"))) {
                    cartChecked.set("ischecked", (Object)"1");
                    continue;
                }
                cartChecked.set("ischecked", (Object)"0");
            }
        }
        SaveServiceHelper.update((DynamicObject[])arrayCartChecked);
    }

    public void updateCartQtyById(long memberId, long cartId, BigDecimal qty) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)cartId));
        DynamicObject cartQty = BusinessDataServiceHelper.loadSingle((String)"ocolsm_cartxml", (String)"id,qty", (QFilter[])filter.toArray());
        if (cartQty != null) {
            cartQty.set("qty", (Object)qty);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartQty});
        }
    }

    public void updateCartCheckedById(long memberId, long cartId, Boolean isChecked) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)cartId));
        DynamicObject cartQty = BusinessDataServiceHelper.loadSingle((String)"ocolsm_cartxml", (String)"id,qty", (QFilter[])filter.toArray());
        if (cartQty != null) {
            cartQty.set("ischecked", (Object)(isChecked != false ? "1" : "0"));
            SaveServiceHelper.update((DynamicObject)cartQty);
        }
    }

    public DynamicObject[] getCartAuxpropIdQty(List<Long> lstItemId, List<Long> lstAuxpropId, long channelId, long memberId) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("channelId", "=", (Object)channelId));
        filter.and(new QFilter("itemId", "in", lstItemId));
        filter.and(new QFilter("auxpropId", "in", lstAuxpropId));
        DynamicObject[] cartAuxpropIdQty = BusinessDataServiceHelper.load((String)"ocolsm_cartxml", (String)"id,itemId,auxpropId,qty,modifytime", (QFilter[])filter.toArray());
        return cartAuxpropIdQty;
    }

    public List<JSONObject> getCartItemDetails(long channelId, long memberId, boolean isOnlySelectChecked) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        if (isOnlySelectChecked) {
            filter.and(new QFilter("isChecked", "=", (Object)Boolean.TRUE));
        }
        DynamicObjectCollection colCart = QueryServiceHelper.query((String)"ocolsm_cartxml", (String)"id,itemid,auxpropId,qty,channelId,isChecked,spuid", (QFilter[])filter.toArray());
        Map<String, List<DynamicObject>> mapCart = colCart.stream().collect(Collectors.groupingBy(r -> r.getLong("itemid") + "_" + r.getLong("auxpropId") + "_" + r.getLong("spuid"), Collectors.toList()));
        String[] arrayItemId = new String[colCart.size()];
        String[] arrayAuxpropId = new String[colCart.size()];
        for (int i = 0; i < colCart.size(); ++i) {
            arrayItemId[i] = ((DynamicObject)colCart.get(i)).getString("itemId");
            arrayAuxpropId[i] = ((DynamicObject)colCart.get(i)).getString("auxpropId");
        }
        return this.queryItemDetails(channelId, arrayItemId, arrayAuxpropId, mapCart);
    }

    public List<JSONObject> getBuyNowItemDetails(long channelId, long itemId, long auxpropId, long spuid, long qty) {
        HashMap<String, List<DynamicObject>> mapCart = new HashMap<String, List<DynamicObject>>();
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"ocolsm_cartxml");
        object.set("id", (Object)0);
        object.set("qty", (Object)qty);
        object.set("ischecked", (Object)"true");
        ArrayList<DynamicObject> lstItem = new ArrayList<DynamicObject>();
        lstItem.add(object);
        mapCart.put(itemId + "_" + auxpropId + "_" + spuid, lstItem);
        String[] arrayItemId = String.valueOf(itemId).split(",");
        String[] arrayAuxpropId = String.valueOf(auxpropId).split(",");
        return this.queryItemDetails(channelId, arrayItemId, arrayAuxpropId, mapCart);
    }

    public List<JSONObject> getShipPriceItemDetails(long channelId, long itemId, long auxpropId, BigDecimal shipPrice) {
        HashMap<String, List<DynamicObject>> mapCart = new HashMap<String, List<DynamicObject>>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolsm_cartxml");
        DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
        object.set("id", (Object)-1);
        object.set("qty", (Object)1);
        object.set("ischecked", (Object)"true");
        ArrayList<DynamicObject> lstItem = new ArrayList<DynamicObject>();
        lstItem.add(object);
        mapCart.put(itemId + "_" + auxpropId, lstItem);
        String[] arrayItemId = String.valueOf(itemId).split(",");
        String[] arrayAuxpropId = String.valueOf(auxpropId).split("");
        List<JSONObject> lstItemDetail = this.queryItemDetails(channelId, arrayItemId, arrayAuxpropId, mapCart);
        if (lstItemDetail != null && lstItemDetail.size() > 0) {
            lstItemDetail.get(0).put("memberprice", (Object)shipPrice);
        }
        return lstItemDetail;
    }

    public List<JSONObject> queryItemDetails(long channelId, String[] arrayItemId, String[] arrayAuxpropId, Map<String, List<DynamicObject>> mapCart) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("itemid.id", "itemid");
        map.put("itemid.weightunit", "weightunit");
        map.put("itemid.volumnunit", "volumnunit");
        map.put("itemid.saleunit", "saleunit");
        map.put("itemid.baseunit", "baseunit");
        map.put("itemid.assistunit", "assistunit");
        map.put("itemid.material.taxrate", "taxrate");
        map.put("itemid.material.id", "materialid");
        map.put("auxptyid", "auxptyid");
        String appendFields = SerializationUtils.toJsonString(map);
        JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemDetails", (Object[])new Object[]{"ocolmm_itemsale_content", String.valueOf(channelId), arrayItemId, arrayAuxpropId, appendFields});
        JSONObject item = null;
        ArrayList<JSONObject> lstItemDetail = new ArrayList<JSONObject>();
        if (returnData.get((Object)"code").toString().equals("0000")) {
            Set<String> cartItemSet = mapCart.keySet();
            HashSet<String> copyCartItemSet = new HashSet<String>();
            copyCartItemSet.addAll(cartItemSet);
            JSONArray items = returnData.getJSONArray("data");
            String key = "";
            for (int i = 0; i < items.size(); ++i) {
                item = items.getJSONObject(i);
                key = item.getLong("itemid") + "_" + item.getLong("auxptyid");
                for (String cartItem : copyCartItemSet) {
                    if (cartItem.indexOf(key + "_") != 0) continue;
                    key = cartItem;
                    copyCartItemSet.remove(cartItem);
                    break;
                }
                if (mapCart.get(key) == null) continue;
                DynamicObject cartItem = mapCart.get(key).get(0);
                item.put("id", (Object)cartItem.getLong("id"));
                item.put("qty", (Object)cartItem.getBigDecimal("qty"));
                item.put("ischecked", (Object)cartItem.getString("ischecked"));
                item.put("channelid", (Object)channelId);
                String itemName = "";
                String[] keys = key.split("_");
                long skuId = Long.parseLong(keys[1]);
                long spuId = Long.parseLong(keys[2]);
                if (spuId > 0L) {
                    itemName = AuxptyHelper.getSpuDetail((long)spuId).getAuxptyName();
                    itemName = itemName.replace('+', ' ');
                } else if (skuId > 0L) {
                    itemName = AuxptyHelper.getAuxptyName((long)skuId).getAuxptyName();
                    StringBuilder sb = new StringBuilder();
                    String[] keyValues = itemName.split(",");
                    int length = keyValues.length;
                    for (int j = 0; j < length; ++j) {
                        sb.append(keyValues[j].split(":")[1]).append(' ');
                    }
                    itemName = sb.toString().trim();
                }
                item.put("itemname", (Object)(item.get((Object)"itemname") + itemName));
                item.put("pspuid", (Object)item.getLong("spuid"));
                item.put("spuid", (Object)spuId);
                item.put("modelnumname", (Object)itemName);
                BigDecimal rate = ItemUtil.queryConversionFactor((Object)item.getLong("itemid"), (Object)item.getLong("saleunit"), (Object)item.getLong("baseunit"));
                BigDecimal baseUnitQty = item.getBigDecimal("qty").multiply(rate);
                item.put("baseunitqty", (Object)baseUnitQty);
                BigDecimal assistqty = item.getBigDecimal("qty").multiply(rate);
                item.put("assistUnit", (Object)item.getString("assistunit"));
                item.put("assistQty", (Object)assistqty);
                lstItemDetail.add(item);
            }
        }
        return lstItemDetail;
    }

    public DynamicObject GetCityFreight(long channelId, long shippingId, long cityId) {
        QFilter filter = new QFilter("channelId", "=", (Object)channelId);
        filter.and(new QFilter("shippingTypeId", "=", (Object)shippingId));
        filter.and(new QFilter("ocolmm_shippriceentry.city", "=", (Object)cityId));
        DynamicObject cityFreight = QueryServiceHelper.queryOne((String)"ocolmm_shipprice", (String)"id,ocolmm_shippriceentry.weightfreight weightfreight,ocolmm_shippriceentry.volumefreight volumefreight", (QFilter[])filter.toArray());
        if (cityFreight == null) {
            filter = new QFilter("channelId", "=", (Object)channelId);
            filter.and(new QFilter("id", "=", (Object)shippingId));
            cityFreight = QueryServiceHelper.queryOne((String)"ocolmm_shipping", (String)"id,weightfreight,volumefreight", (QFilter[])filter.toArray());
        }
        return cityFreight;
    }

    public BigDecimal GetShipAmount(DynamicObject cityFreight, DynamicObjectCollection items) {
        Map<Long, DoubleSummaryStatistics> freightStatistics = items.stream().collect(Collectors.groupingBy(r -> r.getLong("freightType"), Collectors.summarizingDouble(r -> r.getBigDecimal("weight").multiply(r.getBigDecimal("qty")).doubleValue())));
        return this.CalculateShipAmount(cityFreight, freightStatistics);
    }

    public BigDecimal GetShipAmount(DynamicObject cityFreight, List<JSONObject> items) {
        Map<Long, DoubleSummaryStatistics> freightStatistics = items.stream().collect(Collectors.groupingBy(r -> r.getLong("freightType"), Collectors.summarizingDouble(r -> r.getBigDecimal("weight").multiply(r.getBigDecimal("qty")).doubleValue())));
        return this.CalculateShipAmount(cityFreight, freightStatistics);
    }

    public BigDecimal CalculateShipAmount(DynamicObject cityFreight, Map<Long, DoubleSummaryStatistics> freightStatistics) {
        BigDecimal shipAmount = BigDecimal.ZERO;
        if (cityFreight == null) {
            shipAmount = new BigDecimal("999999999.00");
            return shipAmount;
        }
        String weightFreght = cityFreight.getString("weightfreight");
        String volumeFreight = cityFreight.getString("volumefreight");
        try {
            int count;
            String[] item;
            int lenght;
            double totalWeight = 0.0;
            double totalVolume = 0.0;
            for (Map.Entry<Long, DoubleSummaryStatistics> m : freightStatistics.entrySet()) {
                if (m.getKey() == 1L) {
                    totalWeight = m.getValue().getSum();
                    continue;
                }
                if (m.getKey() != 2L) continue;
                totalVolume = m.getValue().getSum();
            }
            BigDecimal weightAmount = BigDecimal.ZERO;
            BigDecimal volumeAmount = BigDecimal.ZERO;
            if (totalWeight > 0.0) {
                lenght = (weightFreght = weightFreght.replaceFirst("w", String.valueOf(totalWeight))).indexOf(43);
                if (lenght > 0) {
                    weightAmount = new BigDecimal(weightFreght.substring(0, lenght).trim());
                    weightFreght = weightFreght.substring(lenght + 1);
                } else {
                    weightAmount = new BigDecimal(weightFreght);
                    weightFreght = "";
                }
            } else {
                weightFreght = "";
            }
            if (totalVolume > 0.0) {
                lenght = (volumeFreight = volumeFreight.replaceFirst("v", String.valueOf(totalVolume))).indexOf(43);
                if (lenght > 0) {
                    volumeAmount = new BigDecimal(volumeFreight.substring(0, lenght));
                    volumeFreight = volumeFreight.substring(lenght + 1);
                } else {
                    volumeAmount = new BigDecimal(volumeFreight);
                    volumeFreight = "";
                }
            } else {
                volumeFreight = "";
            }
            lenght = 0;
            BigDecimal itemExpress = BigDecimal.ZERO;
            String itemPrice = "";
            if (StringUtil.isNotEmpty((String)weightFreght)) {
                lenght = weightFreght.indexOf(42);
                item = weightFreght.substring(1, lenght - 1).split("-");
                count = item.length;
                if (count == 1) {
                    itemExpress = new BigDecimal(item[0]);
                } else if (count == 2) {
                    itemExpress = new BigDecimal(item[0]).subtract(new BigDecimal(item[1]));
                }
                itemPrice = weightFreght.substring(lenght + 1, weightFreght.length());
                itemExpress = itemExpress.setScale(0, 0);
                if (itemExpress.compareTo(BigDecimal.ZERO) > 0) {
                    weightAmount = weightAmount.add(itemExpress.multiply(new BigDecimal(itemPrice)));
                }
            }
            if (StringUtil.isNotEmpty((String)volumeFreight)) {
                lenght = volumeFreight.indexOf(42);
                item = volumeFreight.substring(1, lenght - 1).split("-");
                count = item.length;
                if (count == 1) {
                    itemExpress = new BigDecimal(item[0]).setScale(0, 0);
                } else if (count == 2) {
                    itemExpress = new BigDecimal(item[0]).subtract(new BigDecimal(item[1])).setScale(0, 0);
                }
                itemExpress = itemExpress.setScale(0, 0);
                itemPrice = volumeFreight.substring(lenght + 1, volumeFreight.length());
                if (itemExpress.compareTo(BigDecimal.ZERO) > 0) {
                    volumeAmount = volumeAmount.add(itemExpress.multiply(new BigDecimal(itemPrice)));
                }
            }
            shipAmount = weightAmount.add(volumeAmount);
        }
        catch (Exception e) {
            shipAmount = new BigDecimal("999999999.00");
            Logger.error("CalculateShipAmount\u65b9\u6cd5\u91cc\u8ba1\u7b97\u6b21\u91cd\u7684\u91d1\u989d\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
        return shipAmount.setScale(2, 4);
    }

    public OperationResult CreateOrder(DynamicObject orders, List<ExtDynamicObject> lstItemPrice, List<ExtDynamicObject> lstReceivePay, List<ExtDynamicObject> lstProductAmout) {
        DynamicObjectCollection entrys = orders.getDynamicObjectCollection("ocolmm_ordersentry");
        DynamicObjectType type = entrys.getDynamicObjectType();
        for (ExtDynamicObject item : lstItemPrice) {
            DynamicObject entry = new DynamicObject(type);
            entry.set("isShipping", (Object)item.getString("isShipping"));
            entry.set("itemId", (Object)item.getLong("itemId"));
            entry.set("material", (Object)item.getLong("materialid"));
            entry.set("auxpropId", (Object)item.getLong("auxpropId"));
            entry.set("spuid", (Object)item.getLong("spuid"));
            entry.set("modelnumname", (Object)item.getString("modelnumname"));
            entry.set("unitId", (Object)item.getLong("unitId"));
            entry.set("qty", (Object)item.getBigDecimal("qty"));
            entry.set("assistUnit", (Object)item.getBigDecimal("assistUnit"));
            entry.set("assistQty", (Object)item.getBigDecimal("assistQty"));
            entry.set("baseUnitId", (Object)item.getLong("baseUnitId"));
            entry.set("baseUnitQty", (Object)item.getBigDecimal("baseUnitQty"));
            entry.set("taxPrice", (Object)item.getBigDecimal("taxPrice"));
            entry.set("actUnitPrice", (Object)item.getBigDecimal("actUnitPrice"));
            entry.set("priceDiscount", (Object)item.getBigDecimal("priceDiscount"));
            entry.set("actTaxPrice", (Object)item.getBigDecimal("actTaxPrice"));
            entry.set("productAmount", (Object)item.getBigDecimal("productAmount"));
            entry.set("taxRate", (Object)item.getBigDecimal("taxRate"));
            entry.set("price", (Object)item.getBigDecimal("unitPrice"));
            entry.set("discount", (Object)item.getBigDecimal("discountPrice"));
            entry.set("taxPriceTatol", (Object)item.getBigDecimal("taxPriceTatol"));
            entry.set("amount", (Object)item.getBigDecimal("price"));
            entry.set("entryTaxAmount", (Object)item.getBigDecimal("entryTaxAmount"));
            entry.set("allamount_lc", (Object)item.getBigDecimal("taxPriceTatol").multiply(orders.getBigDecimal("exchangeRate")));
            entry.set("amount_lc", (Object)item.getBigDecimal("price").multiply(orders.getBigDecimal("exchangeRate")));
            entry.set("taxamount_lc", (Object)item.getBigDecimal("entryTaxAmount").multiply(orders.getBigDecimal("exchangeRate")));
            entry.set("shipments", (Object)item.getString("shipments"));
            entry.set("sostockId", (Object)item.getString("sostockId"));
            entry.set("shipmentsSupplier", (Object)item.getString("shipmentsSupplier"));
            entry.set("rowclosestatus", (Object)item.getString("rowclosestatus"));
            DynamicObjectCollection moneyEntrys = entry.getDynamicObjectCollection("ocolmm_oemoneydetail");
            List lstThisProductAmount = lstProductAmout.stream().filter(r -> r.getLong("id").longValue() == item.getLong("id").longValue()).collect(Collectors.toList());
            DynamicObjectType moneyType = moneyEntrys.getDynamicObjectType();
            for (ExtDynamicObject moneyItem : lstThisProductAmount) {
                DynamicObject moneyEntry = new DynamicObject(moneyType);
                moneyEntry.set("moneytype", (Object)moneyItem.getBigDecimal("moneytype"));
                moneyEntry.set("itemdetailamount", (Object)moneyItem.getBigDecimal("itemdetailamount"));
                moneyEntry.set("itemdetailnote", (Object)moneyItem.getString("itemdetailnote"));
                moneyEntrys.add((Object)moneyEntry);
            }
            entrys.add((Object)entry);
        }
        DynamicObjectCollection receivePays = orders.getDynamicObjectCollection("ocolmm_receivepay");
        DynamicObjectType receivePayType = receivePays.getDynamicObjectType();
        for (ExtDynamicObject item : lstReceivePay) {
            DynamicObject receivePay = new DynamicObject(receivePayType);
            receivePay.set("paymentmethod", (Object)item.getInt("paymentmethod"));
            receivePay.set("settlecurrid", (Object)item.getInt("settlecurrid"));
            receivePay.set("recamount", (Object)item.getBigDecimal("recamount"));
            receivePay.set("collectiontime", item.get((Object)"collectiontime"));
            receivePays.add((Object)receivePay);
        }
        OperateOption option = OperateOption.create();
        OperationResult result = SaveServiceHelper.saveOperate((String)"ocolmm_orders", (DynamicObject[])new DynamicObject[]{orders}, (OperateOption)option);
        return result;
    }

    public ExtDynamicObject getExchangeData(Long orgId, Long srcCurId, Date date) {
        ExtDynamicObject obj = new ExtDynamicObject();
        Map CompanyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        long CompanyId = (Long)CompanyMap.get("id");
        Map BaseAccountingMap = BaseDataServiceHelper.getBaseAccountingInfo((Long)CompanyId);
        long exRateTableId = (Long)BaseAccountingMap.get("exchangeRateTableID");
        long baseCurrencyId = (Long)BaseAccountingMap.get("baseCurrencyID");
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)baseCurrencyId, (Date)date);
        obj.put("baseCurrencyId", (Object)baseCurrencyId);
        obj.put("exRateTableId", (Object)exRateTableId);
        obj.put("exchangeRate", (Object)exchangeRate);
        return obj;
    }

    public DynamicObjectCollection getPaymentType(long channelId) {
        QFilter filter = new QFilter("channelId", "=", (Object)channelId);
        filter.and(new QFilter("status", "=", (Object)"C"));
        return QueryServiceHelper.query((String)"ocolmm_paymenttype", (String)"id,name", null);
    }

    public DynamicObjectCollection getShipping(long channelId) {
        QFilter filter = new QFilter("channelId", "=", (Object)channelId);
        filter.and(new QFilter("status", "=", (Object)"C"));
        return QueryServiceHelper.query((String)"ocolmm_shipping", (String)"id,name", (QFilter[])filter.toArray());
    }

    public OperationResult CreateOrderInvoice(DynamicObject orderInvoice) {
        OperateOption option = OperateOption.create();
        OperationResult result = SaveServiceHelper.saveOperate((String)"ocolmm_ordersinvoice", (DynamicObject[])new DynamicObject[]{orderInvoice}, (OperateOption)option);
        return result;
    }
}

