/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.business.member;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.AddAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.DeleteAddressByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressListDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryDefaultAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.UpdateAddressDTO;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionProcessor;

public class AddressProcessor {
    public JSONObject getAddresses(Long memberId) {
        JSONObject returnData = null;
        QueryAddressListDTO dto = new QueryAddressListDTO();
        dto.setUserId(memberId);
        returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryAddressList", (Object[])new Object[]{dto});
        return returnData;
    }

    public JSONObject getAddress(long memberId, long addressId) {
        JSONObject returnData = null;
        QueryAddressByIdDTO dto = new QueryAddressByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        dto.setAddressId(Long.valueOf(addressId));
        returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryAddressById", (Object[])new Object[]{dto});
        return returnData;
    }

    public JSONObject addAddress(Long memberId, ExtDynamicObject address) {
        AddAddressDTO dto = new AddAddressDTO();
        dto.setUserId(memberId);
        dto.setAddressTypeId(Long.valueOf(749865059609482240L));
        dto.setContact(address.getString("linkman"));
        dto.setPhone(address.getString("linkphone"));
        dto.setCountryId(address.getLong("countryid"));
        dto.setProvinceId(address.getLong("provinceid"));
        dto.setCityId(address.getLong("cityid"));
        dto.setDistrictId(address.getLong("districtid"));
        dto.setDetailedAddress(address.getString("address"));
        dto.setDefaultAddress(address.getBoolean("isdefaultaddr").booleanValue());
        JSONObject returnData = null;
        returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"addAddress", (Object[])new Object[]{dto});
        return returnData;
    }

    public JSONObject updateAddress(Long memberId, ExtDynamicObject address) {
        UpdateAddressDTO dto = new UpdateAddressDTO();
        dto.setUserId(memberId);
        dto.setAddressId(address.getLong("addressid"));
        dto.setAddressTypeId(address.getLong("addrtypeid"));
        dto.setContact(address.getString("linkman"));
        dto.setPhone(address.getString("linkphone"));
        dto.setCountryId(address.getLong("countryid"));
        dto.setProvinceId(address.getLong("provinceid"));
        dto.setCityId(address.getLong("cityid"));
        dto.setDistrictId(address.getLong("districtid"));
        dto.setDetailedAddress(address.getString("address"));
        dto.setDefaultAddress(address.getBoolean("isdefaultaddr").booleanValue());
        JSONObject returnData = null;
        returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"updateAddress", (Object[])new Object[]{dto});
        return returnData;
    }

    public JSONObject deleteAddress(Long memberId, Long addressId) {
        DeleteAddressByIdDTO dto = new DeleteAddressByIdDTO();
        dto.setUserId(memberId);
        dto.setAddressId(addressId);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"deleteAddressById", (Object[])new Object[]{dto});
    }

    public ExtDynamicObject getFullDivision(long divisionId) {
        List lst = new AdminDivisionProcessor().getParentDivisionList(divisionId);
        LogUtil.error(AddressProcessor.class, (String)("getFullDivision=" + JsonUtil.toString((Object)lst) + ",divisionId:" + divisionId));
        DynamicObject region = new DynamicObject();
        for (DynamicObject item : lst) {
            if (item.getLong("id") != divisionId) continue;
            region = item;
            break;
        }
        ExtDynamicObject extRegion = new ExtDynamicObject();
        String longnumber = "";
        String fullname = "";
        if (region != null) {
            longnumber = region.getString("longnumber");
            fullname = region.getString("fullname");
            String[] numbers = longnumber.split("\\.");
            int length = numbers.length;
            CharSequence[] ids = new String[length];
            for (int i = 0; i < length; ++i) {
                ids[i] = String.valueOf(Long.parseLong(numbers[i]));
            }
            extRegion.put("id", (Object)divisionId);
            extRegion.put("countryid", (Object)region.getString("country.id"));
            extRegion.put("fullids", (Object)String.join((CharSequence)"_", ids));
            extRegion.put("fullname", (Object)fullname);
        }
        return extRegion;
    }

    public JSONObject getDefalutAddress(long memberId) {
        QueryDefaultAddressDTO dto = new QueryDefaultAddressDTO();
        dto.setUserId(Long.valueOf(memberId));
        dto.setQueryAll(true);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryDefaultAddressByUserId", (Object[])new Object[]{dto});
    }
}

