/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.business.member;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserByIdDTO;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class OrderProcessor {
    private static Log logger = LogFactory.getLog(OrderProcessor.class);

    public DynamicObjectCollection getOrderList(Long memberId, QFilter filter) {
        DynamicObjectCollection Orders = QueryServiceHelper.query((String)"ocolmm_orders", (String)"id,billno,orderstatus,olmm_ordersentry.itemid itemid,olmm_ordersentry.qty qty,olmm_ordersentry.unitid unitid", (QFilter[])filter.toArray());
        return Orders;
    }

    public DynamicObject getOrder(Long memberId, long id) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)id));
        String queryFields = "id,billNo,orderStatus,receiveContact,receiveMobile,fullAddress,note,createTime";
        queryFields = queryFields + ",payType.id as payTypeId,payType.name as payTypeName,shippingtype.name as shippingName";
        queryFields = queryFields + ",itemTotalAmount,shipAmount,apAmount,paidAmount,needPayAmount,paymentStatus";
        return QueryServiceHelper.queryOne((String)"ocolmm_orders", (String)queryFields, (QFilter[])filter.toArray());
    }

    public DynamicObjectCollection getOrderItem(Long memberId, long id, boolean isFilterShipping) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)id));
        String orderBy = "ocolmm_ordersentry.id asc";
        if (isFilterShipping) {
            filter.and(new QFilter("ocolmm_ordersentry.isshipping", "=", (Object)Boolean.FALSE));
        }
        String queryFields = "id orderid,billno orderno,ocolmm_ordersentry.id orderproductid,ocolmm_ordersentry.isshipping isshipping,ocolmm_ordersentry.itemid itemid,ocolmm_ordersentry.spuid spuid,ocolmm_ordersentry.auxpropid auxpropid,ocolmm_ordersentry.material material,ocolmm_ordersentry.unitid unitid,ocolmm_ordersentry.qty qty,ocolmm_ordersentry.assistunit assistunit,ocolmm_ordersentry.assistqty assistqty,ocolmm_ordersentry.baseunitid baseunitid,ocolmm_ordersentry.baseunitqty baseunitqty,ocolmm_ordersentry.taxprice taxprice,ocolmm_ordersentry.actunitprice actunitprice,ocolmm_ordersentry.pricediscount pricediscount,ocolmm_ordersentry.acttaxprice acttaxprice,ocolmm_ordersentry.productamount productamount,ocolmm_ordersentry.taxrate taxrate,ocolmm_ordersentry.price price,ocolmm_ordersentry.discount discount,ocolmm_ordersentry.taxpricetatol taxpricetatol,ocolmm_ordersentry.amount amount,ocolmm_ordersentry.entrytaxamount entrytaxamount,ocolmm_ordersentry.allamount_lc allamount_lc,ocolmm_ordersentry.amount_lc amount_lc,ocolmm_ordersentry.taxamount_lc taxamount_lc,ocolmm_ordersentry.shipments shipments,ocolmm_ordersentry.sostockid sostockid,ocolmm_ordersentry.shipmentssupplier shipmentssupplier";
        queryFields = queryFields + ",ocolmm_ordersentry.itemid.name as itemname,ocolmm_ordersentry.itemid.number as itemnumber,ocolmm_ordersentry.itemid.thumbnail as thumbnail,ocolmm_ordersentry.modelnumname as modelnumname,ocolmm_ordersentry.detailstockorgid as detailstockorgid,ocolmm_ordersentry.mainbillentryseq as mainbillentryseq";
        return QueryServiceHelper.query((String)"ocolmm_orders", (String)queryFields, (QFilter[])filter.toArray(), (String)orderBy);
    }

    public DynamicObject getOrderPayInfo(Long memberId, long id) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)id));
        return QueryServiceHelper.queryOne((String)"ocolmm_orders", (String)"id,billno,ApAmount,paidAmount,needPayAmount,paymentStatus", (QFilter[])filter.toArray());
    }

    public OperationResult CreateAfterSales(DynamicObject afterSales, List<ExtDynamicObject> listOrderProduct, List<ExtDynamicObject> listProductRefund, List<ExtDynamicObject> listAfterSalesOplog) {
        afterSales = this.getAfterSalesData(afterSales, listOrderProduct, listProductRefund, listAfterSalesOplog);
        OperateOption option = OperateOption.create();
        OperationResult result = SaveServiceHelper.saveOperate((String)"ocolmm_aftersales", (DynamicObject[])new DynamicObject[]{afterSales}, (OperateOption)option);
        return result;
    }

    public DynamicObject getAfterSalesData(DynamicObject afterSales, List<ExtDynamicObject> listOrderProduct, List<ExtDynamicObject> listProductRefund, List<ExtDynamicObject> listAfterSalesOplog) {
        DynamicObjectCollection entrys = afterSales.getDynamicObjectCollection("ocolmm_asentry");
        DynamicObjectType type = entrys.getDynamicObjectType();
        for (ExtDynamicObject item : listOrderProduct) {
            DynamicObject entry = new DynamicObject(type);
            entry.set("itemid", (Object)item.getLong("itemid"));
            entry.set("assistunitid", (Object)item.getLong("assistunitid"));
            entry.set("baseunitid", (Object)item.getLong("baseunitid"));
            entry.set("unitid", (Object)item.getLong("unitid"));
            entry.set("materialid", (Object)item.getLong("materialid"));
            entry.set("skuid", (Object)item.getLong("skuid"));
            entry.set("qty", (Object)item.getBigDecimal("qty"));
            entry.set("assistqty", (Object)item.getBigDecimal("assistqty"));
            entry.set("baseqty", (Object)item.getBigDecimal("baseqty"));
            entry.set("taxprice", (Object)item.getBigDecimal("taxprice"));
            entry.set("realprice", (Object)item.getBigDecimal("realprice"));
            entry.set("discountrate", (Object)item.getBigDecimal("discountrate"));
            entry.set("actualunitprice", (Object)item.getBigDecimal("actualunitprice"));
            entry.set("itemamount", (Object)item.getBigDecimal("itemamount"));
            entry.set("unitprice", (Object)item.getBigDecimal("unitprice"));
            entry.set("discountamount", (Object)item.getBigDecimal("discountamount"));
            entry.set("amountandtax", (Object)item.getBigDecimal("amountandtax"));
            entry.set("amount", (Object)item.getBigDecimal("amount"));
            entry.set("taxamount", (Object)item.getBigDecimal("taxamount"));
            entry.set("taxrate", (Object)item.getBigDecimal("taxrate"));
            entry.set("lcamount", (Object)item.getBigDecimal("lcamount"));
            entry.set("lctaxamount", (Object)item.getBigDecimal("lctaxamount"));
            entry.set("lcallamount", (Object)item.getBigDecimal("lcallamount"));
            entry.set("detailstockorgid", (Object)item.getLong("detailstockorgid"));
            entry.set("sostockid", (Object)item.getLong("sostockid"));
            entry.set("srcbillentity", (Object)item.getString("srcbillentity"));
            entry.set("srcbillid", (Object)item.getLong("srcbillid"));
            entry.set("srcbillnumber", (Object)item.getString("srcbillnumber"));
            entry.set("srcbillentryid", (Object)item.getLong("srcbillentryid"));
            entry.set("srcbillentryseq", (Object)item.getInt("srcbillentryseq"));
            entry.set("mainbillentity", (Object)item.getString("mainbillentity"));
            entry.set("mainbillid", (Object)item.getLong("mainbillid"));
            entry.set("mainbillnumber", (Object)item.getString("mainbillnumber"));
            entry.set("mainbillentryid", (Object)item.getLong("mainbillentryid"));
            entry.set("mainbillentryseq", (Object)item.getInt("mainbillentryseq"));
            entrys.add((Object)entry);
        }
        DynamicObjectCollection asRefundEntrys = afterSales.getDynamicObjectCollection("ocolmm_asrefundentry");
        DynamicObjectType asRefundEntryType = asRefundEntrys.getDynamicObjectType();
        for (ExtDynamicObject item : listProductRefund) {
            DynamicObject asRefundEntry = new DynamicObject(asRefundEntryType);
            asRefundEntry.set("collectiontype", (Object)ObjectUtil.toLong((Object)item.get((Object)"collectiontype"), (long)-1L));
            asRefundEntry.set("collectioncurrencyid", (Object)ObjectUtil.toLong((Object)item.get((Object)"collectioncurrencyid"), (long)-1L));
            asRefundEntry.set("refundamount", (Object)ObjectUtil.toBigDecimal((Object)item.get((Object)"refundamount"), (BigDecimal)BigDecimal.ZERO));
            asRefundEntry.set("adjustamount", (Object)ObjectUtil.toBigDecimal((Object)item.get((Object)"adjustamount"), (BigDecimal)BigDecimal.ZERO));
            asRefundEntry.set("realrefundamount", (Object)ObjectUtil.toBigDecimal((Object)item.get((Object)"realrefundamount"), (BigDecimal)BigDecimal.ZERO));
            asRefundEntry.set("adjustseason", (Object)ObjectUtil.toString((Object)item.get((Object)"adjustseason")));
            asRefundEntry.set("detailcomment", (Object)ObjectUtil.toString((Object)item.get((Object)"detailcomment")));
            asRefundEntrys.add((Object)asRefundEntry);
        }
        DynamicObjectCollection afterSalesOplogs = afterSales.getDynamicObjectCollection("ocolmm_aftersalesoplog");
        DynamicObjectType afterSalesOplogType = afterSalesOplogs.getDynamicObjectType();
        for (ExtDynamicObject item : listAfterSalesOplog) {
            DynamicObject afterSalesOplog = new DynamicObject(afterSalesOplogType);
            afterSalesOplog.set("operatorrule", (Object)item.getInt("operatorrule"));
            afterSalesOplog.set("operator", (Object)item.getString("operator"));
            afterSalesOplog.set("opdesc", (Object)item.getString("opdesc"));
            afterSalesOplog.set("opcomment", (Object)item.getString("opcomment"));
            afterSalesOplog.set("flag", (Object)item.getInt("flag"));
            afterSalesOplog.set("opcreatetime", item.get((Object)"opcreatetime"));
            afterSalesOplogs.add((Object)afterSalesOplog);
        }
        return afterSales;
    }

    public DynamicObjectCollection getAfterSalesDetail(Long memberId, long id) {
        QFilter afterSalesfilter = new QFilter("id", "=", (Object)id);
        String afterSalesQueryFields = "id,billno,billstatus,orderid,billtype,returnreason,comment,createtime";
        afterSalesQueryFields = afterSalesQueryFields + ",customerreceivermember,customerreceiverphone,customercountriesid,customerprovinecid,customercityid,customercountyid,customeraddress,customerreceiveraddress";
        afterSalesQueryFields = afterSalesQueryFields + ",ocolmm_asentry.itemid itemid,ocolmm_asentry.srcbillentryid opid,ocolmm_asentry.itemid.number itemnumber,ocolmm_asentry.itemid.name itemname,ocolmm_asentry.itemid.thumbnail itemimg,ocolmm_asentry.actualunitprice actualunitprice,ocolmm_asentry.qty qty";
        return QueryServiceHelper.query((String)"ocolmm_aftersales", (String)afterSalesQueryFields, (QFilter[])afterSalesfilter.toArray());
    }

    public String cancelAfterSales(Long memberId, long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject afterSales = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocolmm_aftersales");
        String msg = "";
        if (afterSales != null) {
            afterSales.set("cancelstatus", (Object)"B");
            QueryUserByIdDTO dto = new QueryUserByIdDTO();
            dto.setUserId(memberId);
            JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserById", (Object[])new Object[]{dto});
            String myname = "";
            if (returnData.get((Object)"code").toString().equals("0")) {
                JSONObject memberInfo = returnData.getJSONObject("data");
                myname = memberInfo.getString("name");
                DynamicObjectCollection afterSalesOplogs = afterSales.getDynamicObjectCollection("ocolmm_aftersalesoplog");
                DynamicObjectType afterSalesOplogType = afterSalesOplogs.getDynamicObjectType();
                DynamicObject afterSalesOplog = new DynamicObject(afterSalesOplogType);
                afterSalesOplog.set("operatorrule", (Object)2);
                afterSalesOplog.set("operator", (Object)myname);
                afterSalesOplog.set("opdesc", (Object)"\u53d6\u6d88\u7533\u8bf7");
                afterSalesOplog.set("opcomment", (Object)"");
                afterSalesOplog.set("flag", (Object)2);
                afterSalesOplog.set("opcreatetime", (Object)new Date());
                afterSalesOplogs.add((Object)afterSalesOplog);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{afterSales});
            } else {
                msg = "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25";
            }
        } else {
            msg = "\u672a\u627e\u5230\u8be5\u552e\u540e\u5355";
        }
        return msg;
    }

    public int getOrdersCount(QFilter filter) {
        String queryFields = "id";
        return QueryServiceHelper.query((String)"ocolmm_orders", (String)queryFields, (QFilter[])filter.toArray()).size();
    }

    public DynamicObjectCollection getLogisticComp() {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.query((String)"bd_logisticcomp", (String)"id,number,name", (QFilter[])filter.toArray());
    }

    public String itemReturn(long memberId, long id, int itemReturnType, long logisticsCompanyId, String retLogisticsNo, String returnRemark) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject afterSales = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocolmm_aftersales");
        String msg = "";
        if (afterSales != null) {
            afterSales.set("billstatus", (Object)"D");
            afterSales.set("returnremark", (Object)returnRemark);
            if (itemReturnType == 2) {
                afterSales.set("retlogisticscompanyid", (Object)logisticsCompanyId);
                afterSales.set("retlogisticsno", (Object)retLogisticsNo);
            }
            QueryUserByIdDTO dto = new QueryUserByIdDTO();
            dto.setUserId(Long.valueOf(memberId));
            JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserById", (Object[])new Object[]{dto});
            String myname = "";
            if (returnData.get((Object)"code").toString().equals("0")) {
                JSONObject memberInfo = returnData.getJSONObject("data");
                myname = memberInfo.getString("name");
                DynamicObjectCollection afterSalesOplogs = afterSales.getDynamicObjectCollection("ocolmm_aftersalesoplog");
                DynamicObjectType afterSalesOplogType = afterSalesOplogs.getDynamicObjectType();
                DynamicObject afterSalesOplog = new DynamicObject(afterSalesOplogType);
                afterSalesOplog.set("operatorrule", (Object)2);
                afterSalesOplog.set("operator", (Object)myname);
                afterSalesOplog.set("opdesc", (Object)(itemReturnType == 2 ? "\u5ba2\u6237\u5bc4\u56de" : "\u4e0a\u95e8\u53d6\u4ef6"));
                afterSalesOplog.set("opcomment", (Object)"");
                afterSalesOplog.set("flag", (Object)2);
                afterSalesOplog.set("opcreatetime", (Object)new Date());
                afterSalesOplogs.add((Object)afterSalesOplog);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{afterSales});
            } else {
                msg = "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25";
            }
        } else {
            msg = "\u672a\u627e\u5230\u8be5\u552e\u540e\u5355";
        }
        return msg;
    }

    public DynamicObjectCollection getAfterSales(long memberId, String searchinput, String ServersStatus, String page, String pageSize) {
        QFilter aftersalesfilter = new QFilter("ocolmm_aftersales.orderid.memberid", "=", (Object)memberId);
        if (ServersStatus.equals("2")) {
            aftersalesfilter.and(new QFilter("billstatus", "=", (Object)"G"));
        }
        aftersalesfilter.and(new QFilter("cancelstatus", "=", (Object)"A"));
        aftersalesfilter.and(new QFilter("ocolmm_aftersales.orderid.orderstatus", "in", Arrays.asList("6", "7", "8")));
        aftersalesfilter.and(new QFilter("ocolmm_aftersales.orderid.closestatus", "=", (Object)"A"));
        aftersalesfilter.and(new QFilter("ocolmm_aftersales.orderid.cancelstatus", "=", (Object)"A"));
        if (StringUtil.isNotEmpty((String)searchinput)) {
            aftersalesfilter.and(new QFilter("ocolmm_aftersales.billno", "like", (Object)searchinput));
        }
        String orderBy = "id desc";
        DynamicObjectCollection aftersales = QueryServiceHelper.query((String)"ocolmm_aftersales", (String)"id aftersalesid,billno aftersalesno,billtype,billstatus,ocolmm_aftersales.orderid.number orderno,ocolmm_asentry.srcbillentryid opid,ocolmm_asentry.qty qty,ocolmm_asentry.itemid itemid,ocolmm_asentry.itemid.number itemnumber,ocolmm_asentry.itemid.name itemname,ocolmm_asentry.itemid.thumbnail itemimg", (QFilter[])aftersalesfilter.toArray(), (String)orderBy);
        return aftersales;
    }

    public void orderPaynotify(JSONObject queryResponse) {
        if (queryResponse.getString("trade_state").equals("SUCCESS")) {
            String transaction_id = queryResponse.getString("transaction_id");
            String attach = queryResponse.getString("attach");
            long orderId = Long.parseLong(attach.split("_")[0]);
            long payConfigId = Long.parseLong(attach.split("_")[1]);
            long payModeId = Long.parseLong(attach.split("_")[2]);
            QFilter filter = new QFilter("outtradeno", "=", (Object)transaction_id);
            DynamicObject receipts = QueryServiceHelper.queryOne((String)"ocolmm_receipts", (String)"id", (QFilter[])filter.toArray());
            if (receipts == null) {
                filter = new QFilter("id", "=", (Object)orderId);
                filter.and(new QFilter("orderstatus", "in", Arrays.asList("1", "2")));
                DynamicObject orders = BusinessDataServiceHelper.loadSingle((String)"ocolmm_orders", (String)"orderstatus,id,memberid,billsettlecurrid,billno,needpayamount,paidamount,paymentstatus,latestpaytime,org", (QFilter[])filter.toArray());
                if (orders != null) {
                    Date paytime = new Date();
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        paytime = sdf.parse(queryResponse.getString("time_end"));
                    }
                    catch (ParseException e) {
                        logger.error("\u8f6c\u6362\u65f6\u95f4\u683c\u53d1\u751f\u5f02\u5e38\uff0c\u8981\u8f6c\u6362\u7684\u65f6\u95f4:" + queryResponse.getString("time_end"));
                    }
                    BigDecimal payamount = new BigDecimal(queryResponse.getString("total_fee"));
                    payamount = payamount.divide(new BigDecimal(100), 2, 4);
                    BigDecimal needPayAmount = orders.getBigDecimal("needpayamount").subtract(payamount);
                    BigDecimal paidAmount = orders.getBigDecimal("paidAmount").add(payamount);
                    orders.set("needpayamount", (Object)needPayAmount);
                    orders.set("paidAmount", (Object)paidAmount);
                    orders.set("latestPayTime", (Object)paytime);
                    if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                        orders.set("orderstatus", (Object)3);
                        orders.set("paymentstatus", (Object)3);
                    } else {
                        orders.set("orderstatus", (Object)2);
                        orders.set("paymentstatus", (Object)2);
                    }
                    SaveServiceHelper.update((DynamicObject)orders);
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_receipts");
                    receipts = new DynamicObject((DynamicObjectType)entityType);
                    String billNo = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    receipts.set("billNo", (Object)billNo);
                    receipts.set("billStatus", (Object)"B");
                    receipts.set("org", (Object)orders.getLong("org.id"));
                    receipts.set("memberid", (Object)orders.getString("memberid.id"));
                    receipts.set("currency", (Object)orders.getLong("billsettlecurrid.id"));
                    receipts.set("payamount", (Object)payamount);
                    receipts.set("paydatetime", (Object)paytime);
                    receipts.set("paytypeid", (Object)payModeId);
                    receipts.set("isreceipt", (Object)1);
                    receipts.set("outtradeno", (Object)transaction_id);
                    receipts.set("orderno", (Object)orders.getString("billno"));
                    receipts.set("orderid", (Object)orders.getLong("id"));
                    receipts.set("payconfigid", (Object)payConfigId);
                    OperationResult result = SaveServiceHelper.saveOperate((String)"ocolmm_receipts", (DynamicObject[])new DynamicObject[]{receipts}, (OperateOption)OperateOption.create());
                    DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orders.getLong("id"), (String)"ocolmm_orders");
                    DynamicObjectCollection receivePays = order.getDynamicObjectCollection("ocolmm_receivepay");
                    DynamicObjectType receivePayType = receivePays.getDynamicObjectType();
                    DynamicObject receivePay = new DynamicObject(receivePayType);
                    receivePay.set("paymentmethod", (Object)payModeId);
                    receivePay.set("settlecurrid", (Object)order.getLong("billsettlecurrid.masterid"));
                    receivePay.set("recamount", (Object)payamount);
                    receivePay.set("collectiontime", (Object)paytime);
                    receivePays.add((Object)receivePay);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
                } else {
                    logger.error("\u8ba2\u5355\u4e0d\u5b58\u5728,\u8ba2\u5355id:" + orderId);
                }
            }
        }
    }
}

