/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.business.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.business.payhelper.PayTradeHelper;
import kd.occ.ocbase.business.payhelper.WxPayTradeHelper;
import kd.occ.ocbase.common.pay.config.CheckOutCounterInfo;
import kd.occ.ocbase.common.pay.config.MiniPayResult;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.util.PayUtil;
import kd.occ.ocbase.common.pay.util.WechatPayUtil;
import kd.occ.ocbase.common.pay.wechat.vo.RefundRequestParam;
import kd.occ.ocepfp.common.enums.ClientType;
import kd.occ.ocepfp.common.util.ClientTypeUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocolsm.business.member.MemberHelper;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.common.constant.PayModeEnum;

public class PayProcessor {
    private static Log logger = LogFactory.getLog(PayProcessor.class);

    public DynamicObjectCollection getPaymentType(long channelId) {
        ClientType clientType = ClientTypeUtil.getClientType();
        if (clientType == ClientType.PC) {
            // empty if block
        }
        if (clientType == ClientType.H5) {
            // empty if block
        }
        if (clientType != ClientType.WeiXin) {
            if (clientType == ClientType.MiniProgram) {
                // empty if block
            }
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("onstoreeffect", "=", (Object)"1"));
        filter.and(new QFilter("treeentryentity.branch.id", "=", (Object)channelId));
        String orderBy = "entryentity.id asc";
        String queryFields = "ocdbd_payconfigs.id payconfigid,entryentity.channel.id id,entryentity.channel.name name";
        DynamicObjectCollection colChannelPayment = QueryServiceHelper.query((String)"ocdbd_payconfigs", (String)queryFields, (QFilter[])filter.toArray(), (String)orderBy);
        if (colChannelPayment.size() == 0) {
            filter = new QFilter("status", "=", (Object)"C");
            filter.and(new QFilter("onstoreeffect", "=", (Object)"1"));
            colChannelPayment = QueryServiceHelper.query((String)"ocdbd_payconfigs", (String)queryFields, (QFilter[])filter.toArray(), (String)orderBy);
        }
        return colChannelPayment;
    }

    public HashMap<String, String> getPayData(long channelId, long orderId, long memberId, long payConfigId, long payModeId) {
        LogUtil.info(PayProcessor.class, (String)("channelId=" + channelId + "\uff0cmemberId=" + memberId));
        HashMap<String, String> ext = new HashMap<String, String>();
        ClientType clientType = ClientTypeUtil.getClientType();
        DynamicObject orderDetail = OrderHelper.getOrder(memberId, orderId);
        long orderStatus = orderDetail.getLong("orderStatus");
        LogUtil.info(PayProcessor.class, (String)("orderStatus=" + orderStatus + ",clientType" + clientType));
        if (orderStatus < 3L) {
            HashMap<String, String> orderData = new HashMap<String, String>();
            orderData.put("payConfigId", String.valueOf(payConfigId));
            orderData.put("payModeId", String.valueOf(payModeId));
            orderData.put("memberId", String.valueOf(memberId));
            orderData.put("orderId", String.valueOf(orderId));
            orderData.put("needPayAmount", String.valueOf(orderDetail.getBigDecimal("needPayAmount")));
            orderData.put("billNo", orderDetail.getString("billNo"));
            orderData.put("subject", "");
            String body = "\u8ba2\u5355" + orderDetail.getString("billNo") + ",\u5171\u652f\u4ed8" + orderDetail.getBigDecimal("needPayAmount").setScale(2, 4) + "\u5143";
            orderData.put("body", body);
            orderData.put("storeId", String.valueOf(channelId));
            orderData.put("spbillCreateIp", "");
            orderData.put("openId", "");
            String payWayType = new PayProcessor().getPayWayType(payModeId);
            if (payWayType.equals(PayModeEnum.WeChatPayType.toString())) {
                if (clientType == ClientType.H5) {
                    ext = PayProcessor.invokeMiniPay(orderData);
                } else if (clientType == ClientType.MiniProgram) {
                    ext = PayProcessor.invokeMiniPay(orderData);
                } else if (clientType == ClientType.WeiXin) {
                    ext = PayProcessor.invokeMiniPay(orderData);
                } else if (clientType == ClientType.PC) {
                    ext = PayProcessor.invokeMiniPay(orderData);
                }
            } else {
                ext.put("tradeStatus", TradeStatus.FAILED.toString());
                ext.put("errorMessage", "\u652f\u4ed8\u5931\u8d25");
            }
            ext.put("payWayType", payWayType);
        } else if (orderStatus == 8L) {
            ext.put("tradeStatus", TradeStatus.FAILED.toString());
            ext.put("errorMessage", "\u8ba2\u5355\u5df2\u53d6\u6d88");
        } else {
            ext.put("tradeStatus", TradeStatus.FAILED.toString());
            ext.put("errorMessage", "\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4e0d\u8981\u91cd\u590d\u652f\u4ed8");
        }
        return ext;
    }

    public static HashMap<String, String> invokeMiniPay(HashMap<String, String> orderData) {
        HashMap<String, String> ext = new HashMap<String, String>();
        try {
            CheckOutCounterInfo payData = new CheckOutCounterInfo();
            payData.setBillNo(orderData.get("billNo"));
            payData.setSubject(orderData.get("subject"));
            payData.setBody(orderData.get("body"));
            payData.setOperaTime(TimeServiceHelper.now());
            payData.setStoreId(Long.parseLong(orderData.get("storeId")));
            payData.setSpbillCreateIp(RequestContext.get().getLoginIP());
            if (ext.get("tradeStatus") == TradeStatus.FAILED.toString()) {
                return ext;
            }
            DynamicObject memberLoginInfo = MemberHelper.getMiniProgramMemberLoginInfo(Long.parseLong(orderData.get("memberId")));
            try {
                LogUtil.info(PayProcessor.class, (String)("memberLoginInfo=" + JSONUtils.toString((Object)memberLoginInfo)));
            }
            catch (IOException e) {
                logger.error("JSONUtils.toString(memberLoginInfo)\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
            }
            String openId = memberLoginInfo.getString("openid");
            if (openId.length() < 28) {
                ext.put("tradeStatus", TradeStatus.FAILED.toString());
                ext.put("errorMessage", "openId\u4e0d\u6b63\u786e");
            }
            if (ext.get("tradeStatus") == TradeStatus.FAILED.toString()) {
                return ext;
            }
            payData.setOpenId(openId);
            String orderId = orderData.get("orderId");
            long paymode = Long.parseLong(orderData.get("payModeId"));
            long payConfigId = Long.parseLong(orderData.get("payConfigId"));
            String attach = orderId + "_" + payConfigId + "_" + paymode;
            payData.setAttach(attach);
            try {
                LogUtil.info(PayProcessor.class, (String)("payData=" + JSONUtils.toString((Object)payData)));
            }
            catch (IOException e) {
                logger.error("JSONUtils.toString(payData)\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
            }
            String notifyUrl = "";
            MiniPayResult miniPayResult = PayTradeHelper.getMiniPayData((CheckOutCounterInfo)payData, (BigDecimal)new BigDecimal(orderData.get("needPayAmount")), (long)paymode, (String)notifyUrl);
            LogUtil.info(PayProcessor.class, (String)("miniPayResult=" + JSON.toJSONString((Object)miniPayResult)));
            if (miniPayResult.getTradeStatus() == TradeStatus.SUCCESS) {
                ext.put("timeStamp", miniPayResult.getTimeStamp());
                ext.put("nonceStr", miniPayResult.getNonceStr());
                ext.put("package", miniPayResult.getPackages());
                ext.put("signType", miniPayResult.getSignType());
                ext.put("paySign", miniPayResult.getPaySign());
                ext.put("tradeStatus", miniPayResult.getTradeStatus().toString());
                ext.put("errorMessage", miniPayResult.getErrorMessage());
                ext.put("payResponse", miniPayResult.getPayResponse().toJSONString());
            } else {
                ext.put("tradeStatus", miniPayResult.getTradeStatus().toString());
                ext.put("errorMessage", miniPayResult.getErrorMessage());
            }
        }
        catch (Exception e) {
            ext.put("tradeStatus", TradeStatus.FAILED.toString());
            ext.put("errorMessage", "\u652f\u4ed8\u5931\u8d25");
            logger.error("invokeMiniPay\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
        }
        return ext;
    }

    public static JSONObject tradeQuery(long payModeId, Map<String, String> payConfig, String tradeNo) {
        String ayWayType;
        logger.info("tradeQuery\u65b9\u6cd5\u53c2\u6570:" + payModeId + "_" + tradeNo);
        JSONObject result = null;
        if (!CollectionUtils.isEmpty(payConfig) && (ayWayType = new PayProcessor().getPayWayType(payModeId)).equals(PayModeEnum.WeChatPayType.toString())) {
            result = WxPayTradeHelper.tradeQuery(payConfig, (String)"", (String)"", (String)tradeNo, (long)0L, (Date)new Date());
        }
        return result;
    }

    public JSONObject loopTradeQuery(long payModeId, Map<String, String> payConfig, String tradeNo, int loopTimes, int sleepMilliSeconds) {
        JSONObject queryResult = null;
        for (int i = 0; i < loopTimes; ++i) {
            if (i > 0) {
                PayUtil.sleep((long)sleepMilliSeconds);
            }
            JSONObject tradeQueryResponse = PayProcessor.tradeQuery(payModeId, payConfig, tradeNo);
            try {
                logger.info(JSONUtils.toString((Object)tradeQueryResponse));
            }
            catch (IOException e) {
                logger.error("loopTradeQuery\u65b9\u6cd5\u5e8f\u5217\u5316\u62a5\u9519" + e.getMessage());
            }
            if (tradeQueryResponse == null) continue;
            if (PayProcessor.stopQuery(tradeQueryResponse)) {
                return tradeQueryResponse;
            }
            queryResult = tradeQueryResponse;
        }
        return queryResult;
    }

    protected static boolean stopQuery(JSONObject response) {
        return "SUCCESS".equals(response.getString("return_code")) && "SUCCESS".equals(response.getString("result_code")) && ("SUCCESS".equals(response.getString("trade_state")) || "REVOKED".equals(response.getString("trade_state")) || "CLOSED".equals(response.getString("trade_state")) || "PAYERROR".equals(response.getString("trade_state")));
    }

    public String getPayWayType(long payModeId) {
        String payWayType = "";
        QFilter filter = new QFilter("id", "=", (Object)payModeId);
        DynamicObject payModePayWayType = BusinessDataServiceHelper.loadSingle((String)"ocdbd_paymode", (String)"paywaytype.number", (QFilter[])new QFilter[]{filter});
        if (payModePayWayType != null) {
            DynamicObject paywayType = (DynamicObject)payModePayWayType.getDynamicObjectCollection("paywaytype").get(0);
            if (paywayType != null) {
                payWayType = paywayType.getDynamicObject("fbasedataid").getString("number");
            }
        } else {
            logger.info("getPayWayType\u65b9\u6cd5\uff0c\u6ca1\u6709\u83b7\u5f97\u5230\u6570\u636e\uff0c\u53c2\u65701{0}", (Object)payModeId);
        }
        return payWayType;
    }

    public Map<String, String> getPayConfig(long payConfigId, long payModeId) {
        QFilter filter = new QFilter("id", "=", (Object)payConfigId);
        filter.and(new QFilter("entryentity.channel.id", "=", (Object)payModeId));
        DynamicObjectCollection payChannelDatas = QueryServiceHelper.query((String)"ocdbd_payconfigs", (String)"id,entryentity.id,entryentity.subentryentity.id,entryentity.subentryentity.paramkey,entryentity.subentryentity.paramvalue,entryentity.channel.id", (QFilter[])new QFilter[]{filter});
        HashMap<String, String> payConfig = new HashMap<String, String>(8);
        if (!CollectionUtils.isEmpty((Collection)payChannelDatas)) {
            for (DynamicObject payChannelData : payChannelDatas) {
                payConfig.put(payChannelData.getString("entryentity.subentryentity.paramkey"), payChannelData.getString("entryentity.subentryentity.paramvalue"));
            }
        } else {
            logger.info(String.format("getPayConfig\u65b9\u6cd5\uff0c\u6ca1\u6709\u83b7\u5f97\u5230\u6570\u636e\uff0cpayConfigId:%s,payModeId:%s", payConfigId, payModeId));
        }
        return payConfig;
    }

    public JSONObject tradeRefund(long payModeId, Map<String, String> payConfig, HashMap<String, String> refundData) {
        JSONObject refundResult = new JSONObject();
        String ayWayType = new PayProcessor().getPayWayType(payModeId);
        if (ayWayType.equals(PayModeEnum.WeChatPayType.toString())) {
            JSONObject refundResponse = this.WeChatPayRefund(payConfig, refundData);
            logger.info("refundResponse:" + refundResponse.toJSONString());
            if (refundResponse.getString("pay_status").equals(TradeStatus.SUCCESS.toString())) {
                refundResult.put("pay_status", (Object)TradeStatus.SUCCESS);
                refundResult.put("refund_fee", (Object)refundResponse.getString("refund_fee"));
                refundResult.put("transaction_id", (Object)refundResponse.getString("transaction_id"));
                refundResult.put("out_refund_no", (Object)refundResponse.getString("out_refund_no"));
                refundResult.put("refund_id", (Object)refundResponse.getString("refund_id"));
                refundResult.put("opera_time", (Object)refundData.get("operaTime"));
            } else {
                refundResult.put("pay_status", (Object)TradeStatus.FAILED);
            }
        }
        return refundResult;
    }

    private JSONObject WeChatPayRefund(Map<String, String> payConfig, HashMap<String, String> refundData) {
        String billNo = refundData.get("billNo");
        long operatorId = Long.parseLong(refundData.get("operatorId"));
        Date operaTime = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            operaTime = sdf.parse(refundData.get("operaTime"));
        }
        catch (ParseException e) {
            logger.error("\u8f6c\u6362\u65f6\u95f4\u683c\u53d1\u751f\u5f02\u5e38\uff0c\u8981\u8f6c\u6362\u7684\u65f6\u95f4:" + refundData.get("operaTime"));
        }
        RefundRequestParam refundRequestParam = new RefundRequestParam(payConfig, billNo, operatorId, operaTime);
        refundRequestParam.setTransactionId(refundData.get("transaction_id"));
        refundRequestParam.setOutRefundNo(refundData.get("out_refund_no"));
        refundRequestParam.setRefundFee(Integer.parseInt(refundData.get("refund_fee")));
        refundRequestParam.setTotalFee(Integer.parseInt(refundData.get("total_fee")));
        JSONObject refundResponse = WechatPayUtil.refund((RefundRequestParam)refundRequestParam);
        if (refundResponse == null) {
            refundResponse = new JSONObject();
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
            return refundResponse;
        }
        try {
            logger.info("refundResponse:" + JSONUtils.toString((Object)refundResponse));
        }
        catch (IOException e) {
            logger.error("refundResponse\u65b9\u6cd5\u5e8f\u5217\u5316\u62a5\u9519" + e.getMessage());
        }
        refundResponse.put("trade_no", (Object)refundResponse.getString("refund_id"));
        if ("FAIL".equals(refundResponse.getString("return_code"))) {
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
        } else if ("FAIL".equals(refundResponse.getString("result_code"))) {
            refundResponse.put("pay_status", (Object)TradeStatus.FAILED);
        } else {
            refundResponse.put("pay_status", (Object)TradeStatus.SUCCESS);
        }
        return refundResponse;
    }
}

