/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.member.AddressHelper;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class AddressMobListPlugin
extends ExtBillViewPlugin {
    private long selectedAddressId = 0L;
    private static final String itementrys = "addresslist";

    public boolean initView(InitViewEvent initViewEvent) {
        DataGrid dataGrid = (DataGrid)((ExtBillView)this.getView()).getControl(itementrys);
        long scene = initViewEvent.getCustomParam().getLong("scene");
        if (scene == 0L) {
            dataGrid.setSelectBox("false");
        }
        return true;
    }

    public void afterDataLoad(LoadDataEvent event) {
        long scene = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("scene");
        this.selectedAddressId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("addressid");
        ((BillFormData)this.getBillData()).updateValue("scene", (Object)scene);
        if (scene == 2L) {
            long orderno = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("orderno");
            ((BillFormData)this.getBillData()).updateValue("orderno", (Object)orderno);
            long opid = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("opid");
            ((BillFormData)this.getBillData()).updateValue("opid", (Object)opid);
            long aftertype = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("aftertype");
            ((BillFormData)this.getBillData()).updateValue("aftertype", (Object)aftertype);
            long returnreason = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("returnreason");
            ((BillFormData)this.getBillData()).updateValue("returnreason", (Object)returnreason);
            String returncomment = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getString("returncomment");
            ((BillFormData)this.getBillData()).updateValue("returncomment", (Object)returncomment);
            String qtys = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getString("qtys");
            ((BillFormData)this.getBillData()).updateValue("qtys", (Object)qtys);
        }
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        this.bindAddressList(memberId, this.selectedAddressId);
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "edit": {
                long addressId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                long scene = ((BillFormData)this.getBillData()).getLong("scene");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("id", String.valueOf(addressId));
                openParam.addCustomParam("scene", String.valueOf(scene));
                this.createBuyNowParam(openParam);
                openParam.setViewId("ocolsm_addressadd");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "add": {
                JSONArray items;
                long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                JSONObject addresses = AddressHelper.getAddresses((Long)memberId);
                if (addresses.get((Object)"code").toString().equals("0") && (items = addresses.getJSONArray("data")).size() >= 20) {
                    ((ExtBillView)this.view).showMessage("\u5df2\u670920\u6761\u5730\u5740\u636e\uff0c\u4e0d\u80fd\u518d\u65b0\u52a0");
                    return;
                }
                long scene = ((BillFormData)this.getBillData()).getLong("scene");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("scene", String.valueOf(scene));
                this.createBuyNowParam(openParam);
                openParam.setViewId("ocolsm_addressadd");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "delete": {
                long addressId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                this.delete(addressId);
                break;
            }
            case "setdefault": {
                long addressId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                DynamicObject obj = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                ExtDynamicObject address = new ExtDynamicObject();
                address.put("addressid", (Object)obj.getLong("addressid"));
                address.put("isdefaultaddr", (Object)Boolean.TRUE);
                address.put("addrtypeid", (Object)obj.getLong("addresstypeid"));
                this.setDefault(address);
                break;
            }
            case "rowclick": {
                long addressId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                this.RowSelected(currentRow);
                break;
            }
        }
        super.onClick(event);
    }

    protected void onRowSelected(SelectAllEvent event) {
        DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
        this.RowSelected(currentRow);
        super.onRowSelected(event);
    }

    private void RowSelected(DynamicObject currentRow) {
        long id = currentRow.getLong("id");
        String linkman = currentRow.getString("linkman");
        String linkphone = currentRow.getString("linkphone");
        String address = currentRow.getString("address");
        String streetdetail = currentRow.getString("streetdetail");
        String streetdetailids = currentRow.getString("streetdetailids");
        String countryid = currentRow.getString("countryid");
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        long scene = ((BillFormData)this.getBillData()).getLong("scene");
        if (scene == 1L) {
            this.createBuyNowParam(openParam);
            openParam.setViewId("ocolsm_checkout");
        } else if (scene == 2L) {
            long orderno = ((BillFormData)this.getBillData()).getLong("orderno");
            long opid = ((BillFormData)this.getBillData()).getLong("opid");
            long aftertype = ((BillFormData)this.getBillData()).getLong("aftertype");
            long returnreason = ((BillFormData)this.getBillData()).getLong("returnreason");
            String returncomment = ((BillFormData)this.getBillData()).getString("returncomment");
            String qtys = ((BillFormData)this.getBillData()).getString("qtys");
            openParam.setViewId("ocolsm_applyforaftersales");
            openParam.addCustomParam("orderno", String.valueOf(orderno));
            openParam.addCustomParam("opid", String.valueOf(opid));
            openParam.addCustomParam("aftertype", String.valueOf(aftertype));
            openParam.addCustomParam("returnreason", String.valueOf(returnreason));
            openParam.addCustomParam("returncomment", returncomment);
            openParam.addCustomParam("qtys", qtys);
        } else {
            long addressId = currentRow.getLong("id");
            openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.addCustomParam("id", String.valueOf(addressId));
            openParam.addCustomParam("scene", String.valueOf(scene));
            this.createBuyNowParam(openParam);
            openParam.setViewId("ocolsm_addressadd");
            ((ExtBillView)this.getView()).showView(openParam);
        }
        openParam.addCustomParam("addressid", String.valueOf(id));
        openParam.addCustomParam("linkman", linkman);
        openParam.addCustomParam("linkphone", linkphone);
        openParam.addCustomParam("address", address);
        openParam.addCustomParam("streetdetail", streetdetail);
        openParam.addCustomParam("streetdetailids", streetdetailids);
        openParam.addCustomParam("countryid", countryid);
        ((ExtBillView)this.getView()).showView(openParam);
    }

    private void bindAddressList(long memberId, long selectedAddressId) {
        JSONObject addresses = AddressHelper.getAddresses((Long)memberId);
        if (addresses.get((Object)"code").toString().equals("0")) {
            JSONArray items = addresses.getJSONArray("data");
            ArrayList lstRowSelectionStatus = new ArrayList();
            if (items != null && items.size() > 0) {
                Object item;
                int size = items.size();
                HashSet<Long> setDistrictId = new HashSet<Long>();
                for (int i = 0; i < size; ++i) {
                    item = items.getJSONObject(i);
                    setDistrictId.add(item.getLong("districtId"));
                }
                ArrayList<ExtDynamicObject> lstFullDivision = new ArrayList<ExtDynamicObject>();
                item = setDistrictId.iterator();
                while (item.hasNext()) {
                    long id = (Long)item.next();
                    lstFullDivision.add(AddressHelper.getFullDivision((long)id));
                }
                LogUtil.error(AddressMobListPlugin.class, (String)("lstFullDivision=" + JsonUtil.toString(lstFullDivision)));
                Map mapFullDivision = lstFullDivision.stream().collect(Collectors.groupingBy(r -> r.getLong("id"), Collectors.toList()));
                LogUtil.error(AddressMobListPlugin.class, (String)("mapFullDivision=" + JsonUtil.toString(mapFullDivision)));
                for (int i = 0; i < size; ++i) {
                    JSONObject item2 = items.getJSONObject(i);
                    DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                    dataObject.set("linkman", (Object)item2.getString("contact"));
                    dataObject.set("mobile", (Object)StringUtil.mobileNumberPartHide((String)item2.getString("phone")));
                    if (item2.getBoolean("defaultAddress").booleanValue()) {
                        dataObject.set("isdefault", (Object)"\u9ed8\u8ba4");
                        ((ExtBillView)this.view).hide("isdefault", false, i);
                    }
                    dataObject.set("id", (Object)item2.getLong("id"));
                    dataObject.set("addressid", (Object)item2.getLong("id"));
                    dataObject.set("addresstypeid", (Object)item2.getLong("addressTypeId"));
                    dataObject.set("districtid", (Object)item2.getLong("districtId"));
                    dataObject.set("linkphone", (Object)item2.getString("phone"));
                    dataObject.set("address", (Object)item2.getString("detailedAddress"));
                    ExtDynamicObject region = (ExtDynamicObject)mapFullDivision.get(item2.getLong("districtId")).get(0);
                    dataObject.set("streetdetail", (Object)(region.getString("fullname").replaceAll("_", "") + item2.getString("detailedAddress")));
                    dataObject.set("streetdetailids", (Object)region.getString("fullids"));
                    dataObject.set("countryid", (Object)region.getString("countryid"));
                    ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
                }
                if (lstRowSelectionStatus.size() > 0) {
                    ((ExtBillView)this.view).setRowSelection(itementrys, lstRowSelectionStatus);
                }
            } else {
                ((ExtBillView)this.view).hide(itementrys, true);
                ((ExtBillView)this.view).hide("isempty", false);
            }
        } else {
            String message = addresses.get((Object)"message").toString();
            ((ExtBillView)this.view).showMessage(message);
        }
    }

    private void setDefault(ExtDynamicObject address) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject jsonResult = AddressHelper.updateAddress((Long)memberId, (ExtDynamicObject)address);
        if (jsonResult.get((Object)"code").toString().equals("0")) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            long scene = ((BillFormData)this.getBillData()).getLong("scene");
            if (scene > 0L) {
                openParam.addCustomParam("scene", ((BillFormData)this.getBillData()).getString("scene"));
                this.createBuyNowParam(openParam);
            }
            openParam.setViewId("ocolsm_addresslist");
            ((ExtBillView)this.getView()).showView(openParam);
        } else {
            String message = jsonResult.get((Object)"message").toString();
            ((ExtBillView)this.view).showMessage(message);
        }
    }

    private void delete(long addressId) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        JSONObject jsonResult = AddressHelper.deleteAddress((Long)memberId, (Long)addressId);
        if (jsonResult.get((Object)"code").toString().equals("0")) {
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            long scene = ((BillFormData)this.getBillData()).getLong("scene");
            if (scene > 0L) {
                openParam.addCustomParam("scene", ((BillFormData)this.getBillData()).getString("scene"));
                this.createBuyNowParam(openParam);
            }
            openParam.setViewId("ocolsm_addresslist");
            ((ExtBillView)this.getView()).showView(openParam);
        } else {
            ((ExtBillView)this.view).showMessage(jsonResult.get((Object)"message").toString());
        }
    }

    public void createBuyNowParam(OpenParam openParam) {
        String itemId = ObjectUtil.toString((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("itemid"));
        String auxpropId = ObjectUtil.toString((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("auxpropid"));
        String qty = ObjectUtil.toString((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("qty"));
        if (StringUtil.isNotEmpty((String)itemId)) {
            openParam.addCustomParam("itemid", itemId);
            openParam.addCustomParam("auxpropid", auxpropId);
            openParam.addCustomParam("qty", qty);
        }
    }
}

