/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.RowSelectionStatus;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.cart.CartHelper;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.common.util.BigDecimalUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class CartMobEditPlugin
extends ExtBillViewPlugin {
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private static final String itementrys = "goodslist";

    public void afterDataLoad(LoadDataEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        List lstItemDetail = CartHelper.getCartItemDetails((long)this.channelCache.getLong("channelid.id"), (long)memberId, (boolean)false);
        if (lstItemDetail.size() > 0) {
            ((ExtBillView)this.view).hide("isnotempty", false);
            ((ExtBillView)this.view).hide("isempty", true);
            ArrayList<RowSelectionStatus> lstRowSelectionStatus = new ArrayList<RowSelectionStatus>();
            int rowIndex = 0;
            for (JSONObject item : lstItemDetail) {
                if (item.getString("ischecked").equals("1")) {
                    RowSelectionStatus rowSelectionStatus = new RowSelectionStatus(rowIndex, true);
                    lstRowSelectionStatus.add(rowSelectionStatus);
                }
                DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                dataObject.set("id", (Object)item.getLong("id"));
                dataObject.set("pspuid", (Object)item.getLong("pspuid"));
                dataObject.set("itemname", (Object)item.getString("itemname"));
                dataObject.set("itemid", (Object)item.getLong("itemid"));
                dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.getString("thumbnail")));
                dataObject.set("qty", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("qty"), (int)0));
                dataObject.set("price", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("memberprice"), (int)2));
                dataObject.set("signprice", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("memberprice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                BigDecimal amount = BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("memberprice").multiply(item.getBigDecimal("qty")), (int)2);
                dataObject.set("amount", (Object)amount);
                ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
                ++rowIndex;
            }
            if (lstRowSelectionStatus.size() > 0) {
                ((ExtBillView)this.view).setRowSelection(itementrys, lstRowSelectionStatus);
            } else {
                ((ExtBillView)this.view).disable("buy", true);
                ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            }
        } else {
            ((ExtBillView)this.view).hide("isnotempty", true);
            ((ExtBillView)this.view).hide("isempty", false);
            ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        }
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "delitem": {
                Long id = Long.parseLong((String)event.getCurrentRow().getPkValue());
                ArrayList<Long> lstCartId = new ArrayList<Long>();
                lstCartId.add(id);
                long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                CartHelper.deleteCartByIds((long)memberId, lstCartId);
                ((ExtBillView)this.view).refresh();
                break;
            }
            case "buy": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocolsm_checkout");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "goindex": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setViewId("ocolsm_index");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "thumbnail": 
            case "itemname": {
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocolsm_productmobdetail");
                openParam.addCustomParam("itemid", currentRow.getString("itemid"));
                openParam.addCustomParam("spuid", currentRow.getString("pspuid"));
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtBillView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        switch (eventId = event.getId()) {
            case "qty": {
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getRow());
                BigDecimal price = currentRow.getBigDecimal("price");
                BigDecimal qty = new BigDecimal(String.valueOf(event.getValue()));
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    qty = new BigDecimal("1");
                    ((BillFormData)this.getBillData()).updateValue("qty", event.getRow(), (Object)"1");
                }
                BigDecimal amount = BigDecimalUtil.setScale((BigDecimal)price.multiply(qty), (int)2);
                ((BillFormData)this.getBillData()).updateValue("amount", event.getRow(), (Object)amount);
                CartHelper.updateCartQtyById((long)memberId, (long)currentRow.getLong("id"), (BigDecimal)qty);
                List selectRows = event.getSelections(itementrys);
                DynamicObjectCollection dataList = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, selectRows);
                this.countTotalQtyAndAmount((List<DynamicObject>)dataList);
                break;
            }
        }
    }

    protected void onRowSelected(SelectAllEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        List selectRows = event.getSelections(itementrys);
        List lstCartId = selectRows.stream().map(r -> Long.parseLong(r.getPkValue().toString())).collect(Collectors.toList());
        CartHelper.updateCartCheckedByIds((long)memberId, lstCartId, (boolean)true);
        DynamicObjectCollection selectDatas = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, selectRows);
        this.countTotalQtyAndAmount((List<DynamicObject>)selectDatas);
        super.onRowSelected(event);
    }

    protected void onRowSelectedAll(SelectAllEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        boolean isSelectAll = ((BillFormData)this.getBillData()).getBoolean("allselect");
        if (isSelectAll) {
            DynamicObjectCollection dataList = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
            this.countTotalQtyAndAmount((List<DynamicObject>)dataList);
        } else {
            this.countTotalQtyAndAmount(null);
        }
        CartHelper.updateCartCheckedByIds((long)memberId, null, (boolean)isSelectAll);
        super.onRowSelectedAll(event);
    }

    private void countTotalQtyAndAmount(List<DynamicObject> dataList) {
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2);
        if (dataList != null && dataList.size() > 0) {
            for (DynamicObject data : dataList) {
                totalQty = totalQty.add(data.getBigDecimal("qty"));
                totalAmount = totalAmount.add(data.getBigDecimal("amount"));
            }
        }
        ((BillFormData)this.getBillData()).updateValue("totalamount", (Object)StringUtil.setSign((BigDecimal)totalAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        if (totalQty.compareTo(new BigDecimal("99")) > 0) {
            ((ExtBillView)this.view).updateControlName("buy", "\u53bb\u7ed3\u7b97\uff0899+\uff09");
        } else {
            ((ExtBillView)this.view).updateControlName("buy", "\u53bb\u7ed3\u7b97\uff08" + BigDecimalUtil.setScale((BigDecimal)totalQty, (int)0) + "\uff09");
        }
        if (totalAmount == BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2)) {
            ((ExtBillView)this.view).disable("buy", true);
        } else {
            ((ExtBillView)this.view).disable("buy", false);
        }
    }
}

