/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.LevelMenuEntity;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LevelClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;

public class CategoryAllPlugin
extends ExtBillViewPlugin {
    public DynamicObject onDataLoad(LoadDataEvent event) {
        super.onDataLoad(event);
        List<LevelMenuEntity> menus = this.getItemClasses(event);
        ExtDynamicObject data = new ExtDynamicObject();
        data.put("allgoodsclass", menus);
        ((ExtBillView)this.getView()).bindData((Object)data);
        event.setPreventDefault(true);
        return null;
    }

    private List<LevelMenuEntity> getItemClasses(LoadDataEvent event) {
        ArrayList<LevelMenuEntity> itemClasses = new ArrayList<LevelMenuEntity>();
        QFilter qfilter = new QFilter("applyplatform", "=", (Object)"7");
        DynamicObjectCollection colClassStandId = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ClassstandardApplyService", (String)"query", (Object[])new Object[]{"classstandardid", new QFilter[]{qfilter}});
        if (colClassStandId.size() > 0) {
            long classStandId = ((DynamicObject)colClassStandId.get(0)).getLong("classstandardid");
            qfilter = new QFilter("standard", "=", (Object)classStandId);
            qfilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            String filterField = "id,number,name,parent.id,level,picture";
            DynamicObjectCollection classEntitys = (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"gmc", (String)"ItemClassService", (String)"query", (Object[])new Object[]{filterField, new QFilter[]{qfilter}});
            if (classEntitys != null && classEntitys.size() > 0) {
                Map levelItemClassesMap = classEntitys.stream().map(r -> {
                    LevelMenuEntity exData = new LevelMenuEntity();
                    exData.setId(r.getString("id"));
                    exData.setKey(r.getString("number"));
                    exData.setName(r.getString("name"));
                    exData.setParent(r.getString("parent.id"));
                    exData.setLevel(r.getString("level"));
                    exData.setIcon(PictureUtil.getFileServerUrl() + r.getString("picture"));
                    return exData;
                }).collect(Collectors.groupingBy(r -> r.getLevel(), Collectors.toList()));
                List<LevelMenuEntity> level1ItemClasses = levelItemClassesMap.get("1");
                List<LevelMenuEntity> level2ItemClasses = levelItemClassesMap.get("2");
                List<LevelMenuEntity> level3ItemClasses = levelItemClassesMap.get("3");
                if (level3ItemClasses != null && level2ItemClasses != null) {
                    Map<Object, List<LevelMenuEntity>> level3ItemClassesMap = this.getChildrenMap(level3ItemClasses, 3);
                    level2ItemClasses.forEach(r -> r.setChildren((List)level3ItemClassesMap.get(r.getId())));
                }
                if (level2ItemClasses != null && level1ItemClasses != null) {
                    Map<Object, List<LevelMenuEntity>> level2ItemClassesMap = this.getChildrenMap(level2ItemClasses, 2);
                    level1ItemClasses.forEach(r -> r.setChildren((List)level2ItemClassesMap.get(r.getId())));
                }
                if (level1ItemClasses != null) {
                    itemClasses.addAll(level1ItemClasses);
                }
            }
        }
        return itemClasses;
    }

    private Map<Object, List<LevelMenuEntity>> getChildrenMap(List<LevelMenuEntity> levelItemClasses, int level) {
        Map<Object, List<LevelMenuEntity>> levelItemClassesMap = levelItemClasses.stream().collect(Collectors.groupingBy(r -> r.getParent(), Collectors.toList()));
        return levelItemClassesMap;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "allgoodsclass": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_productmoblist");
                openParam.addCustomParam("classId", event.getPkValue().toString());
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    public void onLevelClick(LevelClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "allgoodsclass": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_productmoblist");
                openParam.addCustomParam("classId", event.getPkValue().toString());
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick((ClickEvent)event);
    }
}

