/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.pojo.dto.member.rule.QueryPointCostRuleDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserByIdDTO;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Radio;
import kd.occ.ocepfp.core.form.control.controls.RadioGroup;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ConfirmPopDataEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.LoadPopPanelDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.cart.CartHelper;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.AddressHelper;
import kd.occ.ocolsm.business.member.MemberHelper;
import kd.occ.ocolsm.common.util.BigDecimalUtil;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.RegExUtil;
import kd.occ.ocolsm.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class CheckoutMobEditPlugin
extends ExtBillViewPlugin {
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private long channelId = this.channelCache.getLong("channelid.id");
    private DynamicObject mallInfoCache = ConfigHelper.getMallInfoCache();
    private static final String itementrys = "goodslist";
    private BigDecimal itemTotalAmount = BigDecimal.ZERO;
    private BigDecimal shipAmount = BigDecimal.ZERO;
    private BigDecimal discountPrice = BigDecimal.ZERO;
    private BigDecimal couponAmount = BigDecimal.ZERO;
    private BigDecimal apAmount = BigDecimal.ZERO;
    private BigDecimal scoreAmount = BigDecimal.ZERO;
    private long addressId = 0L;
    private String linkman = "";
    private String linkphone = "";
    private Long countryId = 0L;
    private Long provinceId = 0L;
    private Long cityId = 0L;
    private Long districtId = 0L;
    private String address = "";
    private String streetdetail = "";
    private String note = "";
    private Long payTypeId = 0L;
    private Long shippingId = 0L;
    private int scoreType = 1;

    public boolean initView(InitViewEvent initViewEvent) {
        DynamicObjectCollection payType = CartHelper.getPaymentType((long)this.channelId);
        RadioGroup pg = (RadioGroup)((ExtBillView)this.view).getControl("paytypegroup");
        for (DynamicObject item : payType) {
            Radio r = new Radio();
            r.setId(item.getString("id"));
            r.setName(item.getString("name"));
            r.setValue((Object)item.getString("id"));
            pg.addChild((Object)r);
        }
        DynamicObjectCollection shipping = CartHelper.getShipping((long)this.channelId);
        RadioGroup sg = (RadioGroup)((ExtBillView)this.view).getControl("shippinggroup");
        for (DynamicObject item : shipping) {
            Radio r = new Radio();
            r.setId(item.getString("id"));
            r.setName(item.getString("name"));
            r.setValue((Object)item.getString("id"));
            sg.addChild((Object)r);
        }
        return false;
    }

    public void onLoadPopPanelData(LoadPopPanelDataEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "invoicediv": {
                this.initInvoiceDiv();
                break;
            }
            case "scorediv": {
                int scoretype = ((BillFormData)this.getBillData()).getInt("scoregroup");
                if (scoretype != 0) break;
                ((BillFormData)this.getBillData()).updateValue("scoregroup", (Object)"2");
            }
        }
    }

    public void onConfirmPopData(ConfirmPopDataEvent event) {
        String eventId = event.getId();
        event.setPreventDefault(true);
        switch (eventId) {
            case "paytypediv": {
                this.payTypeConfirm();
                break;
            }
            case "shippingdiv": {
                this.shippingConfirm();
                break;
            }
            case "invoicediv": {
                this.invoiceConfirm();
                break;
            }
            case "scorediv": {
                this.scoreConfirm();
                break;
            }
            case "itemlistdiv": {
                ((ExtBillView)this.view).closePopPanel("itemlistdiv");
            }
        }
    }

    public void afterDataLoad(LoadDataEvent event) {
        RadioGroup gp = (RadioGroup)((ExtBillView)this.view).getControl("paytypegroup");
        List lstRadio = gp.getChilds();
        if (lstRadio.size() > 0) {
            this.payTypeId = ObjectUtil.toLong((Object)((Control)lstRadio.get(0)).getValue());
            String payTypeName = gp.getRadioByValue(String.valueOf(this.payTypeId)).getName();
            ((BillFormData)this.getBillData()).updateValue("paytypegroup", (Object)String.valueOf(this.payTypeId));
            ((BillFormData)this.getBillData()).updateValue("paytypeid", (Object)this.payTypeId);
            ((BillFormData)this.getBillData()).updateValue("showpaytypediv", (Object)payTypeName);
        }
        if ((lstRadio = (gp = (RadioGroup)((ExtBillView)this.view).getControl("shippinggroup")).getChilds()).size() > 0) {
            this.shippingId = ObjectUtil.toLong((Object)((Control)lstRadio.get(0)).getValue());
            String shippingName = gp.getRadioByValue(String.valueOf(this.shippingId)).getName();
            ((BillFormData)this.getBillData()).updateValue("shippinggroup", (Object)String.valueOf(this.shippingId));
            ((BillFormData)this.getBillData()).updateValue("shippingid", (Object)this.shippingId);
            ((BillFormData)this.getBillData()).updateValue("showshippingdiv", (Object)shippingName);
        }
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        ((BillFormData)this.getBillData()).updateValue("mallname", (Object)this.channelCache.getString("channelid.name"));
        ((BillFormData)this.getBillData()).updateValue("itemtotalamount", (Object)BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2));
        ((BillFormData)this.getBillData()).updateValue("shipamount", (Object)BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2));
        ((BillFormData)this.getBillData()).updateValue("discountamount", (Object)BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2));
        ((BillFormData)this.getBillData()).updateValue("couponamount", (Object)BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2));
        ((BillFormData)this.getBillData()).updateValue("scoreamount", (Object)BigDecimalUtil.setScale((BigDecimal)BigDecimal.ZERO, (int)2));
        ((BillFormData)this.getBillData()).updateValue("showitemtotalamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("showshipamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("showdiscountamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("showcouponamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("showscoreamount", (Object)StringUtil.setSign((BigDecimal)BigDecimal.ZERO, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        this.bindAddress(memberId);
        int productCount = this.bindItem(memberId);
        if (productCount <= 0) {
            ((ExtBillView)this.view).showMessage("\u4f60\u8fd8\u6ca1\u6709\u9009\u62e9\u5546\u54c1\u54e6");
            return;
        }
        this.addressId = ((BillFormData)this.getBillData()).getLong("addressid");
        if (this.addressId > 0L) {
            ((BillFormData)this.getBillData()).updateValue("selectaddress", (Object)" ");
        }
        long shippingId = ((BillFormData)this.getBillData()).getLong("shippingid");
        if (this.addressId > 0L && shippingId > 0L) {
            DynamicObjectCollection colItemDetail = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
            long cityId = ((BillFormData)this.getBillData()).getLong("cityid");
            DynamicObject cityFreight = CartHelper.GetCityFreight((long)this.channelId, (long)shippingId, (long)cityId);
            this.shipAmount = CartHelper.GetShipAmount((DynamicObject)cityFreight, (DynamicObjectCollection)colItemDetail);
            ((BillFormData)this.getBillData()).updateValue("shipamount", (Object)String.valueOf(this.shipAmount));
            if (this.shipAmount.compareTo(BigDecimal.ZERO) > 0) {
                ((BillFormData)this.getBillData()).updateValue("showshipamount", (Object)("+" + StringUtil.setSign((BigDecimal)this.shipAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
            } else {
                ((BillFormData)this.getBillData()).updateValue("showshipamount", (Object)StringUtil.setSign((BigDecimal)this.shipAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            }
        }
        ((BillFormData)this.getBillData()).updateValue("itemtotalamount", (Object)BigDecimalUtil.setScale((BigDecimal)this.itemTotalAmount, (int)2));
        ((BillFormData)this.getBillData()).updateValue("showitemtotalamount", (Object)StringUtil.setSign((BigDecimal)this.itemTotalAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        this.updateTotalAmount();
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "showaddress": 
            case "selectaddress": {
                this.addressId = ((BillFormData)this.getBillData()).getLong("addressid");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("scene", "1");
                long itemId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("itemid"));
                if (itemId > 0L) {
                    long auxpropId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("auxpropid"));
                    long qty = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("qty"));
                    openParam.addCustomParam("itemid", String.valueOf(itemId));
                    openParam.addCustomParam("auxpropid", String.valueOf(auxpropId));
                    openParam.addCustomParam("qty", String.valueOf(qty));
                }
                openParam.addCustomParam("addressid", String.valueOf(this.addressId));
                openParam.setViewId("ocolsm_addresslist");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "createorder": {
                this.createOrder();
                break;
            }
        }
        super.onClick(event);
    }

    protected void updateTotalAmount() {
        this.itemTotalAmount = ((BillFormData)this.getBillData()).getBigDecimal("itemtotalamount");
        this.shipAmount = ((BillFormData)this.getBillData()).getBigDecimal("shipamount");
        this.discountPrice = ((BillFormData)this.getBillData()).getBigDecimal("discountamount");
        this.couponAmount = ((BillFormData)this.getBillData()).getBigDecimal("couponamount");
        this.scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
        this.apAmount = BigDecimalUtil.setScale((BigDecimal)this.itemTotalAmount.add(this.shipAmount).subtract(this.discountPrice).subtract(this.couponAmount).subtract(this.scoreAmount), (int)2);
        ((BillFormData)this.getBillData()).updateValue("apamount", (Object)String.valueOf(this.apAmount));
        ((BillFormData)this.getBillData()).updateValue("showapamount", (Object)StringUtil.setSign((BigDecimal)this.apAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        this.queryPointCostRule();
        if (this.discountPrice.compareTo(BigDecimal.ONE) <= 0) {
            ((ExtBillView)this.view).hide("discountamountdiv", true);
        } else {
            ((ExtBillView)this.view).hide("discountamountdiv", false);
        }
        if (this.couponAmount.compareTo(BigDecimal.ONE) <= 0) {
            ((ExtBillView)this.view).hide("couponamountdiv", true);
        } else {
            ((ExtBillView)this.view).hide("couponamountdiv", false);
        }
        if (this.scoreAmount.compareTo(BigDecimal.ONE) <= 0) {
            ((ExtBillView)this.view).hide("scoreamountdiv", true);
        } else {
            ((ExtBillView)this.view).hide("scoreamountdiv", false);
        }
    }

    protected void bindAddress(long memberId) {
        SimpleMap mapCustomParam = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam();
        this.addressId = mapCustomParam.getLong("addressid");
        if (this.addressId > 0L) {
            String linkman = mapCustomParam.getString("linkman");
            String linkphone = mapCustomParam.getString("linkphone");
            String address = mapCustomParam.getString("address");
            String streetdetail = mapCustomParam.getString("streetdetail");
            String streetdetailids = mapCustomParam.getString("streetdetailids");
            String countryid = mapCustomParam.getString("countryid");
            ((BillFormData)this.getBillData()).updateValue("addressid", (Object)this.addressId);
            ((BillFormData)this.getBillData()).updateValue("linkman", (Object)linkman);
            ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)linkphone);
            ((BillFormData)this.getBillData()).updateValue("mobile", (Object)StringUtil.mobileNumberPartHide((String)linkphone));
            ((BillFormData)this.getBillData()).updateValue("address", (Object)address);
            ((BillFormData)this.getBillData()).updateValue("streetdetail", (Object)streetdetail);
            ((BillFormData)this.getBillData()).updateValue("streetdetailids", (Object)streetdetailids);
            ((BillFormData)this.getBillData()).updateValue("provinceid", (Object)streetdetailids.split("_")[0]);
            ((BillFormData)this.getBillData()).updateValue("cityid", (Object)streetdetailids.split("_")[1]);
            ((BillFormData)this.getBillData()).updateValue("districtid", (Object)streetdetailids.split("_")[2]);
            ((BillFormData)this.getBillData()).updateValue("countryid", (Object)countryid);
        } else {
            ExtDynamicObject region;
            JSONObject item;
            long districtId;
            JSONArray items;
            JSONObject addresses = AddressHelper.getDefalutAddress((long)memberId);
            if (addresses.get((Object)"code").toString().equals("0") && (items = addresses.getJSONArray("data")) != null && items.size() > 0 && (districtId = (item = items.getJSONObject(0)).getLong("districtId").longValue()) > 0L && (region = AddressHelper.getFullDivision((long)districtId)).getLong("id") > 0L) {
                ((BillFormData)this.getBillData()).updateValue("addressid", (Object)item.getLong("id"));
                ((BillFormData)this.getBillData()).updateValue("linkman", (Object)item.getString("contact"));
                ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)item.getString("phone"));
                ((BillFormData)this.getBillData()).updateValue("districtid", (Object)item.getLong("districtId"));
                ((BillFormData)this.getBillData()).updateValue("mobile", (Object)StringUtil.mobileNumberPartHide((String)item.getString("phone")));
                ((BillFormData)this.getBillData()).updateValue("address", (Object)item.getString("detailedAddress"));
                ((BillFormData)this.getBillData()).updateValue("streetdetail", (Object)(region.getString("fullname").replaceAll("_", "") + item.getString("detailedAddress")));
                String fullids = region.getString("fullids");
                ((BillFormData)this.getBillData()).updateValue("streetdetailids", (Object)region.getString("fullids"));
                ((BillFormData)this.getBillData()).updateValue("provinceid", (Object)fullids.split("_")[0]);
                ((BillFormData)this.getBillData()).updateValue("cityid", (Object)fullids.split("_")[1]);
                ((BillFormData)this.getBillData()).updateValue("countryid", (Object)region.getString("countryid"));
            }
        }
    }

    protected int bindItem(long memberId) {
        List lstItemDetail = new ArrayList();
        long itemId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("itemid"));
        if (itemId == 0L) {
            lstItemDetail = CartHelper.getCartItemDetails((long)this.channelId, (long)memberId, (boolean)true);
        } else {
            long auxpropId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("auxpropid"));
            long qty = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("qty"));
            long spuid = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("spuid"));
            lstItemDetail = CartHelper.getBuyNowItemDetails((long)this.channelId, (long)itemId, (long)auxpropId, (long)spuid, (long)qty);
        }
        int count = lstItemDetail.size();
        ArrayList<ImgObject> lstImg = new ArrayList<ImgObject>();
        BigDecimal totalQty = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            JSONObject item = (JSONObject)lstItemDetail.get(i);
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            dataObject.set("cartid", (Object)item.getLong("id"));
            dataObject.set("itemname", (Object)item.getString("itemname"));
            dataObject.set("itemid", (Object)item.getLong("itemid"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.getString("thumbnail")));
            dataObject.set("multiply", (Object)"\u00d7");
            dataObject.set("qty", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("qty"), (int)0));
            dataObject.set("price", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("memberprice"), (int)2));
            dataObject.set("showprice", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("memberprice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            dataObject.set("weight", (Object)(item.getBigDecimal("grossweight").compareTo(BigDecimal.ZERO) > 0 ? item.getBigDecimal("grossweight") : item.getBigDecimal("volume")));
            dataObject.set("volume", (Object)item.getBigDecimal("volume"));
            dataObject.set("freightType", (Object)(item.getBigDecimal("grossweight").compareTo(BigDecimal.ZERO) > 0 ? 1 : 2));
            BigDecimal amount = BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("memberprice").multiply(item.getBigDecimal("qty")), (int)2);
            dataObject.set("amount", (Object)amount);
            this.itemTotalAmount = this.itemTotalAmount.add(amount);
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
            if (i < 3) {
                ImgObject img = new ImgObject();
                img.setWidth("60");
                img.setHeight("60");
                img.setId("img" + item.getLong("itemid"));
                img.setSrc(PictureUtil.getFileServerUrl() + item.getString("thumbnail"));
                lstImg.add(img);
            }
            totalQty = totalQty.add(dataObject.getBigDecimal("qty"));
        }
        ((BillFormData)this.getBillData()).updateImgGroup("itemimggroup", lstImg);
        ((BillFormData)this.getBillData()).updateValue("showitemlistdiv", (Object)("\u5171" + totalQty + "\u4ef6"));
        return count;
    }

    protected void promotionRule(List<ExtDynamicObject> lstItemPrice) {
        int size = lstItemPrice.size();
        BigDecimal discountPrice = new BigDecimal("20");
        for (int i = 0; i < size; ++i) {
            ExtDynamicObject item = lstItemPrice.get(i);
            item.put("discountPrice", (Object)BigDecimalUtil.setScale((BigDecimal)discountPrice.multiply(item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).divide(this.itemTotalAmount, 8, 4)), (int)2));
            item.put("priceDiscount", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("discountPrice").divide(item.getBigDecimal("qty"), 8, 4), (int)2));
            item.put("taxPriceTatol", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("taxPriceTatol").subtract(item.getBigDecimal("discountPrice")), (int)2));
            item.put("price", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("unitPrice").multiply(item.getBigDecimal("qty")).subtract(item.getBigDecimal("discountPrice")), (int)2));
        }
    }

    protected void createOrder() {
        OperationResult result;
        String errorMsg = "";
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        List<JSONObject> lstItemDetail = new ArrayList();
        long itemId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("itemid"));
        if (itemId == 0L) {
            lstItemDetail = CartHelper.getCartItemDetails((long)this.channelId, (long)memberId, (boolean)true);
        } else {
            long auxpropId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("auxpropid"));
            long qty = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("qty"));
            long spuid = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("spuid"));
            lstItemDetail = CartHelper.getBuyNowItemDetails((long)this.channelId, (long)itemId, (long)auxpropId, (long)spuid, (long)qty);
        }
        String string = errorMsg = lstItemDetail.size() < 1 ? "\u4f60\u8fd8\u6ca1\u6709\u9009\u62e9\u5546\u54c1\u54e6" : "";
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            ((ExtBillView)this.view).showMessage(errorMsg);
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_orders");
        DynamicObject orders = new DynamicObject((DynamicObjectType)entityType);
        errorMsg = this.BindReceiveAddress(orders);
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            ((ExtBillView)this.view).showMessage(errorMsg);
            return;
        }
        errorMsg = this.BindShipping(orders);
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            ((ExtBillView)this.view).showMessage(errorMsg);
            return;
        }
        this.CreateOrderBaseInfo(orders);
        String isShipping = "0";
        List<ExtDynamicObject> lstItemPrice = this.getItemPrice(lstItemDetail, isShipping);
        DynamicObject cityFreight = CartHelper.GetCityFreight((long)this.channelId, (long)this.shippingId, (long)this.districtId);
        if (cityFreight == null) {
            ((ExtBillView)this.view).showMessage("\u8bf7\u5148\u8bbe\u7f6e\u914d\u9001\u65b9\u5f0f\u53ca\u5bf9\u5e94\u7684\u8fd0\u8d39\u516c\u5f0f");
            return;
        }
        for (JSONObject item : lstItemDetail) {
            item.put("weight", (Object)(item.getBigDecimal("grossweight").compareTo(BigDecimal.ZERO) > 0 ? item.getBigDecimal("grossweight") : item.getBigDecimal("volume")));
            item.put("freightType", (Object)(item.getBigDecimal("grossweight").compareTo(BigDecimal.ZERO) > 0 ? 1 : 2));
        }
        this.shipAmount = CartHelper.GetShipAmount((DynamicObject)cityFreight, lstItemDetail);
        ArrayList<ExtDynamicObject> lstShipPriceItemPrice = new ArrayList();
        if (this.shipAmount.compareTo(BigDecimal.ZERO) > 0) {
            List lstShipPriceItemDetail = CartHelper.getShipPriceItemDetails((long)this.channelId, (long)this.mallInfoCache.getLong("itemid.id"), (long)0L, (BigDecimal)this.shipAmount);
            isShipping = "1";
            lstShipPriceItemPrice = this.getItemPrice(lstShipPriceItemDetail, isShipping);
        }
        this.itemTotalAmount = ((BillFormData)this.getBillData()).getBigDecimal("itemtotalamount");
        this.shipAmount = ((BillFormData)this.getBillData()).getBigDecimal("shipamount");
        this.discountPrice = ((BillFormData)this.getBillData()).getBigDecimal("discountamount");
        this.couponAmount = ((BillFormData)this.getBillData()).getBigDecimal("couponamount");
        this.scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
        ExtDynamicObject payInfo = new ExtDynamicObject();
        long payTypeId = ((BillFormData)this.getBillData()).getLong("paytypeid");
        payInfo.put("payType", (Object)payTypeId);
        payInfo.put("shipAmount", (Object)this.shipAmount);
        payInfo.put("scoreAmount", (Object)this.scoreAmount);
        List<ExtDynamicObject> lstProductAmout = this.CreateOrderProductAmount(lstItemPrice, lstShipPriceItemPrice);
        this.CreateOrderPayInfo(orders, payInfo, lstItemPrice);
        ExtDynamicObject financeData = new ExtDynamicObject();
        String isIncludedTax = "1";
        long billsettlecurrId = this.channelCache.getLong("channelid.currency.id");
        ExtDynamicObject exchangeData = CartHelper.getExchangeData((Long)orders.getLong("saleOrgId"), (Long)billsettlecurrId, (Date)new Date());
        long localCurrId = exchangeData.getLong("baseCurrencyId");
        long exchangeRateTb = exchangeData.getLong("exRateTableId");
        String exchangeRateDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        BigDecimal exchangeRate = exchangeData.getBigDecimal("exchangeRate");
        financeData.put("isIncludedTax", (Object)isIncludedTax);
        financeData.put("billsettlecurrId", (Object)billsettlecurrId);
        financeData.put("localCurrId", (Object)localCurrId);
        financeData.put("exchangeRateTb", (Object)exchangeRateTb);
        financeData.put("exchangeRateDate", (Object)exchangeRateDate);
        financeData.put("exchangeRate", (Object)exchangeRate);
        this.createOrderFinanceData(orders, financeData, lstItemPrice);
        ArrayList<ExtDynamicObject> lstReceivePay = new ArrayList<ExtDynamicObject>();
        if (this.scoreType == 0 && this.scoreAmount.compareTo(BigDecimal.ZERO) > 0) {
            ExtDynamicObject receivePay = new ExtDynamicObject();
            receivePay.put("paymentmethod", (Object)8);
            receivePay.put("settlecurrid", (Object)this.channelCache.getLong("channelid.currency.id"));
            receivePay.put("recamount", (Object)this.scoreAmount);
            receivePay.put("collectiontime", (Object)new Date());
            lstReceivePay.add(receivePay);
        }
        this.createOrderReceiveData(orders);
        if (lstShipPriceItemPrice.size() > 0) {
            lstItemPrice.addAll(lstShipPriceItemPrice);
        }
        if ((result = CartHelper.CreateOrder((DynamicObject)orders, lstItemPrice, lstReceivePay, lstProductAmout)).isSuccess()) {
            int isneedinvoice;
            long id = (Long)result.getSuccessPkIds().get(0);
            if (this.scoreAmount.compareTo(BigDecimal.ZERO) > 0) {
                UUID uuid = UUID.randomUUID();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("requestUuid", (Object)uuid.toString());
                jsonObject.put("memberId", (Object)orders.getLong("memberId"));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                jsonObject.put("transactionTime", (Object)df.format(new Date()));
                jsonObject.put("pointBizTypeId", (Object)"1021");
                PageCache pageCache = ((ExtBillView)this.view).getPageCache();
                Long pointTypeId = Long.parseLong(pageCache.get("pointTypeId"));
                BigDecimal pointPrice = new BigDecimal(pageCache.get("pointPrice"));
                HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>();
                pointMap.put(pointTypeId, Integer.parseInt(this.scoreAmount.divide(pointPrice).toString()));
                jsonObject.put("pointMap", pointMap);
                jsonObject.put("orgId", (Object)this.channelCache.getLong("channelid.saleorg.id"));
                jsonObject.put("channelId", (Object)this.channelCache.getLong("channelid.id"));
                jsonObject.put("srcNo", (Object)orders.getString("billNo"));
                JSONObject jSONObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"freezePoint", (Object[])new Object[]{jsonObject});
            }
            if ((isneedinvoice = ((BillFormData)this.getBillData()).getInt("isneedinvoice")) > 0) {
                entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_ordersinvoice");
                DynamicObject orderInvoice = new DynamicObject((DynamicObjectType)entityType);
                this.BindInvoiceData(orderInvoice);
                orderInvoice.set("org", (Object)this.channelCache.getLong("channelid.saleorg.id"));
                orderInvoice.set("channelId", (Object)this.channelCache.getLong("channelid.id"));
                orderInvoice.set("orderId", (Object)id);
                orderInvoice.set("memberId", (Object)memberId);
                orderInvoice.set("invoiceAmount", (Object)orders.getBigDecimal("apAmount"));
                orderInvoice.set("billStatus", (Object)"B");
                orderInvoice.set("invoiceStatus", (Object)2);
                orderInvoice.set("openinvoicetype", (Object)1);
                orderInvoice.set("cancelstatus", (Object)"A");
                String billNo = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                orderInvoice.set("billno", (Object)billNo);
                orderInvoice.set("createtime", (Object)new Date());
                OperationResult invoiceResult = CartHelper.CreateOrderInvoice((DynamicObject)orderInvoice);
                ((ExtBillView)this.view).showMessage(invoiceResult.getMessage());
            }
            if (itemId == 0L) {
                DynamicObjectCollection colItemDetail = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
                List lstCartId = colItemDetail.stream().map(r -> r.getLong("cartid")).collect(Collectors.toList());
                CartHelper.deleteCartByIds((long)memberId, lstCartId);
            }
            OpenParam openParam = new OpenParam();
            openParam.setTarget(OpenParam.OpenTarget.NewWindow);
            openParam.setShowTitle(Boolean.TRUE);
            openParam.addCustomParam("id", String.valueOf(id));
            openParam.setViewId("ocolsm_checkoutsucc");
            ((ExtBillView)this.getView()).showView(openParam);
        } else {
            String message = result.getMessage();
            ((ExtBillView)this.view).showMessage(message);
        }
    }

    private String BindReceiveAddress(DynamicObject orders) {
        this.addressId = ((BillFormData)this.getBillData()).getLong("addressid");
        this.countryId = ((BillFormData)this.getBillData()).getLong("countryid");
        this.linkman = ((BillFormData)this.getBillData()).getString("linkman");
        this.linkphone = ((BillFormData)this.getBillData()).getString("linkphone");
        this.provinceId = ((BillFormData)this.getBillData()).getLong("provinceid");
        this.cityId = ((BillFormData)this.getBillData()).getLong("cityid");
        this.districtId = ((BillFormData)this.getBillData()).getLong("districtid");
        this.address = ((BillFormData)this.getBillData()).getString("address");
        this.streetdetail = ((BillFormData)this.getBillData()).getString("streetdetail");
        this.note = ((BillFormData)this.getBillData()).getString("note") == null ? "" : ((BillFormData)this.getBillData()).getString("note");
        String errorMsg = "";
        if (this.addressId == 0L) {
            errorMsg = "\u8bf7\u9009\u62e9\u6536\u8d27\u5730\u5740";
        } else if (!RegExUtil.isReceiverName((String)this.linkman)) {
            errorMsg = "\u6536\u8d27\u4eba\u59d3\u540d\u4e0d\u6b63\u786e";
        } else if (!RegExUtil.isMobile((String)this.linkphone)) {
            errorMsg = "\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u6b63\u786e";
        } else if (!RegExUtil.isAddress((String)this.streetdetail)) {
            errorMsg = "\u6536\u8d27\u5730\u5740\u4e0d\u6b63\u786e";
        }
        if (errorMsg.equals("")) {
            orders.set("receiveContact", (Object)this.linkman);
            orders.set("receiveMobile", (Object)this.linkphone);
            orders.set("country", (Object)this.countryId);
            orders.set("province", (Object)this.provinceId);
            orders.set("city", (Object)this.cityId);
            orders.set("county", (Object)this.districtId);
            orders.set("receiveAddress", (Object)this.address);
            orders.set("fullAddress", (Object)this.streetdetail);
            orders.set("note", (Object)this.note);
            orders.set("divisionid", (Object)this.districtId);
        }
        return errorMsg;
    }

    private String BindShipping(DynamicObject orders) {
        String errorMsg = "";
        this.shippingId = ((BillFormData)this.getBillData()).getLong("shippingid");
        if (this.shippingId == 0L) {
            errorMsg = "\u8bf7\u9009\u62e9\u914d\u9001\u65b9\u5f0f";
        }
        if (errorMsg.equals("")) {
            orders.set("shippingType", (Object)this.shippingId);
            orders.set("shippingTime", (Object)"");
        }
        return errorMsg;
    }

    private void CreateOrderBaseInfo(DynamicObject orders) {
        DynamicObject channelCache = ConfigHelper.getChannelCache();
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        String billNo = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        orders.set("billNo", (Object)billNo);
        orders.set("billStatus", (Object)"B");
        orders.set("closestatus", (Object)"A");
        orders.set("cancelstatus", (Object)"A");
        orders.set("billType", (Object)1113582077531616256L);
        orders.set("billSource", (Object)1);
        orders.set("businessType", (Object)"422876630176775168");
        orders.set("createTime", (Object)new Date());
        orders.set("mallId", (Object)this.mallInfoCache.getLong("id"));
        orders.set("org", (Object)channelCache.getLong("channelid.saleorg.id"));
        orders.set("saleOrgId", (Object)channelCache.getLong("channelid.saleorg.id"));
        orders.set("settleOrgid", (Object)this.mallInfoCache.getLong("settleorgid.id"));
        orders.set("custId", (Object)this.mallInfoCache.getLong("customerid.id"));
        orders.set("memberId", (Object)memberId);
        String mobile = "";
        QueryUserByIdDTO dto = new QueryUserByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserById", (Object[])new Object[]{dto});
        if (returnData.get((Object)"code").toString().equals("0")) {
            JSONObject memberInfo = returnData.getJSONObject("data");
            mobile = memberInfo.getString("mobile");
        }
        orders.set("mobile", (Object)mobile);
    }

    private List<ExtDynamicObject> CreateOrderProductAmount(List<ExtDynamicObject> lstItemPrice, List<ExtDynamicObject> lstShipPriceItemPrice) {
        ExtDynamicObject item;
        int i;
        this.itemTotalAmount = ((BillFormData)this.getBillData()).getBigDecimal("itemtotalamount");
        this.shipAmount = ((BillFormData)this.getBillData()).getBigDecimal("shipamount");
        this.discountPrice = ((BillFormData)this.getBillData()).getBigDecimal("discountamount");
        this.couponAmount = ((BillFormData)this.getBillData()).getBigDecimal("couponamount");
        this.scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
        if (this.scoreType == 1) {
            this.discountPrice = this.discountPrice.add(this.scoreAmount);
        }
        this.apAmount = BigDecimalUtil.setScale((BigDecimal)this.itemTotalAmount.add(this.shipAmount).subtract(this.discountPrice).subtract(this.couponAmount).subtract(this.scoreAmount), (int)2);
        int size = lstItemPrice.size();
        for (i = 0; i < size; ++i) {
            item = lstItemPrice.get(i);
            item.put("shipamount", (Object)BigDecimalUtil.setScale((BigDecimal)this.shipAmount.multiply(item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).divide(this.itemTotalAmount, 8, 4)), (int)2));
            item.put("scoreamount", (Object)BigDecimalUtil.setScale((BigDecimal)this.scoreAmount.multiply(item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).divide(this.itemTotalAmount, 8, 4)), (int)2));
            item.put("discountPrice", (Object)BigDecimalUtil.setScale((BigDecimal)this.discountPrice.multiply(item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).divide(this.itemTotalAmount, 8, 4)), (int)2));
            item.put("couponamount", (Object)BigDecimalUtil.setScale((BigDecimal)this.couponAmount.multiply(item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).divide(this.itemTotalAmount, 8, 4)), (int)2));
        }
        this.fixData(lstItemPrice, "shipamount", this.shipAmount);
        this.fixData(lstItemPrice, "scoreamount", this.scoreAmount);
        this.fixData(lstItemPrice, "discountPrice", this.discountPrice);
        this.fixData(lstItemPrice, "couponamount", this.couponAmount);
        if (this.discountPrice.compareTo(BigDecimal.ZERO) > 0) {
            for (i = 0; i < size; ++i) {
                item = lstItemPrice.get(i);
                BigDecimal qwe1 = item.getBigDecimal("discountPrice");
                BigDecimal qwe2 = item.getBigDecimal("qty");
                item.put("priceDiscount", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("discountPrice").divide(item.getBigDecimal("qty"), 8, 4), (int)2));
                item.put("taxPriceTatol", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("taxPrice").multiply(item.getBigDecimal("qty")).subtract(item.getBigDecimal("discountPrice")), (int)2));
                item.put("price", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("unitPrice").multiply(item.getBigDecimal("qty")).subtract(item.getBigDecimal("discountPrice")), (int)2));
                item.put("actTaxPrice", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("taxPrice").subtract(item.getBigDecimal("discountPrice")), (int)2));
            }
        }
        ArrayList<ExtDynamicObject> lstProductAmout = new ArrayList<ExtDynamicObject>(size);
        ExtDynamicObject productAmout = new ExtDynamicObject();
        if (lstShipPriceItemPrice.size() > 0) {
            productAmout.put("id", (Object)lstShipPriceItemPrice.get(0).getLong("id"));
            productAmout.put("moneytype", (Object)1);
            productAmout.put("itemdetailamount", (Object)BigDecimalUtil.setScale((BigDecimal)lstShipPriceItemPrice.get(0).getBigDecimal("taxPrice").multiply(lstShipPriceItemPrice.get(0).getBigDecimal("qty")), (int)2));
            productAmout.put("itemdetailnote", (Object)"\u5546\u54c1\u91d1\u989d");
            lstProductAmout.add(productAmout);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            ExtDynamicObject item2 = lstItemPrice.get(i2);
            long id = item2.getLong("id");
            BigDecimal shipamount = ObjectUtil.toBigDecimal((Object)item2.getBigDecimal("shipamount"));
            BigDecimal scoreamount = ObjectUtil.toBigDecimal((Object)item2.getBigDecimal("scoreamount"));
            BigDecimal discountprice = ObjectUtil.toBigDecimal((Object)item2.getBigDecimal("discountprice"));
            BigDecimal couponamount = ObjectUtil.toBigDecimal((Object)item2.getBigDecimal("couponamount"));
            productAmout = new ExtDynamicObject();
            productAmout.put("id", (Object)id);
            productAmout.put("moneytype", (Object)1);
            productAmout.put("itemdetailamount", (Object)BigDecimalUtil.setScale((BigDecimal)item2.getBigDecimal("taxPrice").multiply(item2.getBigDecimal("qty")), (int)2));
            productAmout.put("itemdetailnote", (Object)"\u5546\u54c1\u91d1\u989d");
            lstProductAmout.add(productAmout);
            if (shipamount.compareTo(BigDecimal.ZERO) > 0) {
                productAmout = new ExtDynamicObject();
                productAmout.put("id", (Object)id);
                productAmout.put("moneytype", (Object)5);
                productAmout.put("itemdetailamount", (Object)shipamount);
                productAmout.put("itemdetailnote", (Object)"\u8fd0\u8d39");
                lstProductAmout.add(productAmout);
            }
            if (scoreamount.compareTo(BigDecimal.ZERO) > 0) {
                productAmout = new ExtDynamicObject();
                productAmout.put("id", (Object)id);
                productAmout.put("moneytype", (Object)2);
                productAmout.put("itemdetailamount", (Object)scoreamount.multiply(new BigDecimal(-1)));
                productAmout.put("itemdetailnote", (Object)"\u79ef\u5206");
                lstProductAmout.add(productAmout);
            }
            if (discountprice.compareTo(BigDecimal.ZERO) > 0) {
                productAmout = new ExtDynamicObject();
                productAmout.put("id", (Object)id);
                productAmout.put("moneytype", (Object)4);
                productAmout.put("itemdetailamount", (Object)discountprice.multiply(new BigDecimal(-1)));
                productAmout.put("itemdetailnote", (Object)"\u6ee1\u51cf");
                lstProductAmout.add(productAmout);
            }
            if (couponamount.compareTo(BigDecimal.ZERO) <= 0) continue;
            productAmout = new ExtDynamicObject();
            productAmout.put("id", (Object)id);
            productAmout.put("moneytype", (Object)3);
            productAmout.put("itemdetailamount", (Object)couponamount.multiply(new BigDecimal(-1)));
            productAmout.put("itemdetailnote", (Object)"\u4f18\u60e0\u5238");
            lstProductAmout.add(productAmout);
        }
        return lstProductAmout;
    }

    private void CreateOrderPayInfo(DynamicObject orders, ExtDynamicObject payInfo, List<ExtDynamicObject> lstItemPrice) {
        BigDecimal itemTotalAmount = lstItemPrice.stream().map(p -> p.getBigDecimal("productAmount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountPrice = lstItemPrice.stream().map(p -> p.getBigDecimal("discountPrice")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal shipAmount = payInfo.getBigDecimal("shipAmount");
        BigDecimal scoreAmount = payInfo.getBigDecimal("scoreAmount");
        BigDecimal apAmount = itemTotalAmount.add(shipAmount).subtract(discountPrice);
        BigDecimal paidAmount = BigDecimal.ZERO;
        if (this.scoreType == 0) {
            paidAmount = scoreAmount;
        }
        BigDecimal needPayAmount = apAmount.subtract(paidAmount);
        orders.set("payType", (Object)payInfo.getLong("payType"));
        orders.set("itemTotalAmount", (Object)itemTotalAmount);
        orders.set("shipAmount", (Object)shipAmount);
        orders.set("apAmount", (Object)apAmount);
        orders.set("paidAmount", (Object)paidAmount);
        orders.set("needPayAmount", (Object)needPayAmount);
        if (paidAmount.compareTo(BigDecimal.ZERO) > 0 && needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            orders.set("paymentStatus", (Object)3);
            orders.set("orderStatus", (Object)3);
        } else if (paidAmount.compareTo(BigDecimal.ZERO) > 0 && needPayAmount.compareTo(BigDecimal.ZERO) > 0) {
            orders.set("paymentStatus", (Object)2);
            orders.set("orderStatus", (Object)2);
        } else {
            orders.set("paymentStatus", (Object)1);
            orders.set("orderStatus", (Object)1);
        }
        orders.set("latestPayTime", null);
    }

    private void createOrderFinanceData(DynamicObject orders, ExtDynamicObject financeData, List<ExtDynamicObject> lstItemPrice) {
        String isIncludedTax = financeData.getString("isIncludedTax");
        long billsettlecurrId = financeData.getLong("billsettlecurrId");
        long localCurrId = financeData.getLong("localCurrId");
        long exchangeRateTb = financeData.getLong("exchangeRateTb");
        Date exchangeRateDate = financeData.getDate("exchangeRateDate");
        BigDecimal exchangeRate = financeData.getBigDecimal("exchangeRate");
        BigDecimal billAllAmount = lstItemPrice.stream().map(p -> p.getBigDecimal("taxPriceTatol")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal billAmount = lstItemPrice.stream().map(p -> p.getBigDecimal("productAmount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal billTaxAmount = lstItemPrice.stream().map(p -> p.getBigDecimal("entryTaxAmount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal billDiscount = lstItemPrice.stream().map(p -> p.getBigDecimal("discountPrice")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal billAllAmount_lc = billAllAmount.multiply(exchangeRate);
        BigDecimal billAmount_lc = billAmount.multiply(exchangeRate);
        BigDecimal billTaxAmount_lc = billTaxAmount.multiply(exchangeRate);
        orders.set("isIncludedTax", (Object)isIncludedTax);
        orders.set("billsettlecurrid", (Object)billsettlecurrId);
        orders.set("localCurrId", (Object)localCurrId);
        orders.set("exchangeRateTb", (Object)exchangeRateTb);
        orders.set("exchangeRateDate", (Object)exchangeRateDate);
        orders.set("exchangeRate", (Object)exchangeRate);
        orders.set("billAllAmount", (Object)billAllAmount);
        orders.set("billAmount", (Object)billAmount);
        orders.set("billTaxAmount", (Object)billTaxAmount);
        orders.set("billDiscount", (Object)billDiscount);
        orders.set("billAllAmount_lc", (Object)billAllAmount_lc);
        orders.set("billAmount_lc", (Object)billAmount_lc);
        orders.set("billTaxAmount_lc", (Object)billTaxAmount_lc);
    }

    private void createOrderReceiveData(DynamicObject orders) {
    }

    private List<ExtDynamicObject> getItemPrice(List<JSONObject> lstItemDetail, String isShipping) {
        ArrayList<ExtDynamicObject> lstItemPrice = new ArrayList<ExtDynamicObject>(lstItemDetail.size());
        for (JSONObject data : lstItemDetail) {
            ExtDynamicObject exData = new ExtDynamicObject();
            exData.put("isShipping", (Object)isShipping);
            exData.put("id", (Object)data.getLong("id"));
            exData.put("itemId", (Object)data.getLong("itemid"));
            exData.put("auxpropId", (Object)data.getLong("auxptyid"));
            exData.put("spuid", (Object)data.getLong("spuid"));
            exData.put("modelnumname", (Object)data.getString("modelnumname"));
            BigDecimal qty = data.getBigDecimal("qty");
            BigDecimal taxPrice = data.getBigDecimal("memberprice");
            BigDecimal actUnitPrice = data.getBigDecimal("memberprice");
            BigDecimal discountPrice = taxPrice.subtract(actUnitPrice).multiply(qty);
            BigDecimal taxPriceTatol = taxPrice.multiply(qty).subtract(discountPrice);
            BigDecimal taxRate = data.getBigDecimal("taxrate");
            BigDecimal unitPrice = taxPrice.divide(taxRate.add(BigDecimal.ONE), 10, 4);
            BigDecimal entryTaxAmount = taxPrice.subtract(unitPrice);
            exData.put("qty", (Object)qty);
            exData.put("taxPrice", (Object)taxPrice);
            exData.put("actUnitPrice", (Object)actUnitPrice);
            exData.put("discountPrice", (Object)discountPrice);
            exData.put("priceDiscount", (Object)discountPrice.divide(qty, 8, 4));
            exData.put("taxPriceTatol", (Object)taxPriceTatol);
            exData.put("entryTaxAmount", (Object)entryTaxAmount);
            exData.put("price", (Object)taxPriceTatol.subtract(entryTaxAmount.multiply(qty)));
            exData.put("actTaxPrice", (Object)taxPriceTatol.divide(qty, 8, 4));
            exData.put("productAmount", (Object)actUnitPrice.multiply(qty));
            exData.put("unitPrice", (Object)unitPrice);
            exData.put("unitId", (Object)data.getString("saleunit"));
            exData.put("baseUnitId", (Object)data.getString("baseunit"));
            exData.put("baseUnitQty", (Object)data.getBigDecimal("baseunitqty"));
            exData.put("assistUnit", (Object)data.getString("assistunit"));
            exData.put("assistQty", (Object)data.getBigDecimal("assistqty"));
            exData.put("shipments", (Object)1);
            exData.put("sostockId", (Object)1);
            exData.put("shipmentsSupplier", (Object)1);
            exData.put("materialid", (Object)data.getLong("materialid"));
            if (isShipping.equals("1")) {
                exData.put("rowclosestatus", (Object)"B");
            } else {
                exData.put("rowclosestatus", (Object)"A");
            }
            lstItemPrice.add(exData);
        }
        return lstItemPrice;
    }

    private void payTypeConfirm() {
        long payTypeId = ((BillFormData)this.getBillData()).getLong("paytypegroup");
        if (payTypeId > 0L) {
            RadioGroup radioGroup = (RadioGroup)((ExtBillView)this.getView()).getControl("paytypegroup");
            String payTypeName = radioGroup.getRadioByValue(String.valueOf(payTypeId)).getName();
            ((BillFormData)this.getBillData()).updateValue("paytypeid", (Object)payTypeId);
            ((BillFormData)this.getBillData()).updateValue("showpaytypediv", (Object)payTypeName);
            long cityId = ((BillFormData)this.getBillData()).getLong("cityid");
            if (cityId <= 0L) {
                ((ExtBillView)this.view).showMessage("\u8bf7\u5148\u9009\u62e9\u6536\u8d27\u5730\u5740");
            }
            ((ExtBillView)this.view).closePopPanel("paytypediv");
        } else {
            ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u652f\u4ed8\u65b9\u5f0f");
        }
    }

    private void shippingConfirm() {
        long shippingId = ((BillFormData)this.getBillData()).getLong("shippinggroup");
        if (shippingId > 0L) {
            RadioGroup radioGroup = (RadioGroup)((ExtBillView)this.getView()).getControl("shippinggroup");
            String shippingName = radioGroup.getRadioByValue(String.valueOf(shippingId)).getName();
            ((BillFormData)this.getBillData()).updateValue("shippingid", (Object)shippingId);
            ((BillFormData)this.getBillData()).updateValue("showshippingdiv", (Object)shippingName);
            long cityId = ((BillFormData)this.getBillData()).getLong("cityid");
            if (cityId > 0L) {
                DynamicObjectCollection colItemDetail = ((BillFormData)this.getBillData()).getEntryRowData(itementrys);
                DynamicObject cityFreight = CartHelper.GetCityFreight((long)this.channelId, (long)shippingId, (long)cityId);
                this.shipAmount = CartHelper.GetShipAmount((DynamicObject)cityFreight, (DynamicObjectCollection)colItemDetail);
                BigDecimal oldShipAmount = ((BillFormData)this.getBillData()).getBigDecimal("shipamount");
                ((BillFormData)this.getBillData()).updateValue("shipamount", (Object)String.valueOf(this.shipAmount));
                if (oldShipAmount.compareTo(this.shipAmount) != 0) {
                    this.cancelScore();
                }
                if (this.shipAmount.compareTo(BigDecimal.ZERO) > 0) {
                    ((BillFormData)this.getBillData()).updateValue("showshipamount", (Object)("+" + StringUtil.setSign((BigDecimal)this.shipAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
                } else {
                    ((BillFormData)this.getBillData()).updateValue("showshipamount", (Object)StringUtil.setSign((BigDecimal)this.shipAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                }
                this.updateTotalAmount();
            } else {
                ((ExtBillView)this.view).showMessage("\u8bf7\u5148\u9009\u62e9\u6536\u8d27\u5730\u5740");
            }
            ((ExtBillView)this.view).closePopPanel("shippingdiv");
        } else {
            ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u914d\u9001\u65b9\u5f0f");
        }
    }

    private void invoiceConfirm() {
        int invoiceContent = ((BillFormData)this.getBillData()).getInt("invoicecontent");
        if (invoiceContent == 1) {
            ((BillFormData)this.getBillData()).updateValue("selectedinvoicemain", (Object)"\u4e0d\u5f00\u7968");
            ((BillFormData)this.getBillData()).updateValue("isneedinvoice", (Object)"0");
            ((ExtBillView)this.view).closePopPanel("invoicediv");
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_ordersinvoice");
            DynamicObject orderInvoice = new DynamicObject((DynamicObjectType)entityType);
            this.BindInvoiceData(orderInvoice);
        }
    }

    private void scoreConfirm() {
        int scoretype = ((BillFormData)this.getBillData()).getInt("scoregroup");
        RadioGroup radioGroup = (RadioGroup)((ExtBillView)this.getView()).getControl("scoregroup");
        String scoretypeName = radioGroup.getRadioByValue(String.valueOf(scoretype)).getName();
        this.scoreAmount = BigDecimal.ZERO;
        if (scoretype == 2) {
            BigDecimal scoreNumber = ObjectUtil.toBigDecimal((Object)((BillFormData)this.getBillData()).getString("scorenumber"), (BigDecimal)BigDecimal.ZERO);
            if (scoreNumber.compareTo(BigDecimal.ZERO) <= 0) {
                ((ExtBillView)this.view).showMessage("\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u79ef\u5206\u6570\u91cf");
                return;
            }
            QueryPointCostRuleDTO dto = new QueryPointCostRuleDTO();
            dto.setUseOrgId(Long.valueOf(this.channelCache.getLong("channelid.saleorg.id")));
            dto.setChannelId(Long.valueOf(this.channelCache.getLong("channelid.id")));
            dto.setBizTypeNum("1021");
            dto.setCurrencyNum("CNY");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dto.setBizTime(df.format(new Date()));
            JSONObject integralRuleResult = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"RightsRuleService", (String)"queryPointCostRule", (Object[])new Object[]{dto});
            if (integralRuleResult.get((Object)"code").toString().equals("0")) {
                JSONArray integralRules = integralRuleResult.getJSONArray("data");
                if (integralRules.size() >= 1) {
                    JSONObject integralRule = integralRules.getJSONObject(0);
                    long pointTypeId = integralRule.getLong("pointTypeId");
                    long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                    ArrayList<Long> pointTypeIdList = new ArrayList<Long>();
                    pointTypeIdList.add(pointTypeId);
                    BigDecimal memberScore = MemberHelper.getMemberScore((Long)memberId, pointTypeIdList);
                    if (memberScore.compareTo(scoreNumber) >= 0) {
                        BigDecimal minQTY = integralRule.getBigDecimal("minQTY");
                        BigDecimal maxQTY = integralRule.getBigDecimal("maxQTY");
                        if (maxQTY.compareTo(BigDecimal.ZERO) == 0) {
                            maxQTY = BigDecimal.valueOf(Double.MAX_VALUE);
                        }
                        BigDecimal minRate = integralRule.getBigDecimal("minRate");
                        BigDecimal maxRate = integralRule.getBigDecimal("maxRate");
                        if (maxRate.compareTo(BigDecimal.ZERO) == 0) {
                            maxRate = BigDecimal.ONE;
                        }
                        this.apAmount = ((BillFormData)this.getBillData()).getBigDecimal("apamount");
                        this.scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
                        this.apAmount = this.apAmount.add(this.scoreAmount);
                        BigDecimal pointPrice = integralRule.getBigDecimal("pointPrice");
                        BigDecimal minRateAmount = this.apAmount.multiply(minRate).multiply(pointPrice);
                        BigDecimal maxRateAmount = this.apAmount.multiply(maxRate).multiply(pointPrice);
                        this.scoreAmount = scoreNumber.multiply(integralRule.getBigDecimal("pointPrice"));
                        if (this.scoreAmount.compareTo(minRateAmount) >= 0 && scoreNumber.compareTo(minQTY) >= 0 && this.scoreAmount.compareTo(maxRateAmount) <= 0 && scoreNumber.compareTo(maxQTY) <= 0) {
                            ((BillFormData)this.getBillData()).updateValue("showscorediv", (Object)scoretypeName);
                            ((ExtBillView)this.view).closePopPanel("scorediv");
                            PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
                            pageCache.put("pointTypeId", String.valueOf(pointTypeId));
                            pageCache.put("pointPrice", String.valueOf(pointPrice));
                        } else {
                            this.scoreAmount = BigDecimal.ZERO;
                            ((ExtBillView)this.view).showMessage("\u4f7f\u7528\u79ef\u5206\u6570\u91cf\u4e0d\u7b26\u5408\u89c4\u5219\u8981\u6c42\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                        }
                    } else {
                        ((ExtBillView)this.view).showMessage("\u79ef\u5206\u4e0d\u8db3");
                    }
                } else {
                    ((ExtBillView)this.view).showMessage("\u672a\u8bbe\u7f6e\u76f8\u5e94\u79ef\u5206\u89c4\u5219");
                }
            } else {
                ((ExtBillView)this.view).showMessage("\u672a\u5339\u914d\u5230\u76f8\u5e94\u79ef\u5206\u89c4\u5219");
            }
        } else {
            ((BillFormData)this.getBillData()).updateValue("showscorediv", (Object)scoretypeName);
            ((ExtBillView)this.view).closePopPanel("scorediv");
        }
        ((BillFormData)this.getBillData()).updateValue("scoreamount", (Object)String.valueOf(this.scoreAmount));
        if (this.scoreAmount.compareTo(BigDecimal.ZERO) > 0) {
            ((BillFormData)this.getBillData()).updateValue("showscoreamount", (Object)("-" + StringUtil.setSign((BigDecimal)this.scoreAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
        } else {
            ((BillFormData)this.getBillData()).updateValue("showscoreamount", (Object)StringUtil.setSign((BigDecimal)this.scoreAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        }
        this.updateTotalAmount();
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "invoicetype": {
                String invoiceType = event.getValue().toString();
                if (invoiceType.equals("1")) {
                    ((ExtBillView)this.view).hide("invoiceheadtitle", false);
                    ((ExtBillView)this.view).hide("invoicehead", false);
                    int invoiceHead = ((BillFormData)this.getBillData()).getInt("invoicehead");
                    if (invoiceHead == 1) {
                        ((ExtBillView)this.view).hide("personagediv", false);
                    } else {
                        ((ExtBillView)this.view).hide("companydiv", false);
                    }
                    ((ExtBillView)this.view).hide("vatdiv", true);
                    ((ExtBillView)this.view).hide("receivediv", true);
                    break;
                }
                ((ExtBillView)this.view).hide("invoiceheadtitle", true);
                ((ExtBillView)this.view).hide("invoicehead", true);
                ((ExtBillView)this.view).hide("personagediv", true);
                ((ExtBillView)this.view).hide("companydiv", true);
                ((ExtBillView)this.view).hide("vatdiv", false);
                ((ExtBillView)this.view).hide("receivediv", false);
                break;
            }
            case "invoicehead": {
                String invoicehead = event.getValue().toString();
                if (invoicehead.equals("1")) {
                    ((ExtBillView)this.view).hide("personagediv", false);
                    ((ExtBillView)this.view).hide("companydiv", true);
                    break;
                }
                ((ExtBillView)this.view).hide("personagediv", true);
                ((ExtBillView)this.view).hide("companydiv", false);
                break;
            }
            case "scoregroup": {
                String scoregroup = event.getValue().toString();
                if (scoregroup.equals("1")) {
                    ((ExtBillView)this.view).hide("scorenumber", true);
                    break;
                }
                ((ExtBillView)this.view).hide("scorenumber", false);
                break;
            }
        }
    }

    public void initInvoiceDiv() {
        int isNeedInitInvoice = ((BillFormData)this.getBillData()).getInt("isneedinitinvoice");
        if (isNeedInitInvoice == 1) {
            ((BillFormData)this.getBillData()).updateValue("invoicetype", (Object)"1");
            ((BillFormData)this.getBillData()).updateValue("invoicehead", (Object)"1");
            ((BillFormData)this.getBillData()).updateValue("invoicecontent", (Object)"2");
            ((BillFormData)this.getBillData()).updateValue("isneedinitinvoice", (Object)"0");
        }
    }

    public void BindInvoiceData(DynamicObject invoiceData) {
        invoiceData.set("divisionid", (Object)0);
        StringBuilder selectedInvoiceMain = new StringBuilder();
        int invoiceContent = ((BillFormData)this.getBillData()).getInt("invoicecontent");
        String invoiceContentDetial = "";
        if (invoiceContent == 2) {
            invoiceContentDetial = "\u5546\u54c1\u660e\u7ec6";
        } else if (invoiceContent == 3) {
            invoiceContentDetial = "\u5546\u54c1\u5206\u7c7b";
        }
        String errorMsg = "";
        int invoiceType = ((BillFormData)this.getBillData()).getInt("invoicetype");
        if (invoiceType == 1) {
            int invoiceHead = ((BillFormData)this.getBillData()).getInt("invoicehead");
            if (invoiceHead == 1) {
                String personageName = ((BillFormData)this.getBillData()).getString("personagename");
                if (personageName.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u4e2a\u4eba\u540d\u79f0";
                } else if (!RegExUtil.isReceiverName((String)personageName)) {
                    errorMsg = "\u4e2a\u4eba\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u6587\u3001\u82f1\u6587\u3001\u6570\u5b57,\u957f\u5ea6\u57282-10\u4e4b\u95f4";
                } else {
                    selectedInvoiceMain.append("\u666e\u7968(");
                    selectedInvoiceMain.append(invoiceContentDetial).append('-');
                    selectedInvoiceMain.append(personageName).append(')');
                    invoiceData.set("invoiceType", (Object)"1");
                    invoiceData.set("invoiceTitle", (Object)personageName);
                }
            } else {
                String companyName = ((BillFormData)this.getBillData()).getString("companyName");
                String taxPayerCode = ((BillFormData)this.getBillData()).getString("taxPayerCode");
                String registeredAddress = ((BillFormData)this.getBillData()).getString("registeredAddress");
                String registeredPhone = ((BillFormData)this.getBillData()).getString("registeredPhone");
                String bank = ((BillFormData)this.getBillData()).getString("bank");
                String bankAccount = ((BillFormData)this.getBillData()).getString("bankAccount");
                if (companyName.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u516c\u53f8\u540d\u79f0";
                } else if (!RegExUtil.isCompanyName((String)companyName)) {
                    errorMsg = "\u516c\u53f8\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (taxPayerCode.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7";
                } else if (!RegExUtil.isNsrCode((String)taxPayerCode)) {
                    errorMsg = "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53ea\u80fd\u8f93\u5165\u5927\u5199\u82f1\u6587\u3001\u6570\u5b57\uff0c\u957f\u5ea6\u572815-20\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)registeredAddress) && !RegExUtil.isAddress((String)registeredAddress)) {
                    errorMsg = "\u6ce8\u518c\u5730\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)registeredPhone) && !RegExUtil.isPhoneOrMobile((String)registeredPhone)) {
                    errorMsg = "\u6ce8\u518c\u7535\u8bdd\u53ea\u80fd\u8f93\u5165\u624b\u673a\u6216\u5ea7\u673a";
                } else if (StringUtil.isNotEmpty((String)bank) && !RegExUtil.isCompanyName((String)bank)) {
                    errorMsg = "\u5f00\u6237\u94f6\u884c\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)bankAccount) && !RegExUtil.isBankAccout((String)bankAccount)) {
                    errorMsg = "\u94f6\u884c\u8d26\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57 ,\u957f\u5ea6\u572810-20\u4e4b\u95f4";
                } else {
                    selectedInvoiceMain.append("\u666e\u7968(");
                    selectedInvoiceMain.append(invoiceContentDetial).append('-');
                    selectedInvoiceMain.append(companyName).append(')');
                    invoiceData.set("invoiceType", (Object)"1");
                    invoiceData.set("invoiceTitle", (Object)companyName);
                    invoiceData.set("taxpayercode", (Object)taxPayerCode);
                    invoiceData.set("registeredAddress", (Object)registeredAddress);
                    invoiceData.set("registeredPhone", (Object)registeredPhone);
                    invoiceData.set("bank", (Object)bank);
                    invoiceData.set("bankAccount", (Object)bankAccount);
                }
            }
        } else {
            String vatCompanyName = ((BillFormData)this.getBillData()).getString("vatCompanyname");
            String vatTaxPayerCode = ((BillFormData)this.getBillData()).getString("vatTaxPayerCode");
            String vatRegisteredAddress = ((BillFormData)this.getBillData()).getString("vatRegisteredAddress");
            String vatRegisteredPhone = ((BillFormData)this.getBillData()).getString("vatRegisteredPhone");
            String vatBank = ((BillFormData)this.getBillData()).getString("vatBank");
            String vatBankAccount = ((BillFormData)this.getBillData()).getString("vatBankAccount");
            String invoiceReceiverName = ((BillFormData)this.getBillData()).getString("invoiceReceiverName");
            String invoiceReceiverMobile = ((BillFormData)this.getBillData()).getString("invoiceReceiverMobile");
            String invoiceReceiverAddress = ((BillFormData)this.getBillData()).getString("invoiceReceiverAddress");
            ExtDynamicObject region = new ExtDynamicObject();
            int invoicedistrictId = ((BillFormData)this.getBillData()).getInt("invoicedistrictid");
            if (invoicedistrictId > 0) {
                region = AddressHelper.getFullDivision((long)invoicedistrictId);
            }
            if (vatCompanyName.equals("")) {
                errorMsg = "\u8bf7\u586b\u5199\u516c\u53f8\u540d\u79f0";
            } else if (!RegExUtil.isCompanyName((String)vatCompanyName)) {
                errorMsg = "\u516c\u53f8\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (vatTaxPayerCode.equals("")) {
                errorMsg = "\u8bf7\u586b\u5199\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7";
            } else if (!RegExUtil.isNsrCode((String)vatTaxPayerCode)) {
                errorMsg = "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53ea\u80fd\u8f93\u5165\u5927\u5199\u82f1\u6587\u3001\u6570\u5b57\uff0c\u957f\u5ea6\u572815-20\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatRegisteredAddress) && !RegExUtil.isAddress((String)vatRegisteredAddress)) {
                errorMsg = "\u6ce8\u518c\u5730\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatRegisteredPhone) && !RegExUtil.isPhoneOrMobile((String)vatRegisteredPhone)) {
                errorMsg = "\u6ce8\u518c\u7535\u8bdd\u53ea\u80fd\u8f93\u5165\u624b\u673a\u6216\u5ea7\u673a";
            } else if (StringUtil.isNotEmpty((String)vatBank) && !RegExUtil.isCompanyName((String)vatBank)) {
                errorMsg = "\u5f00\u6237\u94f6\u884c\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatBankAccount) && !RegExUtil.isBankAccout((String)vatBankAccount)) {
                errorMsg = "\u94f6\u884c\u8d26\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57 ,\u957f\u5ea6\u572810-20\u4e4b\u95f4";
            } else if (!RegExUtil.isReceiverName((String)invoiceReceiverName)) {
                errorMsg = "\u6536\u7968\u4eba\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (!RegExUtil.isMobile((String)invoiceReceiverMobile)) {
                errorMsg = "\u6536\u7968\u4eba\u624b\u673a\u53ea\u80fd\u8f93\u516511\u4f4d\u7684\u624b\u673a\u53f7";
            } else if (invoicedistrictId <= 0) {
                errorMsg = "\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u6536\u7968\u4eba\u7701\u3001\u5e02\u3001\u53bf";
            } else if (invoicedistrictId > 0) {
                region = AddressHelper.getFullDivision((long)invoicedistrictId);
                if (region.getString("fullids").split("_").length < 3) {
                    errorMsg = "\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u6536\u7968\u4eba\u7701\u3001\u5e02\u3001\u53bf";
                }
            } else if (!RegExUtil.isReceiverName((String)invoiceReceiverAddress)) {
                errorMsg = "\u6536\u7968\u4eba\u5730\u5740\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            }
            if (errorMsg.equals("")) {
                selectedInvoiceMain.append("\u589e\u7968(");
                selectedInvoiceMain.append(invoiceContentDetial).append('-');
                selectedInvoiceMain.append(vatCompanyName).append(')');
                invoiceData.set("invoiceType", (Object)"2");
                invoiceData.set("invoiceTitle", (Object)vatCompanyName);
                invoiceData.set("taxpayercode", (Object)vatTaxPayerCode);
                invoiceData.set("registeredAddress", (Object)vatRegisteredAddress);
                invoiceData.set("registeredPhone", (Object)vatRegisteredPhone);
                invoiceData.set("bank", (Object)vatBank);
                invoiceData.set("bankAccount", (Object)vatBankAccount);
                invoiceData.set("receivername", (Object)invoiceReceiverName);
                invoiceData.set("receivermobile", (Object)invoiceReceiverMobile);
                invoiceData.set("countryid", (Object)region.getString("countryid"));
                invoiceData.set("provinceid", (Object)region.getString("fullids").split("_")[0]);
                invoiceData.set("cityid", (Object)region.getString("fullids").split("_")[1]);
                invoiceData.set("countyid", (Object)invoicedistrictId);
                invoiceData.set("divisionid", (Object)invoicedistrictId);
                invoiceData.set("receiveraddress", (Object)invoiceReceiverAddress);
                invoiceData.set("fulladdress", (Object)(region.getString("fullname").replaceAll("_", "") + invoiceReceiverAddress));
            }
        }
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            ((ExtBillView)this.view).showMessage(errorMsg);
            ((BillFormData)this.getBillData()).updateValue("selectedinvoicemain", (Object)"\u4e0d\u5f00\u7968");
            ((BillFormData)this.getBillData()).updateValue("isneedinvoice", (Object)"0");
        } else {
            invoiceData.set("invoiceContent", (Object)invoiceContentDetial);
            ((BillFormData)this.getBillData()).updateValue("selectedinvoicemain", (Object)selectedInvoiceMain.toString());
            ((BillFormData)this.getBillData()).updateValue("isneedinvoice", (Object)"1");
            ((ExtBillView)this.view).closePopPanel("invoicediv");
        }
    }

    private void queryPointCostRule() {
        JSONArray integralRules;
        QueryPointCostRuleDTO dto = new QueryPointCostRuleDTO();
        dto.setUseOrgId(Long.valueOf(this.channelCache.getLong("channelid.saleorg.id")));
        dto.setChannelId(Long.valueOf(this.channelCache.getLong("channelid.id")));
        dto.setBizTypeNum("1021");
        dto.setCurrencyNum("CNY");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dto.setBizTime(df.format(new Date()));
        JSONObject integralRuleResult = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"RightsRuleService", (String)"queryPointCostRule", (Object[])new Object[]{dto});
        ArrayList<String> lstRuleDescription = new ArrayList<String>();
        BigDecimal memberScore = BigDecimal.ZERO;
        if (integralRuleResult.get((Object)"code").toString().equals("0") && (integralRules = integralRuleResult.getJSONArray("data")).size() >= 1) {
            JSONObject integralRule = integralRules.getJSONObject(0);
            BigDecimal minQTY = integralRule.getBigDecimal("minQTY");
            BigDecimal maxQTY = integralRule.getBigDecimal("maxQTY");
            BigDecimal minRate = integralRule.getBigDecimal("minRate");
            BigDecimal maxRate = integralRule.getBigDecimal("maxRate");
            BigDecimal pointPrice = integralRule.getBigDecimal("pointPrice");
            this.apAmount = ((BillFormData)this.getBillData()).getBigDecimal("apamount");
            this.scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
            this.apAmount = this.apAmount.add(this.scoreAmount);
            if (minQTY.compareTo(BigDecimal.ZERO) > 0) {
                lstRuleDescription.add("\u6700\u4f4e\u4f7f\u7528\u79ef\u5206\u6570\u91cf" + minQTY);
                if (this.scoreAmount.compareTo(minQTY) < 0) {
                    this.scoreAmount = minQTY;
                }
            }
            if (maxQTY.compareTo(BigDecimal.ZERO) > 0) {
                lstRuleDescription.add("\u6700\u9ad8\u4f7f\u7528\u79ef\u5206\u6570\u91cf" + maxQTY);
                if (this.scoreAmount.compareTo(maxQTY) > 0) {
                    this.scoreAmount = maxQTY;
                }
            }
            if (minRate.compareTo(BigDecimal.ZERO) > 0) {
                lstRuleDescription.add("\u6b64\u5355\u6700\u4f4e\u53ef\u4f7f\u7528\u79ef\u5206" + this.apAmount.multiply(minRate).longValue());
                if (this.scoreAmount.compareTo(this.apAmount.multiply(minRate)) < 0) {
                    this.scoreAmount = this.apAmount.multiply(minRate);
                }
            }
            if (maxRate.compareTo(BigDecimal.ZERO) > 0) {
                lstRuleDescription.add("\u6b64\u5355\u6700\u9ad8\u53ef\u4f7f\u7528\u79ef\u5206" + this.apAmount.multiply(maxRate).longValue());
                if (this.scoreAmount.compareTo(this.apAmount.multiply(maxRate)) > 0) {
                    this.scoreAmount = this.apAmount.multiply(maxRate);
                }
            }
            long pointTypeId = integralRule.getLong("pointTypeId");
            ArrayList<Long> pointTypeIdList = new ArrayList<Long>();
            pointTypeIdList.add(pointTypeId);
            long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
            memberScore = MemberHelper.getMemberScore((Long)memberId, pointTypeIdList);
            ((BillFormData)this.getBillData()).updateValue("pointPrice", (Object)("1\u79ef\u5206\u53ef\u62b5\u6263" + BigDecimalUtil.setScale((BigDecimal)pointPrice, (int)2) + "\u5143"));
        }
        if (memberScore.compareTo(BigDecimal.ZERO) <= 0) {
            ((ExtBillView)this.view).hide("showscorediv", true);
            ((ExtBillView)this.view).hide("notusescore", false);
        } else {
            ((ExtBillView)this.view).hide("showscorediv", false);
            ((ExtBillView)this.view).hide("notusescore", true);
        }
        ((BillFormData)this.getBillData()).updateValue("memberscore", (Object)memberScore.toString());
        ((BillFormData)this.getBillData()).updateValue("integralruledescription", (Object)StringUtils.join(lstRuleDescription, (String)","));
    }

    private void fixData(List<ExtDynamicObject> lstItemPrice, final String roundkey, BigDecimal roundValue) {
        BigDecimal value;
        BigDecimal diffAmount;
        if (roundValue.compareTo(BigDecimal.ZERO) > 0 && (diffAmount = roundValue.subtract(value = lstItemPrice.stream().map(p -> p.getBigDecimal(roundkey)).reduce(BigDecimal.ZERO, BigDecimal::add))).compareTo(BigDecimal.ZERO) != 0) {
            ArrayList<ExtDynamicObject> newLstItemPrice = new ArrayList<ExtDynamicObject>();
            newLstItemPrice.addAll(lstItemPrice);
            Collections.sort(newLstItemPrice, new Comparator<ExtDynamicObject>(){

                @Override
                public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                    return s2.getBigDecimal(roundkey).compareTo(s1.getBigDecimal(roundkey));
                }
            });
            Object object = newLstItemPrice.get(0);
            int index = lstItemPrice.indexOf(object);
            BigDecimal newAmount = lstItemPrice.get(index).getBigDecimal(roundkey).add(diffAmount);
            lstItemPrice.get(index).put(roundkey, (Object)newAmount);
        }
    }

    private void cancelScore() {
        BigDecimal scoreAmount = ((BillFormData)this.getBillData()).getBigDecimal("scoreamount");
        if (scoreAmount.compareTo(BigDecimal.ZERO) != 0) {
            RadioGroup radioGroup = (RadioGroup)((ExtBillView)this.getView()).getControl("scoregroup");
            String scoretypeName = radioGroup.getRadioByValue("1").getName();
            ((BillFormData)this.getBillData()).updateValue("showscorediv", (Object)scoretypeName);
            scoreAmount = BigDecimal.ZERO;
            ((BillFormData)this.getBillData()).updateValue("scoreamount", (Object)String.valueOf(scoreAmount));
            ((BillFormData)this.getBillData()).updateValue("showscoreamount", (Object)StringUtil.setSign((BigDecimal)scoreAmount, (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            this.updateTotalAmount();
        }
    }
}

