/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.FlexPanel;
import kd.occ.ocepfp.core.form.control.controls.Img;
import kd.occ.ocepfp.core.form.control.controls.LatticePanel;
import kd.occ.ocepfp.core.form.control.controls.Panel;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SearchEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.index.IndexHelper;
import kd.occ.ocolsm.common.util.StringUtil;

public class IndexPlugin
extends ExtBillViewPlugin {
    private static Log Logger = LogFactory.getLog(IndexPlugin.class);
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private DynamicObject mallInfoCache = ConfigHelper.getMallInfoCache();
    private long id = IndexHelper.getHomeContentId((long)this.channelCache.getLong("channelid.id"));

    public boolean initView(InitViewEvent initViewEvent) {
        this.setLmAd();
        this.setCustomAd();
        return false;
    }

    public String initPageTitle(InitViewEvent initViewEvent) {
        String mallName = this.mallInfoCache.getString("name");
        return mallName;
    }

    public DynamicObject onDataLoad(LoadDataEvent event) {
        super.onDataLoad(event);
        ((BillFormData)this.billData).updateValue("logoimg", (Object)(PictureUtil.getFileServerUrl() + ConfigHelper.getMallLogo()));
        this.setFlashAd();
        try {
            this.setFloorAd();
        }
        catch (IOException e) {
            Logger.error("setFloorAd\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a" + e);
        }
        return ((BillFormData)this.billData).getDataObject();
    }

    public void afterBindData(LoadDataEvent event) {
    }

    public void onSearch(SearchEvent event) {
        String searchinput = event.getFilterParam() == null ? "" : (String)event.getFilterParam().get("searchinput");
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.setViewId("ocolsm_productmoblist");
        openParam.addCustomParam("itemName", searchinput);
        ((ExtBillView)this.getView()).showView(openParam);
    }

    protected void onRowSelected(SelectAllEvent event) {
        Object pkValue = event.getCurrentRow().getPkValue();
        int index = event.getCurrentRow().getRow();
        String spuid = "0";
        for (int i = 0; i < 6; ++i) {
            DynamicObject entryRowData = ((BillFormData)this.getBillData()).getEntryRowData("flooritem" + i, index);
            String itemid = entryRowData.getString("id");
            if (!itemid.equals(pkValue.toString())) continue;
            spuid = entryRowData.getString("spuid" + i);
            break;
        }
        OpenParam openParam = new OpenParam();
        openParam.setViewId("ocolsm_productmobdetail");
        openParam.addCustomParam("itemid", pkValue.toString());
        openParam.addCustomParam("spuid", spuid);
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "floor0more": 
            case "floor1more": 
            case "floor2more": 
            case "floor3more": 
            case "floor4more": 
            case "floor5more": 
            case "floor6more": {
                String link = ((BillFormData)this.getBillData()).getString(eventId + "link");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                if (link.toLowerCase(Locale.ENGLISH).startsWith("view:")) {
                    link = link.substring(5);
                }
                String[] arrayLink = link.split("&");
                openParam.setViewId(arrayLink[0]);
                if (arrayLink.length > 1) {
                    for (int i = 1; i < arrayLink.length; ++i) {
                        openParam.addCustomParam(arrayLink[i].split("=")[0], arrayLink[i].split("=")[1]);
                    }
                }
                ((ExtBillView)this.getView()).showView(openParam);
            }
        }
    }

    private void setFlashAd() {
        DynamicObjectCollection colFlashAdEntry = IndexHelper.getFlashAds((long)this.id);
        List lstFlashId = colFlashAdEntry.stream().map(r -> r.getLong("adId")).collect(Collectors.toList());
        List lstFlashAd = IndexHelper.getAds(lstFlashId);
        Map mapflasAdIdSort = colFlashAdEntry.stream().collect(Collectors.groupingBy(r -> r.getLong("adId"), Collectors.toList()));
        lstFlashAd.forEach(r -> r.put("sort", (Object)((DynamicObject)((List)mapflasAdIdSort.get(r.getLong("id"))).get(0)).getInt("sort")));
        Collections.sort(lstFlashAd, new Comparator<ExtDynamicObject>(){

            @Override
            public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                return s1.getInt("sort").compareTo(s2.getInt("sort"));
            }
        });
        ArrayList<ImgObject> lstImg = new ArrayList<ImgObject>(lstFlashAd.size());
        for (ExtDynamicObject item : lstFlashAd) {
            ImgObject i = new ImgObject();
            i.setId("img" + item.getId());
            i.setSrc(PictureUtil.getFileServerUrl() + item.getString("adImg"));
            i.setHref(item.getString("url"));
            lstImg.add(i);
        }
        ((BillFormData)this.billData).updateValue("swiper1", lstImg);
    }

    private void setLmAd() {
        DynamicObjectCollection colLmEntity = IndexHelper.getLmAds((long)this.id);
        List lstLmId = colLmEntity.stream().map(r -> r.getLong("lmId")).collect(Collectors.toList());
        List lstLm = IndexHelper.getAds(lstLmId);
        Map mapLmIdSort = colLmEntity.stream().collect(Collectors.groupingBy(r -> r.getLong("lmId"), Collectors.toList()));
        lstLm.forEach(r -> r.put("sort", (Object)((DynamicObject)((List)mapLmIdSort.get(r.getLong("id"))).get(0)).getInt("sort")));
        LatticePanel latticepanel = (LatticePanel)((ExtBillView)this.getView()).getControl("lmad");
        for (ExtDynamicObject item : lstLm) {
            Img i = new Img();
            i.setId(item.getId().toString());
            i.setSrc(PictureUtil.getFileServerUrl() + item.getString("adImg"));
            i.setWidth("60");
            i.setHeight("60");
            i.setLabel(item.getString("name"));
            i.setLabelPosition(Control.LabelPosition.Bottom);
            i.setClickable(true);
            i.setHref(item.getString("url"));
            latticepanel.addControl((Control)i);
        }
    }

    private void setCustomAd() {
        DynamicObjectCollection colCustomAdEntry = IndexHelper.getCustomAds((long)this.id);
        ArrayList<ExtDynamicObject> lstCustomAdEntry = new ArrayList<ExtDynamicObject>();
        for (DynamicObject data : colCustomAdEntry) {
            ExtDynamicObject exData = new ExtDynamicObject();
            exData.put("id", (Object)data.getString("id"));
            exData.put("templateType", (Object)data.getString("templateType"));
            exData.put("sort", (Object)data.getString("sort"));
            exData.put("adId", (Object)data.getString("adId"));
            exData.put("subSort", (Object)data.getString("subSort"));
            lstCustomAdEntry.add(exData);
        }
        List lstIAdId = lstCustomAdEntry.stream().map(r -> r.getLong("adId")).collect(Collectors.toList());
        List lstAd = IndexHelper.getAds(lstIAdId);
        Map mapAdEntry = lstAd.stream().collect(Collectors.groupingBy(r -> r.getLong("id"), Collectors.toList()));
        lstCustomAdEntry.forEach(r -> r.put("adEntry", mapAdEntry.get(r.getLong("adId"))));
        Collections.sort(lstCustomAdEntry, new Comparator<ExtDynamicObject>(){

            @Override
            public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                return s1.getInt("sort").compareTo(s2.getInt("sort"));
            }
        });
        Map mapCustomTemplateAd = lstCustomAdEntry.stream().collect(Collectors.groupingBy(r -> r.getInt("sort") + "_" + r.getInt("templateType"), Collectors.toList()));
        Panel customAd = (Panel)((ExtBillView)this.getView()).getControl("customAd");
        for (Map.Entry entry : mapCustomTemplateAd.entrySet()) {
            String sort_templateType = entry.getKey();
            List<ExtDynamicObject> lstCustomAd = entry.getValue();
            Collections.sort(lstCustomAd, new Comparator<ExtDynamicObject>(){

                @Override
                public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                    return s1.getInt("sort").compareTo(s2.getInt("sort"));
                }
            });
            int templateType = Integer.parseInt(sort_templateType.split("_")[1]);
            switch (templateType) {
                case 1: {
                    LatticePanel latticePanel = new LatticePanel();
                    latticePanel.setCols(1);
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setHref(r2.getString("url"));
                    latticePanel.addChild((Object)img);
                    break;
                }
                case 2: {
                    FlexPanel panel = new FlexPanel();
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 1);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    customAd.addControl((Control)panel);
                    break;
                }
                case 3: {
                    FlexPanel panel = new FlexPanel();
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 1);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 2);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    customAd.addControl((Control)panel);
                    break;
                }
                case 4: {
                    FlexPanel panel = new FlexPanel();
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 1);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 2);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 3);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    customAd.addControl((Control)panel);
                    break;
                }
                case 5: {
                    FlexPanel panel = new FlexPanel();
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    LatticePanel rightPanel = new LatticePanel();
                    rightPanel.setId("rightPanel");
                    rightPanel.setCols(1);
                    rightPanel.setFlex("1");
                    panel.addChild((Object)rightPanel);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 1);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    rightPanel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 2);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    rightPanel.addChild((Object)img);
                    customAd.addControl((Control)panel);
                    break;
                }
                case 6: {
                    FlexPanel panel = new FlexPanel();
                    LatticePanel leftPanel = new LatticePanel();
                    leftPanel.setId("leftPanel");
                    leftPanel.setCols(1);
                    leftPanel.setFlex("1");
                    panel.addChild((Object)leftPanel);
                    Img img = new Img();
                    ExtDynamicObject r2 = this.getRowData(lstCustomAd, 0);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    leftPanel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 1);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    leftPanel.addChild((Object)img);
                    img = new Img();
                    r2 = this.getRowData(lstCustomAd, 2);
                    img.setSrc(PictureUtil.getFileServerUrl() + r2.getString("adImg"));
                    img.setId(r2.getId().toString());
                    img.setFlex("1");
                    img.setHref(r2.getString("url"));
                    panel.addChild((Object)img);
                    customAd.addControl((Control)panel);
                }
            }
        }
    }

    private final ExtDynamicObject getRowData(List<ExtDynamicObject> lstCustomAd, int index) {
        List lstAdEntry = (List)lstCustomAd.get(index).get((Object)"adEntry");
        return (ExtDynamicObject)lstAdEntry.get(0);
    }

    private void setFloorAd() throws IOException {
        DynamicObjectCollection colFloorEntry = IndexHelper.getFloorAds((long)this.id);
        ArrayList<ExtDynamicObject> lstFloorEntry = new ArrayList<ExtDynamicObject>();
        for (DynamicObject data : colFloorEntry) {
            ExtDynamicObject exData = new ExtDynamicObject();
            exData.put("floorId", (Object)data.getString("floorId"));
            exData.put("sort", (Object)data.getString("sort"));
            lstFloorEntry.add(exData);
        }
        List lstFloorId = colFloorEntry.stream().map(r -> r.getLong("floorId")).collect(Collectors.toList());
        List lstFloorItemEntry = IndexHelper.getFloorItems(lstFloorId);
        Collections.sort(lstFloorItemEntry, new Comparator<ExtDynamicObject>(){

            @Override
            public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                return s1.getInt("sort").compareTo(s2.getInt("sort"));
            }
        });
        List<Long> lstItemId = lstFloorItemEntry.stream().map(r -> r.getLong("itemId")).collect(Collectors.toList());
        List<ExtDynamicObject> lstItem = this.getItems(lstItemId);
        List lstFloor = IndexHelper.getFloors(lstFloorId);
        Map mapFloorEntry = lstFloorEntry.stream().collect(Collectors.groupingBy(r -> r.getLong("floorId"), Collectors.toList()));
        lstFloor.forEach(r -> r.put("sort", (Object)((ExtDynamicObject)((List)mapFloorEntry.get(r.getLong("floorId"))).get(0)).getInt("sort")));
        Collections.sort(lstFloor, new Comparator<ExtDynamicObject>(){

            @Override
            public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                return s1.getInt("sort").compareTo(s2.getInt("sort"));
            }
        });
        int count = lstFloor.size();
        ExtDynamicObject item = new ExtDynamicObject();
        for (int i = 0; i < count; ++i) {
            Long floorId = ((ExtDynamicObject)lstFloor.get(i)).getLong("floorId");
            List lstPerFloorItem = lstFloorItemEntry.stream().filter(r -> r.getLong("floorId").longValue() == floorId.longValue()).collect(Collectors.toList());
            for (ExtDynamicObject floorItem : lstPerFloorItem) {
                List lstPerItem = lstItem.stream().filter(r -> r.getLong("itemId").longValue() == floorItem.getLong("itemId").longValue()).collect(Collectors.toList());
                if (lstPerItem.size() <= 0) continue;
                item = (ExtDynamicObject)lstPerItem.get(0);
                DynamicObject viewItem = ((BillFormData)this.billData).addEntryRow("flooritem" + i);
                viewItem.set("id", (Object)item.getLong("itemId"));
                viewItem.set("spuid" + i, (Object)item.getLong("spuid"));
                viewItem.set("limg" + i, (Object)(PictureUtil.getFileServerUrl() + item.getString("picture1")));
                viewItem.set("lname" + i, (Object)item.getString("name"));
                viewItem.set("lprice" + i, (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("memberPrice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            }
            ((ExtBillView)this.view).hide("flooradimg" + i, false);
            ((ExtBillView)this.view).hide("floor" + i, false);
            ((ExtBillView)this.view).hide("flooritem" + i, false);
            ImgObject img = new ImgObject();
            img.setSrc(PictureUtil.getFileServerUrl() + ((ExtDynamicObject)lstFloor.get(i)).getString("adImg"));
            img.setHref(((ExtDynamicObject)lstFloor.get(i)).getString("url"));
            ((BillFormData)this.billData).updateValue("flooradimg" + i, (Object)img);
            ((BillFormData)this.billData).updateValue("floor" + i, (Object)((ExtDynamicObject)lstFloor.get(i)).getString("name"));
            String link = ((ExtDynamicObject)lstFloor.get(i)).getString("link");
            if (link.length() <= 0) continue;
            ((BillFormData)this.billData).updateValue("floor" + i + "morelink", (Object)link);
            ((ExtBillView)this.view).hide("floor" + i + "more", false);
        }
    }

    private List<ExtDynamicObject> getItems(List<Long> lstItemId) {
        ArrayList<ExtDynamicObject> lstItem = new ArrayList<ExtDynamicObject>();
        String[] arrayItemId = new String[lstItemId.size()];
        String[] arrayAuxpropId = new String[lstItemId.size()];
        for (int i = 0; i < lstItemId.size(); ++i) {
            arrayItemId[i] = lstItemId.get(i).toString();
            arrayAuxpropId[i] = "0";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("itemid.id", "itemid");
        String appendFields = SerializationUtils.toJsonString(map);
        if (lstItemId.size() > 0) {
            JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemListByItemIds", (Object[])new Object[]{"ocolmm_itemsale_content", String.valueOf(this.channelCache.getLong("channelid.id")), arrayItemId, appendFields});
            if (returnData.get((Object)"code").toString() == "0000") {
                JSONArray items = returnData.getJSONArray("data");
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject item = items.getJSONObject(i);
                    ExtDynamicObject exData = new ExtDynamicObject();
                    exData.put("itemId", item.get((Object)"itemid"));
                    exData.put("spuid", item.get((Object)"spuid"));
                    exData.put("picture1", (Object)item.get((Object)"thumbnail").toString());
                    exData.put("name", (Object)item.get((Object)"itemname").toString());
                    exData.put("memberPrice", (Object)item.get((Object)"minmemberprice").toString());
                    exData.put("shortTitle", (Object)item.get((Object)"shorttitle").toString());
                    lstItem.add(exData);
                }
            } else {
                ((ExtBillView)this.view).showMessage(returnData.get((Object)"msg").toString());
            }
        }
        return lstItem;
    }
}

