/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.WxPayTradeHelper;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.MemberHelper;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.business.pay.PayHelper;
import kd.occ.ocolsm.common.constant.PayModeEnum;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class MyOrderPlugin
extends ExtListViewPlugin {
    private static Log logger = LogFactory.getLog(MyOrderPlugin.class);
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private String searchInput = "";
    private int orderStatus = -1;
    private static final String itementrys = "goodslist";

    public QueryFilter buildQueryFilter(QueryFilter queryFilter, ClientEvent event) {
        QueryFilterParam queryFilterParam = queryFilter.getQueryFilterParam("searchinput");
        this.searchInput = queryFilterParam != null ? ObjectUtil.toString(queryFilterParam.getValue().getValue().get(0)).trim() : "";
        queryFilterParam = queryFilter.getQueryFilterParam("orderstatus");
        int n = this.orderStatus = queryFilterParam != null ? ObjectUtil.toInt(queryFilterParam.getValue().getValue().get(0)) : -1;
        if (this.orderStatus == -1) {
            int status = ObjectUtil.toInt((Object)((ExtListView)this.view).getExtCtx().getForm().getCustomParam().getInt("status"));
            if (status > 0) {
                this.orderStatus = status;
                ((ExtListView)this.view).setActiveByValue("orderstatus", String.valueOf(this.orderStatus));
            }
        } else {
            if (event.getId() != null && event.getId().equalsIgnoreCase("searchinput")) {
                this.orderStatus = 0;
            }
            ((ExtListView)this.view).setActiveByValue("orderstatus", String.valueOf(this.orderStatus));
        }
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        queryFilter.addFilter("memberId", Enums.SqlCompareOperator.equal, (Object)memberId);
        return super.buildQueryFilter(queryFilter, event);
    }

    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        int pageSize;
        int page;
        ListDataSet listDataSet = new ListDataSet();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection pageDate = this.getOrders(memberId, this.searchInput, this.orderStatus, page = ObjectUtil.toInt((Object)event.getPage()), pageSize = ObjectUtil.toInt((Object)event.getPageSize()));
        if (pageDate.size() > 0) {
            listDataSet.setRows((Object)pageDate);
            ((ExtListView)this.view).hide(itementrys, false);
            ((ExtListView)this.view).hide("isempty", true);
        } else {
            ((ExtListView)this.view).hide(itementrys, true);
            ((ExtListView)this.view).hide("isempty", false);
        }
        return listDataSet;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "thumbnail1": {
                long orderId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("id", String.valueOf(orderId));
                openParam.setViewId("ocolsm_orderdetail");
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
            case "gotocancel": {
                long orderId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                this.goToCancel(orderId);
                break;
            }
            case "gotopay": {
                this.goToPay(ObjectUtil.toLong((Object)event.getCurrentRow().getPkValue()));
                break;
            }
            case "addinvoice": 
            case "editinvoice": {
                long ordersinvoiceId = ((ListFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow()).getLong("ordersinvoiceid");
                long orderId = Long.parseLong((String)event.getCurrentRow().getPkValue());
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                if (ordersinvoiceId > 0L) {
                    openParam.addCustomParam("id", String.valueOf(ordersinvoiceId));
                    openParam.setViewId("ocolsm_orderinvoiceedit");
                } else {
                    openParam.addCustomParam("orderid", String.valueOf(orderId));
                    openParam.setViewId("ocolsm_orderinvoiceadd");
                }
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    public void onRowSelected(SelectAllEvent selectallevent) {
        Object pkValue = selectallevent.getCurrentRow().getPkValue();
        OpenParam openParam = new OpenParam();
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        openParam.setShowTitle(Boolean.TRUE);
        openParam.addCustomParam("id", String.valueOf(pkValue));
        openParam.setViewId("ocolsm_orderdetail");
        ((ExtListView)this.getView()).showView(openParam);
    }

    private DynamicObjectCollection getOrders(long memberId, String searchInput, int orderStatus, int page, int pageSize) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        if (StringUtil.isNotEmpty((String)searchInput)) {
            filter.and(new QFilter("billno", "like", (Object)searchInput));
        }
        switch (orderStatus) {
            case 1: {
                filter.and(new QFilter("orderstatus", "in", Arrays.asList("1", "2")));
                break;
            }
            case 3: {
                filter.and(new QFilter("orderstatus", "in", Arrays.asList("3", "4")));
                break;
            }
            case 5: {
                filter.and(new QFilter("orderstatus", "=", (Object)"5"));
                break;
            }
            case 7: {
                filter.and(new QFilter("orderstatus", "=", (Object)"7"));
                break;
            }
            case 8: {
                filter.and(new QFilter("orderstatus", "=", (Object)"8"));
            }
        }
        DynamicObject[] orders = this.getOrders(filter, page, pageSize);
        ArrayList<Long> lstOrderId = new ArrayList<Long>(orders.length);
        for (int i = 0; i < orders.length; ++i) {
            lstOrderId.add(orders[i].getLong("id"));
        }
        DynamicObjectCollection orderItmes = this.getOrderItem(memberId, lstOrderId);
        DynamicObjectCollection invoiceItmes = MemberHelper.getOrderInvoices(lstOrderId, (long)memberId);
        DynamicObjectCollection pageDate = new DynamicObjectCollection();
        for (DynamicObject order : orders) {
            List lstItem = orderItmes.stream().filter(p -> p.getLong("orderid") == order.getLong("id")).collect(Collectors.toList());
            for (DynamicObject item : lstItem) {
                DynamicObject itemDate = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                itemDate.set("orderno", (Object)order.getString("billno"));
                itemDate.set("id", (Object)order.getString("id"));
                itemDate.set("itemid", (Object)item.getLong("itemid"));
                itemDate.set("itemnumber", item.get("itemnumber"));
                itemDate.set("itemname", (Object)(item.getString("itemname") + item.getString("modelnumname")));
                itemDate.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + (String)item.get("thumbnail")));
                itemDate.set("multiply", (Object)"\u00d7");
                itemDate.set("qty", (Object)item.getInt("qty"));
                itemDate.set("actunitprice", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("actunitprice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                itemDate.set("ordersinvoiceid", (Object)this.getInvoiceId(order.getLong("id"), invoiceItmes));
                itemDate.set("needpayamount", (Object)StringUtil.setSign((BigDecimal)order.getBigDecimal("needpayamount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                pageDate.add((Object)itemDate);
            }
            if (this.getInvoiceId(order.getLong("id"), invoiceItmes) == 0L) {
                ((ExtListView)this.view).hideGroupFooter(order.getString("billno"), "editInvoice", true);
            }
            if (this.getInvoiceId(order.getLong("id"), invoiceItmes) > 0L || order.getLong("orderstatus") == 8L) {
                ((ExtListView)this.view).hideGroupFooter(order.getString("billno"), "addInvoice", true);
            }
            if (order.getLong("orderstatus") > 2L) {
                ((ExtListView)this.view).hideGroupFooter(order.getString("billno"), "gotocancel", true);
            }
            if (order.getLong("orderstatus") <= 2L) continue;
            ((ExtListView)this.view).hideGroupFooter(order.getString("billno"), "gotopay", true);
        }
        return pageDate;
    }

    public DynamicObject[] getOrders(QFilter filters, int page, int pageSize) {
        String orderBy = "id desc";
        String queryFields = "id,billno,orderstatus,needpayamount";
        return BusinessDataServiceHelper.load((String)"ocolmm_orders", (String)queryFields, (QFilter[])filters.toArray(), (String)orderBy, (int)(--page), (int)pageSize);
    }

    public DynamicObjectCollection getOrderItem(Long memberId, List<Long> lstOrderId) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "in", lstOrderId));
        String orderBy = "ocolmm_ordersentry.id asc";
        filter.and(new QFilter("ocolmm_ordersentry.isshipping", "=", (Object)Boolean.FALSE));
        String queryFields = "ocolmm_ordersentry.id id,ocolmm_ordersentry.isshipping isshipping";
        queryFields = queryFields + ",ocolmm_ordersentry.itemid itemid,ocolmm_ordersentry.auxpropid auxpropid";
        queryFields = queryFields + ",ocolmm_ordersentry.material material,ocolmm_ordersentry.unitid unitid";
        queryFields = queryFields + ",ocolmm_ordersentry.qty qty,ocolmm_ordersentry.assistunit assistunit";
        queryFields = queryFields + ",ocolmm_ordersentry.assistqty assistqty,ocolmm_ordersentry.baseunitid baseunitid";
        queryFields = queryFields + ",ocolmm_ordersentry.baseunitqty baseunitqty,ocolmm_ordersentry.taxprice taxprice";
        queryFields = queryFields + ",ocolmm_ordersentry.actunitprice actunitprice,ocolmm_ordersentry.pricediscount pricediscount";
        queryFields = queryFields + ",ocolmm_ordersentry.acttaxprice acttaxprice,ocolmm_ordersentry.productamount productamount";
        queryFields = queryFields + ",ocolmm_ordersentry.taxrate taxrate,ocolmm_ordersentry.price price";
        queryFields = queryFields + ",ocolmm_ordersentry.discount discount,ocolmm_ordersentry.taxpricetatol taxpricetatol";
        queryFields = queryFields + ",ocolmm_ordersentry.amount amount,ocolmm_ordersentry.entrytaxamount entrytaxamount";
        queryFields = queryFields + ",ocolmm_ordersentry.allamount_lc allamount_lc,ocolmm_ordersentry.amount_lc amount_lc";
        queryFields = queryFields + ",ocolmm_ordersentry.taxamount_lc taxamount_lc,ocolmm_ordersentry.shipments shipments";
        queryFields = queryFields + ",ocolmm_ordersentry.sostockid sostockid,ocolmm_ordersentry.shipmentssupplier shipmentssupplier";
        queryFields = queryFields + ",ocolmm_ordersentry.itemid.name as itemname,ocolmm_ordersentry.itemid.number as itemnumber";
        queryFields = queryFields + ",ocolmm_ordersentry.itemid.thumbnail as thumbnail,ocolmm_orders.id orderId";
        queryFields = queryFields + ",ocolmm_ordersentry.modelnumname as modelnumname";
        return QueryServiceHelper.query((String)"ocolmm_orders", (String)queryFields, (QFilter[])filter.toArray(), (String)orderBy);
    }

    private void goToCancel(long orderId) {
        QFilter filter = new QFilter("id", "=", (Object)orderId);
        DynamicObject order = BusinessDataServiceHelper.loadSingle((String)"ocolmm_orders", (String)"id,orderStatus", (QFilter[])filter.toArray());
        int orderStatus = order.getInt("orderStatus");
        String msg = "\u8be5\u72b6\u6001\u8ba2\u5355\u53d6\u6d88\u529f\u80fd\u5c1a\u672a\u5b8c\u6210";
        if (orderStatus == 1) {
            order.set("orderStatus", (Object)8);
            msg = "\u8ba2\u5355\u5df2\u53d6\u6d88";
        } else if (orderStatus > 1 && orderStatus < 4 || orderStatus <= 3 || orderStatus < 8) {
            // empty if block
        }
        SaveServiceHelper.update((DynamicObject)order);
        ((ExtListView)this.view).showMessage(msg);
        ((ExtListView)this.view).refresh();
    }

    private long getInvoiceId(long orderId, DynamicObjectCollection invoiceCollection) {
        ArrayList<ExtDynamicObject> lstOrderInvoice = new ArrayList<ExtDynamicObject>();
        for (DynamicObject data : invoiceCollection) {
            if (data.getLong("orderid") != orderId) continue;
            ExtDynamicObject exData = new ExtDynamicObject();
            exData.put("id", (Object)data.getString("id"));
            exData.put("invoiceStatus", (Object)data.getString("invoiceStatus"));
            exData.put("cancelStatus", (Object)data.getString("cancelStatus"));
            exData.put("openInvoiceType", (Object)data.getString("openInvoiceType"));
            lstOrderInvoice.add(exData);
        }
        long ordersInvoiceId = 0L;
        if (lstOrderInvoice.size() == 1) {
            ordersInvoiceId = ((ExtDynamicObject)lstOrderInvoice.get(0)).getLong("id");
        } else if (lstOrderInvoice.size() > 1) {
            Collections.sort(lstOrderInvoice, new Comparator<ExtDynamicObject>(){

                @Override
                public int compare(ExtDynamicObject s1, ExtDynamicObject s2) {
                    int s = ObjectUtil.toString((Object)s1.getString("cancelStatus"), (String)"").compareTo(ObjectUtil.toString((Object)s2.getString("cancelStatus"), (String)""));
                    if (s == 0 && (s = ObjectUtil.toInt((Object)s2.getInt("openInvoiceType"), (int)0) - ObjectUtil.toInt((Object)s1.getInt("openInvoiceType"), (int)0)) == 0 && (s = s1.getInt("invoiceStatus") - s2.getInt("invoiceStatus")) == 0) {
                        return (int)(s1.getLong("id") - s2.getLong("id"));
                    }
                    return s;
                }
            });
            ordersInvoiceId = ((ExtDynamicObject)lstOrderInvoice.get(0)).getLong("id");
        }
        return ordersInvoiceId;
    }

    private void goToPay(long orderId) {
        DynamicObjectCollection colPaymentType = PayHelper.getPaymentType((long)this.channelCache.getLong("channelid.id"));
        if (colPaymentType.size() == 0) {
            ((ExtListView)this.view).showMessage("\u6682\u65e0\u53ef\u7528\u7684\u652f\u4ed8\u65b9\u5f0f");
        } else if (colPaymentType.size() == 1) {
            DynamicObject item = (DynamicObject)colPaymentType.get(0);
            long payConfigId = item.getLong("payConfigId");
            long payModeId = item.getLong("id");
            this.getPayData(orderId, payConfigId, payModeId);
        } else {
            OpenParam openParam = new OpenParam();
            openParam.setViewId("ocolsm_paydialog");
            openParam.addCustomParam("id", String.valueOf(orderId));
            openParam.setPostion(OpenParam.OpenPosition.Bottom);
            openParam.setTarget(OpenParam.OpenTarget.Pop);
            ((ExtListView)this.getView()).showView(openParam);
        }
    }

    private void getPayData(long orderId, long payConfigId, long payModeId) {
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        HashMap payData = PayHelper.getPayData((long)this.channelCache.getLong("channelid.id"), (long)orderId, (long)memberId, (long)payConfigId, (long)payModeId);
        logger.info("payData=" + JSON.toJSONString((Object)payData));
        PageCache pageCache = new PageCache(((ExtListView)this.view).getPageId());
        pageCache.put("payConfigId", String.valueOf(payConfigId));
        pageCache.put("payModeId", String.valueOf(payModeId));
        pageCache.put("orderId", String.valueOf(orderId));
        if (((String)payData.get("tradeStatus")).equals("SUCCESS")) {
            pageCache.put("payResponse", (String)payData.get("payResponse"));
            payData.keySet().removeIf(key -> key.equals("tradeStatus"));
            payData.keySet().removeIf(key -> key.equals("errorMessage"));
            payData.keySet().removeIf(key -> key.equals("payResponse"));
            String payWayType = PayHelper.getPayWayType((long)payModeId);
            if (payWayType.equals(PayModeEnum.WeChatPayType.toString())) {
                ((ExtListView)this.view).wxPay((Map)payData, true);
            }
        } else {
            ((ExtListView)this.view).showMessage((String)payData.get("errorMessage"));
        }
    }

    public void onPayBack(PayBackEvent event) {
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        PageCache pageCache = ((ExtListView)this.view).getPageCache();
        JSONObject payResponse = JSONObject.parseObject((String)pageCache.get("payResponse"));
        String billNo = ObjectUtil.toString((Object)payResponse.get((Object)"billNo"));
        String outTradeNo = ObjectUtil.toString((Object)payResponse.get((Object)"out_trade_no"));
        long payModeId = ObjectUtil.toLong((Object)pageCache.get("payModeId"));
        long orderId = ObjectUtil.toLong((Object)pageCache.get("orderId"));
        long payConfigId = ObjectUtil.toLong((Object)pageCache.get("payConfigId"));
        DynamicObject orderDetail = OrderHelper.getOrder((Long)memberId, (long)orderId);
        long orderStatus = orderDetail.getLong("orderStatus");
        if (orderStatus < 3L) {
            long channelId = this.channelCache.getLong("channelid.id");
            Map payConfig = PayHelper.getPayConfig((long)payConfigId, (long)payModeId);
            logger.info("payConfig=" + JSON.toJSONString((Object)payConfig));
            JSONObject queryResponse = PayHelper.loopTradeQuery((long)payModeId, (Map)payConfig, (String)outTradeNo, (int)2, (int)500);
            logger.info("queryResponse=" + queryResponse.toJSONString());
            JSONObject miniPayResponse = WxPayTradeHelper.checkQueryAndCancel((String)outTradeNo, (JSONObject)queryResponse, (JSONObject)payResponse, (Map)payConfig, (String)billNo, (long)memberId, (Date)new Date(), (long)channelId);
            if (TradeStatus.SUCCESS.toString().equals(miniPayResponse.getString("payStatus"))) {
                OrderHelper.orderPaynotify((JSONObject)queryResponse);
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("id", String.valueOf(orderId));
                openParam.setViewId("ocolsm_orderdetail");
                ((ExtListView)this.getView()).showView(openParam);
            } else {
                logger.error("\u672a\u652f\u4ed8\u6216\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u7ed3\u679c\uff1a" + payResponse);
            }
        } else {
            ((ExtListView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u8ba2\u5355\u4e0d\u662f\u672a\u4ed8\u6b3e\u72b6\u6001");
        }
        super.onPayBack(event);
    }
}

