/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.WxPayTradeHelper;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserByIdDTO;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.CountTimeoutEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolmm.business.botp.AftersalesToRefundbill;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.MemberHelper;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.business.pay.PayHelper;
import kd.occ.ocolsm.common.constant.PayModeEnum;
import kd.occ.ocolsm.common.util.BigDecimalUtil;
import kd.occ.ocolsm.common.util.DateUtil;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.OrderUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class OrderDetailMobPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(OrderDetailMobPlugin.class);
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private static final String itementrys = "goodslist";

    public void afterDataLoad(LoadDataEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        final long id = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
        DynamicObject orderDetail = OrderHelper.getOrder((Long)memberId, (long)id);
        if (orderDetail == null) {
            ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u4e0d\u5b58\u5728");
            ((ExtBillView)this.view).hide("isnotempty", true);
            ((ExtBillView)this.view).hide("isempty", false);
            return;
        }
        Date createTime = orderDetail.getDate("createTime");
        long orderStatus = orderDetail.getLong("orderStatus");
        ((BillFormData)this.getBillData()).updateValue("orderstatus", (Object)OrderUtil.getOrderStatusInfo((long)1L, (long)orderStatus));
        if (orderStatus < 2L) {
            String storeNumber = ((ExtBillView)this.view).getExtCtx().getForm().getString("store");
            DynamicObject mallInfo = ConfigHelper.getMallInfo((String)storeNumber);
            boolean isAutoCancle = mallInfo.getBoolean("autocancle");
            long cancleTimespan = mallInfo.getLong("cancletimespan") * 60L;
            if (isAutoCancle) {
                Calendar deadline = Calendar.getInstance();
                deadline.setTime(createTime);
                deadline.add(13, (int)cancleTimespan);
                if (deadline.getTime().compareTo(new Date()) > 0) {
                    long remainSecond = (deadline.getTime().getTime() - new Date().getTime()) / 1000L;
                    ((ExtBillView)this.view).startCountDown("countdown", remainSecond);
                    ((ExtBillView)this.view).hide("paycountdown", false);
                    ((ExtBillView)this.view).hide("countdown", false);
                }
            }
        }
        ((BillFormData)this.getBillData()).updateValue("receivecontact", (Object)orderDetail.getString("receiveContact"));
        ((BillFormData)this.getBillData()).updateValue("receivemobile", (Object)orderDetail.getString("receiveMobile"));
        ((BillFormData)this.getBillData()).updateValue("fulladdress", (Object)orderDetail.getString("fullAddress"));
        boolean isFilterShipping = true;
        DynamicObjectCollection colOrderItem = OrderHelper.getOrderItem((Long)memberId, (long)id, (boolean)isFilterShipping);
        int count = colOrderItem.size();
        for (int i = 0; i < count; ++i) {
            QFilter filter;
            DynamicObject pspuDate;
            DynamicObject item = (DynamicObject)colOrderItem.get(i);
            DynamicObject dataObject = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
            String pspuid = "0";
            long spuid = item.getLong("spuid");
            if (spuid > 0L && (pspuDate = QueryServiceHelper.queryOne((String)"ocdbd_spu", (String)"id pspuid,ocdbd_spuentry_map.id spuid,", (QFilter[])(filter = new QFilter("ocdbd_spuentry_map.id", "=", (Object)spuid)).toArray())) != null) {
                pspuid = pspuDate.getString("pspuid");
            }
            dataObject.set("pspuid", (Object)pspuid);
            dataObject.set("itemid", (Object)item.getLong("itemid"));
            dataObject.set("itemname", (Object)(item.getString("itemname") + item.getString("modelnumname")));
            dataObject.set("itemnumber", (Object)item.getString("itemnumber"));
            dataObject.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + item.getString("thumbnail")));
            dataObject.set("multiply", (Object)"\u00d7");
            dataObject.set("qty", (Object)BigDecimalUtil.setScale((BigDecimal)item.getBigDecimal("qty"), (int)0));
            dataObject.set("actunitprice", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("actunitprice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
            ((BillFormData)this.getBillData()).addEntryRow(itementrys, dataObject);
        }
        ((BillFormData)this.getBillData()).updateValue("billno", (Object)orderDetail.getString("billno"));
        ((BillFormData)this.getBillData()).updateValue("createtime", (Object)DateUtil.toFormatString((Date)orderDetail.getDate("createTime")));
        ((BillFormData)this.getBillData()).updateValue("paytypename", (Object)orderDetail.getString("payTypeName"));
        ((BillFormData)this.getBillData()).updateValue("shippingname", (Object)orderDetail.getString("shippingName"));
        ((BillFormData)this.getBillData()).updateValue("givenscore", (Object)"0");
        ArrayList<Long> ids = new ArrayList<Long>(){
            {
                this.add(Long.parseLong(String.valueOf(id)));
            }
        };
        DynamicObjectCollection colOrderInvoice = MemberHelper.getOrderInvoices((List)ids, (long)memberId);
        String invoiceStatusInfo = "";
        long ordersInvoiceId = 0L;
        if (colOrderInvoice == null) {
            invoiceStatusInfo = "\u8865\u5f00\u53d1\u7968";
        } else if (colOrderInvoice.size() == 1) {
            invoiceStatusInfo = "\u67e5\u770b\u53d1\u7968";
            ordersInvoiceId = ((DynamicObject)colOrderInvoice.get(0)).getLong("id");
        } else if (colOrderInvoice.size() > 1) {
            invoiceStatusInfo = "\u67e5\u770b\u53d1\u7968";
            Collections.sort(colOrderInvoice, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject s1, DynamicObject s2) {
                    int s = s1.getString("cancelStatus").compareTo(s2.getString("cancelStatus"));
                    if (s == 0 && (s = s2.getInt("openInvoiceType") - s1.getInt("openInvoiceType")) == 0 && (s = s1.getInt("invoiceStatus") - s2.getInt("invoiceStatus")) == 0) {
                        return (int)(s1.getLong("id") - s2.getLong("id"));
                    }
                    return s;
                }
            });
            ordersInvoiceId = ((DynamicObject)colOrderInvoice.get(0)).getLong("id");
        }
        ((BillFormData)this.getBillData()).updateValue("invoicestatusinfo", (Object)invoiceStatusInfo);
        ((BillFormData)this.getBillData()).updateValue("ordersinvoiceid", (Object)ordersInvoiceId);
        ((BillFormData)this.getBillData()).updateValue("note", (Object)orderDetail.getString("note"));
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        filter.and(new QFilter("id", "=", (Object)id));
        String queryFields = "ocolmm_ordersentry.ocolmm_oemoneydetail.moneytype,";
        queryFields = queryFields + "ocolmm_ordersentry.ocolmm_oemoneydetail.itemdetailamount";
        DynamicObjectCollection colMoneyDetail = QueryServiceHelper.query((String)"ocolmm_orders", (String)queryFields, (QFilter[])filter.toArray());
        Map mapMoneyDetail = colMoneyDetail.stream().collect(Collectors.groupingBy(r -> r.getLong("ocolmm_ordersentry.ocolmm_oemoneydetail.moneytype"), Collectors.toList()));
        BigDecimal scoreAmount = BigDecimal.ZERO;
        BigDecimal couponAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        long amountType = 2L;
        if (mapMoneyDetail.get(amountType) != null) {
            scoreAmount = mapMoneyDetail.get(amountType).stream().map(p -> p.getBigDecimal("ocolmm_ordersentry.ocolmm_oemoneydetail.itemdetailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (mapMoneyDetail.get(amountType = 3L) != null) {
            couponAmount = mapMoneyDetail.get(amountType).stream().map(p -> p.getBigDecimal("ocolmm_ordersentry.ocolmm_oemoneydetail.itemdetailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (mapMoneyDetail.get(amountType = 4L) != null) {
            discountAmount = mapMoneyDetail.get(amountType).stream().map(p -> p.getBigDecimal("ocolmm_ordersentry.ocolmm_oemoneydetail.itemdetailamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (discountAmount.compareTo(BigDecimal.ZERO) == 0) {
            ((ExtBillView)this.view).hide("discountamount", true);
        }
        if (couponAmount.compareTo(BigDecimal.ZERO) == 0) {
            ((ExtBillView)this.view).hide("couponamount", true);
        }
        if (scoreAmount.compareTo(BigDecimal.ZERO) == 0) {
            ((ExtBillView)this.view).hide("scoreamount", true);
        }
        ((BillFormData)this.getBillData()).updateValue("itemtotalamount", (Object)StringUtil.setSign((BigDecimal)orderDetail.getBigDecimal("itemTotalAmount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("shipamount", (Object)("+" + StringUtil.setSign((BigDecimal)orderDetail.getBigDecimal("shipAmount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
        ((BillFormData)this.getBillData()).updateValue("discountamount", (Object)("-" + StringUtil.setSign((BigDecimal)discountAmount.abs(), (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
        ((BillFormData)this.getBillData()).updateValue("couponamount", (Object)("-" + StringUtil.setSign((BigDecimal)couponAmount.abs(), (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
        ((BillFormData)this.getBillData()).updateValue("scoreamount", (Object)("-" + StringUtil.setSign((BigDecimal)scoreAmount.abs(), (int)2, (String)this.channelCache.getString("channelid.currency.sign"))));
        ((BillFormData)this.getBillData()).updateValue("apamount", (Object)StringUtil.setSign((BigDecimal)orderDetail.getBigDecimal("apAmount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("needpayamount", (Object)StringUtil.setSign((BigDecimal)orderDetail.getBigDecimal("needpayamount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        ((BillFormData)this.getBillData()).updateValue("paidamount", (Object)StringUtil.setSign((BigDecimal)orderDetail.getBigDecimal("paidamount"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
        if (orderStatus < 3L) {
            ((ExtBillView)this.view).hide("gobuy", false);
            ((ExtBillView)this.view).hide("needpayamount", false);
        } else if (orderStatus == 3L) {
            ((ExtBillView)this.view).hide("gobuy", false);
            ((ExtBillView)this.view).hide("gotopay", true);
            ((ExtBillView)this.view).hide("needpayamount", true);
            ((ExtBillView)this.view).hide("paidamount", false);
        } else {
            ((ExtBillView)this.view).hide("gobuy", true);
            ((ExtBillView)this.view).hide("needpayamount", true);
            ((ExtBillView)this.view).hide("paidamount", false);
        }
    }

    public void onCountTimeout(CountTimeoutEvent event) {
        ((ExtBillView)this.view).hide("paycountdown", true);
        ((ExtBillView)this.view).hide("countdown", true);
    }

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        return data;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "invoicestatusinfo": {
                long ordersinvoiceId = ((BillFormData)this.getBillData()).getLong("ordersinvoiceId");
                long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                if (ordersinvoiceId > 0L) {
                    openParam.addCustomParam("id", String.valueOf(ordersinvoiceId));
                    openParam.setViewId("ocolsm_orderinvoiceedit");
                } else {
                    openParam.addCustomParam("orderid", String.valueOf(orderId));
                    openParam.setViewId("ocolsm_orderinvoiceadd");
                }
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "gotopay": {
                long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
                this.goToPay(orderId);
                break;
            }
            case "gotocancel": {
                this.goToCancel();
                break;
            }
            case "itemimg": 
            case "item": {
                DynamicObject currentRow = ((BillFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocolsm_productmobdetail");
                openParam.addCustomParam("itemid", currentRow.getString("itemid"));
                openParam.addCustomParam("spuid", currentRow.getString("pspuid"));
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                ((ExtBillView)this.view).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void goToCancel() {
        long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)orderId);
        DynamicObject order = BusinessDataServiceHelper.loadSingle((String)"ocolmm_orders", (String)"billno,id,orderStatus,org,billsettlecurrid,apamount", (QFilter[])filter.toArray());
        int orderStatus = order.getInt("orderStatus");
        String orderNo = order.getString("billno");
        long billsettlecurrId = order.getLong("billsettlecurrid.id");
        BigDecimal apamount = order.getBigDecimal("apamount");
        if (orderStatus == 1) {
            order.set("orderStatus", (Object)8);
            SaveServiceHelper.update((DynamicObject)order);
            ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u5df2\u53d6\u6d88");
            ((ExtBillView)this.view).refresh();
        } else if (orderStatus >= 2 && orderStatus <= 5) {
            filter = new QFilter("orderid.id", "=", (Object)orderId);
            filter.and(new QFilter("closestatus", "=", (Object)"A"));
            filter.and(new QFilter("cancelstatus", "=", (Object)"A"));
            DynamicObjectCollection afterSales = QueryServiceHelper.query((String)"ocolmm_aftersales", (String)"orderid.id", (QFilter[])filter.toArray());
            if (afterSales.size() == 0) {
                boolean isAudit = true;
                if (orderStatus == 4 || orderStatus == 5) {
                    isAudit = false;
                }
                this.caneclOrders(orderNo, billsettlecurrId, apamount, isAudit);
            } else {
                ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u6b63\u5728\u53d6\u6d88\u4e2d\uff0c\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
            }
        }
    }

    protected void caneclOrders(String orderNo, long billsettlecurrId, BigDecimal apamount, boolean isAudit) {
        String errorMsg = "";
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_aftersales");
        DynamicObject afterSales = new DynamicObject((DynamicObjectType)entityType);
        afterSales.set("billstatus", (Object)"B");
        afterSales.set("creator", (Object)memberId);
        afterSales.set("org", (Object)this.channelCache.getLong("channelid.saleorg.id"));
        afterSales.set("channelId", (Object)this.channelCache.getLong("channelid.id"));
        afterSales.set("returnreason", (Object)"6");
        long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
        afterSales.set("orderid", (Object)orderId);
        afterSales.set("billtype", (Object)1);
        afterSales.set("itemreturntype", (Object)"");
        afterSales.set("orperatetype", (Object)1);
        afterSales.set("closestatus", (Object)"A");
        afterSales.set("comment", (Object)"\u53d6\u6d88\u5df2\u4ed8\u6b3e\u8ba2\u5355");
        afterSales.set("createtime", (Object)new Date());
        afterSales.set("cancelstatus", (Object)"A");
        afterSales.set("supplierareaid", (Object)0);
        ArrayList<ExtDynamicObject> listOrderProduct = new ArrayList<ExtDynamicObject>();
        long id = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
        boolean isFilterShipping = false;
        DynamicObjectCollection goodsListDate = OrderHelper.getOrderItem((Long)memberId, (long)id, (boolean)isFilterShipping);
        for (DynamicObject goods : goodsListDate) {
            ExtDynamicObject orderProduct = new ExtDynamicObject();
            orderProduct.put("itemid", (Object)goods.getLong("itemid"));
            orderProduct.put("assistunitid", (Object)goods.getLong("assistunit"));
            orderProduct.put("baseunitid", (Object)goods.getLong("baseunitid"));
            orderProduct.put("unitid", (Object)goods.getLong("unitid"));
            orderProduct.put("materialid", (Object)goods.getLong("material"));
            orderProduct.put("skuid", (Object)goods.getLong("auxpropid"));
            orderProduct.put("qty", (Object)goods.getBigDecimal("qty"));
            orderProduct.put("assistqty", (Object)goods.getBigDecimal("assistqty"));
            orderProduct.put("baseqty", (Object)goods.getBigDecimal("baseunitqty"));
            orderProduct.put("taxprice", (Object)goods.getBigDecimal("taxprice"));
            orderProduct.put("realprice", (Object)goods.getBigDecimal("actunitprice"));
            orderProduct.put("discountrate", (Object)goods.getBigDecimal("pricediscount"));
            orderProduct.put("actualunitprice", (Object)goods.getBigDecimal("acttaxprice"));
            orderProduct.put("itemamount", (Object)goods.getBigDecimal("productamount"));
            orderProduct.put("unitprice", (Object)goods.getBigDecimal("price"));
            orderProduct.put("discountamount", (Object)goods.getBigDecimal("discount"));
            orderProduct.put("amountandtax", (Object)goods.getBigDecimal("taxpricetatol"));
            orderProduct.put("amount", (Object)goods.getBigDecimal("amount"));
            orderProduct.put("taxamount", (Object)goods.getBigDecimal("entrytaxamount"));
            orderProduct.put("taxrate", (Object)goods.getBigDecimal("taxrate"));
            orderProduct.put("lcamount", (Object)goods.getBigDecimal("amount_lc"));
            orderProduct.put("lctaxamount", (Object)goods.getBigDecimal("taxamount_lc"));
            orderProduct.put("lcallamount", (Object)goods.getBigDecimal("allamount_lc"));
            orderProduct.put("detailstockorgid", (Object)goods.getLong("detailstockorgid"));
            orderProduct.put("sostockid", (Object)goods.getLong("sostockid"));
            orderProduct.put("srcbillentity", (Object)"ocolmm_orders");
            orderProduct.put("srcbillid", (Object)orderId);
            orderProduct.put("srcbillnumber", (Object)orderNo);
            orderProduct.put("srcbillentryid", (Object)goods.getLong("orderproductid"));
            orderProduct.put("srcbillentryseq", (Object)goods.getInt("mainbillentryseq"));
            orderProduct.put("mainbillentity", (Object)"ocolmm_orders");
            orderProduct.put("mainbillid", (Object)orderId);
            orderProduct.put("mainbillnumber", (Object)orderNo);
            orderProduct.put("mainbillentryid", (Object)goods.getLong("orderproductid"));
            orderProduct.put("mainbillentryseq", (Object)goods.getInt("mainbillentryseq"));
            listOrderProduct.add(orderProduct);
        }
        ArrayList<ExtDynamicObject> listProductRefund = new ArrayList<ExtDynamicObject>();
        QFilter filter = new QFilter("id", "=", (Object)orderId);
        DynamicObjectCollection payedCollection = QueryServiceHelper.query((String)"ocolmm_orders", (String)"ocolmm_receivepay.paymentmethod paymentmethod,ocolmm_receivepay.settlecurrid settlecurrid,ocolmm_receivepay.recamount recamount", (QFilter[])filter.toArray());
        for (DynamicObject data : payedCollection) {
            ExtDynamicObject ProductRefund = new ExtDynamicObject();
            ProductRefund.put("collectiontype", (Object)data.getString("paymentmethod"));
            ProductRefund.put("collectioncurrencyid", (Object)data.getString("settlecurrid"));
            ProductRefund.put("refundamount", (Object)data.getString("recamount"));
            ProductRefund.put("adjustamount", (Object)BigDecimal.ZERO);
            ProductRefund.put("realrefundamount", (Object)data.getString("recamount"));
            ProductRefund.put("detailcomment", (Object)"");
            listProductRefund.add(ProductRefund);
        }
        QueryUserByIdDTO dto = new QueryUserByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        JSONObject returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserById", (Object[])new Object[]{dto});
        String myname = "";
        if (returnData.get((Object)"code").toString().equals("0")) {
            JSONObject memberInfo = returnData.getJSONObject("data");
            myname = memberInfo.getString("name");
        } else {
            errorMsg = "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25";
        }
        if (errorMsg.equals("")) {
            ArrayList<ExtDynamicObject> listAfterSalesOplog = new ArrayList<ExtDynamicObject>();
            ExtDynamicObject AfterSalesOplog = new ExtDynamicObject();
            AfterSalesOplog.put("operatorrule", (Object)2);
            AfterSalesOplog.put("operator", (Object)myname);
            AfterSalesOplog.put("opdesc", (Object)"\u63d0\u4ea4\u7533\u8bf7");
            AfterSalesOplog.put("opcomment", (Object)"");
            AfterSalesOplog.put("flag", (Object)2);
            AfterSalesOplog.put("opcreatetime", (Object)new Date());
            listAfterSalesOplog.add(AfterSalesOplog);
            afterSales = OrderHelper.getAfterSalesData((DynamicObject)afterSales, listOrderProduct, listProductRefund, listAfterSalesOplog);
            OperationResult result = OperationUtil.invokeOperation((DynamicObject)afterSales, (String)"save");
            if (result.isSuccess()) {
                if (isAudit) {
                    List ids = result.getSuccessPkIds();
                    afterSales = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"ocolmm_aftersales");
                    if ((result = OperationUtil.invokeOperation((DynamicObject)afterSales, (String)"audit")).isSuccess()) {
                        new AftersalesToRefundbill().billConvert(String.valueOf(ids.get(0)));
                        ((ExtBillView)this.view).showMessage("\u7b49\u5f85\u9000\u6b3e\u540e\u53d6\u6d88\u8ba2\u5355");
                        ((ExtBillView)this.view).refresh();
                    }
                } else {
                    ((ExtBillView)this.view).showMessage("\u7b49\u5f85\u5ba1\u6838\u540e\u53d6\u6d88\u8ba2\u5355");
                    ((ExtBillView)this.view).refresh();
                }
            } else {
                ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
            }
        } else {
            ((ExtBillView)this.view).showMessage(errorMsg);
        }
    }

    private void goToPay(long orderId) {
        DynamicObjectCollection colPaymentType = PayHelper.getPaymentType((long)this.channelCache.getLong("channelid.id"));
        if (colPaymentType.size() == 0) {
            ((ExtBillView)this.view).showMessage("\u6682\u65e0\u53ef\u7528\u7684\u652f\u4ed8\u65b9\u5f0f");
        } else if (colPaymentType.size() == 1) {
            DynamicObject item = (DynamicObject)colPaymentType.get(0);
            long payConfigId = item.getLong("payConfigId");
            long payModeId = item.getLong("id");
            this.getPayData(orderId, payConfigId, payModeId);
        } else {
            OpenParam openParam = new OpenParam();
            openParam.setViewId("ocolsm_paydialog");
            openParam.addCustomParam("id", String.valueOf(orderId));
            openParam.setPostion(OpenParam.OpenPosition.Bottom);
            openParam.setTarget(OpenParam.OpenTarget.Pop);
            ((ExtBillView)this.getView()).showView(openParam);
        }
    }

    private void getPayData(long orderId, long payConfigId, long payModeId) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        HashMap payData = PayHelper.getPayData((long)this.channelCache.getLong("channelid.id"), (long)orderId, (long)memberId, (long)payConfigId, (long)payModeId);
        logger.info("payData=" + JSON.toJSONString((Object)payData));
        PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
        pageCache.put("payConfigId", String.valueOf(payConfigId));
        pageCache.put("payModeId", String.valueOf(payModeId));
        pageCache.put("orderId", String.valueOf(orderId));
        if (((String)payData.get("tradeStatus")).equals("SUCCESS")) {
            pageCache.put("payResponse", (String)payData.get("payResponse"));
            payData.keySet().removeIf(key -> key.equals("tradeStatus"));
            payData.keySet().removeIf(key -> key.equals("errorMessage"));
            payData.keySet().removeIf(key -> key.equals("payResponse"));
            String payWayType = PayHelper.getPayWayType((long)payModeId);
            if (payWayType.equals(PayModeEnum.WeChatPayType.toString())) {
                ((ExtBillView)this.view).wxPay((Map)payData, true);
            }
        } else {
            ((ExtBillView)this.view).showMessage((String)payData.get("errorMessage"));
        }
    }

    public void onPayBack(PayBackEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        PageCache pageCache = ((ExtBillView)this.view).getPageCache();
        JSONObject payResponse = JSONObject.parseObject((String)pageCache.get("payResponse"));
        String billNo = ObjectUtil.toString((Object)payResponse.get((Object)"billNo"));
        String outTradeNo = ObjectUtil.toString((Object)payResponse.get((Object)"out_trade_no"));
        long payModeId = ObjectUtil.toLong((Object)pageCache.get("payModeId"));
        long orderId = ObjectUtil.toLong((Object)pageCache.get("orderId"));
        long payConfigId = ObjectUtil.toLong((Object)pageCache.get("payConfigId"));
        DynamicObject orderDetail = OrderHelper.getOrder((Long)memberId, (long)orderId);
        long orderStatus = orderDetail.getLong("orderStatus");
        if (orderStatus < 3L) {
            long channelId = this.channelCache.getLong("channelid.id");
            Map payConfig = PayHelper.getPayConfig((long)payConfigId, (long)payModeId);
            logger.info("payConfig=" + JSON.toJSONString((Object)payConfig));
            JSONObject queryResponse = PayHelper.loopTradeQuery((long)payModeId, (Map)payConfig, (String)outTradeNo, (int)2, (int)500);
            logger.info("queryResponse=" + queryResponse.toJSONString());
            JSONObject miniPayResponse = WxPayTradeHelper.checkQueryAndCancel((String)outTradeNo, (JSONObject)queryResponse, (JSONObject)payResponse, (Map)payConfig, (String)billNo, (long)memberId, (Date)new Date(), (long)channelId);
            if (TradeStatus.SUCCESS.toString().equals(miniPayResponse.getString("payStatus"))) {
                OrderHelper.orderPaynotify((JSONObject)queryResponse);
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("id", String.valueOf(orderId));
                openParam.setViewId("ocolsm_orderdetail");
                ((ExtBillView)this.getView()).showView(openParam);
            } else {
                logger.error("\u672a\u652f\u4ed8\u6216\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u7ed3\u679c\uff1a" + payResponse);
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u8ba2\u5355\u4e0d\u662f\u672a\u4ed8\u6b3e\u72b6\u6001");
        }
        super.onPayBack(event);
    }
}

