/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.cart.CartHelper;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.AddressHelper;
import kd.occ.ocolsm.business.member.MemberHelper;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.RegExUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class OrderInvoiceMobAddPlugin
extends ExtBillViewPlugin {
    private DynamicObject channelCache = ConfigHelper.getChannelCache();

    public void afterDataLoad(LoadDataEvent event) {
        long orderId = ObjectUtil.toLong((Object)((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getString("orderid"), (long)0L);
        if (orderId == 0L) {
            ((ExtBillView)this.view).hide("isnotempty", true);
            ((ExtBillView)this.view).hide("isempty", false);
        } else {
            ((BillFormData)this.getBillData()).updateValue("orderid", (Object)orderId);
        }
        this.initInvoiceDiv();
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "addinvoice": {
                this.invoiceConfirm();
                break;
            }
        }
        super.onClick(event);
    }

    private void invoiceConfirm() {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolmm_ordersinvoice");
        DynamicObject orderInvoice = new DynamicObject((DynamicObjectType)entityType);
        boolean result = this.isBindInvoiceData(orderInvoice);
        if (result) {
            final long orderId = ((BillFormData)this.getBillData()).getLong("orderid");
            QFilter filter = new QFilter("id", "=", (Object)orderId);
            DynamicObject order = QueryServiceHelper.queryOne((String)"ocolmm_orders", (String)"createtime,orderstatus,apAmount", (QFilter[])filter.toArray());
            if (order == null) {
                ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u4e0d\u5b58\u5728");
            } else if (order.getLong("orderstatus") == 8L) {
                ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u5df2\u53d6\u6d88\uff0c\u4e0d\u80fd\u518d\u63d0\u4ea4\u5f00\u7968\u6570\u636e");
            } else {
                ArrayList<Long> ids = new ArrayList<Long>(){
                    {
                        this.add(Long.parseLong(String.valueOf(orderId)));
                    }
                };
                DynamicObjectCollection orderInvoices = MemberHelper.getOrderInvoices((List)ids, (long)memberId);
                ArrayList<ExtDynamicObject> lstOrderInvoice = new ArrayList<ExtDynamicObject>();
                for (DynamicObject data : orderInvoices) {
                    if (!data.getString("cancelstatus").equals("A")) continue;
                    ExtDynamicObject exData = new ExtDynamicObject();
                    exData.put("id", (Object)data.getString("id"));
                    exData.put("invoiceStatus", (Object)data.getString("invoiceStatus"));
                    lstOrderInvoice.add(exData);
                }
                if (lstOrderInvoice.size() > 0) {
                    ((ExtBillView)this.view).showMessage("\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u6570\u636e\uff0c\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
                } else {
                    orderInvoice.set("org", (Object)this.channelCache.getLong("channelid.saleorg.id"));
                    orderInvoice.set("channelId", (Object)this.channelCache.getLong("channelid.id"));
                    orderInvoice.set("orderId", (Object)orderId);
                    orderInvoice.set("memberId", (Object)memberId);
                    orderInvoice.set("invoiceAmount", (Object)order.getBigDecimal("apAmount"));
                    orderInvoice.set("billStatus", (Object)"B");
                    orderInvoice.set("invoiceStatus", (Object)2);
                    orderInvoice.set("cancelstatus", (Object)"A");
                    orderInvoice.set("openinvoicetype", (Object)1);
                    String billNo = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    orderInvoice.set("billno", (Object)billNo);
                    orderInvoice.set("createtime", (Object)new Date());
                    OperationResult invoiceResult = CartHelper.CreateOrderInvoice((DynamicObject)orderInvoice);
                    if (invoiceResult.isSuccess()) {
                        long id = (Long)invoiceResult.getSuccessPkIds().get(0);
                        OpenParam openParam = new OpenParam();
                        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                        openParam.setShowTitle(Boolean.TRUE);
                        openParam.addCustomParam("id", String.valueOf(id));
                        openParam.setViewId("ocolsm_orderinvoiceedit");
                        ((ExtBillView)this.getView()).showView(openParam);
                    } else {
                        ((ExtBillView)this.view).showMessage(invoiceResult.getMessage());
                    }
                }
            }
        }
    }

    protected void onDataChange(DataChangeEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "invoicetype": {
                String invoiceType = event.getValue().toString();
                if (invoiceType.equals("1")) {
                    ((ExtBillView)this.view).hide("invoiceheadtitle", false);
                    ((ExtBillView)this.view).hide("invoicehead", false);
                    int invoiceHead = ((BillFormData)this.getBillData()).getInt("invoicehead");
                    if (invoiceHead == 1) {
                        ((ExtBillView)this.view).hide("personagediv", false);
                    } else {
                        ((ExtBillView)this.view).hide("companydiv", false);
                    }
                    ((ExtBillView)this.view).hide("vatdiv", true);
                    ((ExtBillView)this.view).hide("receivediv", true);
                    break;
                }
                ((ExtBillView)this.view).hide("invoiceheadtitle", true);
                ((ExtBillView)this.view).hide("invoicehead", true);
                ((ExtBillView)this.view).hide("personagediv", true);
                ((ExtBillView)this.view).hide("companydiv", true);
                ((ExtBillView)this.view).hide("vatdiv", false);
                ((ExtBillView)this.view).hide("receivediv", false);
                break;
            }
            case "invoicehead": {
                String invoicehead = event.getValue().toString();
                if (invoicehead.equals("1")) {
                    ((ExtBillView)this.view).hide("personagediv", false);
                    ((ExtBillView)this.view).hide("companydiv", true);
                    break;
                }
                ((ExtBillView)this.view).hide("personagediv", true);
                ((ExtBillView)this.view).hide("companydiv", false);
                break;
            }
        }
    }

    public void initInvoiceDiv() {
        ((BillFormData)this.getBillData()).updateValue("invoicetype", (Object)"1");
        ((BillFormData)this.getBillData()).updateValue("invoicehead", (Object)"1");
        ((ExtBillView)this.view).hide("invoiceheadtitle", false);
        ((ExtBillView)this.view).hide("invoicehead", false);
        ((ExtBillView)this.view).hide("personagediv", false);
        ((BillFormData)this.getBillData()).updateValue("invoicecontent", (Object)"2");
    }

    public boolean isBindInvoiceData(DynamicObject invoiceData) {
        invoiceData.set("taxpayercode", (Object)" ");
        invoiceData.set("registeredAddress", (Object)" ");
        invoiceData.set("registeredPhone", (Object)" ");
        invoiceData.set("bank", (Object)" ");
        invoiceData.set("bankAccount", (Object)" ");
        invoiceData.set("receivername", (Object)" ");
        invoiceData.set("receivermobile", (Object)" ");
        invoiceData.set("countryid", (Object)0);
        invoiceData.set("provinceid", (Object)0);
        invoiceData.set("cityid", (Object)0);
        invoiceData.set("countyid", (Object)0);
        invoiceData.set("receiveraddress", (Object)" ");
        invoiceData.set("fulladdress", (Object)" ");
        invoiceData.set("divisionid", (Object)0);
        int invoiceContent = ((BillFormData)this.getBillData()).getInt("invoicecontent");
        String invoiceContentDetial = "";
        if (invoiceContent == 2) {
            invoiceContentDetial = "\u5546\u54c1\u660e\u7ec6";
        } else if (invoiceContent == 3) {
            invoiceContentDetial = "\u5546\u54c1\u5206\u7c7b";
        }
        String errorMsg = "";
        int invoiceType = ((BillFormData)this.getBillData()).getInt("invoicetype");
        if (invoiceType == 1) {
            int invoiceHead = ((BillFormData)this.getBillData()).getInt("invoicehead");
            if (invoiceHead == 1) {
                String personageName = ((BillFormData)this.getBillData()).getString("personagename");
                if (personageName.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u4e2a\u4eba\u540d\u79f0";
                } else if (!RegExUtil.isReceiverName((String)personageName)) {
                    errorMsg = "\u4e2a\u4eba\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u6587\u3001\u82f1\u6587\u3001\u6570\u5b57,\u957f\u5ea6\u57282-10\u4e4b\u95f4";
                } else {
                    invoiceData.set("invoiceType", (Object)"1");
                    invoiceData.set("invoiceTitle", (Object)personageName);
                }
            } else {
                String companyName = ((BillFormData)this.getBillData()).getString("companyName");
                String taxPayerCode = ((BillFormData)this.getBillData()).getString("taxPayerCode");
                String registeredAddress = ((BillFormData)this.getBillData()).getString("registeredAddress");
                String registeredPhone = ((BillFormData)this.getBillData()).getString("registeredPhone");
                String bank = ((BillFormData)this.getBillData()).getString("bank");
                String bankAccount = ((BillFormData)this.getBillData()).getString("bankAccount");
                if (companyName.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u516c\u53f8\u540d\u79f0";
                } else if (!RegExUtil.isCompanyName((String)companyName)) {
                    errorMsg = "\u516c\u53f8\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (taxPayerCode.equals("")) {
                    errorMsg = "\u8bf7\u586b\u5199\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7";
                } else if (!RegExUtil.isNsrCode((String)taxPayerCode)) {
                    errorMsg = "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53ea\u80fd\u8f93\u5165\u5927\u5199\u82f1\u6587\u3001\u6570\u5b57\uff0c\u957f\u5ea6\u572815-20\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)registeredAddress) && !RegExUtil.isAddress((String)registeredAddress)) {
                    errorMsg = "\u6ce8\u518c\u5730\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)registeredPhone) && !RegExUtil.isPhoneOrMobile((String)registeredPhone)) {
                    errorMsg = "\u6ce8\u518c\u7535\u8bdd\u53ea\u80fd\u8f93\u5165\u624b\u673a\u6216\u5ea7\u673a";
                } else if (StringUtil.isNotEmpty((String)bank) && !RegExUtil.isCompanyName((String)bank)) {
                    errorMsg = "\u5f00\u6237\u94f6\u884c\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
                } else if (StringUtil.isNotEmpty((String)bankAccount) && !RegExUtil.isBankAccout((String)bankAccount)) {
                    errorMsg = "\u94f6\u884c\u8d26\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57 ,\u957f\u5ea6\u572810-20\u4e4b\u95f4";
                } else {
                    invoiceData.set("invoiceType", (Object)"1");
                    invoiceData.set("invoiceTitle", (Object)companyName);
                    invoiceData.set("taxpayercode", (Object)taxPayerCode);
                    invoiceData.set("registeredAddress", (Object)registeredAddress);
                    invoiceData.set("registeredPhone", (Object)registeredPhone);
                    invoiceData.set("bank", (Object)bank);
                    invoiceData.set("bankAccount", (Object)bankAccount);
                }
            }
        } else {
            String vatCompanyName = ((BillFormData)this.getBillData()).getString("vatCompanyname");
            String vatTaxPayerCode = ((BillFormData)this.getBillData()).getString("vatTaxPayerCode");
            String vatRegisteredAddress = ((BillFormData)this.getBillData()).getString("vatRegisteredAddress");
            String vatRegisteredPhone = ((BillFormData)this.getBillData()).getString("vatRegisteredPhone");
            String vatBank = ((BillFormData)this.getBillData()).getString("vatBank");
            String vatBankAccount = ((BillFormData)this.getBillData()).getString("vatBankAccount");
            String invoiceReceiverName = ((BillFormData)this.getBillData()).getString("invoiceReceiverName");
            String invoiceReceiverMobile = ((BillFormData)this.getBillData()).getString("invoiceReceiverMobile");
            String invoiceReceiverAddress = ((BillFormData)this.getBillData()).getString("invoiceReceiverAddress");
            ExtDynamicObject region = new ExtDynamicObject();
            int invoicedistrictId = ((BillFormData)this.getBillData()).getInt("invoicedistrictid");
            if (invoicedistrictId > 0) {
                region = AddressHelper.getFullDivision((long)invoicedistrictId);
            }
            if (vatCompanyName.equals("")) {
                errorMsg = "\u8bf7\u586b\u5199\u516c\u53f8\u540d\u79f0";
            } else if (!RegExUtil.isCompanyName((String)vatCompanyName)) {
                errorMsg = "\u516c\u53f8\u540d\u79f0\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (vatTaxPayerCode.equals("")) {
                errorMsg = "\u8bf7\u586b\u5199\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7";
            } else if (!RegExUtil.isNsrCode((String)vatTaxPayerCode)) {
                errorMsg = "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53ea\u80fd\u8f93\u5165\u5927\u5199\u82f1\u6587\u3001\u6570\u5b57\uff0c\u957f\u5ea6\u572815-20\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatRegisteredAddress) && !RegExUtil.isAddress((String)vatRegisteredAddress)) {
                errorMsg = "\u6ce8\u518c\u5730\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatRegisteredPhone) && !RegExUtil.isPhoneOrMobile((String)vatRegisteredPhone)) {
                errorMsg = "\u6ce8\u518c\u7535\u8bdd\u53ea\u80fd\u8f93\u5165\u624b\u673a\u6216\u5ea7\u673a";
            } else if (StringUtil.isNotEmpty((String)vatBank) && !RegExUtil.isCompanyName((String)vatBank)) {
                errorMsg = "\u5f00\u6237\u94f6\u884c\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (StringUtil.isNotEmpty((String)vatBankAccount) && !RegExUtil.isBankAccout((String)vatBankAccount)) {
                errorMsg = "\u94f6\u884c\u8d26\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57 ,\u957f\u5ea6\u572810-20\u4e4b\u95f4";
            } else if (!RegExUtil.isReceiverName((String)invoiceReceiverName)) {
                errorMsg = "\u6536\u7968\u4eba\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            } else if (!RegExUtil.isMobile((String)invoiceReceiverMobile)) {
                errorMsg = "\u6536\u7968\u4eba\u624b\u673a\u53ea\u80fd\u8f93\u516511\u4f4d\u7684\u624b\u673a\u53f7";
            } else if (invoicedistrictId <= 0) {
                errorMsg = "\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u6536\u7968\u4eba\u7701\u3001\u5e02\u3001\u53bf";
            } else if (region.getString("fullids").split("_").length < 3) {
                errorMsg = "\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u6536\u7968\u4eba\u7701\u3001\u5e02\u3001\u53bf";
            } else if (!RegExUtil.isReceiverName((String)invoiceReceiverAddress)) {
                errorMsg = "\u6536\u7968\u4eba\u5730\u5740\u53ea\u80fd\u8f93\u5165\u4e2d\u82f1\u6587\u6570\u5b57.,()\uff08\uff09-\u2014\u2014_\u7a7a\u683c ,\u957f\u5ea6\u57285-50\u4e4b\u95f4";
            }
            if (errorMsg.equals("")) {
                invoiceData.set("invoiceType", (Object)"2");
                invoiceData.set("invoiceTitle", (Object)vatCompanyName);
                invoiceData.set("taxpayercode", (Object)vatTaxPayerCode);
                invoiceData.set("registeredAddress", (Object)vatRegisteredAddress);
                invoiceData.set("registeredPhone", (Object)vatRegisteredPhone);
                invoiceData.set("bank", (Object)vatBank);
                invoiceData.set("bankAccount", (Object)vatBankAccount);
                invoiceData.set("receivername", (Object)invoiceReceiverName);
                invoiceData.set("receivermobile", (Object)invoiceReceiverMobile);
                invoiceData.set("countryid", (Object)region.getString("countryid"));
                invoiceData.set("provinceid", (Object)region.getString("fullids").split("_")[0]);
                invoiceData.set("cityid", (Object)region.getString("fullids").split("_")[1]);
                invoiceData.set("countyid", (Object)invoicedistrictId);
                invoiceData.set("divisionid", (Object)invoicedistrictId);
                invoiceData.set("receiveraddress", (Object)invoiceReceiverAddress);
                invoiceData.set("fulladdress", (Object)(region.getString("fullname").replaceAll("_", "") + invoiceReceiverAddress));
            }
        }
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            ((ExtBillView)this.view).showMessage(errorMsg);
            return false;
        }
        invoiceData.set("invoiceContent", (Object)invoiceContentDetial);
        ((ExtBillView)this.view).closePopPanel("invoicediv");
        return true;
    }
}

