/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;
import kd.occ.ocepfp.core.form.plugin.ExtListViewPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.common.util.ObjectUtil;
import kd.occ.ocolsm.common.util.StringUtil;

public class OrderInvoiceMobListPlugin
extends ExtListViewPlugin {
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private String searchInput = "";
    private int status = 0;
    private static final String itementrys = "goodslist";

    public QueryFilter buildQueryFilter(QueryFilter queryFilter, ClientEvent event) {
        QueryFilterParam queryFilterParam = queryFilter.getQueryFilterParam("searchinput");
        this.searchInput = queryFilterParam != null ? ObjectUtil.toString(queryFilterParam.getValue().getValue().get(0)) : "";
        queryFilterParam = null;
        queryFilterParam = queryFilter.getQueryFilterParam("status");
        this.status = queryFilterParam != null ? ObjectUtil.toInt(queryFilterParam.getValue().getValue().get(0), (int)0) : 0;
        return super.buildQueryFilter(queryFilter, event);
    }

    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        int pageSize;
        int page;
        ListDataSet listDataSet = new ListDataSet();
        long memberId = ((ExtListView)this.view).getExtCtx().getMemberId();
        DynamicObjectCollection pageDate = this.getOrderInvoices(memberId, this.searchInput, this.status, page = ObjectUtil.toInt((Object)event.getPage()), pageSize = ObjectUtil.toInt((Object)event.getPageSize()));
        if (pageDate.size() > 0) {
            listDataSet.setRows((Object)pageDate);
            ((ExtListView)this.view).hide(itementrys, false);
            ((ExtListView)this.view).hide("isempty", true);
        } else {
            ((ExtListView)this.view).hide(itementrys, true);
            ((ExtListView)this.view).hide("isempty", false);
        }
        return listDataSet;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "gotoinvoice": {
                DynamicObject currentRow = ((ListFormData)this.getBillData()).getEntryRowData(itementrys, event.getCurrentRow());
                long id = currentRow.getLong("id");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_orderinvoiceedit");
                openParam.addCustomParam("id", String.valueOf(id));
                ((ExtListView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private DynamicObjectCollection getOrderInvoices(long memberId, String searchInput, int invoiceStatus, int page, int pageSize) {
        QFilter filter = new QFilter("memberId", "=", (Object)memberId);
        if (invoiceStatus > 0) {
            filter.and(new QFilter("invoiceStatus", "=", (Object)String.valueOf(invoiceStatus)));
        }
        if (StringUtil.isNotEmpty((String)searchInput)) {
            filter.and(new QFilter("billno", "like", (Object)searchInput));
        }
        DynamicObject[] orders = this.getOrderInvoices(filter, page, pageSize);
        DynamicObjectCollection pageDate = new DynamicObjectCollection();
        for (DynamicObject order : orders) {
            boolean isFilterShipping = true;
            DynamicObjectCollection orderItems = OrderHelper.getOrderItem((Long)memberId, (long)order.getLong("orderid.id"), (boolean)isFilterShipping);
            for (DynamicObject item : orderItems) {
                DynamicObject itemDate = ((ListFormData)this.getBillData()).createNewEntryDynamicObject(itementrys);
                itemDate.set("billno", (Object)order.getString("billno"));
                itemDate.set("orderno", (Object)order.getString("orderid.number"));
                itemDate.set("id", (Object)order.getString("id"));
                itemDate.set("itemid", (Object)item.getLong("itemid"));
                itemDate.set("itemnumber", item.get("itemnumber"));
                itemDate.set("itemname", (Object)item.getString("itemname"));
                itemDate.set("thumbnail", (Object)(PictureUtil.getFileServerUrl() + (String)item.get("thumbnail")));
                itemDate.set("qty", (Object)item.getInt("qty"));
                itemDate.set("taxPrice", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("taxPrice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                pageDate.add((Object)itemDate);
            }
        }
        return pageDate;
    }

    public DynamicObject[] getOrderInvoices(QFilter filters, int page, int pageSize) {
        String orderBy = "id desc";
        return BusinessDataServiceHelper.load((String)"ocolmm_ordersinvoice", (String)"id,billno,invoicetype,invoiceamount,invoicecontent,invoicetitle,taxpayercode,registeredaddress,registeredphone,bank,bankaccount,invoicestatus,invoicecode,invoiceno,pdflink,orderid", (QFilter[])filters.toArray(), (String)orderBy, (int)(--page), (int)pageSize);
    }
}

