/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.occ.ocbase.business.payhelper.WxPayTradeHelper;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Radio;
import kd.occ.ocepfp.core.form.control.controls.RadioGroup;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.business.pay.PayHelper;
import kd.occ.ocolsm.common.constant.PayModeEnum;
import kd.occ.ocolsm.common.util.ObjectUtil;

public class PayDialogPlugin
extends ExtBillViewPlugin {
    private static Log logger = LogFactory.getLog(PayDialogPlugin.class);
    private DynamicObject channelCache = ConfigHelper.getChannelCache();

    public boolean initView(InitViewEvent initViewEvent) {
        DynamicObjectCollection colPaymentType = PayHelper.getPaymentType((long)this.channelCache.getLong("channelid.id"));
        if (colPaymentType.size() > 0) {
            RadioGroup sg = (RadioGroup)((ExtBillView)this.view).getControl("paymenttypegroup");
            for (DynamicObject item : colPaymentType) {
                Radio r = new Radio();
                r.setId(item.getString("id"));
                r.setName(item.getString("name"));
                r.setValue((Object)(item.getString("payConfigId") + "_" + item.getString("id")));
                sg.addChild((Object)r);
            }
        }
        return false;
    }

    public void afterDataLoad(LoadDataEvent event) {
        String payConfigId_payModeId;
        RadioGroup sg = (RadioGroup)((ExtBillView)this.view).getControl("paymenttypegroup");
        ((ExtBillView)this.view).hide("paydialogdiv", false);
        RadioGroup gp = (RadioGroup)((ExtBillView)this.view).getControl("paymenttypegroup");
        List lstRadio = gp.getChilds();
        if (lstRadio.size() > 0) {
            payConfigId_payModeId = ObjectUtil.toString((Object)((Control)lstRadio.get(0)).getValue());
            ((BillFormData)this.getBillData()).updateValue("paymenttypegroup", (Object)String.valueOf(payConfigId_payModeId));
        }
        if (sg.getChilds().size() == 1) {
            payConfigId_payModeId = ((BillFormData)this.getBillData()).getString("paymenttypegroup");
            long payConfigId = ObjectUtil.toLong((Object)payConfigId_payModeId.split("_")[0]);
            long payModeId = ObjectUtil.toLong((Object)payConfigId_payModeId.split("_")[1]);
            long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
            this.getPayData(orderId, payConfigId, payModeId);
        } else if (sg.getChilds().size() == 0) {
            ((ExtBillView)this.view).showMessage("\u6682\u65e0\u53ef\u7528\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
    }

    public void onClick(ClickEvent clickevent) {
        String eventId;
        switch (eventId = clickevent.getId()) {
            case "gotopay": {
                String payConfigId_payModeId = ((BillFormData)this.getBillData()).getString("paymenttypegroup");
                long payConfigId = ObjectUtil.toLong((Object)payConfigId_payModeId.split("_")[0]);
                long payModeId = ObjectUtil.toLong((Object)payConfigId_payModeId.split("_")[1]);
                long orderId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getLong("id");
                if (payModeId > 0L) {
                    this.getPayData(orderId, payConfigId, payModeId);
                    break;
                }
                ((ExtBillView)this.view).showMessage("\u8bf7\u9009\u62e9\u652f\u4ed8\u65b9\u5f0f");
            }
        }
        super.onClick(clickevent);
    }

    private void getPayData(long orderId, long payConfigId, long payModeId) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        HashMap payData = PayHelper.getPayData((long)this.channelCache.getLong("channelid.id"), (long)orderId, (long)memberId, (long)payConfigId, (long)payModeId);
        logger.info("payData=" + JSON.toJSONString((Object)payData));
        PageCache pageCache = new PageCache(((ExtBillView)this.view).getPageId());
        pageCache.put("payConfigId", String.valueOf(payConfigId));
        pageCache.put("payModeId", String.valueOf(payModeId));
        pageCache.put("orderId", String.valueOf(orderId));
        if (((String)payData.get("tradeStatus")).equals("SUCCESS")) {
            pageCache.put("payResponse", (String)payData.get("payResponse"));
            payData.keySet().removeIf(key -> key.equals("tradeStatus"));
            payData.keySet().removeIf(key -> key.equals("errorMessage"));
            payData.keySet().removeIf(key -> key.equals("payResponse"));
            String payWayType = PayHelper.getPayWayType((long)payModeId);
            if (payWayType.equals(PayModeEnum.WeChatPayType.toString())) {
                ((ExtBillView)this.view).wxPay((Map)payData, true);
            }
        } else {
            ((ExtBillView)this.view).showMessage((String)payData.get("errorMessage"));
        }
    }

    public void onPayBack(PayBackEvent event) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        PageCache pageCache = ((ExtBillView)this.view).getPageCache();
        JSONObject payResponse = JSONObject.parseObject((String)pageCache.get("payResponse"));
        String billNo = ObjectUtil.toString((Object)payResponse.get((Object)"billNo"));
        String outTradeNo = ObjectUtil.toString((Object)payResponse.get((Object)"out_trade_no"));
        long payModeId = ObjectUtil.toLong((Object)pageCache.get("payModeId"));
        long orderId = ObjectUtil.toLong((Object)pageCache.get("orderId"));
        long payConfigId = ObjectUtil.toLong((Object)pageCache.get("payConfigId"));
        DynamicObject orderDetail = OrderHelper.getOrder((Long)memberId, (long)orderId);
        long orderStatus = orderDetail.getLong("orderStatus");
        if (orderStatus < 3L) {
            long channelId = this.channelCache.getLong("channelid.id");
            Map payConfig = PayHelper.getPayConfig((long)payConfigId, (long)payModeId);
            JSONObject queryResponse = PayHelper.loopTradeQuery((long)payModeId, (Map)payConfig, (String)outTradeNo, (int)2, (int)500);
            logger.info("queryResponse=" + queryResponse.toJSONString());
            JSONObject miniPayResponse = WxPayTradeHelper.checkQueryAndCancel((String)outTradeNo, (JSONObject)queryResponse, (JSONObject)payResponse, (Map)payConfig, (String)billNo, (long)memberId, (Date)new Date(), (long)channelId);
            logger.info("miniPayResponse=" + miniPayResponse.toJSONString());
            if (TradeStatus.SUCCESS.toString().equals(miniPayResponse.getString("payStatus"))) {
                OrderHelper.orderPaynotify((JSONObject)queryResponse);
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.addCustomParam("id", String.valueOf(orderId));
                openParam.setViewId("ocolsm_orderdetail");
                ((ExtBillView)this.getView()).showView(openParam);
            } else {
                logger.error("\u672a\u652f\u4ed8\u6216\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u7ed3\u679c\uff1a" + payResponse);
            }
        } else {
            ((ExtBillView)this.view).showMessage("\u652f\u4ed8\u5931\u8d25,\u8ba2\u5355\u4e0d\u662f\u672a\u4ed8\u6b3e\u72b6\u6001");
        }
        super.onPayBack(event);
    }
}

