/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SearchEvent;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.member.OrderHelper;
import kd.occ.ocolsm.common.util.StringUtil;
import org.apache.commons.lang.ArrayUtils;

public class ProductChangOrRefundPlugin
extends ExtBillViewPlugin {
    private static final String orderitementrys = "goodslist";
    private static final String aftersalesitementrys = "aftersaleslist";

    public void onSearch(SearchEvent event) {
        this.onDataLoad((LoadDataEvent)event);
    }

    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject dynamicObject = super.onDataLoad(event);
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        QueryFilterParam queryFilterParam = event.getQueryFilter().getQueryFilterParam("searchinput");
        String searchinput = queryFilterParam != null ? (String)queryFilterParam.getValue().getValue().get(0) : "";
        searchinput = searchinput == null ? "" : searchinput;
        String ServersStatus = "0";
        queryFilterParam = event.getQueryFilter().getQueryFilterParam("aftersalesstatus");
        if (queryFilterParam != null) {
            ServersStatus = queryFilterParam.getValue().getValue().get(0).toString();
        }
        if (ServersStatus.equals("0")) {
            ((ExtBillView)this.view).hide(orderitementrys, false);
            ((ExtBillView)this.view).hide(aftersalesitementrys, true);
            String page = String.valueOf(event.getPage());
            String pageSize = String.valueOf(event.getPageSize());
            DynamicObjectCollection pageDate = this.getOrders(memberId, searchinput, page, pageSize);
            ((BillFormData)this.getBillData()).updateValue(orderitementrys, (Object)pageDate);
        } else if (ServersStatus.equals("1") || ServersStatus.equals("2")) {
            ((ExtBillView)this.view).hide(orderitementrys, true);
            ((ExtBillView)this.view).hide(aftersalesitementrys, false);
            String page = String.valueOf(event.getPage());
            String pageSize = String.valueOf(event.getPageSize());
            DynamicObjectCollection pageDate = this.getAfterSales(memberId, searchinput, ServersStatus, page, pageSize);
            ((BillFormData)this.getBillData()).updateValue(aftersalesitementrys, (Object)pageDate);
            ((ExtBillView)this.view).hide("cancelbtn", false);
        }
        return dynamicObject;
    }

    protected void onClick(ClickEvent event) {
        String eventId;
        switch (eventId = event.getId()) {
            case "itemapplyfor": 
            case "itemapplyfordiv": {
                DynamicObject orserCurrentRow = ((BillFormData)this.getBillData()).getEntryRowData(orderitementrys, event.getCurrentRow());
                Long opid = orserCurrentRow.getLong("opid");
                Long orderno = orserCurrentRow.getLong("orderno");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_applyforaftersales");
                openParam.addCustomParam("orderno", orderno.toString());
                openParam.addCustomParam("opid", opid.toString());
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "applyfor": {
                DynamicObject orserCurrentRow = ((BillFormData)this.getBillData()).getEntryRowData(orderitementrys, event.getCurrentRow());
                Long orderno = orserCurrentRow.getLong("orderno");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_applyforaftersales");
                openParam.addCustomParam("orderno", orderno.toString());
                openParam.addCustomParam("opid", "0");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "cancelbtn": {
                DynamicObject aftersalesCurrentRow = ((BillFormData)this.getBillData()).getEntryRowData(aftersalesitementrys, event.getCurrentRow());
                this.goToCancel(aftersalesCurrentRow);
                break;
            }
            case "viewdetailsdiv": 
            case "viewdetails": {
                DynamicObject aftersalesCurrentRow = ((BillFormData)this.getBillData()).getEntryRowData(aftersalesitementrys, event.getCurrentRow());
                Long aftersalesid = aftersalesCurrentRow.getLong("aftersalesid");
                String afterSalesStatus = "0";
                QueryFilterParam queryFilterParam = event.getQueryFilter().getQueryFilterParam("aftersalesstatus");
                if (queryFilterParam != null) {
                    afterSalesStatus = queryFilterParam.getValue().getValue().get(0).toString();
                }
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_aftersalesdetail");
                openParam.addCustomParam("aftersalesid", aftersalesid.toString());
                openParam.addCustomParam("ServersStatus", afterSalesStatus);
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "itemreturnbtn": {
                DynamicObject aftersalesCurrentRow = ((BillFormData)this.getBillData()).getEntryRowData(aftersalesitementrys, event.getCurrentRow());
                String aftersalesno = aftersalesCurrentRow.getString("aftersalesno");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_productreturn");
                openParam.addCustomParam("aftersalesno", aftersalesno);
                openParam.addCustomParam("previouspage", "ocolsm_aftersaleslist");
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
        }
        super.onClick(event);
    }

    private void goToCancel(DynamicObject currentRow) {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        long aftersalesid = currentRow.getLong("aftersalesid");
        String msg = OrderHelper.cancelAfterSales((Long)memberId, (long)aftersalesid);
        if (msg.equals("")) {
            msg = "\u552e\u540e\u5355\u5df2\u53d6\u6d88";
            DynamicObjectCollection goodsListDate = ((BillFormData)this.getBillData()).getEntryRowData(aftersalesitementrys);
            int rowIndex = goodsListDate.indexOf((Object)currentRow);
            ((BillFormData)this.getBillData()).delEntryRow(aftersalesitementrys, rowIndex);
        }
        ((ExtBillView)this.view).showMessage(msg);
    }

    private DynamicObjectCollection getOrders(long memberId, String searchinput, String strPage, String strPageSize) {
        Row row;
        String sql = "select o.fid,op.fentryid,r.fqty from t_ocolmm_ordersentry op left join t_ocolmm_orders o on o.fid=op.fid left join (select ap.fsrcbillentryid,sum(ab.fqty) fqty from t_ocolmm_asentry_s ap left join t_ocolmm_asentry ab on ab.fentryid=ap.fentryid left join t_ocolmm_aftersales a on a.fid=ap.fid where a.fcancelstatus=? group by ap.fsrcbillentryid) r on r.fsrcbillentryid=op.fentryid where op.fisshipping='0' and (r.fsrcbillentryid is null or op.fqty>r.fqty) and o.fmemberid=? and o.forderstatus in ('6','7')";
        Object[] params = new Object[]{Character.valueOf('A'), memberId};
        String string = searchinput = searchinput == null ? "" : searchinput;
        if (StringUtil.isNotEmpty((String)searchinput)) {
            sql = sql + " and o.fbillno like ?";
            params = ArrayUtils.add((Object[])params, (Object)("%" + searchinput + "%"));
        }
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getOrders";
        ArrayList<Long> oidList = new ArrayList<Long>();
        ArrayList<Long> opidList = new ArrayList<Long>();
        DataSet dscopy = null;
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"kmall"), (String)sql, (Object[])params);){
            String[] stroid = new String[]{"fid"};
            DataSet oidds = ds.groupBy(stroid).finish().orderBy(new String[]{"fid desc"});
            DataSet opiddsds = ds.copy();
            dscopy = ds.copy();
            int page = Integer.parseInt(strPage);
            int pageSize = Integer.parseInt(strPageSize);
            long minFid = 0L;
            for (int i = 0; oidds.hasNext() && i >= (page - 1) * pageSize && i < page * pageSize; ++i) {
                Row row2 = oidds.next();
                oidList.add(row2.getLong("fid"));
                minFid = row2.getLong("fid");
            }
            DataSet opidds = opiddsds.where("fid>=" + minFid).orderBy(new String[]{"fentryid desc"});
            while (opidds.hasNext()) {
                row = opidds.next();
                long fid = row.getLong("fid");
                if (oidList.indexOf(fid) <= -1) continue;
                opidList.add(row.getLong("fentryid"));
            }
        }
        QFilter orderfilter = new QFilter("ocolmm_ordersentry.id", "in", opidList);
        String orderBy = "id desc";
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"ocolmm_orders", (String)"id orderid,billno orderno,ocolmm_ordersentry.id opid,ocolmm_ordersentry.itemid itemid,ocolmm_ordersentry.itemid.number itemnumber,ocolmm_ordersentry.itemid.name itemname,ocolmm_ordersentry.modelnumname modelnumname,ocolmm_ordersentry.itemid.thumbnail itemimg,ocolmm_ordersentry.isshipping isshipping,ocolmm_ordersentry.qty itemqty", (QFilter[])orderfilter.toArray(), (String)orderBy);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((BillFormData)this.getBillData()).getDataObject().getDataEntityType().getName());
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(orderitementrys);
        DynamicObjectCollection pageDate = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entityType);
        for (DynamicObject order : orders) {
            DynamicObject itemDate = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(orderitementrys);
            int itemqty = order.getInt("itemqty");
            DataSet itemds = dscopy.copy().filter("fentryid=" + order.get("opid") + " and fqty>0");
            if (!itemds.isEmpty()) {
                row = itemds.next();
                int rqty = row.getInteger("fqty");
                itemqty -= rqty;
            }
            itemDate.set("orderno", (Object)order.getString("orderno"));
            itemDate.set("itemid", (Object)order.getLong("itemid"));
            itemDate.set("itemnumber", order.get("itemnumber"));
            itemDate.set("itemname", (Object)(order.getString("itemname") + "  " + order.getString("modelnumname")));
            itemDate.set("itemimg", (Object)(PictureUtil.getFileServerUrl() + (String)order.get("itemimg")));
            itemDate.set("itemqty", (Object)itemqty);
            itemDate.set("opid", order.get("opid"));
            itemDate.set("ordertype", (Object)"\u9000\u8d27");
            pageDate.add((Object)itemDate);
            ((ExtBillView)this.view).hide("applyfor", false);
            ((ExtBillView)this.view).hide("cancelrequest", true);
            ((ExtBillView)this.view).hide("viewdetails", true);
        }
        return pageDate;
    }

    private DynamicObjectCollection getAfterSales(long memberId, String searchinput, String ServersStatus, String page, String pageSize) {
        DynamicObjectCollection aftersales = OrderHelper.getAfterSales((long)memberId, (String)searchinput, (String)ServersStatus, (String)page, (String)pageSize);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((BillFormData)this.getBillData()).getDataObject().getDataEntityType().getName());
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(aftersalesitementrys);
        DynamicObjectCollection pageDate = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entityType);
        for (DynamicObject aftersalesitem : aftersales) {
            DynamicObject itemDate = ((BillFormData)this.getBillData()).createNewEntryDynamicObject(aftersalesitementrys);
            String aftersalesno = aftersalesitem.getString("aftersalesno");
            String billstatus = aftersalesitem.getString("billstatus");
            long opid = aftersalesitem.getLong("opid");
            QFilter orderfilter = new QFilter("ocolmm_ordersentry.id", "=", (Object)opid);
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"ocolmm_orders", (String)"id orderid,billno orderno,ocolmm_ordersentry.modelnumname modelnumname", (QFilter[])orderfilter.toArray());
            String modelnumname = "";
            for (DynamicObject ordersitem : orders) {
                modelnumname = ordersitem.getString("modelnumname");
            }
            itemDate.set("aftersalesid", (Object)aftersalesitem.getLong("aftersalesid"));
            itemDate.set("aftersalesno", (Object)aftersalesno);
            itemDate.set("aftersalesorderno", (Object)aftersalesitem.getString("orderno"));
            itemDate.set("aftersalesitemid", (Object)aftersalesitem.getLong("itemid"));
            itemDate.set("aftersalesitemnumber", aftersalesitem.get("itemnumber"));
            itemDate.set("aftersalesitemname", (Object)(aftersalesitem.getString("itemname") + "  " + modelnumname));
            itemDate.set("aftersalesitemimg", (Object)(PictureUtil.getFileServerUrl() + (String)aftersalesitem.get("itemimg")));
            itemDate.set("aftersalesitemqty", (Object)aftersalesitem.getInt("qty"));
            itemDate.set("aftersalesopid", aftersalesitem.get("opid"));
            itemDate.set("aftersalesordertype", aftersalesitem.get("billtype"));
            pageDate.add((Object)itemDate);
            if (billstatus.equals("A")) {
                ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "cancelbtn", false);
                ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "itemreturnbtn", true);
                continue;
            }
            if (billstatus.equals("B")) {
                ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "cancelbtn", false);
                ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "itemreturnbtn", true);
                continue;
            }
            if (!billstatus.equals("C")) continue;
            ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "cancelbtn", true);
            ((ExtBillView)this.view).hideGroupFooter(aftersalesno, "itemreturnbtn", false);
        }
        return pageDate;
    }
}

