/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.InventoryParamConst;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.PictureUtil;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocolsm.business.cart.CartHelper;
import kd.occ.ocolsm.business.config.ConfigHelper;
import kd.occ.ocolsm.business.member.AddressHelper;
import kd.occ.ocolsm.common.util.StringUtil;

public class ProductMobDetailPlugin
extends ExtBillViewPlugin {
    private DynamicObject channelCache = ConfigHelper.getChannelCache();
    private long addressId = 0L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject data = super.onDataLoad(event);
        String itemId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getString("itemid");
        String spuId = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam().getString("spuid");
        itemId = itemId == null ? "" : itemId;
        spuId = spuId == null ? "0" : spuId;
        ((BillFormData)this.getBillData()).updateValue("itemid", (Object)itemId);
        ((BillFormData)this.getBillData()).updateValue("spuid", (Object)spuId);
        String customerid = String.valueOf(this.channelCache.getLong("channelid.id"));
        if (customerid.length() > 1) {
            int cartcount = this.getCartSumCount();
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartcount);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("materielid", "materielid");
            map.put("auxptyid", "auxptyid");
            map.put("itemid.saleunit", "unitid");
            map.put("itemid.baseunit", "baseunit");
            map.put("itemid.description_tag", "description_tag");
            String appendFields = SerializationUtils.toJsonString(map);
            JSONObject ReturnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemDetail", (Object[])new Object[]{"ocolmm_itemsale_content", customerid, spuId, itemId, appendFields});
            if (ReturnData.get((Object)"code").toString() == "0000") {
                JSONArray products = ReturnData.getJSONArray("data");
                int productCount = ReturnData.getIntValue("count");
                ((BillFormData)this.billData).updateValue("productcount", (Object)productCount);
                if (productCount > 1) {
                    ((ExtBillView)this.view).hide("auxpty_flexpanel", false);
                } else {
                    ((ExtBillView)this.view).hide("auxpty_flexpanel", true);
                }
                if (products.size() > 0) {
                    boolean isInvEntoryMatch;
                    if (spuId.length() > 1) {
                        String spumapIds = this.getEnableGroup(spuId, products);
                        ((BillFormData)this.billData).updateValue("spumapids", (Object)spumapIds);
                    }
                    JSONObject item = products.getJSONObject(0);
                    ArrayList<ImgObject> lstImg = new ArrayList<ImgObject>();
                    for (int j = 1; j < 6; ++j) {
                        String picture = item.getString("picture" + j);
                        if (picture.length() <= 0) continue;
                        ImgObject img = new ImgObject();
                        img.setWidth("360");
                        img.setHeight("360");
                        img.setId("img" + j + "_" + itemId);
                        img.setSrc(PictureUtil.getFileServerUrl() + picture);
                        lstImg.add(img);
                    }
                    ((BillFormData)this.billData).updateValue("price", (Object)StringUtil.setSign((BigDecimal)item.getBigDecimal("memberprice"), (int)2, (String)this.channelCache.getString("channelid.currency.sign")));
                    ((BillFormData)this.billData).updateValue("itemname", item.get((Object)"itemname"));
                    ((BillFormData)this.billData).updateValue("shorttitle", item.get((Object)"shorttitle"));
                    ((BillFormData)this.billData).updateValue("materielid", item.get((Object)"materielid"));
                    ((BillFormData)this.billData).updateValue("auxptyid", (Object)item.get((Object)"auxptyid").toString());
                    ((BillFormData)this.billData).updateValue("sel_content", item.get((Object)"itemname"));
                    ((BillFormData)this.billData).updateImgGroup("itemimg", lstImg);
                    ((BillFormData)this.billData).updateValue("descriptiontext", (Object)item.getString("description_tag"));
                    ((BillFormData)this.billData).updateValue("parametertext", (Object)"\u89c4\u683c\u53c2\u6570");
                    ((BillFormData)this.billData).updateValue("servicetext", (Object)"\u552e\u540e\u670d\u52a1");
                    DynamicObject customerInfo = ConfigHelper.getCustomerParams((Long)this.channelCache.getLong("channelid.saleorg.id"));
                    if (customerInfo == null || !(isInvEntoryMatch = customerInfo.getBoolean("isinventorymatch"))) return data;
                    long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
                    this.bindAddress(memberId);
                    this.addressId = ((BillFormData)this.getBillData()).getLong("addressid");
                    if (this.addressId <= 0L) return data;
                    ((ExtBillView)this.view).hide("addresspanel", false);
                    ((ExtBillView)this.view).hide("addressflexpanel", false);
                    ((BillFormData)this.getBillData()).updateValue("selectaddress", (Object)" ");
                    ArrayList<JSONObject> eachEntityList = new ArrayList<JSONObject>();
                    InventoryParamConst inventoryParamConst = new InventoryParamConst();
                    JSONObject eachEntity = new JSONObject();
                    long districtId = ((BillFormData)this.getBillData()).getLong("districtid");
                    eachEntity.put("saleOrgId", (Object)this.channelCache.getLong("channelid.saleorg.id"));
                    eachEntity.put("saleChannelID", (Object)this.channelCache.getLong("channelid.id"));
                    eachEntity.put("itemId", (Object)itemId);
                    eachEntity.put("materialId", (Object)item.getLong("materielid"));
                    eachEntity.put("auxPtyID", (Object)item.getLong("auxptyid"));
                    eachEntity.put("unitId", (Object)item.getLong("unitid"));
                    eachEntity.put("unitQty", (Object)1);
                    eachEntity.put("baseUnitID", item.get((Object)"baseunit"));
                    eachEntity.put("baseUnitQty", (Object)1);
                    eachEntity.put("adminDivisionId", (Object)districtId);
                    eachEntity.put("customerKey", (Object)"");
                    eachEntityList.add(eachEntity);
                    List resultJsons = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{eachEntityList});
                    if (resultJsons == null) return data;
                }
                ((ExtBillView)this.view).showMessage("\u5546\u54c1\u4e0d\u5b58\u5728");
                this.goPage("ocolsm_index");
                return data;
            } else {
                ((ExtBillView)this.view).showMessage(ReturnData.get((Object)"msg").toString());
            }
            return data;
        } else {
            ((ExtBillView)this.view).showMessage("\u5546\u57ce\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u6e20\u9053\uff0c\u8bf7\u5148\u8bbe\u7f6e\u5bf9\u5e94\u6e20\u9053");
        }
        return data;
    }

    public void onClick(ClickEvent clickevent) {
        String pkValue = clickevent.getId();
        int productCount = ((BillFormData)this.getBillData()).getInt("productcount");
        switch (pkValue) {
            case "addcart": {
                if (productCount > 1) {
                    Map<String, Object> param = this.getParam(pkValue);
                    ((ExtBillView)this.view).showAuxptyView(clickevent.getId(), "ocolsm_auxptytext", param);
                    break;
                }
                this.addCart();
                break;
            }
            case "gobuy": {
                if (productCount > 1) {
                    Map<String, Object> param = this.getParam(pkValue);
                    ((ExtBillView)this.view).showAuxptyView(clickevent.getId(), "ocolsm_auxptytext", param);
                    break;
                }
                long itemId = ((BillFormData)this.getBillData()).getLong("itemid");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_checkout");
                openParam.addCustomParam("itemid", String.valueOf(itemId));
                openParam.addCustomParam("auxpropid", (Object)0);
                openParam.addCustomParam("spuid", (Object)0);
                openParam.addCustomParam("qty", (Object)1);
                ((ExtBillView)this.getView()).showView(openParam);
                break;
            }
            case "gohome": {
                this.goPage("ocolsm_index");
                break;
            }
            case "gocart": {
                this.goPage("ocolsm_cart");
                break;
            }
            case "sel_content": {
                Map<String, Object> param = this.getParam(pkValue);
                ((ExtBillView)this.view).showAuxptyView(clickevent.getId(), "ocolsm_auxptytext", param);
                break;
            }
            case "selectaddress": {
                this.addressId = ((BillFormData)this.getBillData()).getLong("addressid");
                long itemid = ((BillFormData)this.getBillData()).getLong("itemid");
                long spuid = ((BillFormData)this.getBillData()).getLong("spuid");
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.NewWindow);
                openParam.setShowTitle(Boolean.TRUE);
                openParam.setViewId("ocolsm_addresslist");
                openParam.addCustomParam("scene", "3");
                openParam.addCustomParam("addressid", String.valueOf(this.addressId));
                openParam.addCustomParam("itemid", String.valueOf(itemid));
                openParam.addCustomParam("spuid", String.valueOf(spuid));
                ((ExtBillView)this.getView()).showView(openParam);
            }
        }
        super.onClick(clickevent);
    }

    private void addCart() {
        long itemId = ((BillFormData)this.getBillData()).getLong("itemid");
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocolsm_cartxml");
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(1);
        DynamicObject dataItem = new DynamicObject((DynamicObjectType)entityType);
        dataItem.set("itemId", (Object)itemId);
        dataItem.set("auxpropId", (Object)0L);
        dataItem.set("qty", (Object)1);
        data.add(dataItem);
        int preCartSumCount = this.getCartSumCount();
        CartHelper.addCartItems((long)this.channelCache.getLong("channelid.id"), (long)memberId, data);
        int cartSumCount = this.getCartSumCount();
        if (preCartSumCount != cartSumCount) {
            ((BillFormData)this.billData).updateValue("cartcount", (Object)cartSumCount);
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f");
        } else {
            ((ExtBillView)this.view).showMessage("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25");
        }
    }

    private void goPage(String pagename) {
        OpenParam openParam = new OpenParam();
        openParam.setViewId(pagename);
        openParam.setTarget(OpenParam.OpenTarget.NewWindow);
        ((ExtBillView)this.view).showView(openParam);
    }

    private int getCartSumCount() {
        long memberId = ((ExtBillView)this.view).getExtCtx().getMemberId();
        boolean isOnlySelectChecked = false;
        List lstItemDetail = CartHelper.getCartItemDetails((long)this.channelCache.getLong("channelid.id"), (long)memberId, (boolean)isOnlySelectChecked);
        BigDecimal cartcount = lstItemDetail.stream().map(p -> p.getBigDecimal("qty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return cartcount.intValue();
    }

    private Map<String, Object> getParam(String pkValue) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String itemId = ((BillFormData)this.getBillData()).getString("itemid");
        param.put("itemid", itemId);
        String materielId = ((BillFormData)this.getBillData()).getString("materielid");
        param.put("materielid", materielId);
        String spuId = ((BillFormData)this.getBillData()).getString("spuid");
        param.put("spuid", spuId);
        String spumapIds = ((BillFormData)this.getBillData()).getString("spumapids");
        param.put("spumapids", spumapIds);
        String auxptyId = ((BillFormData)this.getBillData()).getString("auxptyid");
        String flexfieldId = "";
        flexfieldId = Long.parseLong(spuId) > 0L ? spuId : auxptyId;
        param.put("skuid", auxptyId);
        param.put("btnname", pkValue);
        param.put("updateControlId", "auxptyid");
        return param;
    }

    private String getEnableGroup(String spuId, JSONArray products) {
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(spuId));
        DynamicObjectCollection spuEntry = QueryServiceHelper.query((String)"ocdbd_spu", (String)"id,entryentity_specmap.id entryid,entryentity_specmap.spumapids spumapids,entryentity_specmap.itemid itemid,entryentity_specmap.auxptyid auxptyid", (QFilter[])filter.toArray());
        String str = "[";
        for (DynamicObject item : spuEntry) {
            long itemId = item.getLong("itemid");
            long auxptyId = item.getLong("auxptyid");
            String spumapIds = item.getString("spumapids");
            Object[] spuArray = products.stream().filter(p -> ((JSONObject)p).getLong("itemid") == itemId && ((JSONObject)p).getLong("auxptyid") == auxptyId).toArray();
            if (spuArray.length <= 0) continue;
            str = str + (spuEntry.indexOf((Object)item) == 0 ? spumapIds : "," + spumapIds);
        }
        str = str + "]";
        return str;
    }

    protected void bindAddress(long memberId) {
        SimpleMap mapCustomParam = ((ExtBillView)this.view).getExtCtx().getForm().getCustomParam();
        this.addressId = mapCustomParam.getLong("addressid");
        if (this.addressId > 0L) {
            String linkman = mapCustomParam.getString("linkman");
            String linkphone = mapCustomParam.getString("linkphone");
            String address = mapCustomParam.getString("address");
            String streetdetail = mapCustomParam.getString("streetdetail");
            String streetdetailids = mapCustomParam.getString("streetdetailids");
            String countryid = mapCustomParam.getString("countryid");
            ((BillFormData)this.getBillData()).updateValue("addressid", (Object)this.addressId);
            ((BillFormData)this.getBillData()).updateValue("linkman", (Object)linkman);
            ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)linkphone);
            ((BillFormData)this.getBillData()).updateValue("mobile", (Object)StringUtil.mobileNumberPartHide((String)linkphone));
            ((BillFormData)this.getBillData()).updateValue("address", (Object)address);
            ((BillFormData)this.getBillData()).updateValue("streetdetail", (Object)streetdetail);
            ((BillFormData)this.getBillData()).updateValue("streetdetailids", (Object)streetdetailids);
            ((BillFormData)this.getBillData()).updateValue("provinceid", (Object)streetdetailids.split("_")[0]);
            ((BillFormData)this.getBillData()).updateValue("cityid", (Object)streetdetailids.split("_")[1]);
            ((BillFormData)this.getBillData()).updateValue("districtid", (Object)streetdetailids.split("_")[2]);
            ((BillFormData)this.getBillData()).updateValue("countryid", (Object)countryid);
        } else {
            ExtDynamicObject region;
            JSONObject item;
            long districtId;
            JSONArray items;
            JSONObject addresses = AddressHelper.getDefalutAddress((long)memberId);
            if (addresses.get((Object)"code").toString().equals("0") && (items = addresses.getJSONArray("data")) != null && items.size() > 0 && (districtId = (item = items.getJSONObject(0)).getLong("districtId").longValue()) > 0L && (region = AddressHelper.getFullDivision((long)districtId)).getLong("id") > 0L) {
                ((BillFormData)this.getBillData()).updateValue("addressid", (Object)item.getLong("id"));
                ((BillFormData)this.getBillData()).updateValue("linkman", (Object)item.getString("contact"));
                ((BillFormData)this.getBillData()).updateValue("linkphone", (Object)item.getString("phone"));
                ((BillFormData)this.getBillData()).updateValue("districtid", (Object)item.getLong("districtId"));
                ((BillFormData)this.getBillData()).updateValue("mobile", (Object)StringUtil.mobileNumberPartHide((String)item.getString("phone")));
                ((BillFormData)this.getBillData()).updateValue("address", (Object)item.getString("detailedAddress"));
                ((BillFormData)this.getBillData()).updateValue("streetdetail", (Object)(region.getString("fullname").replaceAll("_", "") + item.getString("detailedAddress")));
                String fullids = region.getString("fullids");
                ((BillFormData)this.getBillData()).updateValue("streetdetailids", (Object)region.getString("fullids"));
                ((BillFormData)this.getBillData()).updateValue("provinceid", (Object)fullids.split("_")[0]);
                ((BillFormData)this.getBillData()).updateValue("cityid", (Object)fullids.split("_")[1]);
                ((BillFormData)this.getBillData()).updateValue("countryid", (Object)item.getString("countryId"));
            }
        }
    }
}

