/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocolsm.common.util;

import java.math.BigDecimal;
import kd.occ.ocolsm.common.util.StringUtil;

public class ObjectUtil {
    public static BigDecimal toBigDecimal(Object object) {
        return ObjectUtil.toBigDecimal(object, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(Object object, BigDecimal defaultValue) {
        if (object != null) {
            String objectStr = object.toString();
            if (StringUtil.isNotEmpty(objectStr)) {
                return new BigDecimal(objectStr);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static String toString(Object obj) {
        return ObjectUtil.toString(obj, "");
    }

    public static String toString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double toDouble(Object obj) {
        return ObjectUtil.toDouble(obj, 0.0);
    }

    public static double toDouble(Object obj, double defaultValue) {
        double value = defaultValue;
        if (obj == null) {
            return value;
        }
        String strValue = ObjectUtil.toString(obj);
        if (StringUtil.isNotEmpty(strValue)) {
            try {
                value = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static long toLong(Object obj) {
        return ObjectUtil.toLong(obj, 0L);
    }

    public static long toLong(Object obj, long defaultValue) {
        long value = defaultValue;
        if (obj == null) {
            return value;
        }
        String strValue = ObjectUtil.toString(obj);
        if (StringUtil.isNotEmpty(strValue)) {
            try {
                value = Long.parseLong(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static int toInt(Object obj) {
        return ObjectUtil.toInt(obj, 0);
    }

    public static int toInt(Object obj, int defaultValue) {
        int value = defaultValue;
        if (obj == null) {
            return value;
        }
        String strValue = ObjectUtil.toString(obj);
        if (StringUtil.isNotEmpty(strValue)) {
            try {
                value = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static boolean toBoolean(Object obj) {
        return ObjectUtil.toBoolean(obj, false);
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        boolean value = defaultValue;
        if (obj != null) {
            value = Boolean.parseBoolean(ObjectUtil.toString(obj));
        }
        return value;
    }
}

